/*
 * Decompiled with CFR 0.152.
 */
package xantorohara.xenoharmonica;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.border.EtchedBorder;
import xantorohara.xenoharmonica.InstrumentEmulator;
import xantorohara.xenoharmonica.midi.XenoMidiSynthesizer;
import xantorohara.xenoharmonica.utils.NoteUtils;

public class BayanEmulator
extends JPanel
implements InstrumentEmulator {
    private static final int BAYAN_FIRST_NOTE = 46;
    private static final int[] KEYS = new int[]{81, 65, 90, 87, 83, 88, 69, 68, 67, 82, 70, 86, 84, 71, 66, 89, 72, 78, 85, 74, 77, 73, 75, 44, 79, 76, 46, 80, 59, 47, 91, 222, 0, 93};
    private static final char[] CHARS = new char[]{'q', 'a', 'z', 'w', 's', 'x', 'e', 'd', 'c', 'r', 'f', 'v', 't', 'g', 'b', 'y', 'h', 'n', 'u', 'j', 'm', 'i', 'k', ',', 'o', 'l', '.', 'p', ';', '/', '[', '\'', ' ', ']'};
    private static final Color COLOR_LIGHT = new Color(153, 204, 255);
    private static final Color COLOR_MIDDLE = new Color(51, 102, 153);
    private static final Color COLOR_DARK = new Color(0, 51, 102);
    private int octave = 5;
    private boolean showNotes = false;
    private boolean showLayout = true;
    private XenoMidiSynthesizer synthesizer;
    private Dimension size;
    private Ellipse2D.Float[] buttons = new Ellipse2D.Float[55];
    private GradientPaint gradientPaint;

    public BayanEmulator(XenoMidiSynthesizer xenoMidiSynthesizer) {
        this.synthesizer = xenoMidiSynthesizer;
        for (int i = 0; i < this.buttons.length; ++i) {
            this.buttons[i] = new Ellipse2D.Float();
        }
        this.addMouseListener(new NoteMouseListener());
        this.setBorder(new EtchedBorder());
        this.setFocusable(true);
    }

    public boolean isShowNotes() {
        return this.showNotes;
    }

    public void setShowNotes(boolean bl) {
        this.showNotes = bl;
        if (this.isVisible()) {
            this.repaint();
        }
    }

    public boolean isShowLayout() {
        return this.showLayout;
    }

    public void setShowLayout(boolean bl) {
        this.showLayout = bl;
        if (this.isVisible()) {
            this.repaint();
        }
    }

    public int getOctave() {
        return this.octave;
    }

    public void setOctave(int n) {
        int n2 = n < 0 ? 0 : (this.octave = n > 10 ? 10 : n);
        if (this.isVisible()) {
            this.repaint();
        }
    }

    private void update() {
        int n;
        double d = 0.0;
        if (this.getWidth() > this.getHeight()) {
            d = (double)this.getWidth() / 20.0;
            for (n = 0; n < this.buttons.length; ++n) {
                this.buttons[n].setFrame((double)((n + 1) / 3) * d + (double)((n + 1) % 3) * d / 2.0, (double)((n + 1) % 3) * d + d / 2.0, d * 0.8, d * 0.8);
            }
            this.gradientPaint = new GradientPaint(this.getWidth() / 2, this.getHeight(), COLOR_LIGHT, this.getWidth() / 2, 0.0f, COLOR_MIDDLE, true);
        } else {
            d = (double)this.getHeight() / 20.0;
            for (n = 0; n < this.buttons.length; ++n) {
                this.buttons[n].setFrame(d * 2.0 - (double)((n + 1) % 3) * d + d / 2.0, (double)((n + 1) / 3) * d + (double)((n + 1) % 3) * d / 2.0, d * 0.8, d * 0.8);
            }
            this.gradientPaint = new GradientPaint(0.0f, this.getHeight() / 2, COLOR_LIGHT, this.getWidth(), this.getHeight() / 2, COLOR_MIDDLE, true);
        }
        n = (int)(d * 0.4);
        if (n != this.getFont().getSize()) {
            this.setFont(new Font("Arial Unicode MS", 0, n));
        }
    }

    private void paintGradient(Graphics2D graphics2D) {
        graphics2D.setPaint(this.gradientPaint);
        graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    private void shiftEllipse2D(Ellipse2D ellipse2D, int n) {
        ellipse2D.setFrame(ellipse2D.getX() + (double)n, ellipse2D.getY() + (double)n, ellipse2D.getWidth(), ellipse2D.getHeight());
    }

    private void paintButtons(Graphics2D graphics2D) {
        for (int i = 0; i < this.buttons.length; ++i) {
            graphics2D.setColor(COLOR_DARK);
            if (!this.synthesizer.isNoteActive(i + 46)) {
                this.shiftEllipse2D(this.buttons[i], 2);
                graphics2D.fill(this.buttons[i]);
                this.shiftEllipse2D(this.buttons[i], -2);
            }
            Color color = BayanEmulator.getColorForNote(i + 10, false);
            graphics2D.setColor(color);
            graphics2D.fill(this.buttons[i]);
            color = BayanEmulator.getColorForNote(i + 10, true);
            if (this.synthesizer.isNoteActive(i + 46)) {
                color = Color.RED;
            }
            graphics2D.setColor(color);
            graphics2D.draw(this.buttons[i]);
        }
    }

    private void paintNotes(Graphics2D graphics2D) {
        double d = this.buttons[0].getWidth();
        int n = graphics2D.getFontMetrics().getHeight();
        for (int i = 0; i < this.buttons.length; ++i) {
            Color color = BayanEmulator.getColorForNote(i + 10, true);
            graphics2D.setColor(color);
            String string = NoteUtils.getNoteName(i + 10);
            int n2 = graphics2D.getFontMetrics().stringWidth(string);
            if (this.showLayout) {
                graphics2D.drawString(string, (int)(this.buttons[i].getX() + d * 0.333 - (double)(n2 / 2)), (int)(this.buttons[i].getY() + d * 0.333 + (double)(n / 3)));
                continue;
            }
            graphics2D.drawString(string, (int)(this.buttons[i].getX() + d / 2.0 - (double)(n2 / 2)), (int)(this.buttons[i].getY() + d / 2.0 + (double)(n / 3)));
        }
    }

    private void paintLayout(Graphics2D graphics2D) {
        double d = this.buttons[0].getWidth();
        int n = graphics2D.getFontMetrics().getHeight();
        for (int i = 0; i < CHARS.length; ++i) {
            int n2 = i + this.octave * 12 - 46;
            if (n2 < 0 || n2 >= this.buttons.length) continue;
            Color color = BayanEmulator.getColorForNote(i + 12, true);
            graphics2D.setColor(color);
            char c = this.getCharForBaseNote(i);
            int n3 = graphics2D.getFontMetrics().charWidth(c);
            if (this.showNotes) {
                graphics2D.drawString(Character.toString(c), (int)(this.buttons[n2].getX() + d * 0.666 - (double)(n3 / 2)), (int)(this.buttons[n2].getY() + d * 0.666 + (double)(n / 3)));
                continue;
            }
            graphics2D.drawString(Character.toString(c), (int)(this.buttons[n2].getX() + d / 2.0 - (double)(n3 / 2)), (int)(this.buttons[n2].getY() + d / 2.0 + (double)(n / 3)));
        }
    }

    protected void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        Dimension dimension = this.getSize();
        if (!dimension.equals(this.size)) {
            this.size = dimension;
            this.update();
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this.paintGradient(graphics2D);
        this.paintButtons(graphics2D);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        if (this.showNotes) {
            this.paintNotes(graphics2D);
        }
        if (this.showLayout) {
            this.paintLayout(graphics2D);
        }
    }

    private static Color getColorForNote(int n, boolean bl) {
        switch (n % 12) {
            case 1: 
            case 3: 
            case 6: 
            case 8: 
            case 10: {
                return bl ? Color.WHITE : Color.BLACK;
            }
        }
        return bl ? Color.BLACK : Color.WHITE;
    }

    public static int getKeyForNote(int n) {
        return n >= 0 && n < KEYS.length ? KEYS[n] : 0;
    }

    public char getCharForBaseNote(int n) {
        return n >= 0 && n < CHARS.length ? CHARS[n] : (char)'\u0000';
    }

    public int getNoteForKey(int n) {
        for (int i = 0; n > 0 && i < KEYS.length; ++i) {
            if (n != KEYS[i]) continue;
            return this.octave * 12 + i;
        }
        return -1;
    }

    public Component getUserInterface() {
        return this;
    }

    private class NoteMouseListener
    extends MouseAdapter {
        private Set<Integer> notes = new HashSet<Integer>();

        private NoteMouseListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!BayanEmulator.this.hasFocus()) {
                BayanEmulator.this.requestFocus();
            }
            for (int i = 0; i < BayanEmulator.this.buttons.length; ++i) {
                if (!BayanEmulator.this.buttons[i].contains(mouseEvent.getX(), mouseEvent.getY())) continue;
                int n = i + 46;
                if (this.notes.contains(n)) {
                    this.notes.remove(n);
                    BayanEmulator.this.synthesizer.stopNote(n);
                    continue;
                }
                this.notes.add(n);
                BayanEmulator.this.synthesizer.playNote(n);
            }
            if (!this.notes.isEmpty()) {
                BayanEmulator.this.repaint();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!this.notes.isEmpty() && !mouseEvent.isControlDown()) {
                for (Integer n : this.notes) {
                    BayanEmulator.this.synthesizer.stopNote(n);
                }
                this.notes.clear();
                BayanEmulator.this.repaint();
            }
        }
    }
}

