/*
 * Decompiled with CFR 0.152.
 */
package xantorohara.xenoharmonica;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import xantorohara.xenoharmonica.InstrumentEmulator;
import xantorohara.xenoharmonica.midi.XenoMidiSynthesizer;

public class KeyboardListener
extends KeyAdapter {
    private XenoMidiSynthesizer synthesizer;
    private InstrumentEmulator emulator;

    public KeyboardListener(XenoMidiSynthesizer xenoMidiSynthesizer, InstrumentEmulator instrumentEmulator) {
        this.synthesizer = xenoMidiSynthesizer;
        this.emulator = instrumentEmulator;
    }

    public void keyPressed(KeyEvent keyEvent) {
        int n = this.emulator.getNoteForKey(keyEvent.getKeyCode());
        if (n != -1) {
            this.synthesizer.playNote(n);
            this.emulator.getUserInterface().repaint();
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        int n = this.emulator.getNoteForKey(keyEvent.getKeyCode());
        if (n != -1) {
            this.synthesizer.stopNote(n);
            this.emulator.getUserInterface().repaint();
        }
    }
}

