/*
 * Decompiled with CFR 0.152.
 */
package xantorohara.xenoharmonica;

import java.awt.Dimension;
import java.awt.Toolkit;
import java.io.FileNotFoundException;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JWindow;
import xantorohara.xenoharmonica.Config;
import xantorohara.xenoharmonica.LauncherHelper;
import xantorohara.xenoharmonica.utils.ConfigUtils;

public class Launcher
extends JFrame {
    private static final String CONF_FILE = "XenoHarmonica.xml";
    private static JWindow splashScreen = null;
    private Config config;

    public Launcher(Config config) {
        super("XenoHarmonica");
        this.config = config;
        this.setIconImage(Toolkit.getDefaultToolkit().createImage(this.getClass().getResource("resources/icon.gif")));
        this.setDefaultCloseOperation(2);
        this.setBounds(16, 16, 800, 240);
    }

    public void dispose() {
        try {
            ConfigUtils.save(this.config, CONF_FILE);
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(this, "Can't save config file", "XenoKeyboard", 2);
        }
        super.dispose();
        System.exit(0);
    }

    private static void showSplashScreen() {
        splashScreen = new JWindow();
        splashScreen.getContentPane().add(new JLabel(new ImageIcon(Launcher.class.getResource("resources/keyboard.gif"))));
        splashScreen.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = splashScreen.getSize();
        if (dimension2.height > dimension.height) {
            dimension2.height = dimension.height;
        }
        if (dimension2.width > dimension.width) {
            dimension2.width = dimension.width;
        }
        splashScreen.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        splashScreen.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void hideSplashScreen() {
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {
            System.out.print(interruptedException.getMessage());
        }
        finally {
            splashScreen.setVisible(false);
            splashScreen.dispose();
            splashScreen = null;
        }
    }

    public static void main(String[] stringArray) {
        Launcher.showSplashScreen();
        Config config = null;
        try {
            config = (Config)ConfigUtils.load(CONF_FILE);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Config file not found.");
        }
        if (config == null) {
            config = new Config();
        }
        Launcher launcher = new Launcher(config);
        LauncherHelper launcherHelper = new LauncherHelper(config);
        launcherHelper.init(launcher);
        launcher.setVisible(true);
        Launcher.hideSplashScreen();
    }
}

