/*
 * Decompiled with CFR 0.152.
 */
package xantorohara.xenoharmonica;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.KeyListener;
import java.io.InputStream;
import javax.sound.midi.MidiUnavailableException;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import xantorohara.xenoharmonica.BayanEmulator;
import xantorohara.xenoharmonica.Config;
import xantorohara.xenoharmonica.InstrumentEmulator;
import xantorohara.xenoharmonica.KeyboardListener;
import xantorohara.xenoharmonica.XenoMenu;
import xantorohara.xenoharmonica.XenoStatusBar;
import xantorohara.xenoharmonica.midi.XenoMidiSynthesizer;

public class LauncherHelper {
    private XenoMidiSynthesizer synthesizer;
    private InstrumentEmulator emulator;
    private Config config;

    public LauncherHelper(Config config) {
        this.config = config;
    }

    public void init(Container container) {
        Object object;
        try {
            this.synthesizer = new XenoMidiSynthesizer();
            if (this.synthesizer.getInstruments().length == 0) {
                object = this.getClass().getResourceAsStream("resources/soundbank.gm");
                this.synthesizer.loadSoundbank((InputStream)object);
            }
            if (this.synthesizer.getInstruments().length == 0) {
                JOptionPane.showMessageDialog(null, "Instruments not found", "XenoKeyboard", 0);
            }
            this.synthesizer.setSelecteInstrumentNumber(this.config.getInstrument());
            this.synthesizer.setVolume(this.config.getVolume());
            this.emulator = new BayanEmulator(this.synthesizer);
            this.emulator.setOctave(this.config.getOctave());
            this.emulator.setShowLayout(this.config.isShowLayout());
            this.emulator.setShowNotes(this.config.isShowNotes());
        }
        catch (MidiUnavailableException midiUnavailableException) {
            JOptionPane.showMessageDialog(null, "Midi device not found", "XenoKeyboard", 0);
        }
        object = new KeyboardListener(this.synthesizer, this.emulator);
        XenoStatusBar xenoStatusBar = new XenoStatusBar(this.synthesizer, this.emulator, (KeyboardListener)object, this.config);
        this.emulator.getUserInterface().addKeyListener((KeyListener)object);
        container.setLayout(new BorderLayout());
        container.add(this.emulator.getUserInterface(), "Center");
        container.add((Component)xenoStatusBar, "South");
        xenoStatusBar.actionPerformed(null);
        XenoMenu xenoMenu = new XenoMenu(container, this.emulator, this.synthesizer, (KeyboardListener)object, this.config);
        xenoMenu.addXenoListener(xenoStatusBar);
        if (container instanceof JFrame) {
            ((JFrame)container).setJMenuBar(xenoMenu);
        } else if (container instanceof JApplet) {
            ((JApplet)container).setJMenuBar(xenoMenu);
        }
    }
}

