/*
 * Decompiled with CFR 0.152.
 */
package xantorohara.xenoharmonica;

import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.sound.midi.Instrument;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import xantorohara.xenoharmonica.AboutPanel;
import xantorohara.xenoharmonica.Config;
import xantorohara.xenoharmonica.InstrumentEmulator;
import xantorohara.xenoharmonica.KeyboardListener;
import xantorohara.xenoharmonica.XenoSetupPanel;
import xantorohara.xenoharmonica.midi.XenoMidiPlayer;
import xantorohara.xenoharmonica.midi.XenoMidiSynthesizer;

public class XenoMenu
extends JMenuBar {
    private Component owner;
    private InstrumentEmulator emulator;
    private XenoMidiSynthesizer synthesizer;
    private KeyboardListener keyboardListener;
    private Config config;
    private ArrayList<JRadioButtonMenuItem> instrumentsMenuItems = new ArrayList();
    private Set<ActionListener> xenoListeners = new HashSet<ActionListener>();

    public XenoMenu(Component component, InstrumentEmulator instrumentEmulator, XenoMidiSynthesizer xenoMidiSynthesizer, KeyboardListener keyboardListener, Config config) {
        this.owner = component;
        this.config = config;
        this.emulator = instrumentEmulator;
        this.synthesizer = xenoMidiSynthesizer;
        this.keyboardListener = keyboardListener;
        this.createFileMenu();
        this.createInstrumentsMenu();
        this.createKeyboardMenu();
        this.createHelpMenu();
    }

    public void addXenoListener(ActionListener actionListener) {
        this.xenoListeners.add(actionListener);
    }

    private void notifyXenoListeners() {
        ActionEvent actionEvent = new ActionEvent(this, 0, null);
        for (ActionListener actionListener : this.xenoListeners) {
            actionListener.actionPerformed(actionEvent);
        }
    }

    private void updateInstruments() {
        Instrument[] instrumentArray = this.synthesizer.getInstruments();
        int[] nArray = this.config.getInstruments();
        for (int i = 0; i < nArray.length && i < this.instrumentsMenuItems.size(); ++i) {
            int n = nArray[i];
            if (n < 0 || n >= instrumentArray.length) continue;
            Instrument instrument = instrumentArray[n];
            JRadioButtonMenuItem jRadioButtonMenuItem = this.instrumentsMenuItems.get(i);
            jRadioButtonMenuItem.setAction(new InstrumentChangeAction(instrument.getName(), n));
            jRadioButtonMenuItem.setSelected(n == this.config.getInstrument());
            if (i >= 10) continue;
            jRadioButtonMenuItem.setAccelerator(KeyStroke.getKeyStroke(Character.forDigit((i + 1) % 10, 10)));
        }
    }

    private void createInstrumentsMenu() {
        JMenu jMenu = new JMenu("Instruments");
        ButtonGroup buttonGroup = new ButtonGroup();
        int[] nArray = this.config.getInstruments();
        if (this.synthesizer.getInstruments().length > 0) {
            for (int i = 0; i < nArray.length; ++i) {
                JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem();
                buttonGroup.add(jRadioButtonMenuItem);
                jMenu.add(jRadioButtonMenuItem);
                this.instrumentsMenuItems.add(jRadioButtonMenuItem);
            }
        }
        this.updateInstruments();
        jMenu.add(new JSeparator());
        JMenuItem jMenuItem = new JMenuItem(new AbstractAction("Setup ..."){

            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = (int[])XenoMenu.this.config.getInstruments().clone();
                int n = XenoMenu.this.synthesizer.getSelecteInstrumentNumber();
                XenoSetupPanel xenoSetupPanel = new XenoSetupPanel(XenoMenu.this.synthesizer, nArray, XenoMenu.this.keyboardListener);
                int n2 = JOptionPane.showOptionDialog(XenoMenu.this.owner, new Object[]{xenoSetupPanel}, "Instruments setup", 2, -1, null, null, null);
                if (n2 == 0) {
                    XenoMenu.this.config.setInstruments(xenoSetupPanel.getSelectedInstrumentNumbers());
                    XenoMenu.this.updateInstruments();
                } else {
                    XenoMenu.this.synthesizer.setSelecteInstrumentNumber(n);
                }
                XenoMenu.this.emulator.getUserInterface().requestFocus();
                XenoMenu.this.notifyXenoListeners();
            }
        });
        jMenu.add(jMenuItem);
        this.add(jMenu);
    }

    private void createKeyboardMenu() {
        JMenu jMenu = new JMenu("Keyboard");
        JMenuItem jMenuItem = new JMenuItem(new AbstractAction("Octave +"){

            public void actionPerformed(ActionEvent actionEvent) {
                XenoMenu.this.synthesizer.stopAllNotes();
                XenoMenu.this.emulator.setOctave(XenoMenu.this.emulator.getOctave() + 1);
                XenoMenu.this.config.setOctave(XenoMenu.this.emulator.getOctave());
                XenoMenu.this.notifyXenoListeners();
            }
        });
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(61, 0));
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem(new AbstractAction("Octave -"){

            public void actionPerformed(ActionEvent actionEvent) {
                XenoMenu.this.synthesizer.stopAllNotes();
                XenoMenu.this.emulator.setOctave(XenoMenu.this.emulator.getOctave() - 1);
                XenoMenu.this.config.setOctave(XenoMenu.this.emulator.getOctave());
                XenoMenu.this.notifyXenoListeners();
            }
        });
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(45, 0));
        jMenu.add(jMenuItem2);
        jMenu.add(new JSeparator());
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(new AbstractAction("Show notes"){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = ((JCheckBoxMenuItem)actionEvent.getSource()).isSelected();
                XenoMenu.this.emulator.setShowNotes(((JCheckBoxMenuItem)actionEvent.getSource()).isSelected());
                XenoMenu.this.config.setShowNotes(bl);
            }
        });
        jCheckBoxMenuItem.setSelected(this.config.isShowNotes());
        jMenu.add(jCheckBoxMenuItem);
        JCheckBoxMenuItem jCheckBoxMenuItem2 = new JCheckBoxMenuItem(new AbstractAction("Show keyboard layout"){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = ((JCheckBoxMenuItem)actionEvent.getSource()).isSelected();
                XenoMenu.this.emulator.setShowLayout(bl);
                XenoMenu.this.config.setShowLayout(bl);
            }
        });
        jCheckBoxMenuItem2.setSelected(this.config.isShowLayout());
        jMenu.add(jCheckBoxMenuItem2);
        this.add(jMenu);
    }

    private void createFileMenu() {
        if (this.owner instanceof Window) {
            JMenu jMenu = new JMenu("File");
            JMenuItem jMenuItem = new JMenuItem(new AbstractAction("Exit"){

                public void actionPerformed(ActionEvent actionEvent) {
                    ((Window)XenoMenu.this.owner).dispose();
                }
            });
            jMenu.add(jMenuItem);
            this.add(jMenu);
        }
    }

    private void createHelpMenu() {
        JMenu jMenu = new JMenu("Help");
        JMenuItem jMenuItem = new JMenuItem(new AbstractAction("About"){

            public void actionPerformed(ActionEvent actionEvent) {
                InputStream inputStream = XenoMenu.this.getClass().getResourceAsStream("resources/about.mid");
                XenoMidiPlayer xenoMidiPlayer = null;
                try {
                    xenoMidiPlayer = new XenoMidiPlayer();
                    xenoMidiPlayer.play(inputStream);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                JOptionPane.showMessageDialog(XenoMenu.this, new AboutPanel(), "About", -1);
                if (xenoMidiPlayer != null) {
                    xenoMidiPlayer.stop();
                }
                XenoMenu.this.emulator.getUserInterface().requestFocus();
            }
        });
        jMenu.add(jMenuItem);
        this.add(jMenu);
    }

    private class InstrumentChangeAction
    extends AbstractAction {
        private int instrumentNo;

        public InstrumentChangeAction(String string, int n) {
            super(string);
            this.instrumentNo = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            XenoMenu.this.synthesizer.setSelecteInstrumentNumber(this.instrumentNo);
            XenoMenu.this.config.setInstrument(XenoMenu.this.synthesizer.getSelecteInstrumentNumber());
            XenoMenu.this.notifyXenoListeners();
        }
    }
}

