/*
 * Decompiled with CFR 0.152.
 */
package xantorohara.xenoharmonica;

import java.awt.Component;
import java.awt.Dimension;
import javax.sound.midi.Instrument;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import xantorohara.xenoharmonica.KeyboardListener;
import xantorohara.xenoharmonica.midi.XenoMidiSynthesizer;

public class XenoSetupPanel
extends JPanel {
    private JTable table = new JTable();
    private JComboBox editor = new JComboBox();
    private Instrument[] selectedInstruments;
    private XenoMidiSynthesizer synthesizer;

    public int[] getSelectedInstrumentNumbers() {
        int[] nArray = new int[this.selectedInstruments.length];
        Instrument[] instrumentArray = this.synthesizer.getInstruments();
        block0: for (int i = 0; i < this.selectedInstruments.length; ++i) {
            for (int j = 0; j < instrumentArray.length; ++j) {
                if (this.selectedInstruments[i] != instrumentArray[j]) continue;
                nArray[i] = j;
                continue block0;
            }
        }
        return nArray;
    }

    public XenoSetupPanel(XenoMidiSynthesizer xenoMidiSynthesizer, int[] nArray, KeyboardListener keyboardListener) {
        this.synthesizer = xenoMidiSynthesizer;
        Instrument[] instrumentArray = xenoMidiSynthesizer.getInstruments();
        this.selectedInstruments = new Instrument[nArray.length];
        for (int i = 0; i < nArray.length && nArray[i] < instrumentArray.length; ++i) {
            this.selectedInstruments[i] = instrumentArray[nArray[i]];
        }
        IntrumentsTableModel intrumentsTableModel = new IntrumentsTableModel(this.selectedInstruments);
        this.table.setAutoResizeMode(1);
        this.table.setModel(intrumentsTableModel);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(40);
        this.table.getColumnModel().getColumn(1).setCellEditor(new InstrumentTableCellEditor(this.editor));
        this.table.getColumnModel().getColumn(1).setCellRenderer(new InstrumentTableCellRenderer());
        this.table.getColumnModel().getColumn(1).setPreferredWidth(200);
        this.table.setRowHeight(20);
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.setPreferredSize(new Dimension(240, 180));
        InstrumentListModel instrumentListModel = new InstrumentListModel(xenoMidiSynthesizer);
        this.editor.setRenderer(new InstrumentListRenderer());
        this.editor.setModel(instrumentListModel);
        this.editor.addKeyListener(keyboardListener);
        this.table.addKeyListener(keyboardListener);
        this.add(jScrollPane);
    }

    private static class InstrumentListRenderer
    extends DefaultListCellRenderer {
        private InstrumentListRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof Instrument) {
                return super.getListCellRendererComponent((JList<?>)jList, ((Instrument)object).getName(), n, bl, bl2);
            }
            return super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
        }
    }

    private static class InstrumentListModel
    extends DefaultComboBoxModel {
        private XenoMidiSynthesizer synthesizer;
        private Instrument[] instruments;
        private Instrument selectedInstrument;

        public InstrumentListModel(XenoMidiSynthesizer xenoMidiSynthesizer) {
            this.synthesizer = xenoMidiSynthesizer;
            this.instruments = xenoMidiSynthesizer.getInstruments();
        }

        public void setSelectedItem(Object object) {
            this.selectedInstrument = (Instrument)object;
            this.synthesizer.setSelecteInstrument(this.selectedInstrument);
        }

        public Object getSelectedItem() {
            return this.selectedInstrument;
        }

        public int getSize() {
            return this.instruments == null ? 0 : this.instruments.length;
        }

        public Object getElementAt(int n) {
            return this.instruments[n];
        }

        public void setInstruments(Instrument[] instrumentArray) {
            this.instruments = instrumentArray;
        }
    }

    private static class IntrumentsTableModel
    extends AbstractTableModel {
        private String[] header = new String[]{"", "Instrument"};
        private Instrument[] instruments;

        public IntrumentsTableModel(Instrument[] instrumentArray) {
            this.instruments = instrumentArray;
        }

        public String getColumnName(int n) {
            return this.header[n];
        }

        public int getRowCount() {
            return this.instruments.length;
        }

        public int getColumnCount() {
            return this.header.length;
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 1;
        }

        public Object getValueAt(int n, int n2) {
            return n2 == 0 ? Integer.valueOf(n + 1) : this.instruments[n];
        }

        public void setValueAt(Object object, int n, int n2) {
            this.instruments[n] = (Instrument)object;
        }
    }

    public class InstrumentTableCellRenderer
    extends DefaultTableCellRenderer {
        protected void setValue(Object object) {
            if (object instanceof Instrument) {
                super.setValue(((Instrument)object).getName());
            } else {
                super.setValue(object);
            }
        }
    }

    private static class InstrumentTableCellEditor
    extends DefaultCellEditor {
        public InstrumentTableCellEditor(JComboBox jComboBox) {
            super(jComboBox);
            this.setClickCountToStart(2);
        }
    }
}

