/*
 * Decompiled with CFR 0.152.
 */
package xantorohara.xenoharmonica;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.sound.midi.Instrument;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import xantorohara.xenoharmonica.Config;
import xantorohara.xenoharmonica.InstrumentEmulator;
import xantorohara.xenoharmonica.KeyboardListener;
import xantorohara.xenoharmonica.midi.XenoMidiSynthesizer;

public class XenoStatusBar
extends JPanel
implements ActionListener {
    private JLabel instrumentLabel = new JLabel("none");
    private JLabel octaveLabel = new JLabel("?");
    private JSlider volumeLabel = new JSlider(0, 100);
    private XenoMidiSynthesizer synthesizer;
    private InstrumentEmulator emulator;
    private Config config;

    public XenoStatusBar(XenoMidiSynthesizer xenoMidiSynthesizer, InstrumentEmulator instrumentEmulator, KeyboardListener keyboardListener, Config config) {
        this.synthesizer = xenoMidiSynthesizer;
        this.emulator = instrumentEmulator;
        this.config = config;
        BoxLayout boxLayout = new BoxLayout(this, 0);
        this.setLayout(boxLayout);
        this.add(new PanelElement("Instrument:", this.instrumentLabel, 200));
        this.add(Box.createRigidArea(new Dimension(4, 0)));
        this.add(new PanelElement("Octave:", this.octaveLabel, 25));
        this.add(Box.createRigidArea(new Dimension(4, 0)));
        this.add(new PanelElement(null, new JPanel(), 100));
        this.add(Box.createRigidArea(new Dimension(4, 0)));
        this.add(new PanelElement("Volume:", this.volumeLabel, 100));
        this.volumeLabel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                XenoStatusBar.this.synthesizer.setVolume(XenoStatusBar.this.volumeLabel.getValue());
                XenoStatusBar.this.config.setVolume(XenoStatusBar.this.synthesizer.getVolume());
            }
        });
        this.volumeLabel.addKeyListener(keyboardListener);
        this.volumeLabel.setMinimumSize(new Dimension(100, 0));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Instrument instrument = this.synthesizer.getSelectedInstrument();
        this.instrumentLabel.setText(instrument == null ? "none" : instrument.getName());
        this.volumeLabel.setValue(this.synthesizer.getVolume());
        this.octaveLabel.setText(String.valueOf(this.emulator.getOctave()));
    }

    private class PanelElement
    extends JPanel {
        public PanelElement(String string, JComponent jComponent, int n) {
            this.setLayout(new BoxLayout(this, 2));
            jComponent.setPreferredSize(new Dimension(n, 0));
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createBevelBorder(1, this.getBackground().brighter(), this.getBackground(), this.getBackground(), this.getBackground().darker().darker()), BorderFactory.createEmptyBorder(2, 2, 2, 2)));
            if (string != null) {
                this.add(new JLabel(string));
                this.add(Box.createRigidArea(new Dimension(4, 0)));
            }
            this.add(jComponent);
        }
    }
}

