/*
 * Decompiled with CFR 0.152.
 */
package xantorohara.xenoharmonica.midi;

import java.io.IOException;
import java.io.InputStream;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;

public class XenoMidiPlayer {
    private Sequencer sequencer = MidiSystem.getSequencer();

    public XenoMidiPlayer() throws MidiUnavailableException {
        if (this.sequencer == null) {
            throw new MidiUnavailableException();
        }
        this.sequencer.open();
        this.sequencer.setLoopCount(-1);
    }

    public void play(InputStream inputStream) throws IOException, InvalidMidiDataException {
        Sequence sequence = MidiSystem.getSequence(inputStream);
        this.sequencer.setSequence(sequence);
        this.sequencer.start();
    }

    public void stop() {
        this.sequencer.stop();
    }
}

