/*
 * Decompiled with CFR 0.152.
 */
package xantorohara.xenoharmonica.midi;

import java.io.InputStream;
import javax.sound.midi.Instrument;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;

public class XenoMidiSynthesizer {
    private Synthesizer synthesizer;
    private MidiChannel channel;
    private int volume = 50;
    private boolean[] activeNotes = new boolean[128];

    public XenoMidiSynthesizer() throws MidiUnavailableException {
        this.synthesizer = MidiSystem.getSynthesizer();
        this.synthesizer.open();
        this.channel = this.synthesizer.getChannels()[0];
        this.channel.programChange(21);
    }

    public void playNote(int n) {
        if (n >= 0 && n < 127 && !this.activeNotes[n]) {
            this.activeNotes[n] = true;
            this.channel.noteOn(n, this.volume);
        }
    }

    public void stopNote(int n) {
        if (n >= 0 && n < 127) {
            this.activeNotes[n] = false;
            this.channel.noteOff(n, 0);
        }
    }

    public void stopAllNotes() {
        this.channel.allNotesOff();
        for (int i = 0; i < this.activeNotes.length; ++i) {
            this.activeNotes[i] = false;
        }
    }

    public boolean isNoteActive(int n) {
        return n < this.activeNotes.length && this.activeNotes[n];
    }

    public Instrument[] getInstruments() {
        if (this.synthesizer.getLoadedInstruments().length > 0) {
            return this.synthesizer.getLoadedInstruments();
        }
        return this.synthesizer.getAvailableInstruments();
    }

    public void setSelecteInstrumentNumber(int n) {
        this.channel.programChange(n);
    }

    public int getSelecteInstrumentNumber() {
        return this.channel.getProgram();
    }

    public Instrument getSelectedInstrument() {
        Instrument[] instrumentArray = this.getInstruments();
        for (int i = 0; i < instrumentArray.length; ++i) {
            if (this.channel.getProgram() != i) continue;
            return instrumentArray[i];
        }
        return null;
    }

    public void setSelecteInstrument(Instrument instrument) {
        Instrument[] instrumentArray = this.getInstruments();
        for (int i = 0; i < instrumentArray.length; ++i) {
            if (!instrumentArray[i].equals(instrument)) continue;
            this.channel.programChange(i);
        }
    }

    public boolean loadSoundbank(InputStream inputStream) {
        try {
            Soundbank soundbank = MidiSystem.getSoundbank(inputStream);
            if (this.synthesizer.isSoundbankSupported(soundbank)) {
                System.out.println("Soundbank loaded");
                this.synthesizer.loadAllInstruments(soundbank);
            }
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public int getVolume() {
        return this.volume;
    }

    public void setVolume(int n) {
        this.volume = n < 0 ? 0 : (n > 100 ? 100 : n);
    }
}

