/*
 * Decompiled with CFR 0.152.
 */
package AbyssEngine;

import AbyssEngine.AEMath;
import AbyssEngine.AEVector3D;

public class AEBoundingSphere {
    public AEVector3D pos;
    public int r;

    public AEBoundingSphere(int n, int n2, int n3, int n4) {
        this.pos = new AEVector3D(n, n2, n3);
        this.r = n4;
    }

    public AEBoundingSphere(AEVector3D aEVector3D, int n) {
        this(aEVector3D.x, aEVector3D.y, aEVector3D.z, n);
    }

    public AEBoundingSphere() {
        this(0, 0, 0, 0);
    }

    public AEBoundingSphere(AEBoundingSphere aEBoundingSphere) {
        this.pos = new AEVector3D(aEBoundingSphere.pos.x, aEBoundingSphere.pos.y, aEBoundingSphere.pos.z);
        this.r = aEBoundingSphere.r;
    }

    public AEBoundingSphere add(AEBoundingSphere aEBoundingSphere, AEBoundingSphere aEBoundingSphere2) {
        if (this.r == 0) {
            aEBoundingSphere2.set(aEBoundingSphere);
            return aEBoundingSphere2;
        }
        if (aEBoundingSphere.r == 0) {
            aEBoundingSphere2.set(this);
            return aEBoundingSphere2;
        }
        int n = aEBoundingSphere.r - this.r;
        int n2 = n * n;
        int n3 = aEBoundingSphere.pos.x - this.pos.x;
        int n4 = aEBoundingSphere.pos.y - this.pos.y;
        int n5 = aEBoundingSphere.pos.z - this.pos.z;
        int n6 = n3 * n3 + n4 * n4 + n5 * n5;
        if (n2 >= n6) {
            if (n >= 0) {
                aEBoundingSphere2.set(aEBoundingSphere.pos, aEBoundingSphere.r);
                return aEBoundingSphere2;
            }
            aEBoundingSphere2.set(this.pos, this.r);
            return aEBoundingSphere2;
        }
        int n7 = AEMath.sqrt((long)n6 << 12);
        int n8 = (int)(((long)((n << 12) + n7) << 12) / (long)(2 * n7));
        aEBoundingSphere2.set(this.pos.x + (int)((long)n8 * ((long)n3 << 12) >> 24), this.pos.y + (int)((long)n8 * ((long)n4 << 12) >> 24), this.pos.z + (int)((long)n8 * ((long)n5 << 12) >> 24), (n7 >> 12) + (aEBoundingSphere.r + this.r) >> 1);
        return aEBoundingSphere2;
    }

    public void add(AEBoundingSphere aEBoundingSphere) {
        this.add(aEBoundingSphere, this);
    }

    public void set(AEBoundingSphere aEBoundingSphere) {
        this.pos.set(aEBoundingSphere.pos);
        this.r = aEBoundingSphere.r;
    }

    public void set(int n, int n2, int n3, int n4) {
        this.pos.x = n;
        this.pos.y = n2;
        this.pos.z = n3;
        this.r = n4;
    }

    public void set(AEVector3D aEVector3D, int n) {
        this.pos.set(aEVector3D);
        this.r = n;
    }

    public String toString() {
        return "AEBoundingSphere | x: " + this.pos.x + " y: " + this.pos.y + " z: " + this.pos.z + " r: " + this.r;
    }
}

