/*
 * Decompiled with CFR 0.152.
 */
package AbyssEngine;

import AbyssEngine.AEBoundingSphere;
import AbyssEngine.AEGraphNode;
import AbyssEngine.AELeafNode;
import AbyssEngine.AEMath;
import AbyssEngine.AERenderer;
import AbyssEngine.AETransform;
import AbyssEngine.AEVector3D;
import AbyssEngine.V3Camera;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public abstract class AECamera
extends AELeafNode {
    public static final byte IS_OUTSIDE_FRUSTUM = 0;
    public static final byte IS_INTERSECTING_FRUSTUM = 1;
    public static final byte IS_INSIDE_FRUSTUM = 2;
    public int a;
    public int c;
    public int d;
    public AEVector3D[] a;
    public AEVector3D[] b;
    public int[] a;
    public static AEVector3D a = new AEVector3D();
    public static AEVector3D b = new AEVector3D();
    public static AEVector3D c = new AEVector3D();
    public int e;
    public int f;
    public int g;
    public int h;

    public AECamera(int n, int n2, int n3, int n4, int n5) {
        this.a = new AEVector3D[6];
        this.b = new AEVector3D[6];
        for (int i = this.b.length - 1; i >= 0; --i) {
            this.b[i] = new AEVector3D();
        }
        this.a = new int[6];
        this.a[0] = new AEVector3D(0, 0, -4096);
        this.a[1] = new AEVector3D(0, 0, 4096);
        this.a[2] = new AEVector3D();
        this.a[3] = new AEVector3D();
        this.a[4] = new AEVector3D();
        this.a[5] = new AEVector3D();
        this.e = n;
        this.f = n2;
        this.setPerspective(n3, n4, n5);
    }

    public AECamera(int n, int n2) {
        this(n, n2, 1024, 10, 8192);
    }

    public AECamera(AECamera aECamera) {
        super(aECamera);
        this.a = aECamera.a;
        this.c = aECamera.c;
        this.d = aECamera.d;
        System.arraycopy(aECamera.b, 0, this.b, 0, aECamera.b.length);
        System.arraycopy(aECamera.a, 0, this.a, 0, aECamera.a.length);
        System.arraycopy(aECamera.a, 0, this.a, 0, aECamera.a.length);
        this.g = aECamera.g;
        this.h = aECamera.h;
        this.e = aECamera.e;
        this.f = aECamera.f;
    }

    public void update(boolean bl) {
        if (((AEGraphNode)this).b || bl) {
            if (((AEGraphNode)this).a != null) {
                ((AEGraphNode)this).b = ((AEGraphNode)this).a.b.multiply(((AEGraphNode)this).a, ((AEGraphNode)this).b);
            } else {
                ((AEGraphNode)this).b.set(((AEGraphNode)this).a);
            }
            this.b = ((AEGraphNode)this).b.getRotated(this.a, this.b);
            a = ((AEGraphNode)this).b.getPosition(a);
            b = ((AEGraphNode)this).b.getDirection(b);
            c.set(b);
            b.mul(-this.c);
            c.mul(-this.d);
            b.add(a);
            c.add(a);
            this.a[0] = b.dot(this.b[0]);
            this.a[1] = c.dot(this.b[1]);
            this.a[2] = a.dot(this.b[2]);
            this.a[3] = a.dot(this.b[3]);
            this.a[4] = a.dot(this.b[4]);
            this.a[5] = a.dot(this.b[5]);
            ((AEGraphNode)this).b = false;
            ((AEGraphNode)this).c = false;
        }
    }

    public void setPerspective(int n, int n2, int n3) {
        this.a = n;
        this.c = n2;
        this.d = n3;
        int n4 = AEMath.sin(n >> 1);
        int n5 = AEMath.cos(n >> 1);
        this.a[2].set(n5, 0, -n4);
        this.a[3].set(-n5, 0, -n4);
        this.a[4].set(0, -n5, -n4);
        this.a[5].set(0, n5, -n4);
        this.g = (n4 << 12) / n5;
        this.h = this.g * ((this.e << 12) / this.f) >> 12;
    }

    public void setParallel(int n, int n2, int n3, int n4) {
        this.a[2].set(4096, 0, 0);
        this.a[3].set(-4096, 0, 0);
        this.a[4].set(0, -4096, 0);
        this.a[5].set(0, 4096, 0);
    }

    public void setFov(int n) {
        this.setPerspective(n, this.c, this.d);
    }

    public int getFov() {
        return this.a;
    }

    public boolean getScreenPosition(AEVector3D aEVector3D) {
        aEVector3D = ((AEGraphNode)this).b.inverseTransform(aEVector3D);
        if (aEVector3D.z > this.c) {
            return false;
        }
        int n = this.h * aEVector3D.z >> 12;
        int n2 = this.g * aEVector3D.z >> 12;
        if (n == 0 || n2 == 0) {
            return false;
        }
        aEVector3D.x = -((aEVector3D.x << 11) / n * this.e >> 12) + (this.e >> 1);
        aEVector3D.y = ((aEVector3D.y << 11) / n2 * this.f >> 12) + (this.f >> 1);
        return aEVector3D.x >= 0 && aEVector3D.y >= 0 && aEVector3D.x < this.e && aEVector3D.y < this.f;
    }

    public void setClippingPlanes(int n, int n2) {
        this.setPerspective(this.a, n, n2);
    }

    public byte isInFrustum(AEBoundingSphere aEBoundingSphere) {
        for (int i = 5; i >= 0; --i) {
            int n = aEBoundingSphere.pos.dot(this.b[i]) - this.a[i];
            if (n < -aEBoundingSphere.r) {
                return 0;
            }
            if (AEMath.abs(n) >= aEBoundingSphere.r) continue;
            return 1;
        }
        return 2;
    }

    public void prerender(AECamera aECamera, AERenderer aERenderer) {
    }

    public void prerenderNoCull(AECamera aECamera, AERenderer aERenderer) {
    }

    public abstract void setCamera();

    public AETransform getViewMatrix(AETransform aETransform) {
        aETransform = ((AEGraphNode)this).b.getInverse(aETransform);
        return aETransform;
    }

    public AETransform getViewMatrix() {
        return ((AEGraphNode)this).b.getInverse();
    }

    public static AECamera create(int n, int n2, int n3, int n4, int n5) {
        return new V3Camera(n, n2, n3, n4, n5);
    }

    public abstract AECamera getCamera();

    public static AECamera create(int n, int n2) {
        return new V3Camera(n, n2);
    }
}

