/*
 * Decompiled with CFR 0.152.
 */
package AbyssEngine;

import AbyssEngine.AEMath;
import AbyssEngine.AEVector3D;

public class AEQuaternion {
    public int x;
    public int y;
    public int z;
    public int w;

    public AEQuaternion(int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.z = n3;
        this.w = n4;
    }

    public AEQuaternion(AEQuaternion aEQuaternion) {
        this.x = aEQuaternion.x;
        this.y = aEQuaternion.y;
        this.z = aEQuaternion.z;
        this.w = aEQuaternion.w;
    }

    public AEQuaternion() {
        this(0, 0, 0, 4096);
    }

    public AEQuaternion multiply(AEQuaternion aEQuaternion, AEQuaternion aEQuaternion2) {
        aEQuaternion2.w = (this.w * aEQuaternion.w >> 12) - (this.x * aEQuaternion.x >> 12) - (this.y * aEQuaternion.y >> 12) - (this.z * aEQuaternion.z >> 12);
        aEQuaternion2.x = (this.w * aEQuaternion.x >> 12) + (this.x * aEQuaternion.w >> 12) + (this.y * aEQuaternion.z >> 12) - (this.z * aEQuaternion.y >> 12);
        aEQuaternion2.y = (this.w * aEQuaternion.y >> 12) + (this.y * aEQuaternion.w >> 12) + (this.z * aEQuaternion.x >> 12) - (this.x * aEQuaternion.z >> 12);
        aEQuaternion2.z = (this.w * aEQuaternion.z >> 12) + (this.z * aEQuaternion.w >> 12) + (this.x * aEQuaternion.y >> 12) - (this.y * aEQuaternion.x >> 12);
        return aEQuaternion2;
    }

    public void multiply(AEQuaternion aEQuaternion) {
        int n = (this.w * aEQuaternion.x >> 12) + (this.x * aEQuaternion.w >> 12) + (this.y * aEQuaternion.z >> 12) - (this.z * aEQuaternion.y >> 12);
        int n2 = (this.w * aEQuaternion.y >> 12) + (this.y * aEQuaternion.w >> 12) + (this.z * aEQuaternion.x >> 12) - (this.x * aEQuaternion.z >> 12);
        int n3 = (this.w * aEQuaternion.z >> 12) + (this.z * aEQuaternion.w >> 12) + (this.x * aEQuaternion.y >> 12) - (this.y * aEQuaternion.x >> 12);
        int n4 = (this.w * aEQuaternion.w >> 12) - (this.x * aEQuaternion.x >> 12) - (this.y * aEQuaternion.y >> 12) - (this.z * aEQuaternion.z >> 12);
        this.x = n;
        this.y = n2;
        this.z = n3;
        this.w = n4;
    }

    public AEQuaternion multiplyL(AEQuaternion aEQuaternion, AEQuaternion aEQuaternion2) {
        aEQuaternion2.x = (int)((long)this.w * (long)aEQuaternion.x + (long)this.x * (long)aEQuaternion.w + (long)this.y * (long)aEQuaternion.z - (long)this.z * (long)aEQuaternion.y >> 12);
        aEQuaternion2.y = (int)((long)this.w * (long)aEQuaternion.y + (long)this.y * (long)aEQuaternion.w + (long)this.z * (long)aEQuaternion.x - (long)this.x * (long)aEQuaternion.z >> 12);
        aEQuaternion2.z = (int)((long)this.w * (long)aEQuaternion.z + (long)this.z * (long)aEQuaternion.w + (long)this.x * (long)aEQuaternion.y - (long)this.y * (long)aEQuaternion.x >> 12);
        aEQuaternion2.w = (int)((long)this.w * (long)aEQuaternion.w - (long)this.x * (long)aEQuaternion.x - (long)this.y * (long)aEQuaternion.y - (long)this.z * (long)aEQuaternion.z >> 12);
        return aEQuaternion2;
    }

    public void multiplyL(AEQuaternion aEQuaternion) {
        int n = (int)((long)this.w * (long)aEQuaternion.x + (long)this.x * (long)aEQuaternion.w + (long)this.y * (long)aEQuaternion.z - (long)this.z * (long)aEQuaternion.y >> 12);
        int n2 = (int)((long)this.w * (long)aEQuaternion.y + (long)this.y * (long)aEQuaternion.w + (long)this.z * (long)aEQuaternion.x - (long)this.x * (long)aEQuaternion.z >> 12);
        int n3 = (int)((long)this.w * (long)aEQuaternion.z + (long)this.z * (long)aEQuaternion.w + (long)this.x * (long)aEQuaternion.y - (long)this.y * (long)aEQuaternion.x >> 12);
        int n4 = (int)((long)this.w * (long)aEQuaternion.w - (long)this.x * (long)aEQuaternion.x - (long)this.y * (long)aEQuaternion.y - (long)this.z * (long)aEQuaternion.z >> 12);
        this.x = n;
        this.y = n2;
        this.z = n3;
        this.w = n4;
    }

    public void mul(int n) {
        this.x = (int)((long)n * (long)this.x >> 12);
        this.y = (int)((long)n * (long)this.y >> 12);
        this.z = (int)((long)n * (long)this.z >> 12);
        this.w = (int)((long)n * (long)this.w >> 12);
    }

    public AEQuaternion mul(int n, AEQuaternion aEQuaternion) {
        aEQuaternion.x = (int)((long)n * (long)this.x >> 12);
        aEQuaternion.y = (int)((long)n * (long)this.y >> 12);
        aEQuaternion.z = (int)((long)n * (long)this.z >> 12);
        aEQuaternion.w = (int)((long)n * (long)this.w >> 12);
        return aEQuaternion;
    }

    public int dot(AEQuaternion aEQuaternion) {
        return (this.w * aEQuaternion.w >> 12) + (this.x * aEQuaternion.x >> 12) + (this.y * aEQuaternion.y >> 12) + (this.z * aEQuaternion.z >> 12);
    }

    public int dotL(AEQuaternion aEQuaternion) {
        return (int)((long)this.x * (long)aEQuaternion.x + (long)this.y * (long)aEQuaternion.y + (long)this.z * (long)aEQuaternion.z + (long)this.w * (long)aEQuaternion.w >> 12);
    }

    public AEQuaternion normalize(AEQuaternion aEQuaternion) {
        int n = AEMath.invsqrt((this.x * this.x >> 12) + (this.y * this.y >> 12) + (this.z * this.z >> 12) + (this.w * this.w >> 12));
        aEQuaternion.x = this.x * n >> 12;
        aEQuaternion.y = this.y * n >> 12;
        aEQuaternion.z = this.z * n >> 12;
        aEQuaternion.w = this.w * n >> 12;
        return aEQuaternion;
    }

    public AEQuaternion normalizeL(AEQuaternion aEQuaternion) {
        int n = AEMath.invsqrt((int)((long)this.x * (long)this.x + (long)this.y * (long)this.y + (long)this.z * (long)this.z + (long)this.w * (long)this.w >> 12));
        aEQuaternion.x = this.x * n >> 12;
        aEQuaternion.y = this.y * n >> 12;
        aEQuaternion.z = this.z * n >> 12;
        aEQuaternion.w = this.w * n >> 12;
        return aEQuaternion;
    }

    public void normalize() {
        this.normalize(this);
    }

    public void normalizeL() {
        this.normalizeL(this);
    }

    public int length() {
        return AEMath.sqrt((int)((long)this.x * (long)this.x + (long)this.y * (long)this.y + (long)this.z * (long)this.z + (long)this.w * (long)this.w >> 12));
    }

    public int invLength() {
        return AEMath.invsqrt((int)((long)this.x * (long)this.x + (long)this.y * (long)this.y + (long)this.z * (long)this.z + (long)this.w * (long)this.w >> 12));
    }

    public AEQuaternion getConjugate(AEQuaternion aEQuaternion) {
        aEQuaternion.x = -this.x;
        aEQuaternion.y = -this.y;
        aEQuaternion.z = -this.z;
        aEQuaternion.w = this.w;
        return aEQuaternion;
    }

    public AEQuaternion getInverse(AEQuaternion aEQuaternion) {
        int n = this.invLength();
        if (n > 4050 && n < 4140) {
            return this.getConjugate(aEQuaternion);
        }
        aEQuaternion = this.getConjugate(aEQuaternion);
        n *= n;
        aEQuaternion = aEQuaternion.mul(n >> 12, aEQuaternion);
        return aEQuaternion;
    }

    public void invert() {
        this.getInverse(this);
    }

    public void conjugate() {
        this.getConjugate(this);
    }

    public void set(int n, int n2, int n3, int n4) {
        this.x = n;
        this.y = n2;
        this.z = n3;
        this.w = n4;
    }

    public void set(AEVector3D aEVector3D, int n) {
        this.set(aEVector3D.x, aEVector3D.y, aEVector3D.z, n);
    }

    public void set(AEQuaternion aEQuaternion) {
        this.set(aEQuaternion.x, aEQuaternion.y, aEQuaternion.z, aEQuaternion.w);
    }

    public String toString() {
        return "AEQuaternion | " + this.x + ",\t" + this.y + ",\t" + this.z + ",\t" + this.w;
    }
}

