/*
 * Decompiled with CFR 0.152.
 */
package AbyssEngine;

import AbyssEngine.AEMath;

public class AEVector3D {
    public int x;
    public int y;
    public int z;

    public AEVector3D(int n, int n2, int n3) {
        this.x = n;
        this.y = n2;
        this.z = n3;
    }

    public AEVector3D() {
        this.z = 0;
        this.y = 0;
        this.x = 0;
    }

    public AEVector3D(AEVector3D aEVector3D) {
        this.x = aEVector3D.x;
        this.y = aEVector3D.y;
        this.z = aEVector3D.z;
    }

    public void set(AEVector3D aEVector3D) {
        this.x = aEVector3D.x;
        this.y = aEVector3D.y;
        this.z = aEVector3D.z;
    }

    public void set(int n, int n2, int n3) {
        this.x = n;
        this.y = n2;
        this.z = n3;
    }

    public int dot(AEVector3D aEVector3D) {
        return (this.x * aEVector3D.x >> 12) + (this.y * aEVector3D.y >> 12) + (this.z * aEVector3D.z >> 12);
    }

    public int scalarTripleProduct(AEVector3D aEVector3D, AEVector3D aEVector3D2, AEVector3D aEVector3D3) {
        aEVector3D3 = this.cross(aEVector3D, aEVector3D3);
        return aEVector3D3.dot(aEVector3D2);
    }

    public int dotL(AEVector3D aEVector3D) {
        return (int)(((long)this.x * (long)aEVector3D.x >> 12) + ((long)this.y * (long)aEVector3D.y >> 12) + ((long)this.z * (long)aEVector3D.z >> 12));
    }

    public AEVector3D cross(AEVector3D aEVector3D, AEVector3D aEVector3D2) {
        aEVector3D2.x = (this.y * aEVector3D.z >> 12) - (this.z * aEVector3D.y >> 12);
        aEVector3D2.y = (this.z * aEVector3D.x >> 12) - (this.x * aEVector3D.z >> 12);
        aEVector3D2.z = (this.x * aEVector3D.y >> 12) - (this.y * aEVector3D.x >> 12);
        return aEVector3D2;
    }

    public AEVector3D crossL(AEVector3D aEVector3D, AEVector3D aEVector3D2) {
        aEVector3D2.x = (int)(((long)this.y * (long)aEVector3D.z >> 12) - ((long)this.z * (long)aEVector3D.y >> 12));
        aEVector3D2.y = (int)(((long)this.z * (long)aEVector3D.x >> 12) - ((long)this.x * (long)aEVector3D.z >> 12));
        aEVector3D2.z = (int)(((long)this.x * (long)aEVector3D.y >> 12) - ((long)this.y * (long)aEVector3D.x >> 12));
        return aEVector3D2;
    }

    public void cross(AEVector3D aEVector3D) {
        int n = this.x;
        int n2 = this.y;
        this.x = (this.y * aEVector3D.z >> 12) - (this.z * aEVector3D.y >> 12);
        this.y = (this.z * aEVector3D.x >> 12) - (n * aEVector3D.z >> 12);
        this.z = (n * aEVector3D.y >> 12) - (n2 * aEVector3D.x >> 12);
    }

    public AEVector3D add(AEVector3D aEVector3D, AEVector3D aEVector3D2) {
        aEVector3D2.x = this.x + aEVector3D.x;
        aEVector3D2.y = this.y + aEVector3D.y;
        aEVector3D2.z = this.z + aEVector3D.z;
        return aEVector3D2;
    }

    public void add(AEVector3D aEVector3D) {
        this.x += aEVector3D.x;
        this.y += aEVector3D.y;
        this.z += aEVector3D.z;
    }

    public AEVector3D sub(AEVector3D aEVector3D, AEVector3D aEVector3D2) {
        aEVector3D2.x = this.x - aEVector3D.x;
        aEVector3D2.y = this.y - aEVector3D.y;
        aEVector3D2.z = this.z - aEVector3D.z;
        return aEVector3D2;
    }

    public void sub(AEVector3D aEVector3D) {
        this.x -= aEVector3D.x;
        this.y -= aEVector3D.y;
        this.z -= aEVector3D.z;
    }

    public AEVector3D mul(int n, AEVector3D aEVector3D) {
        aEVector3D.x = (int)((long)n * (long)this.x >> 12);
        aEVector3D.y = (int)((long)n * (long)this.y >> 12);
        aEVector3D.z = (int)((long)n * (long)this.z >> 12);
        return aEVector3D;
    }

    public void mul(int n) {
        this.x = (int)((long)n * (long)this.x >> 12);
        this.y = (int)((long)n * (long)this.y >> 12);
        this.z = (int)((long)n * (long)this.z >> 12);
    }

    public AEVector3D div(int n, AEVector3D aEVector3D) {
        aEVector3D.x = (this.x << 12) / n;
        aEVector3D.y = (this.y << 12) / n;
        aEVector3D.z = (this.z << 12) / n;
        return aEVector3D;
    }

    public void div(int n) {
        this.x = (this.x << 12) / n;
        this.y = (this.y << 12) / n;
        this.z = (this.z << 12) / n;
    }

    public AEVector3D normalize(AEVector3D aEVector3D) {
        int n = AEMath.invsqrt((int)(((long)this.x * (long)this.x >> 12) + ((long)this.y * (long)this.y >> 12) + ((long)this.z * (long)this.z >> 12)));
        aEVector3D.x = this.x * n >> 12;
        aEVector3D.y = this.y * n >> 12;
        aEVector3D.z = this.z * n >> 12;
        return aEVector3D;
    }

    public void normalize() {
        this.normalize(this);
    }

    public int length() {
        return AEMath.sqrt(((long)this.x * (long)this.x >> 12) + ((long)this.y * (long)this.y >> 12) + ((long)this.z * (long)this.z >> 12));
    }

    public int invLength() {
        return AEMath.invsqrt((int)(((long)this.x * (long)this.x >> 12) + ((long)this.y * (long)this.y >> 12) + ((long)this.z * (long)this.z >> 12)));
    }

    public String toString() {
        return "AEVector3D | " + this.x + ",\t" + this.y + ",\t" + this.z;
    }
}

