/*
 * Decompiled with CFR 0.152.
 */
package FLToolkit;

import FLToolkit.AEImageFont;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class AEFont {
    private static AEImageFont[] font;
    private static byte current_font;
    public static final byte TYPE_BIG = 1;
    public static final byte TYPE_SMALL = 2;
    private static Graphics graphics;
    public static final int LEFT = 1;
    public static final int RIGHT = 2;
    public static final int VCENTER = 4;
    public static final int HCENTER = 8;
    public static final int TOP = 16;
    public static final int BOTTOM = 32;

    public static void release() {
        if (font != null) {
            for (int i = 0; i < font.length; ++i) {
                AEFont.font[i] = null;
            }
            font = null;
        }
        System.gc();
    }

    public static void releaseFont(byte fontId) {
        if (font != null && fontId < font.length) {
            font[fontId].release();
        }
    }

    public static void setGraphics(Graphics device) {
        graphics = device;
        if (font != null) {
            for (int i = 0; i < font.length; ++i) {
                font[i].setGraphics(graphics);
            }
        }
    }

    public static void addFont(String filename, byte font_type, int num_rows, int num_cols) {
        if (graphics != null) {
            if (font == null) {
                font = new AEImageFont[1];
                AEFont.font[0] = new AEImageFont(filename, graphics, font_type, num_rows, num_cols);
            } else {
                AEImageFont[] new_font = new AEImageFont[font.length + 1];
                System.arraycopy(font, 0, new_font, 0, font.length);
                new_font[AEFont.font.length] = new AEImageFont(filename, graphics, font_type, num_rows, num_cols);
                font = new_font;
            }
        }
    }

    public static void setFont(byte id) {
        if (id < 0 || id >= font.length) {
            return;
        }
        current_font = id;
    }

    public static void drawString(String str, int x, int y, int anchor) {
        AEFont.drawString(str, x, y, current_font, anchor);
    }

    public static void setOffset(int y) {
        AEFont.setOffset(y, current_font);
    }

    public static void setOffset(int y, byte id) {
        if (id < 0 || id >= font.length) {
            return;
        }
        font[id].setOffset(y);
    }

    public static int getOffsetY() {
        return AEFont.getOffsetY(current_font);
    }

    public static int getOffsetY(byte id) {
        if (id < 0 || id >= font.length) {
            return 0;
        }
        return font[id].getOffsetY();
    }

    public static void drawString(String str, int x, int y) {
        AEFont.drawString(str, x, y, current_font);
    }

    public static void drawString(String str, int x, int y, byte fontId) {
        if (fontId < 0 || fontId >= font.length) {
            return;
        }
        font[fontId].drawString(str, x, y);
    }

    public static void drawString(String str, int x, int y, byte fontId, int anchor) {
        if ((anchor & 8) != 0) {
            x -= font[fontId].getStringWidth(str) >> 1;
        }
        if ((anchor & 4) != 0) {
            y -= font[fontId].getRowHeight() >> 1;
        } else if ((anchor & 0x20) != 0) {
            y -= font[fontId].getRowHeight();
        }
        if ((anchor & 2) != 0) {
            font[fontId].drawString_rightAligned(str, x, y);
        } else {
            font[fontId].drawString(str, x, y);
        }
    }

    public static void drawLines(String[] str, int x, int y) {
        AEFont.drawLines(str, x, y, current_font);
    }

    public static void drawLines(String[] str, int x, int y, byte fontId) {
        if (fontId < 0 || fontId >= font.length) {
            return;
        }
        for (int i = 0; i < str.length; ++i) {
            font[fontId].drawString(str[i], x, y + i * AEFont.getRowHeight());
        }
    }

    public static void drawLines(String[] str, int x, int y, byte fontId, int anchor, int rowHeight) {
        if (fontId < 0 || fontId >= font.length) {
            return;
        }
        int moveX = 0;
        for (int i = 0; i < str.length; ++i) {
            if ((anchor & 8) != 0) {
                moveX = -(font[fontId].getStringWidth(str[i]) >> 1);
            }
            if ((anchor & 2) != 0) {
                font[fontId].drawString_rightAligned(str[i], x, y + i * rowHeight);
                continue;
            }
            font[fontId].drawString(str[i], x + moveX, y + i * rowHeight);
        }
    }

    public static void drawLines(String[] str, int x, int y, byte fontId, int anchor) {
        AEFont.drawLines(str, x, y, fontId, anchor, AEFont.getRowHeight());
    }

    public static void drawLines270(String[] str, int x, int y, byte fontId) {
        if (fontId < 0 || fontId >= font.length) {
            return;
        }
        font[fontId].drawLines270(str, x, y);
    }

    public static void drawLines90(String[] str, int x, int y, byte fontId) {
        if (fontId < 0 || fontId >= font.length) {
            return;
        }
        font[fontId].drawLines90(str, x, y);
    }

    public static void drawString90(String str, int x, int y) {
        font[current_font].drawString90(str, x, y);
    }

    public static void drawString270(String str, int x, int y) {
        font[current_font].drawString270(str, x, y);
    }

    public static void drawSubString(String str, int beginIndex, int endIndex, int x, int y) {
        font[current_font].drawSubString(str, beginIndex, endIndex, x, y);
    }

    public static void drawSubString90(String str, int beginIndex, int endIndex, int x, int y) {
        font[current_font].drawSubString90(str, beginIndex, endIndex, x, y);
    }

    public static void drawSubString270(String str, int beginIndex, int endIndex, int x, int y) {
        font[current_font].drawSubString270(str, beginIndex, endIndex, x, y);
    }

    public static void applyPattern(String filename, int id) {
        if (id < 0 || id >= font.length) {
            return;
        }
        try {
            Image pattern = Image.createImage((String)filename);
            font[id].applyPattern(pattern);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void applyColor(int r, int g, int b2, int ignoreColor, int id) {
        if (id < 0 || id >= font.length) {
            return;
        }
        font[id].applyColor(r, g, b2, ignoreColor);
    }

    public static void applyColor(int color, int ignoreColor, int id) {
        if (id < 0 || id >= font.length) {
            return;
        }
        font[id].applyColor(color, ignoreColor);
    }

    public static void applyColor(int r, int g, int b2, byte fontId) {
        AEFont.applyColor(r, g, b2, -1, fontId);
    }

    public static void applyColor(int color, byte fontId) {
        AEFont.applyColor(color, -1, fontId);
    }

    public static int getStringWidth(String str) {
        return AEFont.getStringWidth(str, current_font);
    }

    public static int getSubStringWidth(String str, int beginIndex, int endIndex, byte fontId) {
        return font[fontId].getSubStringWidth(str, beginIndex, endIndex);
    }

    public static int getSubStringWidth(String str, int beginIndex, int endIndex) {
        return AEFont.getSubStringWidth(str, beginIndex, endIndex, current_font);
    }

    public static int getStringWidth(String str, byte fontId) {
        if (fontId < 0 || fontId >= font.length) {
            return 0;
        }
        return font[fontId].getStringWidth(str);
    }

    public static int getSpacing() {
        return font[current_font].getSpacing();
    }

    public static int getSpacing(int id) {
        if (id < 0 || id >= font.length) {
            return 0;
        }
        return font[id].getSpacing();
    }

    public static void setSpacing(int spacing) {
        font[current_font].setSpacing(spacing);
    }

    public static void setSpacing(int spacing, int id) {
        if (id < 0 || id >= font.length) {
            return;
        }
        font[id].setSpacing(spacing);
    }

    public static int getRowHeight(int id) {
        if (id < 0 || id >= font.length) {
            return 0;
        }
        return font[id].getRowHeight();
    }

    public static int getRowHeight() {
        return font[current_font].getRowHeight();
    }

    public static int getFrameHeight(int id) {
        if (id < 0 || id >= font.length) {
            return 0;
        }
        return font[id].getFrameHeight();
    }

    public static int getFrameHeight() {
        return font[current_font].getFrameHeight();
    }

    public static void setRowHeight(int row_height) {
        font[current_font].setRowHeight(row_height);
    }

    public static void setRowHeight(int row_height, int id) {
        if (id < 0 || id >= font.length) {
            return;
        }
        font[id].setRowHeight(row_height);
    }

    public static String[] getLineArray(String text, int w, byte fontId) {
        int charIndex;
        int lineArraySize = 0;
        String tempString = "";
        text = text + "\n";
        for (charIndex = 0; charIndex < text.length(); charIndex += tempString.length()) {
            tempString = AEFont.getLine(text.substring(charIndex, text.length()), w, fontId);
            ++lineArraySize;
        }
        String[] lineArray = new String[lineArraySize];
        charIndex = 0;
        for (int lineIndex = 0; lineIndex < lineArraySize; ++lineIndex) {
            lineArray[lineIndex] = AEFont.getLine(text.substring(charIndex, text.length()), w, fontId);
            charIndex += lineArray[lineIndex].length();
            lineArray[lineIndex].trim();
        }
        return lineArray;
    }

    public static String[] getLineArray(String text, int w) {
        return AEFont.getLineArray(text, w, current_font);
    }

    public static String getLine(String str, int w, byte fontId) {
        int last_space = 0;
        int c_start = 0;
        int c_pixel_width = AEFont.getFrameHeight(fontId) >> 1;
        int row_spacing = AEFont.getRowHeight(fontId);
        int c_y = -row_spacing;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == ' ' || str.charAt(i) == '\n' || str.charAt(i) == '\r') {
                last_space = i;
            }
            if ((c_pixel_width += AEFont.getSubStringWidth(str, i, i + 1, fontId)) >= w) {
                c_y += row_spacing;
                if (c_start < last_space) {
                    return str.substring(c_start, last_space + 1);
                }
                return str.substring(c_start, i + 1);
            }
            if (str.charAt(i) != '\n' && str.charAt(i) != '\r') continue;
            if (str.charAt(i) == '\n') {
                return str.substring(c_start, i + 1).replace('\n', ' ');
            }
            return str.substring(c_start, i + 1).replace('\r', ' ');
        }
        if (c_start < str.length() - 1) {
            c_y += row_spacing;
            return str.substring(c_start, str.length());
        }
        return "";
    }

    public static String getLine(String str, int w) {
        return AEFont.getLine(str, w, current_font);
    }
}

