/*
 * Decompiled with CFR 0.152.
 */
package FLToolkit;

import FLToolkit.AEFont;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class AEImageFont {
    private String filename;
    private Image font_image;
    private short[] source_x;
    private short[] source_y;
    private byte[] c_width;
    private byte c_height;
    private byte frame_height;
    private byte c_frame_width;
    private static Graphics g;
    private byte spacing;
    private byte num_rows = (byte)4;
    private byte num_cols = (byte)16;
    private byte font_type;
    private byte offsetY = 0;

    public AEImageFont(String filename, Graphics graphics, byte font_type, int num_rows, int num_cols) {
        this.filename = filename;
        g = graphics;
        this.font_type = font_type;
        this.num_rows = (byte)num_rows;
        this.num_cols = (byte)num_cols;
        try {
            this.font_image = Image.createImage((String)filename);
            this.source_x = new short[num_rows * num_cols];
            this.source_y = new short[this.source_x.length];
            this.c_width = new byte[this.source_x.length];
            this.frame_height = this.c_height = (byte)(this.font_image.getHeight() / num_rows);
            this.c_frame_width = (byte)(this.font_image.getWidth() / num_cols);
            int[] rgba = new int[this.font_image.getWidth() * this.font_image.getHeight()];
            this.font_image.getRGB(rgba, 0, this.font_image.getWidth(), 0, 0, this.font_image.getWidth(), this.font_image.getHeight());
            for (int i = 0; i < num_cols; ++i) {
                for (int k = 0; k < num_rows; ++k) {
                    this.source_x[i + num_cols * k] = (short)(i * this.c_frame_width);
                    this.source_y[i + num_cols * k] = (short)(k * this.c_height);
                    this.c_width[i + num_cols * k] = this.getCharWidth(i * this.c_frame_width, k * this.c_height, rgba);
                }
            }
            this.c_width[this.getCharIndex((char)'1')] = this.c_width[this.getCharIndex('0')];
            this.spacing = 1;
            this.c_width[0] = 4;
        }
        catch (Exception e) {
            this.font_image = null;
        }
        System.gc();
    }

    public AEImageFont(AEImageFont imgFont) {
        this.font_image = Image.createImage((Image)imgFont.font_image, (int)0, (int)0, (int)imgFont.font_image.getWidth(), (int)imgFont.font_image.getHeight(), (int)0);
        this.source_x = new short[imgFont.source_x.length];
        this.source_y = new short[imgFont.source_y.length];
        this.c_width = new byte[imgFont.c_width.length];
        this.num_cols = imgFont.num_cols;
        this.num_rows = imgFont.num_rows;
        this.font_type = imgFont.font_type;
        System.arraycopy(imgFont.source_x, 0, this.source_x, 0, imgFont.source_x.length);
        System.arraycopy(imgFont.source_y, 0, this.source_y, 0, imgFont.source_y.length);
        System.arraycopy(imgFont.c_width, 0, this.c_width, 0, imgFont.c_width.length);
        this.c_height = imgFont.c_height;
        this.frame_height = imgFont.frame_height;
        this.spacing = imgFont.spacing;
        this.offsetY = imgFont.offsetY;
    }

    public void release() {
        this.font_image = null;
        this.source_x = null;
        this.source_y = null;
        this.c_width = null;
        this.c_height = 0;
        this.frame_height = 0;
        this.spacing = 0;
        this.font_type = 0;
    }

    public void setGraphics(Graphics graphics) {
        g = graphics;
    }

    public AEImageFont copy() {
        return new AEImageFont(this);
    }

    public void setDimension(int num_rows, int num_cols) {
        this.num_rows = (byte)num_rows;
        this.num_cols = (byte)num_cols;
    }

    public void applyColor(int color, int ignoreColor) {
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b2 = color & 0xFF;
        this.applyColor(r, g, b2, ignoreColor);
    }

    public void applyColor(int color) {
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b2 = color & 0xFF;
        this.applyColor(r, g, b2, -1);
    }

    public void applyColor(int r, int g, int b2) {
        this.applyColor(r, g, b2, -1);
    }

    public void applyColor(int r, int g, int b2, int ignoreColor) {
        Image new_font_image;
        boolean useIgnoreColor = ignoreColor != -1;
        int[] rgba = new int[this.font_image.getWidth() * this.font_image.getHeight()];
        this.font_image.getRGB(rgba, 0, this.font_image.getWidth(), 0, 0, this.font_image.getWidth(), this.font_image.getHeight());
        int scanline = this.font_image.getWidth();
        int buffer_pos = 0;
        for (int i = 0; i < this.font_image.getHeight(); ++i) {
            for (int k = 0; k < this.font_image.getWidth(); ++k) {
                if (useIgnoreColor) {
                    long colorWithoutTransp = rgba[k + buffer_pos] & 0xFFFFFF;
                    if (colorWithoutTransp == (long)ignoreColor) continue;
                    int ca = rgba[k + buffer_pos] >> 24 & 0xFF;
                    rgba[k + buffer_pos] = ca << 24 | r << 16 | g << 8 | b2;
                    continue;
                }
                int ca = rgba[k + buffer_pos] >> 24 & 0xFF;
                rgba[k + buffer_pos] = ca << 24 | r << 16 | g << 8 | b2;
            }
            buffer_pos += scanline;
        }
        this.font_image = new_font_image = Image.createRGBImage((int[])rgba, (int)this.font_image.getWidth(), (int)this.font_image.getHeight(), (boolean)true);
    }

    public void applyPattern(Image pattern) {
        Image new_font_image;
        int[] rgba = new int[this.font_image.getWidth() * this.font_image.getHeight()];
        this.font_image.getRGB(rgba, 0, this.font_image.getWidth(), 0, 0, this.font_image.getWidth(), this.font_image.getHeight());
        int[] prgba = new int[pattern.getWidth() * pattern.getHeight()];
        pattern.getRGB(prgba, 0, pattern.getWidth(), 0, 0, pattern.getWidth(), pattern.getHeight());
        int cx = 0;
        int cy = 0;
        for (int i = 0; i < this.font_image.getWidth(); ++i) {
            for (int k = 0; k < this.font_image.getHeight(); ++k) {
                int r = (rgba[i + k * this.font_image.getWidth()] >> 16 & 0xFF) * (prgba[cx + cy * pattern.getWidth()] >> 16 & 0xFF) >> 8;
                int g = (rgba[i + k * this.font_image.getWidth()] >> 8 & 0xFF) * (prgba[cx + cy * pattern.getWidth()] >> 8 & 0xFF) >> 8;
                int b2 = (rgba[i + k * this.font_image.getWidth()] & 0xFF) * (prgba[cx + cy * pattern.getWidth()] & 0xFF) >> 8;
                int a2 = (rgba[i + k * this.font_image.getWidth()] >> 24 & 0xFF) * (prgba[cx + cy * pattern.getWidth()] >> 24 & 0xFF) >> 8;
                rgba[i + k * this.font_image.getWidth()] = a2 << 24 | r << 16 | g << 8 | b2;
                if (++cy < pattern.getHeight()) continue;
                cy = 0;
            }
            if (++cx < pattern.getWidth()) continue;
            cx = 0;
        }
        this.font_image = new_font_image = Image.createRGBImage((int[])rgba, (int)this.font_image.getWidth(), (int)this.font_image.getHeight(), (boolean)true);
    }

    public void setSpacing(int spacing) {
        this.spacing = (byte)spacing;
    }

    public int getSpacing() {
        return this.spacing;
    }

    private byte getCharWidth(int x, int y, int[] rgba) {
        byte result = (byte)(this.c_frame_width - 1);
        block0: for (byte i = 0; i < this.c_frame_width; i = (byte)(i + 1)) {
            for (byte k = 0; k < this.c_height; k = (byte)(k + 1)) {
                if ((rgba[i + x + (k + y) * this.font_image.getWidth()] >> 24 & 0xFF) <= 0) continue;
                result = i;
                continue block0;
            }
        }
        return (byte)(result + 1);
    }

    public int getStringWidth(String str) {
        int result = 0;
        int cc = 0;
        for (int i = 0; i < str.length(); ++i) {
            cc = this.getCharIndex(str.charAt(i));
            if (cc == -1) {
                cc = this.getCharIndex('.');
                for (int j = 0; j < 3; ++j) {
                    result += this.c_width[cc] + this.spacing;
                }
                continue;
            }
            result += this.c_width[cc] + this.spacing;
        }
        return result;
    }

    public int getSubStringWidth(String str, int beginIndex, int endIndex) {
        int result = 0;
        int cc = 0;
        beginIndex = beginIndex >= 0 ? beginIndex : 0;
        endIndex = endIndex <= str.length() ? endIndex : str.length();
        for (int i = beginIndex; i < endIndex; ++i) {
            cc = this.getCharIndex(str.charAt(i));
            if (cc == -1) {
                cc = this.getCharIndex('.');
                for (int j = 0; j < 3; ++j) {
                    result += this.c_width[cc] + this.spacing;
                }
                continue;
            }
            result += this.c_width[cc] + this.spacing;
        }
        return result;
    }

    public int getCharIndex(char character) {
        if (this.font_type == 2) {
            switch (character) {
                case ' ': {
                    return 0;
                }
                case '!': {
                    return 1;
                }
                case '\"': {
                    return 2;
                }
                case '#': {
                    return 3;
                }
                case '$': {
                    return 4;
                }
                case '%': {
                    return 5;
                }
                case '&': {
                    return 6;
                }
                case '\'': 
                case '`': 
                case '\u2019': {
                    return 7;
                }
                case '(': {
                    return 8;
                }
                case ')': {
                    return 9;
                }
                case '*': {
                    return 10;
                }
                case '+': {
                    return 11;
                }
                case ',': {
                    return 12;
                }
                case '-': {
                    return 13;
                }
                case '.': {
                    return 14;
                }
                case '/': {
                    return 15;
                }
                case '0': {
                    return 16;
                }
                case '1': {
                    return 17;
                }
                case '2': {
                    return 18;
                }
                case '3': {
                    return 19;
                }
                case '4': {
                    return 20;
                }
                case '5': {
                    return 21;
                }
                case '6': {
                    return 22;
                }
                case '7': {
                    return 23;
                }
                case '8': {
                    return 24;
                }
                case '9': {
                    return 25;
                }
                case ':': {
                    return 26;
                }
                case ';': {
                    return 27;
                }
                case '<': {
                    return 28;
                }
                case '=': {
                    return 29;
                }
                case '>': {
                    return 30;
                }
                case '?': {
                    return 31;
                }
                case '@': {
                    return 32;
                }
                case 'A': 
                case '\u0410': {
                    return 33;
                }
                case 'B': 
                case '\u0412': {
                    return 34;
                }
                case 'C': 
                case '\u0421': {
                    return 35;
                }
                case 'D': {
                    return 36;
                }
                case 'E': 
                case '\u0415': {
                    return 37;
                }
                case 'F': {
                    return 38;
                }
                case 'G': {
                    return 39;
                }
                case 'H': 
                case '\u041d': {
                    return 40;
                }
                case 'I': {
                    return 41;
                }
                case 'J': {
                    return 42;
                }
                case 'K': 
                case '\u041a': {
                    return 43;
                }
                case 'L': {
                    return 44;
                }
                case 'M': 
                case '\u041c': {
                    return 45;
                }
                case 'N': {
                    return 46;
                }
                case 'O': 
                case '\u041e': {
                    return 47;
                }
                case 'P': 
                case '\u0420': {
                    return 48;
                }
                case 'Q': {
                    return 49;
                }
                case 'R': {
                    return 50;
                }
                case 'S': {
                    return 51;
                }
                case 'T': 
                case '\u0422': {
                    return 52;
                }
                case 'U': {
                    return 53;
                }
                case 'V': {
                    return 54;
                }
                case 'W': {
                    return 55;
                }
                case 'X': 
                case '\u0425': {
                    return 56;
                }
                case 'Y': {
                    return 57;
                }
                case 'Z': {
                    return 58;
                }
                case '[': {
                    return 59;
                }
                case '\\': {
                    return 60;
                }
                case ']': {
                    return 61;
                }
                case '^': {
                    return 62;
                }
                case '_': {
                    return 63;
                }
                case 'a': 
                case '\u00aa': 
                case '\u0430': {
                    return 64;
                }
                case 'b': {
                    return 65;
                }
                case 'c': 
                case '\u0441': {
                    return 66;
                }
                case 'd': {
                    return 67;
                }
                case 'e': 
                case '\u0435': {
                    return 68;
                }
                case 'f': {
                    return 69;
                }
                case 'g': {
                    return 70;
                }
                case 'h': {
                    return 71;
                }
                case 'i': {
                    return 72;
                }
                case 'j': {
                    return 73;
                }
                case 'k': {
                    return 74;
                }
                case 'l': {
                    return 75;
                }
                case 'm': {
                    return 76;
                }
                case 'n': {
                    return 77;
                }
                case 'o': 
                case '\u00ba': 
                case '\u043e': {
                    return 78;
                }
                case 'p': 
                case '\u0440': {
                    return 79;
                }
                case 'q': {
                    return 80;
                }
                case 'r': {
                    return 81;
                }
                case 's': {
                    return 82;
                }
                case 't': {
                    return 83;
                }
                case 'u': {
                    return 84;
                }
                case 'v': {
                    return 85;
                }
                case 'w': {
                    return 86;
                }
                case 'x': 
                case '\u0445': {
                    return 87;
                }
                case 'y': {
                    return 88;
                }
                case 'z': {
                    return 89;
                }
                case '{': {
                    return 90;
                }
                case '|': {
                    return 91;
                }
                case '}': {
                    return 92;
                }
                case '~': {
                    return 93;
                }
                case '\u00ae': {
                    return 94;
                }
                case '\u00a9': {
                    return 95;
                }
                case '\u0099': {
                    return 96;
                }
                case '\u00a1': {
                    return 97;
                }
                case '\u00ab': {
                    return 98;
                }
                case '\u00bb': {
                    return 99;
                }
                case '\u00bf': {
                    return 100;
                }
                case '\u00c0': {
                    return 101;
                }
                case '\u00c1': {
                    return 102;
                }
                case '\u00c2': {
                    return 103;
                }
                case '\u00c3': {
                    return 104;
                }
                case '\u00c4': {
                    return 105;
                }
                case '\u00c6': {
                    return 106;
                }
                case '\u00c7': {
                    return 107;
                }
                case '\u00c8': {
                    return 108;
                }
                case '\u00c9': {
                    return 109;
                }
                case '\u00ca': {
                    return 110;
                }
                case '\u00cb': {
                    return 111;
                }
                case '\u00cc': {
                    return 112;
                }
                case '\u00cd': {
                    return 113;
                }
                case '\u00ce': {
                    return 114;
                }
                case '\u00cf': {
                    return 115;
                }
                case '\u00d1': {
                    return 116;
                }
                case '\u00d2': {
                    return 117;
                }
                case '\u00d3': {
                    return 118;
                }
                case '\u00d4': {
                    return 119;
                }
                case '\u00d5': {
                    return 120;
                }
                case '\u00d6': {
                    return 121;
                }
                case '\u00d9': {
                    return 122;
                }
                case '\u00da': {
                    return 123;
                }
                case '\u00db': {
                    return 124;
                }
                case '\u00dc': {
                    return 125;
                }
                case '\u00df': {
                    return 126;
                }
                case '\u0178': {
                    return 127;
                }
                case '\u00e0': {
                    return 128;
                }
                case '\u00e1': {
                    return 129;
                }
                case '\u00e2': {
                    return 130;
                }
                case '\u00e3': {
                    return 131;
                }
                case '\u00e4': {
                    return 132;
                }
                case '\u00e6': {
                    return 133;
                }
                case '\u00e7': {
                    return 134;
                }
                case '\u00e8': {
                    return 135;
                }
                case '\u00e9': {
                    return 136;
                }
                case '\u00ea': {
                    return 137;
                }
                case '\u00eb': {
                    return 138;
                }
                case '\u00ec': {
                    return 139;
                }
                case '\u00ed': {
                    return 140;
                }
                case '\u00ee': {
                    return 141;
                }
                case '\u00ef': {
                    return 142;
                }
                case '\u00f1': {
                    return 143;
                }
                case '\u00f2': {
                    return 144;
                }
                case '\u00f3': {
                    return 145;
                }
                case '\u00f4': {
                    return 146;
                }
                case '\u00f5': {
                    return 147;
                }
                case '\u00f6': {
                    return 148;
                }
                case '\u00f9': {
                    return 149;
                }
                case '\u00fa': {
                    return 150;
                }
                case '\u00fb': {
                    return 151;
                }
                case '\u00fc': {
                    return 152;
                }
                case '\u00ff': {
                    return 153;
                }
                case '\u0152': {
                    return 154;
                }
                case '\u0153': {
                    return 155;
                }
                case '\u0411': {
                    return 156;
                }
                case '\u0413': {
                    return 157;
                }
                case '\u0414': {
                    return 158;
                }
                case '\u0416': {
                    return 159;
                }
                case '\u0417': {
                    return 160;
                }
                case '\u0418': {
                    return 161;
                }
                case '\u0419': {
                    return 162;
                }
                case '\u041b': {
                    return 163;
                }
                case '\u041f': {
                    return 164;
                }
                case '\u0423': {
                    return 165;
                }
                case '\u0424': {
                    return 166;
                }
                case '\u0426': {
                    return 167;
                }
                case '\u0427': {
                    return 168;
                }
                case '\u0428': {
                    return 169;
                }
                case '\u0429': {
                    return 170;
                }
                case '\u042a': {
                    return 171;
                }
                case '\u042b': {
                    return 172;
                }
                case '\u042c': {
                    return 173;
                }
                case '\u042d': {
                    return 174;
                }
                case '\u042e': {
                    return 175;
                }
                case '\u042f': {
                    return 176;
                }
                case '\u0431': {
                    return 177;
                }
                case '\u0432': {
                    return 178;
                }
                case '\u0433': {
                    return 179;
                }
                case '\u0434': {
                    return 180;
                }
                case '\u0436': {
                    return 181;
                }
                case '\u0437': {
                    return 182;
                }
                case '\u0438': {
                    return 183;
                }
                case '\u0439': {
                    return 184;
                }
                case '\u043a': {
                    return 185;
                }
                case '\u043b': {
                    return 186;
                }
                case '\u043c': {
                    return 187;
                }
                case '\u043d': {
                    return 188;
                }
                case '\u043f': {
                    return 189;
                }
                case '\u0442': {
                    return 190;
                }
                case '\u0443': {
                    return 191;
                }
                case '\u0444': {
                    return 192;
                }
                case '\u0446': {
                    return 193;
                }
                case '\u0447': {
                    return 194;
                }
                case '\u0448': {
                    return 195;
                }
                case '\u0449': {
                    return 196;
                }
                case '\u044a': {
                    return 197;
                }
                case '\u044b': {
                    return 198;
                }
                case '\u044c': {
                    return 199;
                }
                case '\u044d': {
                    return 200;
                }
                case '\u044e': {
                    return 201;
                }
                case '\u044f': {
                    return 202;
                }
                case '\u00dd': {
                    return 203;
                }
                case '\u010c': {
                    return 204;
                }
                case '\u010e': {
                    return 205;
                }
                case '\u011a': {
                    return 206;
                }
                case '\u0147': {
                    return 207;
                }
                case '\u0158': {
                    return 208;
                }
                case '\u0160': {
                    return 209;
                }
                case '\u0164': {
                    return 210;
                }
                case '\u016e': {
                    return 211;
                }
                case '\u017d': {
                    return 212;
                }
                case '\u00fd': {
                    return 213;
                }
                case '\u010d': {
                    return 214;
                }
                case '\u010f': {
                    return 215;
                }
                case '\u011b': {
                    return 216;
                }
                case '\u0148': {
                    return 217;
                }
                case '\u0159': {
                    return 218;
                }
                case '\u0161': {
                    return 219;
                }
                case '\u0165': {
                    return 220;
                }
                case '\u016f': {
                    return 221;
                }
                case '\u017e': {
                    return 222;
                }
                case '\u0104': {
                    return 223;
                }
                case '\u0106': {
                    return 224;
                }
                case '\u0118': {
                    return 225;
                }
                case '\u0141': {
                    return 226;
                }
                case '\u0143': {
                    return 227;
                }
                case '\u015a': {
                    return 228;
                }
                case '\u0179': {
                    return 229;
                }
                case '\u017b': {
                    return 230;
                }
                case '\u0105': {
                    return 231;
                }
                case '\u0107': {
                    return 232;
                }
                case '\u0119': {
                    return 233;
                }
                case '\u0142': {
                    return 234;
                }
                case '\u0144': {
                    return 235;
                }
                case '\u015b': {
                    return 236;
                }
                case '\u017a': {
                    return 237;
                }
                case '\u017c': {
                    return 238;
                }
            }
            return 0;
        }
        switch (character) {
            case ' ': {
                return 0;
            }
            case '!': {
                return 1;
            }
            case '\"': {
                return 2;
            }
            case '#': {
                return 3;
            }
            case '$': {
                return 4;
            }
            case '%': {
                return 5;
            }
            case '&': {
                return 6;
            }
            case '\'': 
            case '`': {
                return 7;
            }
            case '(': {
                return 8;
            }
            case ')': {
                return 9;
            }
            case '*': {
                return 10;
            }
            case '+': {
                return 11;
            }
            case ',': {
                return 12;
            }
            case '-': {
                return 13;
            }
            case '.': {
                return 14;
            }
            case '/': {
                return 15;
            }
            case '0': {
                return 16;
            }
            case '1': {
                return 17;
            }
            case '2': {
                return 18;
            }
            case '3': {
                return 19;
            }
            case '4': {
                return 20;
            }
            case '5': {
                return 21;
            }
            case '6': {
                return 22;
            }
            case '7': {
                return 23;
            }
            case '8': {
                return 24;
            }
            case '9': {
                return 25;
            }
            case ':': {
                return 26;
            }
            case ';': {
                return 27;
            }
            case '<': {
                return 28;
            }
            case '=': {
                return 29;
            }
            case '>': {
                return 30;
            }
            case '?': {
                return 31;
            }
            case '@': {
                return 32;
            }
            case 'A': 
            case 'a': 
            case '\u00aa': 
            case '\u0410': 
            case '\u0430': {
                return 33;
            }
            case 'B': 
            case 'b': 
            case '\u0412': 
            case '\u0432': {
                return 34;
            }
            case 'C': 
            case 'c': 
            case '\u0421': 
            case '\u0441': {
                return 35;
            }
            case 'D': 
            case 'd': {
                return 36;
            }
            case 'E': 
            case 'e': 
            case '\u0415': 
            case '\u0435': {
                return 37;
            }
            case 'F': 
            case 'f': {
                return 38;
            }
            case 'G': 
            case 'g': {
                return 39;
            }
            case 'H': 
            case 'h': 
            case '\u041d': 
            case '\u043d': {
                return 40;
            }
            case 'I': 
            case 'i': {
                return 41;
            }
            case 'J': 
            case 'j': {
                return 42;
            }
            case 'K': 
            case 'k': 
            case '\u041a': 
            case '\u043a': {
                return 43;
            }
            case 'L': 
            case 'l': {
                return 44;
            }
            case 'M': 
            case 'm': 
            case '\u041c': 
            case '\u043c': {
                return 45;
            }
            case 'N': 
            case 'n': {
                return 46;
            }
            case 'O': 
            case 'o': 
            case '\u00ba': 
            case '\u041e': 
            case '\u043e': {
                return 47;
            }
            case 'P': 
            case 'p': 
            case '\u0420': 
            case '\u0440': {
                return 48;
            }
            case 'Q': 
            case 'q': {
                return 49;
            }
            case 'R': 
            case 'r': {
                return 50;
            }
            case 'S': 
            case 's': {
                return 51;
            }
            case 'T': 
            case 't': 
            case '\u0422': 
            case '\u0442': {
                return 52;
            }
            case 'U': 
            case 'u': {
                return 53;
            }
            case 'V': 
            case 'v': {
                return 54;
            }
            case 'W': 
            case 'w': {
                return 55;
            }
            case 'X': 
            case 'x': 
            case '\u0425': 
            case '\u0445': {
                return 56;
            }
            case 'Y': 
            case 'y': {
                return 57;
            }
            case 'Z': 
            case 'z': {
                return 58;
            }
            case '[': {
                return 59;
            }
            case '\\': {
                return 60;
            }
            case ']': {
                return 61;
            }
            case '^': {
                return 62;
            }
            case '_': {
                return 63;
            }
            case '{': {
                return 64;
            }
            case '|': {
                return 65;
            }
            case '}': {
                return 66;
            }
            case '~': {
                return 67;
            }
            case '\u00ae': {
                return 68;
            }
            case '\u00a9': {
                return 69;
            }
            case '\u0099': {
                return 70;
            }
            case '\u00a1': {
                return 71;
            }
            case '\u00ab': {
                return 72;
            }
            case '\u00bb': {
                return 73;
            }
            case '\u00bf': {
                return 74;
            }
            case '\u00c0': 
            case '\u00e0': {
                return 75;
            }
            case '\u00c1': 
            case '\u00e1': {
                return 76;
            }
            case '\u00c2': 
            case '\u00e2': {
                return 77;
            }
            case '\u00c3': 
            case '\u00e3': {
                return 78;
            }
            case '\u00c4': 
            case '\u00e4': {
                return 79;
            }
            case '\u00c6': 
            case '\u00e6': {
                return 80;
            }
            case '\u00c7': 
            case '\u00e7': {
                return 81;
            }
            case '\u00c8': 
            case '\u00e8': {
                return 82;
            }
            case '\u00c9': 
            case '\u00e9': {
                return 83;
            }
            case '\u00ca': 
            case '\u00ea': {
                return 84;
            }
            case '\u00cb': 
            case '\u00eb': {
                return 85;
            }
            case '\u00cc': 
            case '\u00ec': {
                return 86;
            }
            case '\u00cd': 
            case '\u00ed': {
                return 87;
            }
            case '\u00ce': 
            case '\u00ee': {
                return 88;
            }
            case '\u00cf': 
            case '\u00ef': {
                return 89;
            }
            case '\u00d1': 
            case '\u00f1': {
                return 90;
            }
            case '\u00d2': 
            case '\u00f2': {
                return 91;
            }
            case '\u00d3': 
            case '\u00f3': {
                return 92;
            }
            case '\u00d4': 
            case '\u00f4': {
                return 93;
            }
            case '\u00d5': 
            case '\u00f5': {
                return 94;
            }
            case '\u00d6': 
            case '\u00f6': {
                return 95;
            }
            case '\u00d9': 
            case '\u00f9': {
                return 96;
            }
            case '\u00da': 
            case '\u00fa': {
                return 97;
            }
            case '\u00db': 
            case '\u00fb': {
                return 98;
            }
            case '\u00dc': 
            case '\u00fc': {
                return 99;
            }
            case '\u00df': {
                return 100;
            }
            case '\u00ff': 
            case '\u0178': {
                return 101;
            }
            case '\u0152': 
            case '\u0153': {
                return 102;
            }
            case '\u0411': 
            case '\u0431': {
                return 103;
            }
            case '\u0413': 
            case '\u0433': {
                return 104;
            }
            case '\u0414': 
            case '\u0434': {
                return 105;
            }
            case '\u0416': 
            case '\u0436': {
                return 106;
            }
            case '\u0417': 
            case '\u0437': {
                return 107;
            }
            case '\u0418': 
            case '\u0438': {
                return 108;
            }
            case '\u0419': 
            case '\u0439': {
                return 109;
            }
            case '\u041b': 
            case '\u043b': {
                return 110;
            }
            case '\u041f': 
            case '\u043f': {
                return 111;
            }
            case '\u0423': 
            case '\u0443': {
                return 112;
            }
            case '\u0424': 
            case '\u0444': {
                return 113;
            }
            case '\u0426': 
            case '\u0446': {
                return 114;
            }
            case '\u0427': 
            case '\u0447': {
                return 115;
            }
            case '\u0428': 
            case '\u0448': {
                return 116;
            }
            case '\u0429': 
            case '\u0449': {
                return 117;
            }
            case '\u042a': 
            case '\u044a': {
                return 118;
            }
            case '\u042b': 
            case '\u044b': {
                return 119;
            }
            case '\u042c': 
            case '\u044c': {
                return 120;
            }
            case '\u042d': 
            case '\u044d': {
                return 121;
            }
            case '\u042e': 
            case '\u044e': {
                return 122;
            }
            case '\u042f': 
            case '\u044f': {
                return 123;
            }
            case '\u00dd': 
            case '\u00fd': {
                return 124;
            }
            case '\u010c': 
            case '\u010d': {
                return 125;
            }
            case '\u010e': 
            case '\u010f': {
                return 126;
            }
            case '\u011a': 
            case '\u011b': {
                return 127;
            }
            case '\u0147': 
            case '\u0148': {
                return 128;
            }
            case '\u0158': 
            case '\u0159': {
                return 129;
            }
            case '\u0160': 
            case '\u0161': {
                return 130;
            }
            case '\u0164': 
            case '\u0165': {
                return 131;
            }
            case '\u016e': 
            case '\u016f': {
                return 132;
            }
            case '\u017d': 
            case '\u017e': {
                return 133;
            }
            case '\u0104': 
            case '\u0105': {
                return 134;
            }
            case '\u0106': 
            case '\u0107': {
                return 135;
            }
            case '\u0118': 
            case '\u0119': {
                return 136;
            }
            case '\u0141': 
            case '\u0142': {
                return 137;
            }
            case '\u0143': 
            case '\u0144': {
                return 138;
            }
            case '\u015a': 
            case '\u015b': {
                return 139;
            }
            case '\u0179': 
            case '\u017a': {
                return 140;
            }
            case '\u017b': 
            case '\u017c': {
                return 141;
            }
        }
        return 0;
    }

    public void setOffset(int y) {
        this.offsetY = (byte)y;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public void drawString(String str, int x, int y) {
        int x_offset = 0;
        int cc = 0;
        for (int i = 0; i < str.length(); ++i) {
            cc = this.getCharIndex(str.charAt(i));
            if (cc == -1) {
                cc = this.getCharIndex('.');
                for (int j = 0; j < 3; ++j) {
                    g.drawRegion(this.font_image, (int)this.source_x[cc], (int)this.source_y[cc], (int)this.c_width[cc], (int)this.frame_height, 0, x + x_offset, y + this.offsetY, 0);
                    x_offset += this.c_width[cc] + this.spacing;
                }
                continue;
            }
            g.drawRegion(this.font_image, (int)this.source_x[cc], (int)this.source_y[cc], (int)this.c_width[cc], (int)this.frame_height, 0, x + x_offset, y + this.offsetY, 0);
            x_offset += this.c_width[cc] + this.spacing;
        }
    }

    public void drawString_rightAligned(String str, int x, int y) {
        int x_offset = 0;
        int cc = 0;
        for (int i = str.length() - 1; i >= 0; --i) {
            cc = this.getCharIndex(str.charAt(i));
            if (cc == -1) {
                cc = this.getCharIndex('.');
                for (int j = 0; j < 3; ++j) {
                    g.drawRegion(this.font_image, (int)this.source_x[cc], (int)this.source_y[cc], (int)this.c_width[cc], (int)this.frame_height, 0, x - (x_offset += this.c_width[cc]), y + this.offsetY, 0);
                    x_offset += this.spacing;
                }
                continue;
            }
            g.drawRegion(this.font_image, (int)this.source_x[cc], (int)this.source_y[cc], (int)this.c_width[cc], (int)this.frame_height, 0, x - (x_offset += this.c_width[cc]), y + this.offsetY, 0);
            x_offset += this.spacing;
        }
    }

    public void drawLines270(String[] str, int x, int y) {
        y = g.getClipHeight() - y;
        for (int i = 0; i < str.length; ++i) {
            this.drawString270(str[i], x + i * AEFont.getRowHeight(), y + this.offsetY);
        }
    }

    public void drawLines90(String[] str, int x, int y) {
        x = g.getClipWidth() - x;
        for (int i = 0; i < str.length; ++i) {
            this.drawString90(str[i], x - i * AEFont.getRowHeight(), y + this.offsetY);
        }
    }

    public void drawString90(String str, int x, int y) {
        x -= this.frame_height - this.c_height;
        int x_offset = 0;
        int cc = 0;
        for (int i = 0; i < str.length(); ++i) {
            cc = this.getCharIndex(str.charAt(i));
            if (cc == -1) {
                cc = this.getCharIndex('.');
                for (int j = 0; j < 3; ++j) {
                    g.drawRegion(this.font_image, (int)this.source_x[cc], (int)this.source_y[cc], (int)this.c_width[cc], (int)this.frame_height, 5, x - this.frame_height, y + x_offset, 0);
                    x_offset += this.c_width[cc] + this.spacing;
                }
                continue;
            }
            g.drawRegion(this.font_image, (int)this.source_x[cc], (int)this.source_y[cc], (int)this.c_width[cc], (int)this.frame_height, 5, x - this.frame_height, y + x_offset, 0);
            x_offset += this.c_width[cc] + this.spacing;
        }
    }

    public void drawString270(String str, int x, int y) {
        int x_offset = 0;
        int cc = 0;
        for (int i = 0; i < str.length(); ++i) {
            cc = this.getCharIndex(str.charAt(i));
            if (cc == -1) {
                cc = this.getCharIndex('.');
                for (int j = 0; j < 3; ++j) {
                    g.drawRegion(this.font_image, (int)this.source_x[cc], (int)this.source_y[cc], (int)this.c_width[cc], (int)this.frame_height, 6, x, y - (x_offset += this.c_width[cc] + this.spacing), 0);
                }
                continue;
            }
            g.drawRegion(this.font_image, (int)this.source_x[cc], (int)this.source_y[cc], (int)this.c_width[cc], (int)this.frame_height, 6, x, y - (x_offset += this.c_width[cc] + this.spacing), 0);
        }
    }

    public void drawSubString(String str, int beginIndex, int endIndex, int x, int y) {
        int x_offset = 0;
        int cc = 0;
        beginIndex = beginIndex >= 0 ? beginIndex : 0;
        endIndex = endIndex <= str.length() ? endIndex : str.length();
        for (int i = beginIndex; i < endIndex; ++i) {
            cc = this.getCharIndex(str.charAt(i));
            if (cc == -1) {
                cc = this.getCharIndex('.');
                for (int j = 0; j < 3; ++j) {
                    g.drawRegion(this.font_image, (int)this.source_x[cc], (int)this.source_y[cc], (int)this.c_width[cc], (int)this.frame_height, 0, x + x_offset, y, 0);
                    x_offset += this.c_width[cc] + this.spacing;
                }
                continue;
            }
            g.drawRegion(this.font_image, (int)this.source_x[cc], (int)this.source_y[cc], (int)this.c_width[cc], (int)this.frame_height, 0, x + x_offset, y, 0);
            x_offset += this.c_width[cc] + this.spacing;
        }
    }

    public void drawSubString90(String str, int beginIndex, int endIndex, int x, int y) {
        x -= this.frame_height - this.c_height;
        int x_offset = 0;
        int cc = 0;
        beginIndex = beginIndex >= 0 ? beginIndex : 0;
        endIndex = endIndex <= str.length() ? endIndex : str.length();
        for (int i = beginIndex; i < endIndex; ++i) {
            cc = this.getCharIndex(str.charAt(i));
            if (cc == -1) {
                cc = this.getCharIndex('.');
                for (int j = 0; j < 3; ++j) {
                    g.drawRegion(this.font_image, (int)this.source_x[cc], (int)this.source_y[cc], (int)this.c_width[cc], (int)this.frame_height, 5, x - this.frame_height, y + x_offset, 0);
                    x_offset += this.c_width[cc] + this.spacing;
                }
                continue;
            }
            g.drawRegion(this.font_image, (int)this.source_x[cc], (int)this.source_y[cc], (int)this.c_width[cc], (int)this.frame_height, 5, x - this.frame_height, y + x_offset, 0);
            x_offset += this.c_width[cc] + this.spacing;
        }
    }

    public void drawSubString270(String str, int beginIndex, int endIndex, int x, int y) {
        int x_offset = 0;
        int cc = 0;
        beginIndex = beginIndex >= 0 ? beginIndex : 0;
        endIndex = endIndex <= str.length() ? endIndex : str.length();
        for (int i = beginIndex; i < endIndex; ++i) {
            cc = this.getCharIndex(str.charAt(i));
            if (cc == -1) {
                cc = this.getCharIndex('.');
                for (int j = 0; j < 3; ++j) {
                    g.drawRegion(this.font_image, (int)this.source_x[cc], (int)this.source_y[cc], (int)this.c_width[cc], (int)this.frame_height, 6, x, y - (x_offset += this.c_width[cc] + this.spacing), 0);
                }
                continue;
            }
            g.drawRegion(this.font_image, (int)this.source_x[cc], (int)this.source_y[cc], (int)this.c_width[cc], (int)this.frame_height, 6, x, y - (x_offset += this.c_width[cc] + this.spacing), 0);
        }
    }

    public int getRowHeight() {
        return this.c_height;
    }

    public int getFrameHeight() {
        return this.frame_height;
    }

    public void setRowHeight(int row_height) {
        this.c_height = (byte)row_height;
    }
}

