/*
 * Decompiled with CFR 0.152.
 */
package FLToolkit;

import FLToolkit.AEFont;
import FLToolkit.AELoadingScreen;
import FLToolkit.AEModule;
import FLToolkit.grh;
import com.Fishlabs.AEBluetooth.FLBluetooth;
import javax.microedition.lcdui.game.GameCanvas;

public class AEModuleHandle {
    private GameCanvas canvas;
    private AELoadingScreen loading_screen;
    private AEModule current_module;
    private AEModule next_module;
    private short state = (short)2;
    private short old_state;
    private static final short S_UPDATE = 0;
    private static final short S_RELEASE = 1;
    private static final short S_INIT = 2;
    public boolean paused;
    private int[] currentKeyPressed;
    private int[] currentKeyReleased = new int[10];
    private int currentKeyReleasedIndex = 0;
    private int currentKeyPressedIndex = 0;
    private String mem;
    public String error = "";

    public AEModuleHandle(GameCanvas canvas, AELoadingScreen loading_screen) {
        this.currentKeyPressed = new int[10];
        this.canvas = canvas;
        this.loading_screen = loading_screen;
        this.paused = false;
        if (loading_screen != null) {
            loading_screen.setCanvas(canvas);
            loading_screen.setHandle(this);
        }
    }

    public AEModuleHandle(GameCanvas canvas) {
        this(canvas, null);
    }

    public void setModule(AEModule module) {
        this.next_module = module;
        this.state = 1;
        if (this.next_module != null) {
            this.next_module.resetStatus();
        }
    }

    public synchronized void onKeyPress(int key) {
        if (this.paused && (key == -5 || key == 53)) {
            this.paused = false;
            if (this.current_module != null) {
                this.current_module.changeStatus(0L, 2L);
            }
        } else if (this.current_module != null && this.state == 0 && this.currentKeyPressedIndex < this.currentKeyPressed.length - 1) {
            this.currentKeyPressed[this.currentKeyPressedIndex] = key;
            ++this.currentKeyPressedIndex;
        }
    }

    public synchronized void onKeyRelease(int key) {
        if (this.current_module != null && this.state == 0 && this.currentKeyReleasedIndex < this.currentKeyReleased.length - 1) {
            this.currentKeyReleased[this.currentKeyReleasedIndex] = key;
            ++this.currentKeyReleasedIndex;
        }
    }

    public synchronized void process() {
        switch (this.state) {
            case 0: {
                int i;
                if (this.old_state == 2) {
                    this.old_state = 0;
                    this.mem = Runtime.getRuntime().freeMemory() + "";
                }
                if (this.current_module == null || this.paused) break;
                if (this.currentKeyPressedIndex > 0) {
                    for (i = 0; i < this.currentKeyPressedIndex; ++i) {
                        this.current_module.keyPress(this.currentKeyPressed[i]);
                    }
                    this.currentKeyPressedIndex = 0;
                }
                if (this.currentKeyReleasedIndex > 0) {
                    for (i = 0; i < this.currentKeyReleasedIndex; ++i) {
                        this.current_module.keyRelease(this.currentKeyReleased[i]);
                    }
                    this.currentKeyReleasedIndex = 0;
                }
                if (!this.current_module.isInitialized()) break;
                this.current_module.updateTime();
                this.current_module.onUpdate();
                this.current_module.onRender3D();
                this.current_module.onRender2D();
                break;
            }
            case 1: {
                if (this.current_module != null) {
                    if (this.loading_screen != null && !this.loading_screen.isRunning()) {
                        this.loading_screen.start();
                    }
                    this.current_module.onRelease();
                }
                this.current_module = this.next_module;
                if (this.current_module != null) {
                    this.current_module.keyReset();
                }
                this.old_state = this.state;
                this.state = (short)2;
                break;
            }
            case 2: {
                int remaining;
                if (this.current_module == null || (remaining = this.current_module.onInitialize()) > 0) break;
                if (this.loading_screen != null) {
                    this.loading_screen.stop();
                }
                this.current_module.initTime();
                this.old_state = this.state;
                System.gc();
                this.state = 0;
            }
        }
        if (this.paused) {
            if (grh.sound != null) {
                grh.sound.stop();
            }
            this.drawResumeScreen();
        }
        grh.g.setColor(255, 0, 0);
    }

    public boolean isInitialized() {
        return this.state == 2;
    }

    public void pause() {
        if (FLBluetooth.statusSecurityQuestion()) {
            return;
        }
        if (!this.paused) {
            this.paused = true;
            if (grh.sound != null) {
                grh.sound.stop();
            }
            if (this.current_module != null) {
                this.current_module.changeStatus(2L, 0L);
            }
        }
    }

    public void quit() {
        this.current_module.onRelease();
    }

    public void resume() {
    }

    public void resetKeyEvents() {
        if (this.current_module != null) {
            this.current_module.keyReset();
        }
    }

    public void drawResumeScreen() {
        grh.g.setColor(921102);
        grh.g.fillRect(0, 0, grh.w, grh.h);
        try {
            AEFont.setFont((byte)0);
            AEFont.drawString(grh.gameText.getText(183), grh.w / 2 - AEFont.getStringWidth(grh.gameText.getText(183)) / 2, grh.h / 2);
        }
        catch (Exception e) {
            grh.g.setColor(9991232);
            grh.g.drawString("Press 5 to continue.", grh.w / 2, grh.h / 2, 17);
        }
        this.canvas.flushGraphics();
    }
}

