/*
 * Decompiled with CFR 0.152.
 */
package FLToolkit;

import FLToolkit.ImgAdjust;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;

public class BMPImage {
    static final byte PNG = 1;
    static final byte BMP = 0;
    private int table_length = 255;
    private int table_start = 0;
    private int table_end = 255;
    byte[] ba = null;
    float[] rgb = null;
    String filename = "";
    byte mode;
    static int[] crc_table = null;
    private int crc = 0;

    public BMPImage(String file) {
        this.createBitmap(file);
    }

    public BMPImage(byte[] image) {
        this.ba = image;
        this.mode = 0;
        if (this.ba != null && this.ba[0] == -119 && this.ba[1] == 80 && this.ba[2] == 78 && this.ba[3] == 71) {
            this.mode = 1;
        } else {
            this.calculateRGBTable();
        }
    }

    private void calculateRGBTable() {
        this.rgb = null;
        this.rgb = new float[1020];
        for (int i = 54; i < 1074; i += 4) {
            for (int k = 0; k < 4; ++k) {
                this.rgb[i + k - 54] = this.calcRGBValue(this.ba[i + k]);
            }
        }
    }

    public void replaceColor(int[] color) {
        if (this.mode == 1) {
            if (this.ba[25] == 3) {
                try {
                    ByteArrayInputStream bin = new ByteArrayInputStream(this.ba);
                    DataInputStream oin = new DataInputStream(bin);
                    oin.skipBytes(8);
                    boolean paletteFound = false;
                    int index = 8;
                    while (!paletteFound && oin.available() > 0) {
                        int chunkDataLength = oin.readInt();
                        int startCRCIndex = index += 4;
                        int chunkType = oin.readInt();
                        index += 4;
                        if (chunkType == 1347179589) {
                            paletteFound = true;
                            index += 3 * this.table_start;
                            for (int i = 0; i < chunkDataLength / 3; ++i) {
                                int red = oin.readByte();
                                int green = oin.readByte();
                                int blue = oin.readByte();
                                red = red < 0 ? red + 256 : red;
                                green = green < 0 ? green + 256 : green;
                                blue = blue < 0 ? blue + 256 : blue;
                                int diff_b = blue - color[2];
                                int diff_g = green - color[1];
                                int diff_r = red - color[0];
                                if (Math.abs(diff_b) < color[6] && Math.abs(diff_g) < color[6] && Math.abs(diff_r) < color[6]) {
                                    this.ba[index] = (byte)Math.min(Math.max(0, color[3] + diff_r), 255);
                                    this.ba[index + 1] = (byte)Math.min(Math.max(0, color[4] + diff_g), 255);
                                    this.ba[index + 2] = (byte)Math.min(Math.max(0, color[5] + diff_b), 255);
                                }
                                index += 3;
                            }
                            if (crc_table == null) {
                                BMPImage.make_crc_table();
                            }
                            this.reset_crc();
                            this.update_crc(this.ba, startCRCIndex, 4);
                            this.update_crc(this.ba, startCRCIndex + 4, index - startCRCIndex - 4);
                            long crc = this.get_crc();
                            this.ba[index] = (byte)((crc & 0xFF000000L) >> 24);
                            this.ba[index + 1] = (byte)((crc & 0xFF0000L) >> 16);
                            this.ba[index + 2] = (byte)((crc & 0xFF00L) >> 8);
                            this.ba[index + 3] = (byte)(crc & 0xFFL);
                            continue;
                        }
                        oin.skipBytes(chunkDataLength + 4);
                        index += chunkDataLength + 4;
                    }
                }
                catch (Exception e) {
                    System.out.println(e);
                }
            } else {
                System.out.println("ERROR: PNG is not indexed!!");
            }
        } else if (color != null && color.length == 7) {
            for (int i = this.table_start; i < this.table_end; i += 4) {
                int diff_b = (int)this.rgb[i] - color[2];
                int diff_g = (int)this.rgb[i + 1] - color[1];
                int diff_r = (int)this.rgb[i + 2] - color[0];
                if (Math.abs(diff_b) >= color[6] || Math.abs(diff_g) >= color[6] || Math.abs(diff_r) >= color[6]) continue;
                this.rgb[i] = Math.min(Math.max(0, color[5] + diff_b), 255);
                this.rgb[i + 1] = Math.min(Math.max(0, color[4] + diff_g), 255);
                this.rgb[i + 2] = Math.min(Math.max(0, color[3] + diff_r), 255);
            }
        }
    }

    private void writeCurrentByteArray() {
        for (int i = 0; i < this.rgb.length; i += 4) {
            for (int k = 0; k < 4; ++k) {
                this.ba[54 + i + k] = this.calcBGRValue(this.rgb[i + k]);
            }
        }
    }

    private void createBitmap(String file) {
        this.filename = file;
        this.ba = ImgAdjust.getCypherBytes(file);
        this.mode = 0;
        if (this.ba != null && this.ba[0] == -119 && this.ba[1] == 80 && this.ba[2] == 78 && this.ba[3] == 71) {
            System.out.print("mode=PNG");
            this.mode = 1;
        } else {
            System.out.print("mode=BMP");
            this.calculateRGBTable();
        }
    }

    public void reset() {
        this.createBitmap(this.filename);
        System.gc();
    }

    public void loadBitmap(String file) {
        this.createBitmap(file);
    }

    private static void make_crc_table() {
        if (crc_table == null) {
            crc_table = new int[256];
        }
        boolean crc = false;
        for (int n = 0; n < 256; ++n) {
            int c = n;
            int k = 8;
            while (--k >= 0) {
                if ((c & 1) != 0) {
                    c = 0xEDB88320 ^ c >>> 1;
                    continue;
                }
                c >>>= 1;
            }
            BMPImage.crc_table[n] = c;
        }
    }

    public void reset_crc() {
        this.crc = 0;
    }

    public void update_crc(byte[] buf, int off, int len) {
        int c = ~this.crc;
        while (--len >= 0) {
            c = crc_table[(c ^ buf[off++]) & 0xFF] ^ c >>> 8;
        }
        this.crc = ~c;
    }

    public void update_crc(byte[] buf) {
        this.update_crc(buf, 0, buf.length);
    }

    public long get_crc() {
        return (long)this.crc & 0xFFFFFFFFL;
    }

    public byte[] getBitmap() {
        if (this.mode == 0) {
            this.writeCurrentByteArray();
        }
        return this.ba;
    }

    private int calcRGBValue(byte bgrValue) {
        return bgrValue < 0 ? 256 + bgrValue : bgrValue;
    }

    private byte calcBGRValue(float rgbValue) {
        return rgbValue >= 128.0f ? (byte)(-256.0f + rgbValue) : (byte)rgbValue;
    }

    public void setColorTableArea(int start, int end) {
        if (this.mode == 0) {
            this.table_start = start * 4;
            this.table_end = (end + 1) * 4;
        } else {
            this.table_start = start;
            this.table_end = end;
        }
    }

    public void release() {
        this.ba = null;
        this.rgb = null;
    }
}

