/*
 * Decompiled with CFR 0.152.
 */
package FLToolkit;

import FLToolkit.AEFont;
import FLToolkit.grh;
import GameEssentials.GUI;

public class ChoiceWindow {
    private static final int MARGIN = 5;
    private int x;
    private int y;
    private int width;
    private int height;
    private String[] msg;
    private int buttonStartY;
    private boolean confirm;
    private boolean yesNo;
    private int selection_mark_time;

    public ChoiceWindow(int x, int y, int width) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = grh.h / 2;
    }

    public ChoiceWindow() {
        this((int)((float)grh.w * 0.125f), 0, grh.w - 2 * (int)((float)grh.w * 0.125f));
    }

    public void set(String str) {
        this.set(str, false);
    }

    public void set(String str, boolean yesNo) {
        this.confirm = false;
        this.yesNo = yesNo;
        this.msg = AEFont.getLineArray(str, this.width - 10);
        this.height = AEFont.getRowHeight() * this.msg.length + 10 + 26;
        if (yesNo) {
            this.height += 13;
        }
        this.y = grh.h / 2 - this.height / 2 - 2;
        this.buttonStartY = this.y + this.msg.length * AEFont.getRowHeight() + 2 + 13;
    }

    public boolean fire() {
        return this.yesNo ? this.confirm : false;
    }

    public void up() {
        if (this.yesNo) {
            this.confirm = !this.confirm;
        }
    }

    public void down() {
        this.up();
    }

    public void draw(int elapsed_time) {
        AEFont.setFont((byte)0);
        if (this.msg == null) {
            return;
        }
        this.selection_mark_time += elapsed_time;
        if (this.selection_mark_time > 700) {
            this.selection_mark_time -= 700;
        }
        GUI.drawBox(this.x, this.y, this.width, this.height);
        if (this.msg.length > 1) {
            AEFont.drawLines(this.msg, this.x + 5, this.y + 5, (byte)0);
        } else {
            AEFont.drawString(this.msg[0], grh.w / 2 - AEFont.getStringWidth(this.msg[0]) / 2, this.y + 5, (byte)0);
        }
        int marginX = AEFont.getStringWidth("OO");
        grh.g.setColor(4140826);
        grh.g.drawLine(this.x + marginX, this.buttonStartY - 6, this.x + this.width - marginX, this.buttonStartY - 6);
        grh.g.setColor(0);
        grh.g.drawLine(this.x + marginX, this.buttonStartY - 6 + 1, this.x + this.width - marginX, this.buttonStartY - 6 + 1);
        int offset = this.selection_mark_time / 116;
        if (offset > 2) {
            offset = 6 - offset;
        }
        int wing_offset = 5;
        if (this.yesNo) {
            if (this.confirm) {
                GUI.drawSelectionWing(true, this.x + (this.width >> 1) - AEFont.getStringWidth(grh.gameText.getText(39)) / 2 - offset, this.buttonStartY + wing_offset);
                GUI.drawSelectionWing(false, this.x + (this.width >> 1) + AEFont.getStringWidth(grh.gameText.getText(39)) / 2 + offset, this.buttonStartY + wing_offset);
            } else {
                GUI.drawSelectionWing(true, this.x + (this.width >> 1) - AEFont.getStringWidth(grh.gameText.getText(40)) / 2 - offset, this.buttonStartY + 13 + wing_offset);
                GUI.drawSelectionWing(false, this.x + (this.width >> 1) + AEFont.getStringWidth(grh.gameText.getText(40)) / 2 + offset, this.buttonStartY + 13 + wing_offset);
            }
            AEFont.drawString(grh.gameText.getText(39), this.x + (this.width >> 1), this.buttonStartY, 24);
            AEFont.drawString(grh.gameText.getText(40), this.x + (this.width >> 1), this.buttonStartY + 13, 24);
        } else {
            GUI.drawSelectionWing(true, this.x + (this.width >> 1) - AEFont.getStringWidth(grh.gameText.getText(5)) / 2 - offset, this.buttonStartY + wing_offset);
            GUI.drawSelectionWing(false, this.x + (this.width >> 1) + AEFont.getStringWidth(grh.gameText.getText(5)) / 2 + offset, this.buttonStartY + wing_offset);
            AEFont.drawString(grh.gameText.getText(5), this.x + (this.width >> 1), this.buttonStartY, 24);
        }
        grh.g.setClip(0, 0, grh.w, grh.h);
    }

    public void release() {
        if (this.msg != null) {
            for (int i = 0; i < this.msg.length; ++i) {
                if (this.msg[i] == null) continue;
                this.msg[i] = null;
            }
            this.msg = null;
        }
    }
}

