/*
 * Decompiled with CFR 0.152.
 */
package FLToolkit;

import java.io.DataInputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Image;

public class ImgAdjust {
    private static final boolean CYPHER = true;
    static /* synthetic */ Class class$java$lang$Class;

    public static Image crunchImage(String filename, int size_w, int size_h) {
        Image orig = ImgAdjust.getCypherImage(filename);
        return ImgAdjust.crunchImage(orig, size_w, size_h);
    }

    public static Image crunchImage(Image orig, int size_w, int size_h) {
        try {
            float fact_x = (float)size_w / (float)orig.getWidth();
            float fact_y = (float)size_h / (float)orig.getHeight();
            int imgWidth = orig.getWidth();
            int imgHeight = orig.getHeight();
            int[] rgbData = new int[imgWidth * imgHeight];
            int[] rgbDataNew = new int[(int)((float)imgWidth * fact_x) * (int)((float)imgHeight * fact_y)];
            orig.getRGB(rgbData, 0, imgWidth, 0, 0, imgWidth, imgHeight);
            rgbDataNew = ImgAdjust.filterData(rgbData, rgbDataNew, imgWidth, (int)((float)imgWidth * fact_x));
            orig = Image.createRGBImage((int[])rgbDataNew, (int)((int)((float)imgWidth * fact_x)), (int)((int)((float)imgHeight * fact_y)), (boolean)true);
            rgbData = null;
            rgbDataNew = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return orig;
    }

    public static int adjustX(int x, int w) {
        return (int)((float)w / 176.0f * (float)x);
    }

    public static int adjustY(int y, int h) {
        return (int)((float)h / 220.0f * (float)y);
    }

    public static Image getAdjustImage(Image orig, int w, int h) {
        try {
            float fact_x = (float)w / 240.0f;
            float fact_y = (float)h / 320.0f;
            int imgWidth = orig.getWidth();
            int imgHeight = orig.getHeight();
            int[] rgbData = new int[imgWidth * imgHeight];
            int[] rgbDataNew = new int[(int)((float)imgWidth * fact_x) * (int)((float)imgHeight * fact_y)];
            orig.getRGB(rgbData, 0, imgWidth, 0, 0, imgWidth, imgHeight);
            rgbDataNew = ImgAdjust.filterData(rgbData, rgbDataNew, imgWidth, (int)((float)imgWidth * fact_x));
            orig = Image.createRGBImage((int[])rgbDataNew, (int)((int)((float)imgWidth * fact_x)), (int)((int)((float)imgHeight * fact_y)), (boolean)true);
            rgbData = null;
            rgbDataNew = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return orig;
    }

    public static Image getAdjustImage(String filename, int w, int h) {
        Image orig = null;
        try {
            orig = ImgAdjust.getCypherImage(filename);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ImgAdjust.getAdjustImage(orig, w, h);
    }

    private static int[] filterData(int[] origData, int[] newData, int scanlength_orig, int scanlength_new) {
        int height_orig = origData.length / scanlength_orig;
        int height_new = newData.length / scanlength_new;
        for (int x = 0; x < scanlength_new; ++x) {
            for (int y = 0; y < height_new; ++y) {
                float fxCorr = (float)x * (float)(scanlength_orig - 1) / (float)(scanlength_new - 1);
                int xCorr = 0;
                xCorr = (double)fxCorr - Math.floor(fxCorr) > 0.5 ? (int)Math.ceil(fxCorr) : (int)Math.floor(fxCorr);
                float fyCorr = (float)y * (float)(height_orig - 1) / (float)(height_new - 1);
                int yCorr = 0;
                yCorr = (double)fyCorr - Math.floor(fyCorr) > 0.5 ? (int)Math.ceil(fyCorr) : (int)Math.floor(fyCorr);
                newData[x + y * scanlength_new] = origData[xCorr + yCorr * scanlength_orig];
            }
        }
        return newData;
    }

    public static Image getCypherImage(String filename) {
        Image img = null;
        try {
            InputStream is = (class$java$lang$Class == null ? (class$java$lang$Class = ImgAdjust.class$("java.lang.Class")) : class$java$lang$Class).getResourceAsStream(filename);
            DataInputStream dis = new DataInputStream(is);
            int size = dis.available();
            byte[] data = new byte[size];
            dis.read(data, 0, size);
            dis.close();
            int cypherSize = size < 100 ? 10 + size % 10 : (size < 200 ? 50 + size % 20 : (size < 300 ? 80 + size % 20 : 100 + size % 50));
            for (int lauf = 0; lauf < cypherSize; ++lauf) {
                byte change = data[lauf];
                data[lauf] = data[size - lauf - 1];
                data[size - lauf - 1] = change;
            }
            img = Image.createImage((byte[])data, (int)0, (int)size);
            data = null;
        }
        catch (Exception e) {
            System.out.println("Image " + filename + " ist nicht verschl\u00fcsselt!");
        }
        return img;
    }

    public static byte[] getCypherBytes(String filename) {
        byte[] data = null;
        try {
            InputStream is = (class$java$lang$Class == null ? (class$java$lang$Class = ImgAdjust.class$("java.lang.Class")) : class$java$lang$Class).getResourceAsStream(filename);
            DataInputStream dis = new DataInputStream(is);
            int size = dis.available();
            data = new byte[size];
            dis.read(data, 0, size);
            dis.close();
            int cypherSize = size < 100 ? 10 + size % 10 : (size < 200 ? 50 + size % 20 : (size < 300 ? 80 + size % 20 : 100 + size % 50));
            for (int lauf = 0; lauf < cypherSize; ++lauf) {
                byte change = data[lauf];
                data[lauf] = data[size - lauf - 1];
                data[size - lauf - 1] = change;
            }
        }
        catch (Exception e) {
            System.out.println("Image " + filename + " ist nicht verschl\u00fcsselt!");
        }
        return data;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

