/*
 * Decompiled with CFR 0.152.
 */
package FLToolkit;

import AbyssEngine.AEEaseInOut;
import FLToolkit.AEFont;
import FLToolkit.ImgAdjust;
import FLToolkit.grh;
import GameEssentials.GUI;
import javax.microedition.lcdui.game.Sprite;

public class ScrollTextBox {
    private static final int MARGIN = 12;
    int x;
    int y;
    int w;
    int h;
    int boxX;
    int boxY;
    int boxW;
    int boxH;
    int currentY;
    String[] lines;
    int linesHeight;
    int titleHeight;
    String text;
    String title;
    int textStartY;
    Sprite arrow;
    private boolean fadeIn;
    private boolean dontFade;
    private AEEaseInOut ease;

    public ScrollTextBox(String text) {
        this(ImgAdjust.adjustX(12, grh.w), ImgAdjust.adjustY(12, grh.h), grh.w - (ImgAdjust.adjustX(12, grh.w) << 1), grh.h - 20 - 2 - (ImgAdjust.adjustY(12, grh.w) << 1), text);
        this.fadeIn = false;
    }

    public ScrollTextBox(int x, int y, int w, int h, String text) {
        this.boxX = x;
        this.boxY = y;
        this.boxW = w;
        this.boxH = h;
        this.x = x + 12;
        this.y = y + 12;
        this.w = w - 24;
        this.currentY = 0;
        if (text != null) {
            this.setText(text);
        }
        this.arrow = new Sprite(ImgAdjust.getCypherImage("/data/2d/240x320/arrow_text.png"));
        this.titleHeight = 0;
        this.fadeIn = false;
    }

    public void setTitle(String title) {
        this.title = title;
        if (title == null) {
            this.titleHeight = 0;
        }
        AEFont.setFont((byte)0);
        this.titleHeight = AEFont.getRowHeight();
    }

    public void setNoFade(boolean b2) {
        this.dontFade = b2;
    }

    public void resetScrollBar() {
        this.currentY = 0;
    }

    public void setPosition(int x, int y) {
        this.boxX = x;
        this.boxY = y;
        this.x = x + 12;
        this.y = y + 12;
        this.initText(this.text);
    }

    public void setText(String text) {
        this.text = text;
    }

    public void initText(String text) {
        int rowHeight;
        this.text = text;
        this.textStartY = this.y;
        if (text == null) {
            return;
        }
        if (this.title != null) {
            this.textStartY += this.titleHeight + 12;
        }
        AEFont.setFont((byte)0);
        this.lines = AEFont.getLineArray(text, this.w);
        this.linesHeight = rowHeight = AEFont.getRowHeight() * this.lines.length;
        this.h = this.boxH - this.textStartY - 12;
        this.h -= this.h % AEFont.getRowHeight();
    }

    public int getHeight() {
        return this.boxH;
    }

    public void downRelease(int time) {
        if (this.linesHeight > this.h) {
            this.currentY -= AEFont.getRowHeight() + this.currentY % AEFont.getRowHeight();
            if (this.currentY < -(this.linesHeight - this.h)) {
                this.currentY = -(this.linesHeight - this.h);
            }
        }
    }

    public void upRelease(int time) {
        this.currentY += AEFont.getRowHeight() - this.currentY % AEFont.getRowHeight();
        if (this.currentY > 0) {
            this.currentY = 0;
        }
    }

    public void down(int time) {
        if (this.linesHeight > this.h) {
            this.currentY -= time / 10;
            if (this.currentY < -(this.linesHeight - this.h)) {
                this.currentY = -(this.linesHeight - this.h);
            }
        }
    }

    public void up(int time) {
        this.currentY += time / 10;
        if (this.currentY > 0) {
            this.currentY = 0;
        }
    }

    public void fadeIn() {
        this.fadeIn = true;
        this.ease = null;
        this.ease = new AEEaseInOut(0, this.boxH / 2);
        if (this.dontFade) {
            this.ease.increase(100000);
            this.setPosition(this.boxX, grh.h / 2 - this.boxH / 2);
        }
    }

    public void draw(boolean upPressed, boolean downPressed, int elapsed_time) {
        if (this.fadeIn && !this.dontFade) {
            this.ease.increase(elapsed_time * 2);
            this.setPosition(this.boxX, grh.h / 2 - this.ease.getValue());
        }
        grh.g.setClip(this.boxX, grh.h / 2 - this.ease.getValue(), this.boxW, this.ease.getValue() * 2);
        GUI.drawBox(this.boxX, this.boxY, this.boxW, this.boxH);
        if (this.title != null) {
            AEFont.setFont((byte)0);
            AEFont.drawString(this.title, this.x + (this.w >> 1), this.y - 6, 24);
            grh.g.setColor(4140826);
            int marginX = AEFont.getStringWidth("OO");
            grh.g.drawLine(this.x + marginX, this.textStartY - 12, this.x + this.w - marginX, this.textStartY - 12);
            grh.g.setColor(0);
            grh.g.drawLine(this.x + marginX, this.textStartY - 12 + 1, this.x + this.w - marginX, this.textStartY - 12 + 1);
        }
        if (this.currentY < 0) {
            this.arrow.setTransform(0);
            this.arrow.setPosition(this.boxX + this.boxW - 12 - this.arrow.getWidth(), this.boxY + this.boxH - 12 - this.arrow.getHeight() - 1);
            this.arrow.paint(grh.g);
        }
        if (this.currentY > -(this.linesHeight - this.h)) {
            this.arrow.setTransform(3);
            this.arrow.setPosition(this.boxX + this.boxW - 12 - this.arrow.getWidth(), this.boxY + this.boxH - 12);
            this.arrow.paint(grh.g);
        }
        AEFont.setFont((byte)0);
        int max_clip_height = 2 * this.ease.getValue() - (this.textStartY - this.boxY);
        if (this.h < max_clip_height) {
            max_clip_height = this.h;
        }
        grh.g.setClip(this.x, this.textStartY + 2, this.w, max_clip_height);
        if (this.lines != null) {
            AEFont.drawLines(this.lines, this.x, this.currentY + this.textStartY);
        }
        grh.g.setClip(0, 0, grh.w, grh.h);
        GUI.drawLines(this.boxX, grh.h / 2 - this.ease.getValue() + this.ease.getValue() * 2, this.boxW);
    }

    public void release() {
        if (this.lines != null) {
            for (int i = 0; i < this.lines.length; ++i) {
                if (this.lines[i] == null) continue;
                this.lines[i] = null;
            }
            this.lines = null;
        }
        Object text = null;
        Object title = null;
        Object arrow = null;
        this.ease = null;
    }
}

