/*
 * Decompiled with CFR 0.152.
 */
package FLToolkit;

import FLToolkit.MenuItem;
import java.util.Vector;

public class SimpleMenu {
    private Vector menu = null;
    private MenuItem currentItem = null;
    private Vector currentMenu;

    public void deleteMenu(int menuIndex) {
        for (int i = 0; i < this.menu.size(); ++i) {
            MenuItem m = ((MenuItem)this.menu.elementAt(i)).getMenuWithIndex(menuIndex);
            if (m == null) continue;
            if (m.parent == null) {
                this.menu = null;
            } else {
                m.parent.subMenu = null;
            }
            return;
        }
    }

    public void setCurrentMenu(int menuIndex, int itemIndex) {
        for (int i = 0; i < this.menu.size(); ++i) {
            MenuItem m = ((MenuItem)this.menu.elementAt(i)).getMenuWithIndex(menuIndex);
            if (m == null) continue;
            this.currentMenu = m.parent == null ? this.menu : m.parent.subMenu;
            this.currentItem = (MenuItem)this.currentMenu.elementAt(itemIndex);
            return;
        }
    }

    public void addMenu(int menuIndex, int[] hierarchy, MenuItem[] menuItems) {
        int i;
        Vector currentMenu = null;
        MenuItem currentMenuItem = null;
        if (hierarchy == null) {
            this.menu = new Vector(menuItems.length);
            currentMenu = this.menu;
        } else {
            currentMenu = this.menu;
            for (i = 0; i < hierarchy.length; ++i) {
                currentMenuItem = (MenuItem)currentMenu.elementAt(hierarchy[i]);
                if (currentMenuItem.subMenu == null) {
                    ((MenuItem)currentMenu.elementAt((int)hierarchy[i])).subMenu = new Vector(menuItems.length);
                }
                currentMenu = ((MenuItem)currentMenu.elementAt((int)hierarchy[i])).subMenu;
            }
        }
        for (i = 0; i < menuItems.length; ++i) {
            currentMenu.addElement(menuItems[i]);
            menuItems[i].parent = currentMenuItem;
            menuItems[i].menuIndex = menuIndex;
            currentMenu.trimToSize();
        }
        this.currentItem = (MenuItem)this.menu.elementAt(0);
        currentMenu = null;
    }

    public void select() {
        if (this.currentItem.subMenu != null) {
            this.currentMenu = this.currentItem.subMenu;
            this.currentItem = (MenuItem)this.currentItem.subMenu.elementAt(0);
            return;
        }
        if (this.currentItem != null) {
            this.currentItem.toggleRight();
        }
    }

    public void back(int lastItem) {
        if (this.currentItem.parent != null) {
            this.currentItem = this.currentItem.parent;
            if (this.currentItem.parent != null) {
                this.currentMenu = this.currentItem.parent.subMenu;
                this.currentItem = (MenuItem)this.currentMenu.elementAt(lastItem);
            } else {
                this.currentMenu = null;
                this.currentItem = (MenuItem)this.menu.elementAt(lastItem);
            }
        }
    }

    public void up() {
        Vector m = this.currentMenu;
        if (m == null) {
            m = this.menu;
        }
        int index = m.indexOf(this.currentItem);
        if (--index < 0) {
            index = m.capacity() - 1;
        }
        this.currentItem = (MenuItem)m.elementAt(index);
    }

    public void down() {
        Vector m = this.currentMenu;
        if (m == null) {
            m = this.menu;
        }
        int index = m.indexOf(this.currentItem);
        if (++index >= m.capacity()) {
            index = 0;
        }
        this.currentItem = (MenuItem)m.elementAt(index);
    }

    public void right() {
        if (this.currentItem != null) {
            this.currentItem.toggleRight();
        }
    }

    public void left() {
        if (this.currentItem != null) {
            this.currentItem.toggleLeft();
        }
    }

    public int getCurrentItem() {
        Vector m = this.currentMenu;
        if (m == null) {
            m = this.menu;
        }
        return m.indexOf(this.currentItem);
    }

    public int getCurrentMenu() {
        return this.currentItem.menuIndex;
    }

    public int getCurrentLength() {
        Vector m = this.currentMenu;
        if (m == null) {
            m = this.menu;
        }
        return m.capacity();
    }

    public MenuItem getItemAt(int index) {
        Vector m = this.currentMenu;
        if (m == null) {
            m = this.menu;
        }
        return (MenuItem)m.elementAt(index);
    }

    public boolean currentMenuIsEmpty() {
        return this.currentItem.getCaption() == null;
    }

    private String getMenuString(Vector m, int layer) {
        String s = "";
        if (m != null) {
            for (int i = 0; i < m.capacity(); ++i) {
                String indent = new String("");
                for (int j = 0; j < layer; ++j) {
                    indent = indent + " ";
                }
                String arrow = new String("");
                if (this.currentItem == (MenuItem)m.elementAt(i)) {
                    arrow = "--> ";
                }
                s = s + arrow + indent + ((MenuItem)m.elementAt(i)).getCaption() + " (" + ((MenuItem)m.elementAt(i)).getToggleString() + ")\n";
                s = s + this.getMenuString(((MenuItem)m.elementAt((int)i)).subMenu, layer + 1);
            }
        }
        return s;
    }

    public String toString() {
        return this.getMenuString(this.menu, 0);
    }
}

