/*
 * Decompiled with CFR 0.152.
 */
package FLToolkit;

import FLToolkit.grh;
import java.io.InputStream;
import javax.microedition.lcdui.AlertType;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VolumeControl;

public class Sound
implements PlayerListener {
    public static final int VOL_25 = 1;
    public static final int VOL_50 = 2;
    public static final int VOL_75 = 3;
    public static final int VOL_100 = 4;
    public static final int VOL_0 = 0;
    public static final int[] volumes = new int[]{0, 25, 50, 75, 100};
    private Player musicPlayer;
    private Player[] soundPlayer;
    private int volume = grh.volume;
    private boolean playerWasKilled = false;
    private int music_id;
    private String SoundName;
    private static final String[] filenames = new String[]{"/data/sound/fx/wav/block04.wav", "/data/sound/fx/wav/cut04.wav", "/data/sound/fx/wav/cut09.wav", "/data/sound/fx/wav/kleng03.wav", "/data/sound/fx/wav/special03.wav", "/data/sound/fx/wav/kling19.wav", "/data/sound/fx/wav/kling20.wav", "/data/sound/fx/wav/kling23.wav", "/data/sound/fx/wav/klong01.wav", "/data/sound/fx/wav/klong02.wav", "/data/sound/fx/wav/punch07.wav", "/data/sound/fx/wav/punch03.wav", "/data/sound/fx/wav/swosh01.wav", "/data/sound/fx/wav/swosh02.wav", "/data/sound/fx/wav/crowdya14.wav", "/data/sound/fx/wav/criticalhit.wav", "/data/sound/music/gl_justdrums.mid", "/data/sound/music/gl_theme.mid", "/data/sound/music/gl_justdark.mid", "/data/sound/music/gl_finalvictory.mid"};
    private int currentID = 0;
    public static final int HIT_COUNT = 3;
    public static final int BLOCK_COUNT = 5;
    public static final int MISS_COUNT = 3;
    public static final int BLOCK_01 = 0;
    public static final int CUT_01 = 1;
    public static final int CUT_02 = 2;
    public static final int CHAIN_01 = 3;
    public static final int SPECIAL_01 = 4;
    public static final int KLING_01 = 5;
    public static final int KLING_02 = 6;
    public static final int KLING_03 = 7;
    public static final int KLONG_01 = 8;
    public static final int KLONG_02 = 9;
    public static final int PUNCH_01 = 10;
    public static final int PUNCH_02 = 11;
    public static final int SWOSH_01 = 12;
    public static final int SWOSH_02 = 13;
    public static final int CROWD_01 = 14;
    public static final int CRITICAL_HIT_01 = 15;
    public static final int MUSIC_DRUMS = 16;
    public static final int MUSIC_MENU = 17;
    public static final int MUSIC_CHAR_SELECT = 18;
    public static final int MUSIC_VICTORY = 19;

    public Sound() {
        this.soundPlayer = new Player[16];
        for (int i = 0; i < this.soundPlayer.length; ++i) {
            try {
                InputStream is = this.getClass().getResourceAsStream(filenames[i]);
                this.soundPlayer[i] = Manager.createPlayer((InputStream)is, (String)"audio/x-wav");
                this.soundPlayer[i].setLoopCount(1);
                this.soundPlayer[i].prefetch();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("Sound(): (" + i + ") " + e.toString());
            }
        }
    }

    public int getLastMusic() {
        return this.music_id;
    }

    public void playMusic(int type) {
        this._playMusic(type, false);
    }

    public void playMusicOnce(int type) {
        this._playMusic(type, true);
    }

    public void _playMusic(int type, boolean once) {
        try {
            InputStream is = this.getClass().getResourceAsStream(filenames[type]);
            this.music_id = type;
            this.musicPlayer = Manager.createPlayer((InputStream)is, (String)"audio/midi");
            this.musicPlayer.addPlayerListener((PlayerListener)this);
            if (once) {
                this.musicPlayer.setLoopCount(1);
            } else {
                this.musicPlayer.setLoopCount(-1);
            }
            this.musicPlayer.prefetch();
            this.musicPlayer.start();
            VolumeControl v = (VolumeControl)this.musicPlayer.getControl("VolumeControl");
            v.setLevel(volumes[this.volume]);
            try {
                v.setMute(false);
            }
            catch (Exception e) {
                System.out.println("Music(): (" + type + ") " + e.toString());
                grh.handle.error = grh.handle.error + "_playMusic()1 " + e.toString();
            }
            grh.r_SoundResume = false;
            is = null;
        }
        catch (Exception e) {
            System.out.println("Music(): (" + type + ") " + e.toString());
            grh.handle.error = grh.handle.error + "_playMusic()2 " + e.toString();
            grh.r_SoundResume = true;
            if (this.musicPlayer != null) {
                this.musicPlayer.deallocate();
                this.musicPlayer.close();
            }
            this.musicPlayer = null;
            e.printStackTrace();
        }
    }

    public boolean isMusicPlaying() {
        try {
            if (this.musicPlayer != null) {
                return this.musicPlayer.getState() == 400;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    public void stop() {
        try {
            try {
                if (this.musicPlayer != null) {
                    VolumeControl volumeControl = (VolumeControl)this.musicPlayer.getControl("VolumeControl");
                    volumeControl.setMute(true);
                }
            }
            catch (Exception e) {
                grh.handle.error = grh.handle.error + "stop()1 " + e.toString();
            }
            if (this.musicPlayer != null) {
                this.musicPlayer.stop();
                this.musicPlayer.deallocate();
                this.musicPlayer.close();
            }
            if (this.soundPlayer != null && this.soundPlayer[this.currentID] != null && this.soundPlayer[this.currentID].getState() == 400) {
                this.soundPlayer[this.currentID].stop();
                this.soundPlayer[this.currentID].deallocate();
                this.soundPlayer[this.currentID].close();
            }
        }
        catch (Exception e) {
            grh.handle.error = grh.handle.error + "stop()2 " + e.toString();
        }
    }

    public void pause() {
        try {
            try {
                VolumeControl volumeControl = (VolumeControl)this.musicPlayer.getControl("VolumeControl");
                volumeControl.setMute(true);
            }
            catch (Exception e) {
                grh.handle.error = "pause()1 " + e.toString();
            }
            this.musicPlayer.stop();
            if (this.soundPlayer != null) {
                for (int i = 0; i < this.soundPlayer.length; ++i) {
                    if (this.soundPlayer[i] == null) continue;
                    this.soundPlayer[i].stop();
                }
            }
        }
        catch (Exception e) {
            grh.handle.error = "pause()2 " + e.toString();
        }
    }

    public void resume() {
        try {
            if (grh.volume != 0) {
                VolumeControl volumeControl;
                try {
                    volumeControl = (VolumeControl)this.musicPlayer.getControl("VolumeControl");
                    volumeControl.setMute(false);
                    AlertType.ERROR.playSound(grh.display);
                    volumeControl.setLevel(volumes[this.volume]);
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.musicPlayer.start();
                volumeControl = (VolumeControl)this.musicPlayer.getControl("VolumeControl");
                volumeControl.setLevel(volumes[this.volume]);
            }
            grh.r_SoundResume = false;
        }
        catch (Exception e) {
            grh.r_SoundResume = true;
            if (this.musicPlayer != null) {
                this.musicPlayer.deallocate();
                this.musicPlayer.close();
            }
            this.musicPlayer = null;
            grh.handle.error = "resume() " + e.toString();
            e.printStackTrace();
        }
    }

    public void setVolume(int volume) {
        this.volume = volume;
        try {
            if (this.isMusicPlaying()) {
                VolumeControl v = (VolumeControl)this.musicPlayer.getControl("VolumeControl");
                v.setLevel(volumes[volume]);
            }
        }
        catch (Exception e) {
            grh.handle.error = "setVolume() " + e.toString();
        }
    }

    public void playSound(int index) {
        block14: {
            boolean playSound = true;
            if (index >= this.soundPlayer.length) {
                return;
            }
            if (grh.volume == 0) {
                return;
            }
            try {
                if (this.soundPlayer[this.currentID].getState() == 400) {
                    int last_id;
                    if (this.getPriority(this.currentID) >= this.getPriority(index)) {
                        if (this.currentID == 4) {
                            last_id = this.currentID;
                            this.currentID = index;
                            this.soundPlayer[last_id].stop();
                            this.soundPlayer[last_id].setMediaTime(0L);
                        } else {
                            playSound = false;
                        }
                    } else {
                        last_id = this.currentID;
                        this.currentID = index;
                        this.soundPlayer[this.currentID].stop();
                        this.soundPlayer[this.currentID].setMediaTime(0L);
                    }
                }
                if (playSound) {
                    this.currentID = index;
                    this.soundPlayer[this.currentID].start();
                    VolumeControl v = (VolumeControl)this.soundPlayer[this.currentID].getControl("VolumeControl");
                    v.setLevel(volumes[this.volume]);
                }
            }
            catch (Exception e) {
                if (!playSound) break block14;
                try {
                    System.out.println("playSound1(): (" + this.currentID + ") " + e.toString());
                    this.soundPlayer[this.currentID].deallocate();
                    this.soundPlayer[this.currentID].close();
                }
                catch (Exception es) {
                    System.out.println("playSound2(): (" + this.currentID + ") " + es.toString());
                }
                try {
                    InputStream is = this.getClass().getResourceAsStream(filenames[this.currentID]);
                    this.soundPlayer[this.currentID] = Manager.createPlayer((InputStream)is, (String)"audio/amr");
                    this.soundPlayer[this.currentID].setLoopCount(1);
                    this.soundPlayer[this.currentID].prefetch();
                    this.soundPlayer[this.currentID].start();
                    VolumeControl v = (VolumeControl)this.soundPlayer[this.currentID].getControl("VolumeControl");
                    v.setLevel(volumes[this.volume]);
                }
                catch (Exception es) {
                    System.out.println("playSound3(): (" + this.currentID + ") " + es.toString());
                }
            }
        }
    }

    public void playerUpdate(Player player, String event, Object object) {
        if (event.compareTo("deviceUnavailable") == 0 && this.musicPlayer != null && this.musicPlayer.getState() != 0) {
            this.playerWasKilled = true;
        }
        if (event.compareTo("deviceAvailable") == 0 && this.playerWasKilled) {
            this.playerWasKilled = false;
            grh.r_SoundResume = true;
        }
    }

    private int getPriority(int id) {
        switch (id) {
            case 14: 
            case 15: {
                return 1;
            }
            case 4: {
                return 2;
            }
        }
        return 0;
    }
}

