/*
 * Decompiled with CFR 0.152.
 */
package FLToolkit;

import FLToolkit.grh;
import javax.microedition.lcdui.Font;

public final class TextOutput {
    private static int lastColor = 0;
    public static final int COLOR_WHITE = -1;
    public static final int COLOR_RED = -65536;
    private static final int MARGIN_X = 4;
    private int absStartX;
    private int absStartY;
    private Font font;
    private int fontHeight;

    public TextOutput() {
        grh.g.setFont(Font.getFont((int)0, (int)0, (int)8));
        this.font = grh.g.getFont();
        this.fontHeight = this.font.getHeight();
    }

    public int getHeight() {
        return this.fontHeight;
    }

    public int getHeight(String[] lines) {
        return lines.length * this.fontHeight;
    }

    public void drawText(int x, int y, String caption, int color) {
        lastColor = grh.g.getColor();
        grh.g.setColor(color);
        grh.g.drawString(caption, x, y, 0);
        grh.g.setColor(lastColor);
    }

    public String[] getTextLines(String text, int w) {
        int charIndex;
        int lineArraySize = 0;
        String tempString = "";
        for (charIndex = 0; charIndex < text.length(); charIndex += tempString.length()) {
            tempString = this.getOneLine(text.substring(charIndex, text.length()), w);
            ++lineArraySize;
        }
        String[] lineArray = new String[lineArraySize];
        charIndex = 0;
        for (int lineIndex = 0; lineIndex < lineArraySize; ++lineIndex) {
            lineArray[lineIndex] = this.getOneLine(text.substring(charIndex, text.length()), w);
            charIndex += lineArray[lineIndex].length();
        }
        return lineArray;
    }

    public void drawText(String[] lineArray, int x, int y, int color) {
        int yPos = y;
        int h = this.getHeight();
        for (int i = 0; i < lineArray.length; ++i) {
            this.drawText(x, yPos, lineArray[i], color);
            yPos += h;
        }
    }

    private String getOneLine(String textPart, int lineWidth) {
        int charIndex = 0;
        int relPosX = this.absStartX;
        int spaceIndex = 0;
        int newLineIndex = 0;
        int tempString_length = 0;
        boolean newLineFlag = false;
        String tempString = "";
        StringBuffer lineBuffer = new StringBuffer();
        while (relPosX + tempString_length < lineWidth - 4 && charIndex < textPart.length()) {
            int i;
            if (tempString.length() > 0) {
                lineBuffer.append(tempString);
                charIndex += tempString.length();
                relPosX += tempString_length;
                tempString_length = 0;
                if (newLineFlag) {
                    return lineBuffer.toString();
                }
            }
            spaceIndex = textPart.indexOf(" ", charIndex);
            newLineIndex = textPart.indexOf("\n", charIndex);
            if (newLineIndex != -1 && (newLineIndex < spaceIndex || spaceIndex == -1)) {
                newLineFlag = true;
                for (i = charIndex; i < newLineIndex; ++i) {
                    tempString_length += grh.g.getFont().charWidth(textPart.charAt(i));
                }
                tempString = textPart.substring(charIndex, newLineIndex) + " ";
            } else if (spaceIndex != -1) {
                for (i = charIndex; i < spaceIndex + 1; ++i) {
                    tempString_length += grh.g.getFont().charWidth(textPart.charAt(i));
                }
                tempString = textPart.substring(charIndex, spaceIndex + 1);
            } else {
                for (i = charIndex; i < textPart.length(); ++i) {
                    tempString_length += grh.g.getFont().charWidth(textPart.charAt(i));
                }
                tempString = textPart.substring(charIndex, textPart.length());
            }
            if (tempString_length + 4 + this.absStartX <= lineWidth - 4) continue;
            int charIndx = 0;
            int charWidth = 0;
            tempString_length = 0;
            do {
                charWidth = grh.g.getFont().charWidth(tempString.charAt(charIndx));
                ++charIndx;
            } while ((tempString_length += charWidth) + this.absStartX + 4 < lineWidth - 4);
            tempString = tempString.substring(0, charIndx - 1);
            tempString_length -= charWidth;
        }
        return lineBuffer.toString();
    }

    public int getFontLength(String text) {
        return this.font.stringWidth(text);
    }
}

