/*
 * Decompiled with CFR 0.152.
 */
package FLToolkit;

import javax.microedition.lcdui.Graphics;

public abstract class Weather {
    protected static boolean onboardCam;
    protected int speed;

    public Weather() {
        onboardCam = false;
    }

    public abstract void draw(Graphics var1);

    public abstract void update(long var1);

    public abstract void release();

    public void setOnboardCam(boolean onboard) {
        onboardCam = onboard;
    }

    public void setSpeed(int speed) {
        this.speed = this.clip(-4096, 4096, speed);
    }

    protected int clip(int lower, int upper, int value) {
        return Math.max(Math.min(upper, value), lower);
    }

    protected static int easeIn(int v1, int v2, int weight) {
        if (weight > 4096) {
            return v2;
        }
        if (weight < 0) {
            return v1;
        }
        int easeInGewicht = -((weight - 4096) * (weight - 4096) >> 12) + 4096;
        return v1 * (4096 - easeInGewicht) + v2 * easeInGewicht >> 12;
    }

    public static int easeOut(int v1, int v2, int weight) {
        if (weight > 4096) {
            return v2;
        }
        if (weight < 0) {
            return v1;
        }
        int easeOutGewicht = -(weight * weight >> 12) + 4096;
        return v1 * easeOutGewicht + v2 * (4096 - easeOutGewicht) >> 12;
    }

    protected static int easeInOut(int v1, int v2, int weight) {
        if (weight > 4096) {
            return v1;
        }
        if (weight < 0) {
            return v1;
        }
        int easeGewicht = -(((weight <<= 1) - 4096) * (weight - 4096) >> 12) + 4096;
        return v1 * (8192 - easeGewicht) + v2 * easeGewicht >> 12;
    }

    protected static int interpolateInts(int v1, int v2, int gewicht) {
        if (gewicht > 4096) {
            return v2;
        }
        if (gewicht < 0) {
            return v1;
        }
        return v1 * (4096 - gewicht) + v2 * gewicht >> 12;
    }

    protected static int interpolateColors(int c1, int c2, int gewicht) {
        if (gewicht > 4096) {
            return c2;
        }
        if (gewicht < 0) {
            return c1;
        }
        int a1 = c1 >> 24;
        int a2 = c2 >> 24;
        int r1 = c1 - (a1 << 24) >> 16;
        int r2 = c2 - (a2 << 24) >> 16;
        int g1 = c1 - (a1 << 24) - (r1 << 16) >> 8;
        int g2 = c2 - (a2 << 24) - (r2 << 16) >> 8;
        int b1 = c1 - (a1 << 24) - (r1 << 16) - (g1 << 8);
        int b2 = c2 - (a2 << 24) - (r2 << 16) - (g2 << 8);
        int a3 = a1 * (4096 - gewicht) + a2 * gewicht >> 12 << 24;
        int r = r1 * (4096 - gewicht) + r2 * gewicht >> 12 << 16;
        int g = g1 * (4096 - gewicht) + g2 * gewicht >> 12 << 8;
        int b3 = b1 * (4096 - gewicht) + b2 * gewicht >> 12;
        return a3 + r + g + b3;
    }
}

