/*
 * Decompiled with CFR 0.152.
 */
package FLToolkit;

import AbyssEngine.AEMath;
import FLToolkit.Weather;
import java.util.Random;
import javax.microedition.lcdui.Graphics;

public class WeatherSnow3DSim
extends Weather {
    private static final int UPSAMPLETIME = 50;
    private int colorFront = 0xFFFFFF;
    private int colorBack = 0x666666;
    private int[] x;
    private int[] y;
    private int[] depth;
    private int[] xSpeedDrops;
    private int[] ySpeedDrops;
    private int[] depthSpeedDrops;
    private Random rnd;
    private int w;
    private int h;
    private int totalElt;
    private int amount;
    private boolean konfetti;

    public WeatherSnow3DSim(int w, int h, int amount) {
        this.construct(w, h, amount, false);
    }

    public WeatherSnow3DSim(int w, int h, int amount, boolean konfetti) {
        this.construct(w, h, amount, konfetti);
    }

    private void construct(int w, int h, int amount, boolean konfetti) {
        this.konfetti = konfetti;
        this.amount = amount;
        this.w = w;
        this.h = h;
        this.rnd = konfetti ? new Random(13L) : new Random(11L);
        this.totalElt = 0;
        this.speed = 0;
        this.setRainStrength(amount);
        this.xSpeedDrops = new int[10];
        this.ySpeedDrops = new int[10];
        this.depthSpeedDrops = new int[10];
        for (int i = 0; i < this.xSpeedDrops.length; ++i) {
            this.initSpeedDrop(i);
            this.depthSpeedDrops[i] = this.rnd.nextInt(4096);
        }
    }

    public void setRainStrength(int amount) {
        if (amount <= 0) {
            this.x = null;
            this.y = null;
            this.depth = null;
            this.amount = amount;
            return;
        }
        if (this.x == null || this.y == null || this.depth == null) {
            this.x = new int[amount];
            this.y = new int[amount];
            this.depth = new int[amount];
            for (int i = 0; i < this.x.length; ++i) {
                this.x[i] = this.rnd.nextInt(this.w);
                this.y[i] = this.rnd.nextInt(this.h);
                int n = i;
                this.y[n] = this.y[n] - this.h;
                this.depth[i] = this.rnd.nextInt(4096);
            }
        } else {
            int[] tmpX = new int[amount];
            int[] tmpY = new int[amount];
            int[] tmpDepth = new int[amount];
            if (tmpX.length <= this.x.length) {
                System.arraycopy(this.x, 0, tmpX, 0, tmpX.length);
                System.arraycopy(this.y, 0, tmpY, 0, tmpY.length);
                System.arraycopy(this.depth, 0, tmpDepth, 0, tmpDepth.length);
            } else {
                System.arraycopy(this.x, 0, tmpX, 0, this.x.length);
                System.arraycopy(this.y, 0, tmpY, 0, this.y.length);
                System.arraycopy(this.depth, 0, tmpDepth, 0, this.depth.length);
                for (int i = this.x.length - 1; i < tmpX.length; ++i) {
                    tmpX[i] = this.rnd.nextInt(this.w);
                    tmpY[i] = this.rnd.nextInt(this.h);
                    tmpDepth[i] = this.rnd.nextInt(4096);
                }
            }
            this.x = null;
            this.y = null;
            this.depth = null;
            this.x = tmpX;
            this.y = tmpY;
            this.depth = tmpDepth;
            tmpX = null;
            tmpY = null;
            tmpDepth = null;
        }
        this.amount = amount;
    }

    public void release() {
        this.x = null;
        this.y = null;
        this.depth = null;
        this.xSpeedDrops = null;
        this.ySpeedDrops = null;
        this.depthSpeedDrops = null;
    }

    private void updateConfettiColors(int index) {
        switch (index % 4) {
            case 0: {
                this.colorFront = 0xEE0000;
                this.colorBack = 0xDD0000;
                break;
            }
            case 1: {
                this.colorFront = 0xEE0000;
                this.colorBack = 0xDD0000;
                break;
            }
            case 2: {
                this.colorFront = 0xFFFFFF;
                this.colorBack = 0xEEEEEE;
                break;
            }
            case 3: {
                this.colorFront = 0xFFFFFF;
                this.colorBack = 0xEEEEEE;
            }
        }
    }

    public void draw(Graphics g) {
        int i;
        boolean onCl = false;
        boolean switchPaint = true;
        for (i = 0; i < this.amount; ++i) {
            int size;
            int cColor = 0;
            int sinVal = AEMath.sin((this.y[i] << 12) / (this.h >> 2));
            int extraXoffset = sinVal * 3 >> 12;
            int sizeH = size = WeatherSnow3DSim.fsize(this.depth[i]);
            if (this.konfetti) {
                this.updateConfettiColors(i);
                cColor = Weather.interpolateColors(this.colorBack, this.colorFront, this.depth[i]);
                sizeH = sinVal * sizeH >> 12;
                if (sizeH < 0) {
                    sizeH = -sizeH;
                    cColor = Weather.interpolateColors(cColor, 0, 3072);
                }
            } else {
                cColor = Weather.interpolateColors(this.colorBack, this.colorFront, this.depth[i]);
            }
            g.setColor(cColor);
            g.fillRect(this.x[i] + extraXoffset, this.y[i], size, sizeH);
        }
        if (this.speed > 1000 && Weather.onboardCam) {
            for (i = 0; i < this.xSpeedDrops.length; ++i) {
                if (this.ySpeedDrops[i] < this.h >> 1 && this.speed < 2200) continue;
                g.setColor(Weather.interpolateColors(this.colorBack, this.colorFront, this.depth[i]));
                int size = this.fsizeSpeedDrops(i);
                int yOffset = this.h >> 4;
                g.fillRect(this.xSpeedDrops[i], this.ySpeedDrops[i] + yOffset, size, size);
            }
        }
    }

    public void update(long elt) {
        this.totalElt = (int)((long)this.totalElt + elt);
        while (this.totalElt > 50) {
            this.totalElt -= 50;
            for (int i = 0; i < this.amount; ++i) {
                int n = i;
                this.depth[n] = this.depth[n] + (this.speed * 300 >> 12);
                if (this.x[i] > this.w >> 1) {
                    int n2 = i;
                    this.x[n2] = this.x[n2] + this.fx(this.depth[i]);
                } else {
                    int n3 = i;
                    this.x[n3] = this.x[n3] - this.fx(this.depth[i]);
                }
                int n4 = i;
                this.y[n4] = this.y[n4] + WeatherSnow3DSim.fy(this.depth[i]);
                if (this.x[i] > this.w || this.x[i] < 0) {
                    this.initDrop(i);
                }
                if (this.y[i] > this.h) {
                    this.initDrop(i);
                }
                if (this.depth[i] <= 4200) continue;
                this.initDrop(i);
            }
            for (int s = 0; s < this.xSpeedDrops.length; ++s) {
                int n = s;
                this.depthSpeedDrops[n] = this.depthSpeedDrops[n] + (this.speed * 200 >> 12);
                if (this.xSpeedDrops[s] > this.w >> 1) {
                    int n5 = s;
                    this.xSpeedDrops[n5] = this.xSpeedDrops[n5] + this.fxSpeedDrops(this.depthSpeedDrops[s], this.ySpeedDrops[s] <= this.h >> 1);
                } else {
                    int n6 = s;
                    this.xSpeedDrops[n6] = this.xSpeedDrops[n6] - this.fxSpeedDrops(this.depthSpeedDrops[s], this.ySpeedDrops[s] <= this.h >> 1);
                }
                if (this.ySpeedDrops[s] > this.h >> 1) {
                    int n7 = s;
                    this.ySpeedDrops[n7] = this.ySpeedDrops[n7] + WeatherSnow3DSim.fy(this.depthSpeedDrops[s]);
                } else {
                    int n8 = s;
                    this.ySpeedDrops[n8] = this.ySpeedDrops[n8] - WeatherSnow3DSim.fy(this.depthSpeedDrops[s]);
                }
                if (this.depthSpeedDrops[s] <= 2048) continue;
                this.initSpeedDrop(s);
            }
        }
    }

    private void initDrop(int i) {
        this.y[i] = -4;
        if (this.speed > 3000) {
            this.y[i] = this.rnd.nextInt(3 * this.h >> 2);
        } else if (this.speed > 1024) {
            this.y[i] = this.rnd.nextInt(this.h >> 1) - 4;
        }
        this.x[i] = this.rnd.nextInt(this.w - (8 * this.speed >> 12)) + (4 * this.speed >> 12);
        int maxDepth = 4096 - this.speed;
        this.depth[i] = maxDepth <= 0 ? 0 : this.rnd.nextInt(maxDepth);
    }

    private void initSpeedDrop(int i) {
        this.xSpeedDrops[i] = this.rnd.nextInt(this.w >> 2) + (this.w >> 1) - (this.w >> 3);
        this.ySpeedDrops[i] = this.rnd.nextInt(this.h >> 2) + (this.h >> 1) - (this.h >> 3);
        this.depthSpeedDrops[i] = 0;
    }

    private int fx(int depth) {
        if (depth < 512) {
            return 0;
        }
        int maxMovement = Weather.interpolateInts(1, 15, depth);
        return Weather.easeOut(0, maxMovement, this.speed);
    }

    private static int fy(int depth) {
        return Weather.easeIn(1, 4, depth);
    }

    private static int fsize(int depth) {
        return Weather.interpolateInts(3, 7, depth);
    }

    private int fsizeSpeedDrops(int index) {
        if (this.ySpeedDrops[index] > this.h >> 1) {
            return Weather.interpolateInts(1, 10, this.depthSpeedDrops[index]);
        }
        return Weather.interpolateInts(-1, -10, this.depthSpeedDrops[index]);
    }

    private int fxSpeedDrops(int depth, boolean goesUp) {
        if (depth < 512) {
            return 0;
        }
        int maxMovement = Weather.interpolateInts(1, goesUp ? 10 : 4, depth);
        return Weather.interpolateInts(0, maxMovement, this.speed);
    }
}

