/*
 * Decompiled with CFR 0.152.
 */
package GameEssentials;

import AbyssEngine.AEGeometry;
import AbyssEngine.AEResourceManager;
import AbyssEngine.AETexture;
import FLToolkit.BMPImage;
import FLToolkit.grh;
import GameEssentials.ContentPool;

public class Arena {
    private static final int DIRT_COUNT = 12;
    private static final int BLOOD_DROP_COUNT = 30;
    private static final int BLOOD_PUDDLE_COUNT = 3;
    private AEGeometry geometry_sky;
    private AEGeometry geometry_floor;
    private AEGeometry[] geometry_details;
    private AEGeometry[] dirt_assets;
    private AEGeometry[] blood_drops;
    private AEGeometry blood_puddle;
    private int id;
    private int blood_drop_count;
    private int blood_puddle_count;
    private AETexture modifiedTexture1;
    private AETexture modifiedTexture2;
    private AETexture modifiedTexture3;
    private boolean dark;
    private int renderFlag = 0;

    public Arena(int id, boolean menu_mode) {
        int i;
        this.id = id;
        this.geometry_details = new AEGeometry[10];
        this.renderFlag = 0;
        boolean crowd = false;
        boolean heads = false;
        boolean awnings_a = false;
        boolean awnings_b = false;
        boolean arcs = false;
        boolean garland = false;
        boolean awnings_top = false;
        this.dark = false;
        if (menu_mode) {
            crowd = true;
            awnings_a = true;
            awnings_b = true;
            arcs = true;
            garland = true;
            heads = true;
        } else {
            switch (grh.current_fight) {
                case -1: {
                    break;
                }
                case 0: {
                    crowd = true;
                    awnings_a = true;
                    break;
                }
                case 1: {
                    crowd = true;
                    awnings_a = true;
                    awnings_b = true;
                    garland = true;
                    arcs = true;
                    heads = true;
                    break;
                }
                case 2: {
                    this.dark = true;
                    arcs = true;
                    crowd = true;
                    garland = true;
                    break;
                }
                default: {
                    garland = true;
                    arcs = true;
                    crowd = true;
                    heads = true;
                    awnings_a = true;
                    awnings_b = true;
                    awnings_top = true;
                }
            }
        }
        if (grh.game_mode == 3) {
            crowd = true;
            awnings_a = true;
            awnings_b = true;
        }
        awnings_a = true;
        this.geometry_sky = AEResourceManager.getGeometryResource(id);
        this.geometry_floor = AEResourceManager.getGeometryResource(id + 1);
        if (id == 110) {
            this.geometry_details[0] = arcs ? AEResourceManager.getGeometryResource(id + 9) : null;
            this.geometry_details[1] = crowd ? AEResourceManager.getGeometryResource(id + 2) : AEResourceManager.getGeometryResource(id + 3);
            this.geometry_details[2] = crowd ? AEResourceManager.getGeometryResource(id + 4) : null;
            this.geometry_details[3] = AEResourceManager.getGeometryResource(id + 5);
            this.geometry_details[4] = AEResourceManager.getGeometryResource(id + 6);
            this.geometry_details[5] = awnings_a ? AEResourceManager.getGeometryResource(id + 7) : null;
            this.geometry_details[6] = awnings_b ? AEResourceManager.getGeometryResource(id + 8) : null;
            this.geometry_details[7] = garland ? AEResourceManager.getGeometryResource(id + 10) : null;
            this.geometry_details[8] = heads ? AEResourceManager.getGeometryResource(id + 11) : null;
            AEGeometry aEGeometry = this.geometry_details[9] = awnings_top ? AEResourceManager.getGeometryResource(id + 12) : null;
            if (this.dark || arcs) {
                this.replaceColors(arcs && !this.dark);
            }
        } else if (id == 100) {
            if (!(grh.opponent_id != 7 && grh.opponent_id != 8 || grh.char_id != 7 && grh.char_id != 8)) {
                this.geometry_details[0] = AEResourceManager.getGeometryResource(id + 3);
                this.geometry_details[1] = AEResourceManager.getGeometryResource(id + 4);
                for (i = 2; i < this.geometry_details.length; ++i) {
                    this.geometry_details[i] = null;
                }
            } else {
                this.geometry_details[0] = AEResourceManager.getGeometryResource(id + 2);
                for (i = 1; i < this.geometry_details.length; ++i) {
                    this.geometry_details[i] = null;
                }
            }
        }
        this.dirt_assets = new AEGeometry[12];
        for (i = 0; i < this.dirt_assets.length; ++i) {
            this.dirt_assets[i] = AEResourceManager.getGeometryResource(200 + grh.rnd.nextInt(3));
            int scaling = grh.rnd.nextInt(7000);
            this.dirt_assets[i].setScaling(1024 + scaling, 1024 + scaling, 1024 + scaling);
            int pos_x = grh.rnd.nextInt(1600);
            int pos_z = grh.rnd.nextInt(1600);
            if (grh.rnd.nextInt(2) > 0) {
                pos_x = -pos_x;
            }
            if (grh.rnd.nextInt(2) > 0) {
                pos_z = -pos_z;
            }
            int rot = grh.rnd.nextInt(4);
            this.dirt_assets[i].setTranslation(pos_x, 0, pos_z);
            this.dirt_assets[i].rotate(0, rot * 1024, 0);
            this.dirt_assets[i].setLayer(1);
        }
        this.blood_drop_count = 0;
        this.blood_drops = new AEGeometry[30];
        boolean r = false;
        if (this.geometry_sky != null) {
            this.geometry_sky.setLayer(0);
        }
        if (this.geometry_floor != null) {
            this.geometry_floor.setLayer(1);
        }
        for (int i2 = 0; i2 < this.geometry_details.length; ++i2) {
            if (this.geometry_details[i2] == null) continue;
            this.geometry_details[i2].setLayer(3);
        }
        if (this.geometry_details[8] != null) {
            this.geometry_details[8].setLayer(2);
        }
    }

    private void replaceColors(boolean arcsonly) {
        int[] color;
        BMPImage img = null;
        boolean modified_a = false;
        boolean modified_b = false;
        if (this.geometry_details[0] != null) {
            img = new BMPImage(ContentPool.TEXTURE_PATH + "arenas.bmp");
            img.setColorTableArea(0, 254);
            color = null;
            color = new int[]{165, 123, 71, 120, 100, 70, 255};
            if (arcsonly) {
                color = new int[]{165, 123, 71, 150, 120, 70, 255};
            }
            if (color != null) {
                img.replaceColor(color);
            }
            this.modifiedTexture1 = AETexture.create(img.getBitmap());
            if (this.geometry_details[1] != null && !arcsonly) {
                this.geometry_details[1].setTexture(this.modifiedTexture1);
            }
            if (this.geometry_details[0] != null) {
                this.geometry_details[0].setTexture(this.modifiedTexture1);
            }
            if (!arcsonly) {
                this.geometry_floor.setTexture(this.modifiedTexture1);
            }
            color = null;
            img.release();
            img = null;
            if (!arcsonly) {
                img = new BMPImage(ContentPool.TEXTURE_PATH + "skybox_fx.bmp");
                img.setColorTableArea(0, 254);
                color = new int[]{74, 133, 203, 170, 170, 170, 255};
                if (color != null) {
                    img.replaceColor(color);
                }
                this.modifiedTexture2 = AETexture.create(img.getBitmap());
                this.geometry_sky.setTexture(this.modifiedTexture2);
                img.release();
                img = null;
            }
        }
        if (!(this.geometry_details[5] == null && this.geometry_details[6] == null || arcsonly)) {
            if (img == null) {
                img = new BMPImage(ContentPool.TEXTURE_PATH + "arenas.bmp");
            }
            img.setColorTableArea(0, 254);
            color = null;
            color = new int[]{124, 20, 20, 60, 5, 5, 255};
            if (color != null) {
                img.replaceColor(color);
            }
            this.modifiedTexture3 = AETexture.create(img.getBitmap());
            if (this.geometry_details[5] != null) {
                this.geometry_details[5].setTexture(this.modifiedTexture3);
            }
            if (this.geometry_details[6] != null) {
                this.geometry_details[6].setTexture(this.modifiedTexture3);
            }
            color = null;
            img.release();
            img = null;
        }
    }

    public void addBloodDrop(int x, int z) {
        if (this.blood_drop_count < 29) {
            this.blood_drops[this.blood_drop_count] = AEResourceManager.getGeometryResource(17);
            this.blood_drops[this.blood_drop_count].setTranslation(x, 0, z);
            this.blood_drops[this.blood_drop_count].setRotation(0, grh.rnd.nextInt(4096), 0);
            int scale_y = grh.rnd.nextInt(3072);
            int scale_x = grh.rnd.nextInt(3072);
            this.blood_drops[this.blood_drop_count].setScaling(1024 + scale_x, 4096, 1024 + scale_y);
            this.blood_drops[this.blood_drop_count].setLayer(1);
            ++this.blood_drop_count;
        }
    }

    public void addBloodPuddle(int x, int z) {
        if (this.blood_puddle_count < 2) {
            this.blood_puddle = AEResourceManager.getGeometryResource(18);
            this.blood_puddle.setTranslation(x, 0, z);
            this.blood_puddle.setLayer(1);
            this.blood_puddle.stopAnim();
            this.blood_puddle.setAnimRange(1, 60);
            this.blood_puddle.playAnim((byte)1);
            ++this.blood_puddle_count;
        }
    }

    public void renderWithoutSky() {
        this.renderArena(false);
    }

    public void render() {
        this.renderArena(true);
    }

    private void renderArena(boolean withSky) {
        int i;
        if (!withSky) {
            grh.g.setColor(83, 179, 217);
        } else {
            switch (this.id) {
                case 110: {
                    if (this.dark) {
                        grh.g.setColor(142, 132, 98);
                        break;
                    }
                    grh.g.setColor(201, 166, 110);
                    break;
                }
                case 100: {
                    grh.g.setColor(227, 205, 166);
                }
            }
        }
        grh.g.fillRect(0, 0, grh.w, grh.h);
        if (this.renderFlag == 16) {
            return;
        }
        if (this.geometry_sky != null && withSky) {
            grh.renderer.render(this.geometry_sky);
        }
        if (this.renderFlag == 15) {
            return;
        }
        if (this.geometry_floor != null) {
            grh.renderer.render(this.geometry_floor);
        }
        if (this.renderFlag == 14) {
            return;
        }
        for (i = 0; i < this.geometry_details.length; ++i) {
            if (this.geometry_details[i] == null) continue;
            grh.renderer.render(this.geometry_details[i]);
            if (this.renderFlag != 13 - i) continue;
            return;
        }
        for (i = 0; i < this.dirt_assets.length; ++i) {
            if (this.dirt_assets[i] == null) continue;
            grh.renderer.render(this.dirt_assets[i]);
        }
        for (i = 0; i < this.blood_drop_count; ++i) {
            if (this.blood_drops[i] == null) continue;
            grh.renderer.render(this.blood_drops[i]);
        }
        for (i = 0; i < this.blood_puddle_count; ++i) {
            if (this.blood_puddle == null) continue;
            this.blood_puddle.update(false);
            grh.renderer.render(this.blood_puddle);
        }
    }

    public void changeRenderFlag() {
        ++this.renderFlag;
        if (this.renderFlag > 16) {
            this.renderFlag = 0;
        }
    }

    public int getRenderFlag() {
        return this.renderFlag;
    }

    public boolean puddleSpreading() {
        return this.blood_puddle != null && this.blood_puddle.isPlaying();
    }

    private void setNormalTexture() {
        BMPImage img = null;
        boolean modified_a = false;
        boolean modified_b = false;
        if (this.geometry_details[0] != null) {
            img = new BMPImage(ContentPool.TEXTURE_PATH + "arenas.png");
            this.modifiedTexture1 = AETexture.create(img.getBitmap());
            if (this.geometry_details[1] != null) {
                this.geometry_details[1].setTexture(this.modifiedTexture1);
            }
            if (this.geometry_details[0] != null) {
                this.geometry_details[0].setTexture(this.modifiedTexture1);
            }
            this.geometry_floor.setTexture(this.modifiedTexture1);
            img.release();
            img = null;
            img = new BMPImage(ContentPool.TEXTURE_PATH + "skybox.png");
            this.modifiedTexture2 = AETexture.create(img.getBitmap());
            this.geometry_sky.setTexture(this.modifiedTexture2);
            img.release();
            img = null;
        }
        if (this.geometry_details[5] != null || this.geometry_details[6] != null) {
            if (img == null) {
                img = new BMPImage(ContentPool.TEXTURE_PATH + "arenas.png");
            }
            this.modifiedTexture3 = AETexture.create(img.getBitmap());
            if (this.geometry_details[5] != null) {
                this.geometry_details[5].setTexture(this.modifiedTexture3);
            }
            if (this.geometry_details[6] != null) {
                this.geometry_details[6].setTexture(this.modifiedTexture3);
            }
            img.release();
            img = null;
        }
    }

    public void release() {
        int i;
        if (this.modifiedTexture1 != null) {
            this.modifiedTexture1.release();
        }
        if (this.modifiedTexture2 != null) {
            this.modifiedTexture2.release();
        }
        if (this.modifiedTexture3 != null) {
            this.modifiedTexture3.release();
        }
        if (this.geometry_details != null) {
            for (i = 0; i < this.geometry_details.length; ++i) {
                this.geometry_details[i] = null;
            }
            this.geometry_details = null;
        }
        if (this.dirt_assets != null) {
            for (i = 0; i < this.dirt_assets.length; ++i) {
                this.dirt_assets[i] = null;
            }
            this.dirt_assets = null;
        }
        if (this.blood_drops != null) {
            for (i = 0; i < this.blood_drops.length; ++i) {
                this.blood_drops[i] = null;
            }
            this.blood_drops = null;
        }
        this.blood_puddle = null;
        this.geometry_floor = null;
        this.geometry_sky = null;
    }
}

