/*
 * Decompiled with CFR 0.152.
 */
package GameEssentials;

import AbyssEngine.AEMath;
import AbyssEngine.AETransform;
import AbyssEngine.AEVector3D;
import FLToolkit.grh;
import GameEssentials.FighterFigure;
import com.Fishlabs.AEBluetooth.FLBluetooth;

public class Fighter {
    public static final int SPECIAL_MOVE_STEP_TIME = 300;
    public static final int SLOWMO_TIME = 2200;
    public static final int SPECIAL_REACT_START_RANGE = 1200;
    public static final int FIGHTER_LEFT = 0;
    public static final int FIGHTER_RIGHT = 1;
    public static final int MAX_HITPOINTS = 100;
    public static final int DODGE_BACK_POSSIBLE_FRAME = 3;
    public static final int DODGE_LEFT_RIGHT_POSSIBLE_FRAME = 0;
    public static final int DODGE_LEFT_RIGHT_POSSIBLE_FRAME_FIERCE = 9;
    private static final int BLOCK_POSSIBLE_FRAME = 5;
    private static final int ATTACK_CONTINUE_FRAMES = 3;
    private static final int ANIM_ABORT_FRAMES = 3;
    public static final int FAME_DAMAGE_BONUS_THRESHOLD_1 = 34;
    public static final int FAME_DAMAGE_BONUS_THRESHOLD_2 = 67;
    public static final int FAME_DAMAGE_BONUS_FACTOR_1 = 15;
    public static final int FAME_DAMAGE_BONUS_FACTOR_2 = 20;
    private static final int FAME_DOWN_TIME = 2500;
    private static final int FAME_DOWN_AMOUNT = 1;
    public static final int LIMIT_X = 1200;
    public static final int LIMIT_Z = 1200;
    private static final int STUNNED_TIME = 2500;
    private static final int FINISH_ANIM = 9;
    public static final byte SPECIAL_NOT_DETERMINED = 0;
    public static final byte SPECIAL_OK = 1;
    public static final byte SPECIAL_FAILED = 2;
    public static final byte SPECIAL_GOOD = 3;
    public static final byte SPECIAL_PERFECT = 4;
    private static final int HIT_DISPLAY_TIME = 400;
    private int hit_display_time;
    private static final int BULL_FIERCE_STUN_PROB = 50;
    public static final int[] basic_damages = new int[]{3, 3, 4, 5, 10, 1, 7, 7, 3};
    public static final int[] basic_bonuses = new int[]{1, 1, 1, 1, 2, 1, 1, 1, 1};
    public static final int F_MACE = 0;
    public static final int F_AMAZON = 1;
    public static final int F_JUBA = 2;
    public static final int F_BULL = 3;
    public static final int F_TRIDENT = 4;
    public static final int F_HAGEN = 5;
    public static final int F_TIGER = 6;
    public static final int F_MAXIMUS = 7;
    public static final int F_COMMODUS = 8;
    private static final int[][] heavy_attack_info = new int[][]{{1500, 1}, {1100, 0}, {1000, 0}, {1000, 0}, {1000, 0}, {1800, 1}, {1200, 0}, {1900, 0}, {1200, 0}};
    private static final int[] special_attack_react_time = new int[]{700, 500, 500, 500, 450, 450, 450, 500, 500};
    public static final int[][] special_moves = new int[][]{{65536, 8192}, {65536, 8192}, {65536, 8192}, {65536, 8192}, {65536, 8192}, {65536, 8192}, {65536, 8192}, {65536, 8192}, {65536, 8192}};
    public FighterFigure figure;
    private Fighter opponent;
    private int mesh_id;
    private int current_anim;
    public int rotate_cw;
    public int rotate_ccw;
    private int agility;
    private int constitution;
    private int charisma;
    private int strength;
    private int[] damages;
    private String name;
    private byte specialAttackState;
    private boolean specialNext;
    private boolean slowMo;
    private boolean stunned;
    private int fame_down_time;
    private int stunned_time;
    private int hitpoints;
    private int oldHitpoints;
    private int fame;
    private int wins;
    private int slowMo_time;
    private int special_react_start_time;
    private int special_display_time;
    private boolean fightOver;
    private boolean won;
    private boolean attackOver;
    public boolean slowMoOver;
    private int position;
    private boolean finishing;
    private boolean eternal_life;
    private boolean new_fame_level;
    private int new_fame_level_time;
    private static final int NEW_FAME_LEVEL_TIME = 3000;
    private boolean highlight_fame;
    private int last_added_fame;
    private int BORDER_DISPLAY_TIME = 1500;
    private int border_time;
    private int border_mark;
    public static final int BORDER_LEFT = 2;
    public static final int BORDER_BACK = 4;
    public static final int BORDER_RIGHT = 8;
    public boolean newAnim;
    public boolean handleAnimEndCalled;
    private boolean addBloodDrops;
    private boolean addBloodPuddle;
    private boolean holdBlock;
    private boolean beingHit;
    private long tutorial_bit_mask;
    private byte[] animationQueue;
    private int animQueueID;
    private boolean waitForSpecialResult;
    private boolean isPlayer = false;
    public static final int SOUND_HIT = 0;
    public static final int SOUND_MISS = 1;
    public static final int SOUND_BLOCK = 2;
    public static final int SOUND_CROWD = 3;
    public static final int SOUND_SPECIAL = 4;

    public Fighter(int mesh_id, int shadow_id) {
        this.figure = new FighterFigure(mesh_id, shadow_id);
        this.mesh_id = mesh_id;
        if (mesh_id >= 300) {
            mesh_id -= 300;
        }
        this.current_anim = 1;
        this.animationQueue = new byte[40];
        this.animQueueID = 0;
    }

    public int getID() {
        return this.mesh_id;
    }

    public int getCurrentAnim() {
        return this.current_anim;
    }

    public Fighter getOpponent() {
        return this.opponent;
    }

    public void setOpponent(Fighter opponent) {
        this.opponent = opponent;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean isInSlowMoMode() {
        return this.slowMo;
    }

    public void setCharisma(int charisma) {
        this.charisma = charisma;
    }

    public int getCharisma() {
        return this.charisma;
    }

    public void setStrength(int strength) {
        this.strength = strength;
    }

    public int getStrength() {
        return this.strength;
    }

    public void setAgility(int agility) {
        this.agility = agility;
    }

    public int getAgility() {
        return this.agility;
    }

    public void setFame(int new_fame, boolean cheering) {
        if (new_fame > this.fame) {
            this.last_added_fame = !cheering ? new_fame - this.fame : 0;
        }
        this.fame_down_time = 0;
        if (this.fame < 34 && new_fame >= 34 || this.fame < 67 && new_fame >= 67) {
            this.new_fame_level = true;
            this.new_fame_level_time = 3000;
        }
        this.highlight_fame = new_fame > this.fame;
        this.fame = new_fame;
        if (this.fame > 100) {
            this.fame = 100;
        } else if (this.fame < 0) {
            this.fame = 0;
        }
    }

    public void setHighlightFame(boolean b2) {
        this.highlight_fame = b2;
    }

    public void setStunned(boolean stunned) {
        this.stunned = stunned;
        this.stunned_time = stunned ? 2500 : 0;
    }

    public boolean isStunned() {
        return this.stunned;
    }

    public boolean addBloodDrops() {
        return this.addBloodDrops;
    }

    public void dropsAdded() {
        this.addBloodDrops = false;
    }

    public boolean addBloodPuddle() {
        return this.addBloodPuddle;
    }

    public void puddleAdded() {
        this.addBloodPuddle = false;
    }

    public int getFame() {
        return this.fame;
    }

    public void setConstitution(int constitution) {
        this.constitution = constitution;
    }

    public int getConstitution() {
        return this.constitution;
    }

    public void setHitPoints(int hitpoints) {
        this.hitpoints = hitpoints;
        this.oldHitpoints = hitpoints;
    }

    public int getHitPoints() {
        return this.hitpoints;
    }

    public int getOldHitPoints() {
        return this.oldHitpoints;
    }

    public void setDamage(int damage) {
        if (damage <= 0) {
            damage = 1;
        }
        this.oldHitpoints = this.hitpoints;
        this.hit_display_time = 400;
        this.hitpoints -= damage;
        if (this.hitpoints < 0) {
            this.hitpoints = 0;
        }
    }

    public int getWins() {
        return this.wins;
    }

    public void setWins(int wins) {
        this.wins = wins;
    }

    public int getHeavyAttackLoopTime() {
        return heavy_attack_info[this.mesh_id][0];
    }

    public boolean heavyAttackLoopDealsDamage() {
        return heavy_attack_info[this.mesh_id][1] == 1;
    }

    public void win() {
        this.fightOver = true;
        this.won = true;
        ++this.wins;
    }

    public void lose() {
        if (this.hitpoints > 0) {
            this.fightOver = true;
        }
        this.won = false;
    }

    public boolean fightOver() {
        return this.fightOver;
    }

    public boolean hasWon() {
        return this.won;
    }

    public boolean hasLost() {
        return this.isDead() || this.fightOver && !this.won;
    }

    public void initMenuMode() {
        this.reset();
        this.eternal_life = true;
    }

    public void initGameOver() {
        if (!this.won) {
            this.addBloodPuddle = false;
            this.hitpoints = 1;
            this.fightOver = false;
            this.won = false;
        } else {
            this.fightOver = false;
            this.won = false;
        }
    }

    public void reset() {
        this.holdBlock = false;
        this.stunned = false;
        this.finishing = false;
        this.fightOver = false;
        this.won = false;
        this.fame = 0;
        this.hitpoints = 100;
        this.rotate_ccw = 0;
        this.rotate_cw = 0;
        this.current_anim = 1;
        this.eternal_life = false;
        this.addBloodPuddle = false;
        this.addBloodDrops = false;
        if (this.position == 0) {
            this.figure.reset(-200, 0, 0);
        } else {
            this.figure.reset(200, 2048, 0);
        }
        this.animQueueID = 0;
        this.playAnim(this.current_anim);
    }

    public boolean specialNext() {
        boolean res = false;
        res = this.specialNext;
        if (this.specialNext) {
            this.specialNext = false;
        }
        return res;
    }

    public int getSpecialHitTime() {
        return this.special_react_start_time;
    }

    public void setTransform(int x, int y, int z, int ry) {
        this.figure.setTransformation(x, y, z, 0, ry, 0);
    }

    public AEVector3D getFuturePosition() {
        return this.figure.getTargetPosition();
    }

    public AEVector3D getPosition() {
        return this.figure.getPosition();
    }

    public int getFutureRY() {
        return this.figure.getTargetRotation().y;
    }

    public int getRotationY() {
        return this.figure.getRotationY();
    }

    public int getPositionX() {
        return this.figure.getPositionX();
    }

    public int getPositionZ() {
        return this.figure.getPositionZ();
    }

    public int getFutureX() {
        return this.figure.getTargetPosition().x;
    }

    public int getFutureZ() {
        return this.figure.getTargetPosition().z;
    }

    public int getCurrentX() {
        if (this.getFutureX() == this.figure.getPositionX()) {
            return this.figure.getPositionX();
        }
        return this.figure.getPositionX() + (int)((float)this.figure.getCurrentAnimFrame() / (float)(this.figure.getCurrentAnimEndFrame() - this.figure.getCurrentAnimStartFrame()) * (float)(this.getFutureX() - this.figure.getPositionX()));
    }

    public int getCurrentZ() {
        if (this.getFutureZ() == this.figure.getPositionZ()) {
            return this.figure.getPositionZ();
        }
        return this.figure.getPositionZ() + (int)((float)this.figure.getCurrentAnimFrame() / (float)(this.figure.getCurrentAnimEndFrame() - this.figure.getCurrentAnimStartFrame()) * (float)(this.getFutureZ() - this.figure.getPositionZ()));
    }

    public boolean canMove() {
        return !this.isStunned() && !this.isDead() && (this.current_anim == 1 || this.current_anim == 25 || this.current_anim == 24);
    }

    public boolean animAbortPossible() {
        return !this.isStunned() && this.current_anim != 4 && this.current_anim != 5 && this.current_anim != 7 && this.current_anim != 9 && this.figure.animAbortPossible(3);
    }

    public void rotateCCW() {
        ++this.rotate_ccw;
    }

    public void rotateCW() {
        ++this.rotate_cw;
    }

    public void undoRotateCCW() {
        --this.rotate_ccw;
    }

    public void undoRotateCW() {
        --this.rotate_cw;
    }

    public boolean backwardRangeOK() {
        return Math.abs(this.getFutureZ() - this.opponent.getFutureZ()) < 150 && Math.abs(this.getFutureX()) <= 800 || Math.abs(this.getFutureX() - this.opponent.getFutureX()) < 150 && Math.abs(this.getFutureZ()) <= 800;
    }

    public boolean leftRangeOK() {
        return Math.abs(this.getFutureZ() - this.opponent.getFutureZ()) < 150 && (this.getFutureX() < this.opponent.getFutureX() && Math.abs(this.getFutureZ() - 400) <= 1200 || this.getFutureX() > this.opponent.getFutureX() && Math.abs(this.getFutureZ() + 400) <= 1200) || Math.abs(this.getFutureX() - this.opponent.getFutureX()) < 150 && (this.getFutureZ() < this.opponent.getFutureZ() && Math.abs(this.getFutureX() + 400) <= 1200 || this.getFutureZ() > this.opponent.getFutureZ() && Math.abs(this.getFutureX() - 400) <= 1200);
    }

    public boolean rightRangeOK() {
        return Math.abs(this.getFutureZ() - this.opponent.getFutureZ()) < 150 && (this.getFutureX() > this.opponent.getFutureX() && Math.abs(this.getFutureZ() - 400) <= 1200 || this.getFutureX() < this.opponent.getFutureX() && Math.abs(this.getFutureZ() + 400) <= 1200) || Math.abs(this.getFutureX() - this.opponent.getFutureX()) < 150 && (this.getFutureZ() > this.opponent.getFutureZ() && Math.abs(this.getFutureX() + 400) <= 1200 || this.getFutureZ() < this.opponent.getFutureZ() && Math.abs(this.getFutureX() - 400) <= 1200);
    }

    public boolean moveLeft(boolean forcedMove) {
        if (forcedMove || this.canMove() || this.animAbortPossible()) {
            if (forcedMove || this.animAbortPossible()) {
                this.handleAnimationEnd();
                if (!forcedMove && !this.leftRangeOK()) {
                    return false;
                }
            }
            if (forcedMove || this.leftRangeOK()) {
                this.rotateAsNeeded();
                this.playAnim(21);
                this.figure.moveLeft(this.opponent.getFutureX(), this.opponent.getFutureZ(), this.opponentWillBeInCloseRange());
                this.opponent.rotateCW();
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean isRotating() {
        return this.getCurrentAnim() == 24 || this.getCurrentAnim() == 25;
    }

    public boolean moveRight(boolean forcedMove) {
        if (forcedMove || this.canMove() || this.animAbortPossible()) {
            if (forcedMove || this.animAbortPossible()) {
                this.handleAnimationEnd();
                if (!forcedMove && !this.rightRangeOK()) {
                    return false;
                }
            }
            if (forcedMove || this.rightRangeOK()) {
                this.rotateAsNeeded();
                this.playAnim(20);
                this.figure.moveRight(this.opponent.getFutureX(), this.opponent.getFutureZ(), this.opponentWillBeInCloseRange());
                this.opponent.rotateCCW();
                return true;
            }
            return false;
        }
        return true;
    }

    public void moveForward(boolean forcedMove) {
        if (forcedMove || this.canMove() || this.animAbortPossible()) {
            if (forcedMove || this.animAbortPossible()) {
                this.handleAnimationEnd();
            }
            if (this.opponent.getCurrentAnim() != 22 && this.opponent.getCurrentAnim() != 20 && this.opponent.getCurrentAnim() != 21 && this.opponent.getCurrentAnim() != 26 && !this.opponentWillBeInCloseRange()) {
                this.rotateAsNeeded();
                this.playAnim(22);
                this.figure.moveForward(this.opponent.getFutureX(), this.opponent.getFutureZ());
            }
        }
    }

    public boolean moveBackward(boolean forcedMove) {
        if (forcedMove || (this.canMove() || this.animAbortPossible()) && this.opponent.getCurrentAnim() != 23 && this.opponentWillBeInCloseRange()) {
            if (forcedMove || this.animAbortPossible()) {
                this.handleAnimationEnd();
                if (!forcedMove && !this.backwardRangeOK()) {
                    return false;
                }
            }
            if (forcedMove || this.backwardRangeOK()) {
                int old_ry = this.figure.getRotationY();
                int rotate = 0;
                this.rotateAsNeeded();
                if (AEMath.abs(old_ry - this.figure.getRotationY()) > 1024) {
                    int new_ry = this.figure.getRotationY();
                    this.figure.setTransformation(this.getPositionX(), this.figure.getPositionY(), this.getPositionZ(), 0, new_ry - 2048, 0);
                    this.current_anim = 27;
                    rotate = 2048;
                    this.figure.moveBackward(this.opponent.getFutureX(), this.opponent.getFutureZ(), new_ry);
                } else {
                    this.current_anim = 23;
                    this.figure.moveBackward(this.opponent.getFutureX(), this.opponent.getFutureZ(), this.figure.getRotationY());
                }
                this.playAnim(this.current_anim);
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean backHit() {
        return this.rotate_ccw > 1 || this.rotate_cw > 1;
    }

    public void setTargetRotation(int rx, int ry, int rz) {
        this.figure.setTargetRotation(rx, ry, rz);
    }

    private void rotateAsNeeded() {
        while (this.rotate_ccw > 0) {
            --this.rotate_ccw;
            this.figure.rotate(0, 1024, 0);
        }
        while (this.rotate_cw > 0) {
            --this.rotate_cw;
            this.figure.rotate(0, -1024, 0);
        }
        this.figure.updateTransformation();
    }

    public boolean fierceAttackWillHit() {
        int compare = 450;
        if (this.staysAtFarRangeAfterFierce()) {
            compare = 850;
        }
        return Math.sqrt((this.getFutureX() - this.opponent.getFutureX()) * (this.getFutureX() - this.opponent.getFutureX()) + (this.getFutureZ() - this.opponent.getFutureZ()) * (this.getFutureZ() - this.opponent.getFutureZ())) <= (double)compare && this.opponent.getCurrentAnim() != 23;
    }

    public boolean opponentWillBeInCloseRange() {
        return Math.sqrt((this.getFutureX() - this.opponent.getFutureX()) * (this.getFutureX() - this.opponent.getFutureX()) + (this.getFutureZ() - this.opponent.getFutureZ()) * (this.getFutureZ() - this.opponent.getFutureZ())) <= 450.0;
    }

    public boolean opponentInCloseRange() {
        return Math.sqrt((this.getPositionX() - this.opponent.getPositionX()) * (this.getPositionX() - this.opponent.getPositionX()) + (this.getPositionZ() - this.opponent.getPositionZ()) * (this.getPositionZ() - this.opponent.getPositionZ())) <= 450.0 && this.opponent.getCurrentAnim() != 23 && this.opponent.getCurrentAnim() != 26;
    }

    public boolean shieldAttack(boolean forcedMove, boolean forceAnimEnd) {
        if (forcedMove || (this.canMove() || this.animAbortPossible()) && this.opponentInCloseRange()) {
            if (forcedMove || this.animAbortPossible()) {
                this.handleAnimEndCalled = true;
                if (forcedMove && forceAnimEnd || !forcedMove) {
                    this.handleAnimationEnd();
                }
            }
            if (forcedMove || this.opponentInCloseRange()) {
                this.attackOver = false;
                this.playAnim(16);
                return true;
            }
        }
        return false;
    }

    public void stopBlock(boolean forcedMove) {
        this.holdBlock = false;
    }

    public void holdBlock(boolean forcedMove) {
        this.holdBlock = true;
        this.handleAnimationEnd();
        this.playAnim(34);
    }

    public void block(boolean forcedMove) {
        if (forcedMove || this.current_anim != 14) {
            this.handleAnimationEnd();
            this.playAnim(14);
        }
    }

    public boolean performsSpecial() {
        return !this.opponent.isDead() && (this.current_anim == 30 || this.current_anim == 31 || this.current_anim == 32);
    }

    public boolean performSpecialAttack(boolean forcedMove) {
        if (forcedMove || (this.canMove() || this.animAbortPossible()) && this.rotatedCorrectly() && !this.opponentWillBeInCloseRange()) {
            if (forcedMove || this.animAbortPossible()) {
                this.handleAnimationEnd();
            }
            if (forcedMove || this.opponent.getCurrentAnim() != 22 && this.opponent.getCurrentAnim() != 26 && this.opponent.getCurrentAnim() != 20 && this.opponent.getCurrentAnim() != 21) {
                this.attackOver = false;
                this.specialAttackState = 0;
                this.specialNext = false;
                if (this.mesh_id != 4 && this.mesh_id != 5) {
                    this.figure.moveForward(this.opponent.getPositionX(), this.opponent.getPositionZ());
                }
                this.playAnim(30);
                return true;
            }
        }
        return false;
    }

    public void performHeavyAttack(boolean forcedMove) {
        this.attackOver = false;
        this.playAnim(13);
    }

    public boolean prepareHeavyAttack(boolean forcedMove, boolean forceAnimEnd) {
        if (!this.isBlocking() && (forcedMove || (this.canMove() || this.animAbortPossible()) && this.current_anim != 11 && this.current_anim != 12)) {
            if (forcedMove || this.animAbortPossible()) {
                this.handleAnimEndCalled = true;
                if (forcedMove && forceAnimEnd || !forcedMove) {
                    this.handleAnimationEnd();
                }
            }
            if (this.heavyAttackLoopDealsDamage()) {
                this.attackOver = false;
            }
            this.playAnim(11);
            return true;
        }
        return false;
    }

    public int getAttackIndex(int attack_anim) {
        switch (attack_anim) {
            case 5: {
                return 0;
            }
            case 7: {
                return 1;
            }
            case 9: {
                return 2;
            }
            case 26: {
                return 3;
            }
            case 13: {
                return 4;
            }
            case 16: {
                return 5;
            }
            case 31: {
                return 6;
            }
            case 32: {
                return 7;
            }
            case 12: {
                return 8;
            }
        }
        return 0;
    }

    public boolean isDead() {
        return this.getHitPoints() <= 0;
    }

    public boolean facesOpponent() {
        this.figure.updateTransformation();
        return this.figure.facesOpponent(this.opponent.getPositionX(), this.opponent.getPositionZ());
    }

    public boolean facesOpponentF() {
        this.figure.updateTransformation();
        return this.figure.facesOpponent(this.opponent.getFutureX(), this.opponent.getFutureZ());
    }

    private boolean criticalHit(int attack_anim, int opponent_id) {
        return opponent_id == 6 && attack_anim == 33 || opponent_id != 6 && attack_anim == 9 || attack_anim == 13 || attack_anim == 32;
    }

    public void setIsPlayer(boolean b2) {
        this.isPlayer = b2;
    }

    public void hit(int attack_anim, int opponent_id) {
        if (this.isPlayer && grh.vibration) {
            grh.display.vibrate(100);
        }
        this.highlight_fame = false;
        this.holdBlock = false;
        if (grh.game_mode != 3 || grh.game_mode == 3 && FLBluetooth.isServer()) {
            this.setFame(this.getFame() - 2, false);
        }
        this.beingHit = true;
        this.handleAnimationEnd();
        this.beingHit = false;
        int factor = 10;
        if (this.opponent.getFame() >= 34) {
            int n = factor = this.opponent.getFame() >= 67 ? 20 : 15;
        }
        if (!this.eternal_life) {
            int subtract = 0;
            if (attack_anim == 31 || attack_anim == 32) {
                switch (this.opponent.getSpecialResult()) {
                    case 1: {
                        subtract = 3;
                        break;
                    }
                    case 3: {
                        subtract = 2;
                    }
                }
            }
            this.setDamage((basic_damages[this.getAttackIndex(attack_anim)] + basic_bonuses[this.getAttackIndex(attack_anim)] * this.opponent.getStrength() / 2) * factor / 10 - this.constitution / 2 - subtract);
        }
        if (this.getHitPoints() <= 0) {
            this.current_anim = 17;
        } else {
            boolean bull_stun = false;
            if (opponent_id == 3 && attack_anim == 26 && grh.rnd.nextInt(100) <= 50) {
                bull_stun = true;
            }
            this.setStunned(!(attack_anim != 16 && !bull_stun || this.facesOpponent() && !bull_stun || this.isStunned()));
            if (this.criticalHit(attack_anim, opponent_id)) {
                this.current_anim = 29;
            } else if (this.backHit()) {
                this.current_anim = 19;
            } else {
                this.current_anim = 18;
                this.rotateAsNeeded();
            }
        }
        this.playAnim(this.current_anim);
        if (grh.game_mode == 3 && !FLBluetooth.isServer() && !this.eternal_life) {
            if (grh.volume != 0) {
                this.playSound(0, this.opponent, this);
            }
        }
    }

    public boolean isBlocking() {
        return this.holdBlock;
    }

    public boolean isBeingHit() {
        return this.figure.getCurrentAnimID() == 29 || this.figure.getCurrentAnimID() == 18 || this.figure.getCurrentAnimID() == 19;
    }

    public boolean animStartedOver() {
        return this.figure.animStartOver;
    }

    public void idle() {
        this.handleAnimationEnd();
        this.playAnim(1);
    }

    public void menuMoveIn() {
        this.figure.moveRight(400, 0, true);
        this.playAnim(20);
    }

    public void clearAnimationQueue() {
        this.animQueueID = 0;
    }

    public int getAnimationCount() {
        return this.animQueueID;
    }

    public byte[] getAnimationQueue() {
        return this.animationQueue;
    }

    public void playAnim(int anim_id) {
        if (grh.game_mode == 3 && this.animQueueID < this.animationQueue.length && (this.animQueueID < 2 || this.animQueueID >= 2 && this.animationQueue[this.animQueueID - 2] != (byte)anim_id)) {
            this.animationQueue[this.animQueueID] = (byte)anim_id;
            this.animationQueue[this.animQueueID + 1] = this.handleAnimEndCalled ? (byte)1 : 0;
            this.animQueueID += 2;
        }
        this.handleAnimEndCalled = false;
        this.newAnim = true;
        if (anim_id == 29 || anim_id == 17) {
            this.addBloodDrops = true;
        }
        this.current_anim = anim_id;
        if (!this.isDead() || this.current_anim == 17) {
            this.figure.playAnim(anim_id);
        }
    }

    public void cheer() {
        if (this.canMove() && this.current_anim != 2) {
            this.handleAnimationEnd();
            this.playAnim(2);
            if (!this.highlight_fame) {
                this.last_added_fame = 0;
            }
        }
    }

    public AETransform getTransform() {
        return this.figure.getTransform();
    }

    public void finishOpponent() {
        this.idle();
        this.performAttack(false, false, false);
        this.attackOver = false;
        this.finishing = true;
    }

    public boolean staysAtFarRangeAfterFierce() {
        return this.getID() == 2 || this.getID() == 1 || this.getID() == 4 || this.getID() == 5;
    }

    public boolean isNearDuringFierce() {
        return this.getID() != 1 && this.getID() != 4;
    }

    public boolean nextAttackPossible() {
        return this.figure.nextAttackPossible(3);
    }

    public byte getSpecialResult() {
        return this.specialAttackState;
    }

    public void setSpecialResult(byte specialResult) {
        this.specialAttackState = specialResult;
    }

    public boolean performAttack(boolean fierceAttack, boolean forcedMove, boolean forceAnimEnd) {
        if (this.slowMo && (this.specialAttackState == 0 || this.specialAttackState == 2 && this.special_display_time == 0)) {
            this.attackOver = false;
            if (this.slowMo_time >= this.special_react_start_time && this.slowMo_time - this.special_react_start_time <= special_attack_react_time[this.mesh_id] && !this.fightOver) {
                this.specialAttackState = this.slowMo_time - this.special_react_start_time >= special_attack_react_time[this.mesh_id] * 2 / 3 ? (byte)4 : (this.slowMo_time - this.special_react_start_time >= special_attack_react_time[this.mesh_id] * 1 / 3 ? (byte)3 : (byte)1);
                this.special_display_time = this.slowMo_time - this.special_react_start_time;
                return true;
            }
            if (this.special_display_time == 0) {
                this.specialAttackState = (byte)2;
                this.special_display_time = this.slowMo_time - this.special_react_start_time;
                return false;
            }
        } else if (this.performsSpecial()) {
            return false;
        }
        if (forcedMove || this.animAbortPossible() && this.getCurrentAnim() != 4 && this.getCurrentAnim() != 5 && this.getCurrentAnim() != 7 && this.getCurrentAnim() != 9 && this.getCurrentAnim() != 6 && this.getCurrentAnim() != 8 && this.getCurrentAnim() != 10 && this.getCurrentAnim() != 26) {
            this.handleAnimEndCalled = true;
            if (forcedMove && forceAnimEnd || !forcedMove) {
                this.handleAnimationEnd();
            }
            if (this.current_anim == 10) {
                return false;
            }
        }
        if (forcedMove || this.canMove() || this.figure.nextAttackPossible(3)) {
            if (!fierceAttack) {
                if (this.figure.nextAttackPossible(3) && this.attackOver) {
                    if (this.opponent.getCurrentAnim() == 18 || this.opponent.getCurrentAnim() == 19) {
                        if (this.current_anim == 5) {
                            this.current_anim = 7;
                        } else if (this.current_anim == 7) {
                            this.current_anim = 9;
                        } else if (this.current_anim == 9) {
                            this.current_anim = 33;
                        }
                        this.attackOver = false;
                        this.playAnim(this.current_anim);
                        return true;
                    }
                } else if (this.canMove() || forcedMove) {
                    this.attackOver = false;
                    this.playAnim(4);
                    return true;
                }
            } else if (forcedMove || this.opponent.getCurrentAnim() != 22 && this.opponent.getCurrentAnim() != 26) {
                if (!this.rotatedCorrectly() && !forcedMove) {
                    this.current_anim = 4;
                } else {
                    this.current_anim = 26;
                    if (!this.staysAtFarRangeAfterFierce()) {
                        this.figure.moveForward(this.opponent.getFutureX(), this.opponent.getFutureZ());
                    }
                }
                this.attackOver = false;
                this.playAnim(this.current_anim);
                return true;
            }
        }
        return false;
    }

    public void setCurrentAnim(int anim) {
        this.current_anim = anim;
    }

    public void setPosition(int position) {
        this.position = position;
        if (position == 0) {
            this.figure.setTransformation(-200, 0, 0, 0, 0, 0);
        } else {
            this.figure.setTransformation(200, 0, 0, 0, 2048, 0);
        }
    }

    public boolean lastAnimFrameReached() {
        return this.figure.lastAnimFrameReached();
    }

    private void setNextAnim() {
        if (!this.isDead() && this.hasWon() && this.opponent != null && this.opponent.hasLost() && (this.opponent.getCurrentAnim() == 17 && this.opponent.lastAnimFrameReached() || !this.opponent.isMoving())) {
            this.won = true;
            this.playAnim(3);
            if (!this.eternal_life) {
                if (grh.volume != 0) {
                    this.playSound(3, this, this.opponent);
                }
            }
            if (!this.opponent.isDead()) {
                this.opponent.playAnim(1);
            }
        } else if (!this.isDead()) {
            this.current_anim = this.isStunned() ? 28 : (this.holdBlock ? 34 : 1);
            this.playAnim(this.current_anim);
        }
    }

    public boolean hasRedTrails() {
        return this.getFame() >= 67;
    }

    public boolean hasBlueTrails() {
        return this.getFame() >= 34 && this.getFame() < 67;
    }

    public boolean rotatedCorrectly() {
        return this.rotate_ccw == 0 && this.rotate_cw == 0;
    }

    public void setSlowMo(boolean slowMo) {
        this.slowMo = slowMo;
        if (slowMo) {
            if (!this.eternal_life) {
                if (grh.volume != 0) {
                    this.playSound(4, this, this.opponent);
                }
            }
            this.slowMo_time = 0;
            this.special_react_start_time = grh.rnd.nextInt(1200);
        }
    }

    public int getSpecialDamageTime() {
        if (this.specialAttackState == 1 || this.specialAttackState == 3 || this.specialAttackState == 4) {
            return this.special_display_time;
        }
        return this.special_display_time == 0 ? this.slowMo_time - this.special_react_start_time : this.special_display_time;
    }

    public int getSpecialMaxDamageTime() {
        return special_attack_react_time[this.mesh_id];
    }

    public boolean specialContinuePossible() {
        return this.slowMo && this.slowMo_time >= this.special_react_start_time;
    }

    public int getMaxDamageUpTime() {
        return 3000;
    }

    public int getDamageUpTime() {
        return this.new_fame_level_time;
    }

    public void checkForBorders() {
        this.border_mark = 0;
        if (!this.leftRangeOK()) {
            this.border_mark |= 2;
        }
        if (!this.rightRangeOK()) {
            this.border_mark |= 8;
        }
        if (!this.backwardRangeOK()) {
            this.border_mark |= 4;
        }
        this.border_time = this.BORDER_DISPLAY_TIME;
    }

    private void translateToTargetPos() {
        this.figure.translateToTargetPos();
        this.checkForBorders();
    }

    public void handleAnimationEnd() {
        if (grh.game_mode == 4 && this.current_anim <= 32) {
            boolean setBitMask = true;
            if (this.current_anim == 2 && this.last_added_fame == 0) {
                setBitMask = false;
            }
            if (this.current_anim == 13 && !this.opponentInCloseRange()) {
                setBitMask = false;
            }
            if (this.current_anim == 32 && this.opponent.getCurrentAnim() != 29) {
                setBitMask = false;
            }
            if (setBitMask) {
                this.tutorial_bit_mask = this.current_anim != 2 ? (this.tutorial_bit_mask |= (long)(1 << this.current_anim - 2)) : (this.tutorial_bit_mask |= 2L);
            }
        }
        switch (this.current_anim) {
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 26: 
            case 27: 
            case 32: {
                if (grh.game_mode != 3 && this.beingHit && this.figure.firstThirdOfAnim() && !this.figure.translateWhileTurning) {
                    this.figure.setTargetPos(this.figure.getPositionX(), this.figure.getPositionY(), this.figure.getPositionZ());
                    this.figure.setTargetRotation(0, this.figure.getRotationY(), 0);
                    if (this.current_anim == 20) {
                        this.opponent.undoRotateCCW();
                    }
                    if (this.current_anim == 21) {
                        this.opponent.undoRotateCW();
                    }
                    if (this.current_anim == 27) {
                        this.rotateCW();
                        this.rotateCW();
                    }
                }
                if (this.current_anim != 26 || !this.staysAtFarRangeAfterFierce()) {
                    this.translateToTargetPos();
                }
                this.setNextAnim();
                break;
            }
            case 28: {
                this.current_anim = 28;
                break;
            }
            case 4: {
                this.current_anim = 5;
                break;
            }
            case 24: {
                if (this.rotate_ccw > 0) {
                    this.figure.rotate(0, 1024, 0);
                    --this.rotate_ccw;
                    this.checkForBorders();
                }
                this.setNextAnim();
                break;
            }
            case 25: {
                if (this.rotate_cw > 0) {
                    this.figure.rotate(0, -1024, 0);
                    --this.rotate_cw;
                    this.checkForBorders();
                }
                this.setNextAnim();
                break;
            }
            case 5: {
                this.current_anim = 6;
                break;
            }
            case 7: {
                this.current_anim = 8;
                break;
            }
            case 9: {
                this.current_anim = 10;
                break;
            }
            case 12: {
                this.current_anim = 12;
                break;
            }
            case 11: {
                this.current_anim = 12;
                break;
            }
            case 30: {
                this.setSlowMo(true);
                break;
            }
            case 31: {
                if (this.specialAttackState == 2 || this.opponent.isDead()) {
                    this.translateToTargetPos();
                    this.setNextAnim();
                    break;
                }
                this.specialAttackState = 0;
                this.attackOver = false;
                this.setSlowMo(true);
                break;
            }
            case 2: {
                if (grh.game_mode != 3 || grh.game_mode == 3 && FLBluetooth.isServer()) {
                    if (this.last_added_fame > 0 && !this.eternal_life) {
                        if (grh.volume != 0) {
                            this.playSound(3, this, this.opponent);
                        }
                    }
                    this.setFame(this.getFame() + 2 * this.last_added_fame, true);
                }
                this.setNextAnim();
                break;
            }
            case 3: {
                this.fightOver = true;
                break;
            }
            case 17: {
                if (!this.fightOver && this.opponent.getWins() >= 2) {
                    this.addBloodPuddle = true;
                    this.fightOver = true;
                }
                return;
            }
            case 29: {
                this.setNextAnim();
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 33: 
            case 34: 
            case 36: {
                this.setNextAnim();
            }
        }
        if (this.finishing) {
            if (this.current_anim != 9) {
                this.playAnim(this.current_anim);
            }
        } else if (!(this.isDead() || this.won || this.slowMo)) {
            this.playAnim(this.current_anim);
        }
    }

    public void handleSlowMoOver() {
        this.setSlowMo(false);
        this.opponent.setSlowMo(false);
        this.special_display_time = 0;
        if (this.current_anim == 30) {
            if (grh.game_mode != 3 || grh.game_mode == 3 && FLBluetooth.isServer()) {
                this.playAnim(31);
            }
            if (this.specialAttackState == 2) {
                if (this.mesh_id == 5) {
                    this.figure.moveForward(this.opponent.getPositionX(), this.opponent.getPositionZ());
                }
                if (this.mesh_id != 4) {
                    this.opponent.rotateAsNeeded();
                    if (grh.game_mode != 3 || grh.game_mode == 3 && FLBluetooth.isServer()) {
                        this.opponent.block(true);
                    }
                } else if (grh.game_mode != 3 || grh.game_mode == 3 && FLBluetooth.isServer()) {
                    this.playAnim(1);
                }
                return;
            }
            this.specialNext = true;
        } else if (this.current_anim == 31) {
            if (grh.game_mode != 3 || grh.game_mode == 3 && FLBluetooth.isServer()) {
                this.playAnim(32);
            }
            if (this.specialAttackState == 2) {
                this.opponent.rotateAsNeeded();
                if (grh.game_mode != 3 || grh.game_mode == 3 && FLBluetooth.isServer()) {
                    this.opponent.block(true);
                }
                if (this.mesh_id == 4 || this.mesh_id == 5) {
                    this.figure.moveForward(this.opponent.getPositionX(), this.opponent.getPositionZ());
                }
            } else {
                this.specialNext = true;
            }
        }
    }

    public void setWaitForSpecialResult(boolean b2) {
        this.waitForSpecialResult = b2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void update(long elapsed_time) {
        if (this.figure == null) {
            return;
        }
        if (this.hit_display_time > 0) {
            this.hit_display_time = (int)((long)this.hit_display_time - elapsed_time);
            if (this.hit_display_time <= 0) {
                this.oldHitpoints = this.hitpoints;
            }
        }
        if (this.border_time > 0) {
            this.border_time = (int)((long)this.border_time - elapsed_time);
        }
        if (grh.game_mode == 3 && !FLBluetooth.isServer() && this.slowMo) {
            this.slowMo_time = (int)((long)this.slowMo_time + elapsed_time);
            if (this.slowMo_time - this.special_react_start_time > special_attack_react_time[this.mesh_id] && this.getSpecialResult() == 0) {
                this.specialAttackState = (byte)2;
            }
        }
        if ((grh.game_mode != 3 || grh.game_mode == 3 && FLBluetooth.isServer()) && this.slowMo) {
            if (this.opponent.isDead()) {
                this.setSlowMo(false);
                this.opponent.setSlowMo(false);
                this.playAnim(1);
                return;
            }
            this.slowMo_time = (int)((long)this.slowMo_time + elapsed_time);
            if (this.waitForSpecialResult) {
                if (this.slowMo_time < 2200 && !this.fightOver || this.specialAttackState == 0) return;
                this.handleSlowMoOver();
            } else {
                if (this.slowMo_time - this.special_react_start_time > special_attack_react_time[this.mesh_id] && this.getSpecialResult() == 0) {
                    this.specialAttackState = (byte)2;
                }
                if (this.slowMo_time < 2200 && !this.fightOver) return;
                this.handleSlowMoOver();
            }
        }
        if (this.slowMo || this.opponent != null && this.opponent.slowMo) {
            return;
        }
        if (this.opponent != null) {
            this.figure.update(elapsed_time, this.opponent.figure.getCurrentAnimID(), this.opponent.figure.getCurrentAnimFrame());
        } else {
            this.figure.update(elapsed_time, 1, 0);
        }
        this.new_fame_level_time = (int)((long)this.new_fame_level_time - elapsed_time);
        if (this.new_fame_level_time <= 0) {
            this.new_fame_level = false;
        }
        if (this.stunned) {
            this.stunned_time = (int)((long)this.stunned_time - elapsed_time);
            if (this.stunned_time < 0) {
                this.setStunned(false);
                this.idle();
            }
        }
        if (!this.figure.isMoving()) {
            this.handleAnimationEnd();
        } else if (!this.isDead()) {
            switch (this.current_anim) {
                case 5: 
                case 7: 
                case 9: 
                case 12: 
                case 13: 
                case 16: 
                case 26: 
                case 31: 
                case 32: 
                case 33: {
                    if (this.current_anim == 12 && this.heavyAttackLoopDealsDamage() && this.opponent.getCurrentAnim() != 18 && this.opponent.getCurrentAnim() != 19) {
                        this.attackOver = false;
                    }
                    if (grh.game_mode == 3 && !this.eternal_life && (grh.game_mode != 3 || !FLBluetooth.isServer()) || !this.hitFrameReached() || this.attackOver || this.current_anim == 13 && this.heavyAttackLoopDealsDamage()) break;
                    this.attackOver = true;
                    if ((this.opponent.getCurrentAnim() != 14 && this.opponent.getCurrentAnim() != 34 || (this.opponent.getCurrentAnim() == 14 || this.opponent.getCurrentAnim() == 34) && !this.opponent.facesOpponent() || this.current_anim == 13 && !this.heavyAttackLoopDealsDamage()) && (this.rotate_ccw == 0 && this.rotate_cw == 0 || this.current_anim == 12 && this.heavyAttackLoopDealsDamage())) {
                        if ((this.opponentInCloseRange() || this.current_anim == 26 && this.fierceAttackWillHit() || this.opponent.getCurrentAnim() == 22 && this.opponent.animAbortPossible() || this.current_anim == 31 || this.current_anim == 32) && (this.current_anim == 12 && this.heavyAttackLoopDealsDamage() || this.opponent.getCurrentAnim() != 23 && this.opponent.getCurrentAnim() != 20 && this.opponent.getCurrentAnim() != 21 && this.opponent.getCurrentAnim() != 27 && this.opponent.getCurrentAnim() != 17)) {
                            if (this.fightOver && !this.finishing) break;
                            if (this.finishing) {
                                this.finishing = false;
                            }
                            this.opponent.hit(this.current_anim, this.mesh_id);
                            if (!this.eternal_life) {
                                if (grh.volume != 0) {
                                    this.playSound(0, this, this.opponent);
                                }
                            }
                            int bonus = basic_damages[this.getAttackIndex(this.current_anim)] + basic_damages[this.getAttackIndex(this.current_anim)] * this.charisma / 4;
                            if (this.current_anim == 5 || this.current_anim == 7) {
                                bonus = bonus * 2 / 3;
                            }
                            this.setFame(this.getFame() + bonus, false);
                            if (!this.opponent.isDead() || this.current_anim != 12) break;
                            this.playAnim(13);
                            break;
                        }
                        if (this.eternal_life) break;
                        if (grh.volume == 0) break;
                        this.playSound(1, this, this.opponent);
                        break;
                    }
                    if ((this.opponent.getCurrentAnim() == 14 || this.opponent.getCurrentAnim() == 34) && this.facesOpponent() && (this.opponentInCloseRange() || this.performsSpecial() || this.current_anim == 26 && this.fierceAttackWillHit())) {
                        if (this.staysAtFarRangeAfterFierce() && this.isNearDuringFierce() && this.getCurrentAnim() == 26) {
                            this.figure.moveForward(this.opponent.getPositionX(), this.opponent.getPositionZ());
                            this.translateToTargetPos();
                        }
                        this.handleAnimationEnd();
                        this.opponent.block(true);
                        if (this.isNearDuringFierce() || this.opponentInCloseRange() || this.mesh_id == 4) {
                            this.playAnim(15);
                        }
                        if (this.eternal_life) break;
                        if (grh.volume == 0) break;
                        this.playSound(2, this, this.opponent);
                        break;
                    }
                    if (this.eternal_life) break;
                    if (grh.volume == 0) break;
                    this.playSound(1, this, this.opponent);
                }
            }
        }
        if ((grh.game_mode != 3 || this.eternal_life || grh.game_mode == 3 && FLBluetooth.isServer()) && this.canMove() && this.current_anim != 24 && this.current_anim != 25) {
            if (this.rotate_ccw > 0) {
                this.playAnim(24);
            } else if (this.rotate_cw > 0) {
                this.playAnim(25);
            }
        }
        this.fame_down_time = (int)((long)this.fame_down_time + elapsed_time);
        if (this.fame_down_time <= 2500 || this.hasWon() || this.hasLost() || grh.game_mode == 3 && (grh.game_mode != 3 || !FLBluetooth.isServer())) return;
        this.setFame(this.getFame() - 1, false);
    }

    public void correctOrientation() {
        if (!this.eternal_life && this.opponent != null && !this.facesOpponentF() && this.rotate_ccw == 0 && this.rotate_cw == 0 && this.canMove() && this.current_anim != 25 && this.current_anim != 24 && this.opponent.getCurrentAnim() != 20 && this.opponent.getCurrentAnim() != 21) {
            int opponent_ry = this.opponent.getRotationY() % 4096;
            int ry = this.getRotationY() % 4096;
            if (ry < 0) {
                ry += 4096;
            }
            if (opponent_ry < 0) {
                opponent_ry += 4096;
            }
            if (AEMath.abs(ry - opponent_ry) != 2048) {
                if (AEMath.abs(ry - opponent_ry) == 0) {
                    this.rotateCCW();
                    this.rotateCCW();
                } else if ((ry + 1024) % 4096 == opponent_ry) {
                    this.rotateCW();
                } else if (((ry += 4096) - 1024) % 4096 == opponent_ry) {
                    this.rotateCCW();
                }
            } else if (!this.facesOpponent()) {
                this.rotateCW();
                this.opponent.rotateCCW();
            }
        }
    }

    public void playSound(int sound, Fighter f, Fighter o) {
        block0 : switch (sound) {
            case 4: {
                grh.sound.playSound(4);
                break;
            }
            case 3: {
                if (grh.game_mode == 4) break;
                grh.sound.playSound(14);
                break;
            }
            case 1: {
                grh.sound.playSound(12 + grh.rnd.nextInt(2));
                break;
            }
            case 2: {
                switch (o.getID()) {
                    case 2: 
                    case 7: {
                        grh.sound.playSound(8 + grh.rnd.nextInt(2));
                        break block0;
                    }
                }
                int rnd = grh.rnd.nextInt(4);
                if (rnd == 0) {
                    grh.sound.playSound(5 + grh.rnd.nextInt(3));
                    break;
                }
                grh.sound.playSound(0);
                break;
            }
            case 0: {
                int punch_count = 2;
                if (o.getID() == 1) {
                    punch_count = 1;
                }
                if (o.getCurrentAnim() == 29 && grh.game_mode != 4) {
                    grh.sound.playSound(15);
                    break;
                }
                if (this.current_anim == 16) {
                    grh.sound.playSound(10 + grh.rnd.nextInt(punch_count));
                    break;
                }
                if (o.getID() == 3) {
                    if (f.getID() == 0) {
                        grh.sound.playSound(10 + grh.rnd.nextInt(punch_count));
                        break;
                    }
                    grh.sound.playSound(1 + grh.rnd.nextInt(2));
                    break;
                }
                if (o.getID() == 0) {
                    if (grh.rnd.nextInt(4) == 0) {
                        grh.sound.playSound(10 + grh.rnd.nextInt(punch_count));
                        break;
                    }
                    grh.sound.playSound(1 + grh.rnd.nextInt(2));
                    break;
                }
                switch (f.getID()) {
                    case 0: {
                        if (grh.rnd.nextInt(2) == 0) {
                            grh.sound.playSound(10 + grh.rnd.nextInt(punch_count));
                            break block0;
                        }
                        grh.sound.playSound(8 + grh.rnd.nextInt(2));
                        break block0;
                    }
                    case 3: {
                        if (this.getCurrentAnim() == 26 || this.getCurrentAnim() == 16) {
                            grh.sound.playSound(10 + grh.rnd.nextInt(punch_count));
                            break block0;
                        }
                        grh.sound.playSound(5 + grh.rnd.nextInt(3));
                        break block0;
                    }
                    case 5: {
                        if (grh.rnd.nextInt(2) == 0) {
                            grh.sound.playSound(10 + grh.rnd.nextInt(punch_count));
                            break block0;
                        }
                        grh.sound.playSound(8 + grh.rnd.nextInt(2));
                        break block0;
                    }
                    case 2: {
                        grh.sound.playSound(1 + grh.rnd.nextInt(2));
                        break block0;
                    }
                    case 1: {
                        if (this.current_anim == 26) {
                            grh.sound.playSound(12 + grh.rnd.nextInt(2));
                            break block0;
                        }
                        if (grh.rnd.nextInt(5) == 0) {
                            grh.sound.playSound(1 + grh.rnd.nextInt(2));
                            break block0;
                        }
                        grh.sound.playSound(5 + grh.rnd.nextInt(3));
                        break block0;
                    }
                }
                if (grh.rnd.nextInt(5) == 0) {
                    grh.sound.playSound(1 + grh.rnd.nextInt(2));
                    break;
                }
                grh.sound.playSound(5 + grh.rnd.nextInt(3));
            }
        }
    }

    public void setContinueDecisionPose() {
        this.figure.setContinueDecisionPose();
    }

    public void setExecutionPose() {
        this.figure.setExecutionPose();
    }

    public void getUp() {
        this.playAnim(36);
    }

    public int getPuddleX() {
        return this.figure.getPuddleX();
    }

    public int getPuddleZ() {
        return this.figure.getPuddleZ();
    }

    public int getBorderMark() {
        return this.border_mark;
    }

    public boolean displayBorders() {
        return this.border_time > 0;
    }

    public boolean fameMultiplierChanged() {
        return this.new_fame_level;
    }

    public boolean fameWentUp() {
        return this.highlight_fame;
    }

    public boolean isMoving() {
        return this.figure.isMoving() && this.current_anim != 1;
    }

    public void setAnimStartedOver(boolean b2) {
        this.figure.animStartOver = false;
    }

    private boolean hitFrameReached() {
        return this.figure.hitFrameReached() || this.current_anim == 12 && this.heavyAttackLoopDealsDamage();
    }

    public boolean blockFrameReached() {
        return this.figure.blockFrameReached();
    }

    public boolean moveRightPossible() {
        return !this.opponent.isAttacking() || this.opponent.figure.getCurrentAnimID() != 26 && this.opponent.figure.getCurrentAnimFrame() <= 0 || this.opponent.figure.getCurrentAnimID() == 26 && this.opponent.figure.getCurrentAnimFrame() <= 9 || this.opponent.getCurrentAnim() == 4;
    }

    public boolean moveLeftPossible() {
        return !this.opponent.isAttacking() || this.opponent.figure.getCurrentAnimID() != 26 && this.opponent.figure.getCurrentAnimFrame() <= 0 || this.opponent.figure.getCurrentAnimID() == 26 && this.opponent.figure.getCurrentAnimFrame() <= 9 || this.opponent.getCurrentAnim() == 4;
    }

    public boolean moveBackwardsPossible() {
        return this.opponentInCloseRange() && this.current_anim != 23 && (!this.opponent.isAttacking() || !this.opponent.rotatedCorrectly() || this.opponent.getCurrentAnim() == 20 || this.opponent.getCurrentAnim() == 21 || this.opponent.figure.getCurrentAnimFrame() <= 3 && this.opponent.getCurrentAnim() != 5);
    }

    public boolean blockPossible() {
        return !(!this.opponentInCloseRange() && this.opponent.getCurrentAnim() != 26 || !this.facesOpponent() || !this.canMove() && !this.animAbortPossible() || this.current_anim == 23 || !this.opponent.isAttacking() || this.current_anim == 18 || this.current_anim == 19 || this.current_anim == 24 || this.current_anim == 25 || this.current_anim == 20 || this.current_anim == 21 || this.opponent.figure.getHitFrame() - this.opponent.figure.getCurrentAnimFrame() < 5 && this.opponent.getCurrentAnim() != 4);
    }

    public boolean isAttacking() {
        return this.getCurrentAnim() == 4 || this.getCurrentAnim() == 5 || this.getCurrentAnim() == 7 || this.getCurrentAnim() == 9 || this.getCurrentAnim() == 26 || this.getCurrentAnim() == 13;
    }

    public void render() {
        this.figure.render();
    }

    public void renderBlueTrails() {
        this.figure.renderTrails(0);
    }

    public void renderRedTrails() {
        this.figure.renderTrails(1);
    }

    public void release() {
        this.figure.release();
        this.opponent = null;
        this.name = null;
        this.damages = null;
        this.animationQueue = null;
    }

    public long getTutorialBitMask() {
        return this.tutorial_bit_mask;
    }

    public void setTutorialBitMask(long mask) {
        this.tutorial_bit_mask = mask;
    }
}

