/*
 * Decompiled with CFR 0.152.
 */
package GameEssentials;

import FLToolkit.grh;
import GameEssentials.Fighter;

public class FighterAI {
    private static final int MODE_RANDOM = 0;
    private static final int MODE_AGILE = 2;
    private static final int MODE_LOW_LIFE = 4;
    private static final int MODE_SLOW = 5;
    public static final int STAGE_1 = 0;
    public static final int STAGE_2 = 1;
    public static final int STAGE_3 = 2;
    public static final int STAGE_4 = 3;
    public static final int STAGE_5 = 4;
    private static final int INTELLIGENCE_LOW = 0;
    private static final int INTELLIGENCE_MEDIUM = 1;
    private static final int INTELLIGENCE_HIGH = 2;
    private int DODGE_CHANCE = 30;
    private int DODGE_CHANCE_DIFF_ALTER = 15;
    private int DODGE_CHANCE_STAGE_ALTER = 5;
    private int DODGE_MOVE_BACK = 15;
    private int DODGE_MOVE_LEFT_RIGHT = 25;
    private int DODGE_BLOCK = 100;
    private int PARRY_CHANCE = 35;
    private int PARRY_CHANCE_DIFF_ALTER = 15;
    private int COMBO_CHANCE = 20;
    private int COMBO_CHANCE_DIFF_ALTER = 15;
    private int COMBO_CHANCE_TIGER_ADD = 5;
    private int SPECIAL_SUCCESS_PROBABILITY = 60;
    private int ACTION_PROBABILITY = 15;
    private int ACTION_PROBABILITY_DIFF_ALTER = 10;
    private int ACTION_PROBABILITY_STAGE_ALTER = 3;
    private int ACTION_PROBABILITY_LOW_HEALTH_THRESHOLD = 20;
    private int ACTION_PROBABILITY_LOW_HEALTH_BONUS_LOW = 15;
    private int ACTION_PROBABILITY_LOW_HEALTH_BONUS_MEDIUM = 10;
    private int ACTION_PROBABILITY_LOW_HEALTH_BONUS_HIGH = 7;
    private int TURN_LEFT_RIGHT_CHANCE = 10;
    private int STUN_CHANCE = 20;
    private int HEAVY_ATTACK_CHANCE = 30;
    private int STEP_BACK_CHANCE = 55;
    private int ATTACK_CHANCE = 100;
    private int SPECIAL_ATTACK_CHANCE = 5;
    private int TURN_LEFT_RIGHT_CHANCE_FAR = 20;
    private int STEP_FORWARD_CHANCE = 65;
    private int RANGE_ATTACK_CHANCE = 100;
    private int AGILE_MOVE_THEN_ATTACK = 10;
    private int AGILE_RANDOM_ACTION = 100;
    private int SLOW_LEFT_RIGHT_CHANCE = 5;
    private int SLOW_STEP_BACK_CHANCE = 17;
    private int SLOW_BLOCK_CHANCE = 35;
    private int SLOW_SHIELD_ATTACK_CHANCE = 40;
    private int SLOW_ATTACK_CHANCE = 85;
    private int SLOW_HEAVY_ATTACK_CHANCE = 100;
    private int SLOW_FAR_LEFT_RIGHT_CHANCE = 10;
    private int SLOW_FAR_MOVE_FORWARD_CHANCE = 25;
    private int SLOW_FAR_ATTACK_CHANCE = 65;
    private int SLOW_FAR_SPECIAL_ATTACK_CHANCE = 85;
    private int SLOW_FAR_HEAVY_ATTACK_CHANCE = 100;
    private static final int HAGEN_MACE_HEAVY_ATTACK_EASY_SUB = 10;
    private int LOW_LIFE_MOVE_BACK_CHANCE = 20;
    private int LOW_LIFE_BLOCK_CHANCE = 45;
    private int LOW_LIFE_ATTACK_CHANCE = 75;
    private int LOW_LIFE_MOVE_LEFT_RIGHT_CHANCE = 100;
    private int LOW_LIFE_FAR_ATTACK = 30;
    private int LOW_LIFE_FAR_SPECIAL_ATTACK = 60;
    private int LOW_LIFE_FAR_MOVE_FORWARD = 80;
    private int LOW_LIFE_FAR_MOVE_LEFT_RIGHT_CHANCE = 100;
    private int HEAVY_ATTACK_BACKWARD_LOW = 8;
    private int HEAVY_ATTACK_BACKWARD_MEDIUM = 30;
    private int HEAVY_ATTACK_BACKWARD_HIGH = 60;
    private Fighter fighter;
    private Fighter opponent;
    private int heavy_attack_time;
    private int opponent_block_time;
    private static final int OPPONENT_BLOCK_ACTION_TIME = 800;
    private static final int SPECIAL_DELAY = 1000;
    private int difficulty;
    private int stage;
    private int mode;
    private boolean attack;
    private boolean specialOutcomeDetermined;
    private boolean specialWillHit;
    private boolean block;
    private boolean performSpecials;
    private boolean moveBackward;
    private int action_probability_bonus;
    private int special_wait_time;
    private boolean dynamic_dodge_alter;
    private int dodge_chance;
    private int parry_chance;
    private long last_action_time;
    private int dodge_sub_time;
    private int last_action;
    private static final int DODGE_SUBTRACT_TIME = 400;
    private static final int DODGE_TIME_SUB = 4;
    private static final int PARRY_TIME_SUB = 4;
    private static final int DODGE_ACTION_SUB = 20;
    private static int DODGE_ADD = 3;
    private static int PARRY_ADD = 3;
    private int test_time;

    public FighterAI(int difficulty, int stage) {
        this.difficulty = difficulty;
        this.stage = stage;
        ++this.stage;
        switch (difficulty) {
            case 0: {
                this.DODGE_CHANCE -= this.DODGE_CHANCE_DIFF_ALTER;
                this.ACTION_PROBABILITY -= this.ACTION_PROBABILITY_DIFF_ALTER;
                this.PARRY_CHANCE -= this.PARRY_CHANCE_DIFF_ALTER;
                this.COMBO_CHANCE -= this.COMBO_CHANCE_DIFF_ALTER;
                this.dynamic_dodge_alter = stage > 2;
                break;
            }
            case 2: {
                this.DODGE_CHANCE += this.DODGE_CHANCE_DIFF_ALTER;
                this.ACTION_PROBABILITY += this.ACTION_PROBABILITY_DIFF_ALTER;
                this.PARRY_CHANCE += this.PARRY_CHANCE_DIFF_ALTER;
                this.COMBO_CHANCE += this.COMBO_CHANCE_DIFF_ALTER;
                this.dynamic_dodge_alter = true;
                break;
            }
            case 1: {
                this.dynamic_dodge_alter = true;
            }
        }
        DODGE_ADD = stage <= 3 ? 2 : 3;
        PARRY_ADD = stage <= 3 ? 2 : 3;
        for (int i = 0; i < stage; ++i) {
            this.DODGE_CHANCE += this.DODGE_CHANCE_STAGE_ALTER;
            this.ACTION_PROBABILITY += this.ACTION_PROBABILITY_STAGE_ALTER;
        }
        this.dodge_chance = this.DODGE_CHANCE;
        this.parry_chance = this.PARRY_CHANCE;
        this.mode = 0;
        this.performSpecials = true;
        this.action_probability_bonus = 0;
    }

    public void disableSpecials() {
        this.performSpecials = false;
        this.SPECIAL_ATTACK_CHANCE = -1;
    }

    public void setFighters(Fighter ai_fighter, Fighter opponent) {
        this.fighter = ai_fighter;
        this.opponent = opponent;
        this.mode = 0;
        if (this.getIntelligence() != 0) {
            if (this.fighter.getAgility() <= 1) {
                this.mode = 5;
                if (this.difficulty == 0 && ai_fighter.heavyAttackLoopDealsDamage()) {
                    this.SLOW_HEAVY_ATTACK_CHANCE -= 10;
                    this.SLOW_FAR_HEAVY_ATTACK_CHANCE -= 10;
                }
            } else {
                this.mode = this.fighter.getAgility() > opponent.getAgility() ? 2 : 0;
            }
        } else if (this.fighter.getAgility() <= 1) {
            if (this.stage > 3) {
                this.ACTION_PROBABILITY -= (this.stage - 3) * this.ACTION_PROBABILITY_STAGE_ALTER;
            }
            this.mode = 5;
            if (this.difficulty == 0 && ai_fighter.heavyAttackLoopDealsDamage()) {
                this.SLOW_HEAVY_ATTACK_CHANCE -= 10;
                this.SLOW_FAR_HEAVY_ATTACK_CHANCE -= 10;
            }
        }
        if (ai_fighter.getID() == 6) {
            this.COMBO_CHANCE += this.COMBO_CHANCE_TIGER_ADD;
        }
        if (this.difficulty == 0) {
            switch (opponent.getID()) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    this.dynamic_dodge_alter = false;
                }
            }
        }
        switch (ai_fighter.getID()) {
            case 7: 
            case 8: {
                DODGE_ADD = 6;
                PARRY_ADD = 6;
            }
        }
    }

    private void moveLeftOrRight() {
        if (grh.rnd.nextInt(2) == 0) {
            if (this.fighter.rightRangeOK() && this.fighter.moveRightPossible()) {
                this.fighter.moveRight(false);
            } else if (this.fighter.leftRangeOK() && this.fighter.moveLeftPossible()) {
                this.fighter.moveLeft(false);
            }
        } else if (this.fighter.leftRangeOK() && this.fighter.moveLeftPossible()) {
            this.fighter.moveLeft(false);
        } else if (this.fighter.rightRangeOK() && this.fighter.moveRightPossible()) {
            this.fighter.moveRight(false);
        }
    }

    private void performRandomMove() {
        int rnd = grh.rnd.nextInt(100);
        if (this.fighter.opponentWillBeInCloseRange()) {
            if (rnd <= this.TURN_LEFT_RIGHT_CHANCE) {
                this.moveLeftOrRight();
            } else if (rnd <= this.STUN_CHANCE && this.fighter.facesOpponent()) {
                this.fighter.shieldAttack(false, false);
            } else if (rnd <= this.HEAVY_ATTACK_CHANCE && this.fighter.facesOpponent()) {
                this.heavy_attack_time = 0;
                this.fighter.prepareHeavyAttack(false, false);
            } else if (rnd <= this.STEP_BACK_CHANCE) {
                if (this.fighter.moveBackwardsPossible() && this.fighter.backwardRangeOK()) {
                    this.fighter.moveBackward(false);
                }
            } else if (this.fighter.facesOpponent()) {
                this.fighter.performAttack(false, false, false);
            }
        } else if (rnd <= this.SPECIAL_ATTACK_CHANCE && this.special_wait_time > 1000) {
            this.performSpecial();
        } else if (rnd <= this.TURN_LEFT_RIGHT_CHANCE_FAR) {
            this.moveLeftOrRight();
        } else if (rnd <= this.STEP_FORWARD_CHANCE) {
            this.fighter.moveForward(false);
        } else if (this.special_wait_time > 1000) {
            this.fighter.performAttack(true, false, false);
        }
    }

    private int getIntelligence() {
        if (this.difficulty == 0 && this.stage <= 3 || this.difficulty == 1 && this.stage <= 1) {
            return 0;
        }
        if (this.difficulty == 0 && this.stage == 4 || this.difficulty == 1 && this.stage > 1 || this.difficulty == 2 && this.stage <= 0) {
            return 1;
        }
        return 2;
    }

    private void performSpecial() {
        if (this.performSpecials && !this.fighter.opponentInCloseRange() && !this.fighter.opponentWillBeInCloseRange() && this.opponent.getCurrentAnim() != 23) {
            this.fighter.performSpecialAttack(false);
            this.specialOutcomeDetermined = false;
            this.specialWillHit = false;
        }
    }

    private void moveEventuallyIfNotRotatedCorrectly() {
        switch (grh.rnd.nextInt(10)) {
            case 0: 
            case 1: {
                if (this.fighter.opponentWillBeInCloseRange() && this.fighter.moveBackwardsPossible() && this.fighter.backwardRangeOK()) {
                    this.fighter.moveBackward(false);
                } else {
                    this.fighter.moveForward(false);
                }
                return;
            }
            case 2: {
                this.moveLeftOrRight();
                return;
            }
        }
    }

    public int updateTutorialShowMove(int lesson_id, int step, long elapsed_time) {
        switch (lesson_id) {
            case 1: {
                switch (step) {
                    case 0: {
                        if (!this.fighter.canMove()) break;
                        this.fighter.moveLeft(true);
                        return step + 1;
                    }
                    case 1: {
                        if (!this.fighter.canMove()) break;
                        this.fighter.moveRight(true);
                        return step + 1;
                    }
                    case 2: {
                        if (!this.fighter.canMove()) break;
                        this.fighter.moveBackward(true);
                        return step + 1;
                    }
                    case 3: {
                        if (!this.fighter.canMove()) break;
                        this.fighter.moveForward(true);
                        return step + 1;
                    }
                    case 4: {
                        if (!this.fighter.canMove()) break;
                        return -1;
                    }
                }
                break;
            }
            case 2: {
                if (step == 0) {
                    this.fighter.performAttack(false, false, false);
                    return step + 1;
                }
                if (step != 1 || !this.fighter.canMove()) break;
                return -1;
            }
            case 3: {
                if (step == 0) {
                    this.fighter.performAttack(false, false, false);
                    return step + 1;
                }
                if (step < 3 && (this.fighter.getCurrentAnim() == 5 || this.fighter.getCurrentAnim() == 7 || this.fighter.getCurrentAnim() == 33) && this.opponent.getCurrentAnim() == 18 && this.fighter.nextAttackPossible()) {
                    this.fighter.performAttack(false, false, false);
                    return step + 1;
                }
                if (step != 3 || !this.fighter.canMove()) break;
                return -1;
            }
            case 4: 
            case 9: {
                if (step == 0) {
                    this.fighter.prepareHeavyAttack(true, false);
                    this.heavy_attack_time = 0;
                    return step + 1;
                }
                if (step == 1 && this.heavy_attack_time >= 0) {
                    this.heavy_attack_time = (int)((long)this.heavy_attack_time + elapsed_time);
                    if (this.heavy_attack_time > this.fighter.getHeavyAttackLoopTime()) {
                        this.fighter.performHeavyAttack(false);
                        this.heavy_attack_time = -1;
                        return step + 1;
                    }
                }
                if (lesson_id == 9) {
                    if (step == 2 && this.fighter.canMove()) {
                        this.fighter.cheer();
                        return step + 1;
                    }
                    if (step != 3 || !this.fighter.canMove()) break;
                    return -1;
                }
                if (step != 2 || !this.fighter.canMove()) break;
                return -1;
            }
            case 5: {
                if (step == 0) {
                    if (this.fighter.backwardRangeOK()) {
                        this.fighter.moveBackward(true);
                    }
                    return step + 1;
                }
                if (step == 1 && this.fighter.canMove()) {
                    this.fighter.performAttack(true, false, false);
                    return step + 1;
                }
                if (step == 2 && this.fighter.canMove()) {
                    this.fighter.moveForward(true);
                    return step + 1;
                }
                if (step != 3 || !this.fighter.canMove()) break;
                return -1;
            }
            case 6: {
                if (step == 0) {
                    if (this.fighter.backwardRangeOK()) {
                        this.fighter.moveBackward(true);
                    }
                    return step + 1;
                }
                if (step == 1 && this.fighter.canMove()) {
                    this.fighter.performSpecialAttack(true);
                    return step + 1;
                }
                if (step == 2) {
                    if (this.fighter.performsSpecial()) {
                        if (this.fighter.isInSlowMoMode() && !this.specialOutcomeDetermined && this.fighter.specialContinuePossible()) {
                            this.fighter.performAttack(false, false, false);
                            this.fighter.setSpecialResult((byte)4);
                        }
                    } else if (this.fighter.canMove()) {
                        this.fighter.moveForward(true);
                        return step + 1;
                    }
                }
                if (step != 3 || !this.fighter.canMove()) break;
                return -1;
            }
            case 7: {
                if (step == 0) {
                    this.fighter.holdBlock(true);
                    return step + 1;
                }
                if (step == 1 && this.opponent.getCurrentAnim() == 15) {
                    this.fighter.stopBlock(true);
                    this.fighter.idle();
                    return step + 1;
                }
                if (step != 2 || !this.fighter.canMove()) break;
                return -1;
            }
            case 8: {
                if (step == 0) {
                    this.fighter.moveRight(true);
                    this.heavy_attack_time = 0;
                    return step + 1;
                }
                if (step == 1) {
                    this.heavy_attack_time = (int)((long)this.heavy_attack_time + elapsed_time);
                    if (this.heavy_attack_time > 500 && this.opponent.canMove()) {
                        this.opponent.performAttack(true, false, false);
                    }
                    if (this.fighter.canMove()) {
                        this.fighter.shieldAttack(true, false);
                        return step + 1;
                    }
                }
                if (step != 2 || !this.fighter.canMove() || !this.opponent.canMove()) break;
                return -1;
            }
        }
        return step;
    }

    public void update(long elapsed_time) {
        this.test_time = (int)((long)this.test_time + elapsed_time);
        this.special_wait_time = this.fighter.opponentInCloseRange() ? 0 : (int)((long)this.special_wait_time + elapsed_time);
        this.dodge_sub_time = (int)((long)this.dodge_sub_time + elapsed_time);
        if (this.dodge_sub_time > 400) {
            this.dodge_sub_time = 0;
            this.dodge_chance -= 4;
            if (this.dodge_chance < this.DODGE_CHANCE) {
                this.dodge_chance = this.DODGE_CHANCE;
            }
            this.parry_chance -= 4;
            if (this.parry_chance < this.PARRY_CHANCE) {
                this.parry_chance = this.PARRY_CHANCE;
            }
        }
        if (this.fighter.fightOver() || this.opponent.fightOver()) {
            if (this.fighter.getCurrentAnim() == 12 || this.fighter.getCurrentAnim() == 11 && this.fighter.heavyAttackLoopDealsDamage() || this.fighter.getCurrentAnim() == 34) {
                this.fighter.idle();
            }
            return;
        }
        if (this.fighter.getHitPoints() < this.ACTION_PROBABILITY_LOW_HEALTH_THRESHOLD && this.action_probability_bonus == 0) {
            switch (this.getIntelligence()) {
                case 0: {
                    this.action_probability_bonus = this.ACTION_PROBABILITY_LOW_HEALTH_BONUS_LOW;
                    break;
                }
                case 1: {
                    this.mode = 4;
                    this.action_probability_bonus = this.ACTION_PROBABILITY_LOW_HEALTH_BONUS_MEDIUM;
                    break;
                }
                case 2: {
                    this.mode = 4;
                    this.action_probability_bonus = this.ACTION_PROBABILITY_LOW_HEALTH_BONUS_HIGH;
                }
            }
        }
        if (this.opponent.performsSpecial()) {
            return;
        }
        if (this.fighter.performsSpecial()) {
            if (this.fighter.isInSlowMoMode() && this.fighter.getSpecialResult() == 0 && this.fighter.specialContinuePossible()) {
                this.specialOutcomeDetermined = true;
                if (grh.rnd.nextInt(100) <= this.SPECIAL_SUCCESS_PROBABILITY) {
                    this.fighter.performAttack(false, false, false);
                    switch (grh.rnd.nextInt(4)) {
                        case 0: {
                            this.fighter.setSpecialResult((byte)1);
                            break;
                        }
                        case 1: {
                            this.fighter.setSpecialResult((byte)3);
                            break;
                        }
                        case 2: 
                        case 3: {
                            this.fighter.setSpecialResult((byte)4);
                        }
                    }
                    this.specialOutcomeDetermined = false;
                } else {
                    this.fighter.setSpecialResult((byte)2);
                }
            }
            return;
        }
        if (this.opponent.getCurrentAnim() == 29 && this.getIntelligence() != 0 && this.fighter.canMove() && this.fighter.getCurrentAnim() != 2 && grh.rnd.nextInt(3) == 0) {
            this.fighter.cheer();
            return;
        }
        if (this.fighter.getCurrentAnim() != 12 && this.fighter.getCurrentAnim() != 11) {
            this.heavy_attack_time = -1;
        }
        if (this.heavy_attack_time >= 0) {
            this.heavy_attack_time = (int)((long)this.heavy_attack_time + elapsed_time);
            if (this.heavy_attack_time > this.fighter.getHeavyAttackLoopTime()) {
                this.fighter.performHeavyAttack(false);
                this.heavy_attack_time = -1;
            } else if (!(this.getIntelligence() != 2 && this.getIntelligence() != 1 || this.fighter.heavyAttackLoopDealsDamage() || this.fighter.getCurrentAnim() != 12 || this.fighter.opponentInCloseRange() && this.fighter.rotatedCorrectly())) {
                this.heavy_attack_time = -1;
                this.fighter.idle();
            }
            return;
        }
        if (this.opponent.isStunned()) {
            if (this.fighter.opponentWillBeInCloseRange()) {
                switch (this.getIntelligence()) {
                    case 0: {
                        this.fighter.performAttack(false, false, false);
                        break;
                    }
                    case 1: {
                        this.heavy_attack_time = 0;
                        this.fighter.prepareHeavyAttack(false, false);
                        break;
                    }
                    case 2: {
                        if (grh.rnd.nextInt(2) == 0 && this.fighter.backwardRangeOK()) {
                            this.fighter.moveBackward(false);
                            break;
                        }
                        this.heavy_attack_time = 0;
                        this.fighter.prepareHeavyAttack(false, false);
                    }
                }
            } else if (this.special_wait_time > 1000) {
                this.performSpecial();
            }
            return;
        }
        if (this.opponent.getCurrentAnim() == 12 || this.opponent.getCurrentAnim() == 13) {
            if (this.opponent.heavyAttackLoopDealsDamage()) {
                if (this.fighter.opponentWillBeInCloseRange()) {
                    int compare = this.HEAVY_ATTACK_BACKWARD_LOW;
                    switch (this.getIntelligence()) {
                        case 1: {
                            compare = this.HEAVY_ATTACK_BACKWARD_MEDIUM;
                            break;
                        }
                        case 2: {
                            compare = this.HEAVY_ATTACK_BACKWARD_HIGH;
                        }
                    }
                    if ((this.fighter.canMove() || this.fighter.animAbortPossible()) && (grh.rnd.nextInt(100) <= compare || this.moveBackward)) {
                        this.moveBackward = false;
                        if (this.fighter.backwardRangeOK() && this.fighter.moveBackwardsPossible()) {
                            this.fighter.moveBackward(false);
                        } else {
                            this.moveLeftOrRight();
                        }
                        return;
                    }
                    return;
                }
                if (this.fighter.canMove() || this.fighter.animAbortPossible()) {
                    switch (this.getIntelligence()) {
                        case 1: 
                        case 2: {
                            int compare = 20;
                            if (this.getIntelligence() == 2) {
                                compare = 33;
                            }
                            if (grh.rnd.nextInt(100) < compare && this.special_wait_time > 1000) {
                                this.performSpecial();
                                this.moveBackward = true;
                            } else if (this.special_wait_time > 1000) {
                                this.fighter.performAttack(true, false, false);
                                this.moveBackward = true;
                            }
                            return;
                        }
                        case 0: {
                            if (grh.rnd.nextInt(100) >= 30) break;
                            this.fighter.performAttack(true, false, false);
                            this.moveBackward = true;
                        }
                    }
                }
                return;
            }
            int compare = this.HEAVY_ATTACK_BACKWARD_LOW;
            switch (this.getIntelligence()) {
                case 1: {
                    compare = this.HEAVY_ATTACK_BACKWARD_MEDIUM;
                    break;
                }
                case 2: {
                    compare = this.HEAVY_ATTACK_BACKWARD_HIGH;
                }
            }
            if ((this.fighter.canMove() || this.fighter.animAbortPossible()) && (grh.rnd.nextInt(100) <= compare || this.moveBackward)) {
                if (grh.rnd.nextInt(3) == 0) {
                    if (this.fighter.backwardRangeOK() && this.fighter.moveBackwardsPossible()) {
                        this.fighter.moveBackward(false);
                    } else {
                        this.moveLeftOrRight();
                    }
                } else {
                    this.moveLeftOrRight();
                }
            }
        }
        if (this.opponent.getCurrentAnim() == 16 && this.fighter.getCurrentAnim() == 29 && this.fighter.animAbortPossible()) {
            switch (grh.rnd.nextInt(3)) {
                case 0: 
                case 1: {
                    this.moveLeftOrRight();
                    break;
                }
                default: {
                    if (!this.fighter.backwardRangeOK()) break;
                    this.fighter.moveBackward(false);
                }
            }
        }
        if (this.opponent.isBlocking()) {
            this.opponent_block_time = (int)((long)this.opponent_block_time + elapsed_time);
            if (this.opponent_block_time > 800) {
                switch (this.getIntelligence()) {
                    case 0: {
                        if (this.fighter.opponentWillBeInCloseRange()) {
                            switch (grh.rnd.nextInt(6)) {
                                case 0: {
                                    this.heavy_attack_time = 0;
                                    this.fighter.prepareHeavyAttack(false, false);
                                    this.opponent_block_time = 0;
                                    break;
                                }
                                case 1: 
                                case 2: {
                                    this.moveLeftOrRight();
                                    this.opponent_block_time = 0;
                                    break;
                                }
                                case 5: {
                                    if (!this.fighter.backwardRangeOK()) break;
                                    this.fighter.moveBackward(false);
                                    break;
                                }
                                case 3: 
                                case 4: {
                                    this.fighter.performAttack(false, false, false);
                                }
                            }
                            break;
                        }
                        if (this.special_wait_time <= 1000) break;
                        if (grh.rnd.nextInt(3) == 0) {
                            this.opponent_block_time = 0;
                            this.performSpecial();
                            break;
                        }
                        this.fighter.performAttack(true, false, false);
                        break;
                    }
                    case 1: 
                    case 2: {
                        if (this.fighter.opponentWillBeInCloseRange()) {
                            switch (grh.rnd.nextInt(3)) {
                                case 0: {
                                    this.heavy_attack_time = 0;
                                    this.fighter.prepareHeavyAttack(false, false);
                                    this.opponent_block_time = 0;
                                    break;
                                }
                                case 1: {
                                    this.moveLeftOrRight();
                                    this.opponent_block_time = 0;
                                    break;
                                }
                                case 2: {
                                    if (!this.fighter.backwardRangeOK()) break;
                                    this.fighter.moveBackward(false);
                                }
                            }
                            break;
                        }
                        if (this.special_wait_time <= 1000) break;
                        this.opponent_block_time = 0;
                        this.performSpecial();
                    }
                }
                return;
            }
        } else {
            this.opponent_block_time = 0;
        }
        if (this.block || this.fighter.isBlocking()) {
            if (!this.fighter.facesOpponent()) {
                switch (this.getIntelligence()) {
                    case 0: 
                    case 1: {
                        if (grh.rnd.nextInt(100) >= this.ACTION_PROBABILITY + this.action_probability_bonus) break;
                        this.block = false;
                        this.fighter.stopBlock(false);
                        this.fighter.idle();
                        break;
                    }
                    case 2: {
                        this.fighter.stopBlock(false);
                        this.fighter.idle();
                    }
                }
            }
            if (this.fighter.getCurrentAnim() == 14 || this.fighter.isBlocking()) {
                if (this.opponent.getCurrentAnim() != 26 && grh.rnd.nextInt(100) < this.ACTION_PROBABILITY + this.action_probability_bonus) {
                    this.block = false;
                    this.fighter.stopBlock(false);
                    this.fighter.idle();
                }
            } else if ((this.fighter.canMove() || this.fighter.animAbortPossible()) && (this.opponent.blockFrameReached() || grh.rnd.nextInt(100) < this.ACTION_PROBABILITY + this.action_probability_bonus)) {
                this.block = false;
                this.fighter.holdBlock(false);
            }
            return;
        }
        if ((this.fighter.getCurrentAnim() == 5 || this.fighter.getCurrentAnim() == 7 || this.fighter.getCurrentAnim() == 9 && this.fighter.getID() == 6) && (this.opponent.getCurrentAnim() == 18 || this.opponent.getCurrentAnim() == 19) && grh.rnd.nextInt(100) < this.COMBO_CHANCE && this.fighter.nextAttackPossible()) {
            this.fighter.performAttack(false, false, false);
        }
        if (this.attack && (this.fighter.canMove() || this.fighter.animAbortPossible())) {
            if (this.fighter.facesOpponent()) {
                if (this.getIntelligence() == 2) {
                    if (grh.rnd.nextInt(3) == 0) {
                        if (this.fighter.opponentWillBeInCloseRange()) {
                            if (!this.opponent.facesOpponent()) {
                                this.fighter.shieldAttack(false, false);
                            } else {
                                this.fighter.performAttack(false, false, false);
                            }
                        } else {
                            this.fighter.performAttack(true, false, false);
                        }
                    } else if (this.fighter.opponentWillBeInCloseRange()) {
                        this.fighter.performAttack(false, false, false);
                    } else {
                        this.fighter.performAttack(true, false, false);
                    }
                } else if (grh.rnd.nextInt(2) == 0 && !this.opponent.facesOpponent() && this.fighter.opponentWillBeInCloseRange()) {
                    this.fighter.shieldAttack(false, false);
                } else if (this.fighter.opponentWillBeInCloseRange()) {
                    this.fighter.performAttack(false, false, false);
                } else {
                    this.fighter.performAttack(true, false, false);
                }
            }
            this.attack = false;
        }
        if (this.fighter.canMove() || this.fighter.animAbortPossible()) {
            this.heavy_attack_time = -1;
            switch (this.mode) {
                case 0: {
                    if (grh.rnd.nextInt(100) > this.ACTION_PROBABILITY + this.action_probability_bonus) break;
                    this.performRandomMove();
                    break;
                }
                case 4: {
                    if (grh.rnd.nextInt(100) > this.ACTION_PROBABILITY + this.action_probability_bonus) break;
                    int rnd = grh.rnd.nextInt(100);
                    if (this.fighter.opponentWillBeInCloseRange()) {
                        if (rnd <= this.LOW_LIFE_MOVE_BACK_CHANCE) {
                            if (!this.fighter.moveBackwardsPossible() || !this.fighter.backwardRangeOK()) break;
                            this.fighter.moveBackward(false);
                            break;
                        }
                        if (rnd <= this.LOW_LIFE_BLOCK_CHANCE) {
                            this.fighter.holdBlock(true);
                            break;
                        }
                        if (rnd <= this.LOW_LIFE_ATTACK_CHANCE) {
                            this.fighter.performAttack(false, false, false);
                            break;
                        }
                        if (rnd > this.LOW_LIFE_MOVE_LEFT_RIGHT_CHANCE) break;
                        this.moveLeftOrRight();
                        break;
                    }
                    if (rnd <= this.LOW_LIFE_FAR_ATTACK) {
                        this.fighter.performAttack(true, false, false);
                        break;
                    }
                    if (rnd <= this.LOW_LIFE_FAR_SPECIAL_ATTACK && this.special_wait_time > 1000) {
                        this.performSpecial();
                        break;
                    }
                    if (rnd <= this.LOW_LIFE_FAR_MOVE_FORWARD) {
                        this.fighter.moveForward(false);
                        break;
                    }
                    this.moveLeftOrRight();
                    break;
                }
                case 5: {
                    if (grh.rnd.nextInt(100) > this.ACTION_PROBABILITY + this.action_probability_bonus) break;
                    int rnd = grh.rnd.nextInt(100);
                    if (!this.fighter.rotatedCorrectly()) {
                        this.moveEventuallyIfNotRotatedCorrectly();
                        if (grh.rnd.nextInt(5) != 0) {
                            return;
                        }
                    }
                    if (this.fighter.opponentWillBeInCloseRange()) {
                        if (rnd <= this.SLOW_LEFT_RIGHT_CHANCE) {
                            this.moveLeftOrRight();
                            break;
                        }
                        if (rnd <= this.SLOW_STEP_BACK_CHANCE) {
                            if (!this.fighter.moveBackwardsPossible() || !this.fighter.backwardRangeOK()) break;
                            this.fighter.moveBackward(false);
                            break;
                        }
                        if (rnd <= this.SLOW_BLOCK_CHANCE) {
                            this.fighter.holdBlock(false);
                            break;
                        }
                        if (rnd <= this.SLOW_SHIELD_ATTACK_CHANCE) {
                            this.fighter.shieldAttack(false, false);
                            break;
                        }
                        if (rnd <= this.SLOW_ATTACK_CHANCE) {
                            this.fighter.performAttack(false, false, false);
                            break;
                        }
                        if (rnd > this.SLOW_HEAVY_ATTACK_CHANCE) break;
                        if (this.fighter.heavyAttackLoopDealsDamage() || grh.rnd.nextInt(3) == 0) {
                            this.heavy_attack_time = 0;
                            this.fighter.prepareHeavyAttack(false, false);
                            break;
                        }
                        this.fighter.performAttack(false, false, false);
                        break;
                    }
                    if (rnd <= this.SLOW_FAR_LEFT_RIGHT_CHANCE) {
                        this.moveLeftOrRight();
                        break;
                    }
                    if (rnd <= this.SLOW_FAR_MOVE_FORWARD_CHANCE) {
                        this.fighter.moveForward(false);
                        break;
                    }
                    if (rnd <= this.SLOW_FAR_ATTACK_CHANCE) {
                        this.fighter.performAttack(true, false, false);
                        break;
                    }
                    if (rnd <= this.SLOW_FAR_SPECIAL_ATTACK_CHANCE && this.special_wait_time > 1000) {
                        this.performSpecial();
                        break;
                    }
                    if (rnd > this.SLOW_FAR_HEAVY_ATTACK_CHANCE) break;
                    if (this.fighter.heavyAttackLoopDealsDamage()) {
                        this.heavy_attack_time = 0;
                        this.fighter.prepareHeavyAttack(false, false);
                        break;
                    }
                    if (this.special_wait_time <= 1000) break;
                    this.fighter.performAttack(true, false, false);
                    break;
                }
                case 2: {
                    if (this.attack) {
                        if (this.fighter.canMove() || this.fighter.animAbortPossible()) {
                            if (this.fighter.facesOpponent()) {
                                if (!this.opponent.facesOpponent()) {
                                    this.fighter.shieldAttack(false, false);
                                } else {
                                    this.fighter.performAttack(false, false, false);
                                }
                                this.attack = false;
                            } else if (this.getIntelligence() == 2) {
                                this.moveLeftOrRight();
                            }
                        }
                        return;
                    }
                    if (grh.rnd.nextInt(100) > this.ACTION_PROBABILITY + this.action_probability_bonus) break;
                    if (!this.fighter.rotatedCorrectly()) {
                        this.moveEventuallyIfNotRotatedCorrectly();
                    }
                    if (grh.rnd.nextInt(100) <= this.AGILE_MOVE_THEN_ATTACK) {
                        this.moveLeftOrRight();
                        this.attack = true;
                        break;
                    }
                    this.performRandomMove();
                }
            }
        }
    }

    public void react(int action_in, long ingame_time) {
    }

    public void release() {
        this.fighter = null;
        this.opponent = null;
    }
}

