/*
 * Decompiled with CFR 0.152.
 */
package GameEssentials;

import AbyssEngine.AEGeometry;
import AbyssEngine.AEMath;
import AbyssEngine.AEResourceManager;
import AbyssEngine.AETransform;
import AbyssEngine.AEVector3D;
import FLToolkit.grh;

public class FighterFigure {
    public static final int ANIM_IDLE = 1;
    public static final int ANIM_CHEER = 2;
    public static final int ANIM_VICTORY = 3;
    public static final int ANIM_ATTACK_INIT = 4;
    public static final int ANIM_FIRST_ATTACK = 5;
    public static final int ANIM_FIRST_ATTACK_TO_IDLE = 6;
    public static final int ANIM_SECOND_ATTACK = 7;
    public static final int ANIM_SECOND_ATTACK_TO_IDLE = 8;
    public static final int ANIM_THIRD_ATTACK = 9;
    public static final int ANIM_THIRD_ATTACK_TO_IDLE = 10;
    public static final int ANIM_HEAVY_ATTACK_INIT = 11;
    public static final int ANIM_HEAVY_ATTACK_HOLD_LOOP = 12;
    public static final int ANIM_HEAVY_ATTACK = 13;
    public static final int ANIM_BLOCK = 14;
    public static final int ANIM_BEING_BLOCKED = 15;
    public static final int ANIM_SHIELD_ATTACK = 16;
    public static final int ANIM_DIE = 17;
    public static final int ANIM_FRONT_HIT = 18;
    public static final int ANIM_BACK_HIT = 19;
    public static final int ANIM_90_DEGREE_TURN_DOWN = 20;
    public static final int ANIM_90_DEGREE_TURN_UP = 21;
    public static final int ANIM_MOVE_FORWARD = 22;
    public static final int ANIM_MOVE_BACKWARDS = 23;
    public static final int ANIM_ROTATE_CCW = 24;
    public static final int ANIM_ROTATE_CW = 25;
    public static final int ANIM_FIERCE_ATTACK = 26;
    public static final int ANIM_180_DEGREE_BACK = 27;
    public static final int ANIM_STUNNED_LOOP = 28;
    public static final int ANIM_CRITICAL_HIT = 29;
    public static final int ANIM_SPECIAL_1_INIT = 30;
    public static final int ANIM_SPECIAL_1_HIT = 31;
    public static final int ANIM_SPECIAL_2_HIT = 32;
    public static final int ANIM_FOURTH_ATTACK = 33;
    public static final int ANIM_BLOCK_LOOP = 34;
    public static final int ANIM_CONTINUE_POSE = 35;
    public static final int ANIM_GET_UP = 36;
    public static final int[][][] anim_info = new int[][][]{new int[][]{{1, 1, 0, 0}, {0, 24, 0, 0}, {25, 45, 0, 0}, {46, 90, 0, 0}, {95, 96, 0, 4}, {97, 106, 100, 3}, {107, 114, 0, 0}, {115, 125, 120, 3}, {126, 133, 0, 0}, {134, 145, 141, 3}, {146, 153, 0, 0}, {154, 160, 0, 0}, {161, 179, 0, 0}, {180, 189, 0, 0}, {190, 200, 191, 0}, {201, 216, 201, 0}, {217, 237, 225, 4}, {238, 288, 238, 0}, {289, 294, 289, 0}, {295, 300, 295, 0}, {301, 321, 0, 0}, {322, 342, 0, 0}, {343, 355, 0, 0}, {356, 368, 0, 0}, {369, 385, 0, 0}, {386, 402, 0, 0}, {403, 429, 413, 9}, {430, 442, 0, 0}, {443, 467, 0, 0}, {468, 492, 0, 0}, {493, 504, 0, 0}, {505, 523, 508, 0}, {524, 538, 526, 0}, {0}, {539, 563, 0, 0}, {479, 479, 0, 0}, {480, 492, 0, 0}}, new int[][]{{1, 1, 0, 0}, {0, 24, 0, 0}, {25, 45, 0, 0}, {46, 80, 0, 0}, {81, 84, 0, 4}, {85, 90, 88, 2}, {91, 96, 0, 0}, {97, 103, 99, 2}, {104, 109, 0, 0}, {110, 117, 115, 2}, {118, 123, 0, 0}, {124, 130, 0, 0}, {131, 142, 0, 0}, {143, 158, 145, 3}, {159, 169, 159, 0}, {170, 185, 170, 0}, {186, 199, 190, 0}, {200, 237, 200, 0}, {238, 243, 238, 0}, {244, 249, 244, 0}, {250, 266, 0, 0}, {267, 283, 0, 0}, {284, 292, 0, 0}, {293, 301, 0, 0}, {302, 314, 0, 0}, {315, 327, 0, 0}, {328, 344, 340, 7}, {345, 353, 0, 0}, {354, 378, 0, 0}, {379, 403, 379, 0}, {404, 415, 0, 0}, {416, 435, 419, 0}, {436, 448, 438, 0}, {0}, {449, 473, 0, 0}, {397, 397, 0, 0}, {398, 403, 0, 0}}, new int[][]{{1, 1, 0, 0}, {0, 24, 0, 0}, {25, 45, 0, 0}, {46, 83, 0, 0}, {84, 86, 0, 4}, {87, 91, 90, 2}, {92, 97, 0, 0}, {98, 103, 102, 2}, {104, 109, 0, 0}, {110, 116, 113, 2}, {117, 122, 0, 0}, {123, 128, 0, 0}, {129, 134, 0, 0}, {135, 156, 144, 3}, {157, 168, 157, 0}, {169, 183, 0, 0}, {184, 200, 191, 0}, {201, 242, 0, 0}, {243, 248, 243, 0}, {249, 254, 249, 0}, {255, 271, 0, 0}, {272, 288, 0, 0}, {289, 296, 0, 0}, {297, 304, 0, 0}, {305, 316, 0, 0}, {317, 328, 0, 0}, {329, 355, 343, 7}, {356, 364, 0, 0}, {365, 389, 0, 0}, {390, 414, 0, 0}, {415, 422, 6, 0}, {423, 438, 429, 0}, {439, 452, 444, 0}, {0}, {453, 477, 0, 0}, {400, 400, 0, 0}, {401, 414, 0, 0}}, new int[][]{{1, 1, 0, 0}, {0, 24, 0, 0}, {25, 45, 0, 0}, {46, 74, 0, 0}, {75, 79, 0, 4}, {80, 87, 83, 2}, {88, 94, 0, 0}, {95, 103, 98, 2}, {104, 110, 0, 0}, {111, 120, 118, 2}, {121, 127, 0, 0}, {128, 136, 0, 0}, {137, 143, 0, 0}, {144, 163, 146, 3}, {164, 174, 164, 0}, {175, 190, 175, 0}, {191, 209, 199, 0}, {210, 260, 210, 0}, {261, 266, 261, 0}, {267, 272, 267, 0}, {273, 291, 0, 0}, {292, 310, 0, 0}, {311, 321, 0, 0}, {322, 332, 0, 0}, {333, 347, 0, 0}, {348, 362, 0, 0}, {363, 386, 375, 7}, {387, 397, 0, 0}, {398, 422, 0, 0}, {423, 447, 423, 0}, {448, 457, 0, 0}, {458, 473, 461, 0}, {474, 487, 478, 0}, {0}, {488, 512, 0, 0}, {433, 433, 0}, {434, 447, 0, 0}}, new int[][]{{1, 1, 0, 0}, {1, 24, 0, 0}, {25, 45, 0, 0}, {46, 83, 0, 0}, {87, 88, 0, 4}, {89, 97, 94, 2}, {98, 105, 0, 0}, {106, 115, 111, 2}, {116, 123, 0, 0}, {124, 135, 132, 2}, {136, 142, 0, 0}, {143, 153, 0, 0}, {154, 162, 0, 0}, {163, 185, 166, 3}, {186, 198, 188, 0}, {199, 210, 199, 0}, {211, 227, 219, 0}, {228, 269, 228, 0}, {270, 275, 270, 0}, {276, 281, 276, 0}, {282, 302, 0, 0}, {303, 323, 0, 0}, {324, 336, 0, 0}, {337, 349, 0, 0}, {350, 366, 0, 0}, {367, 383, 0, 0}, {384, 418, 396, 7}, {419, 431, 0, 0}, {432, 456, 0, 0}, {457, 481, 0, 0}, {482, 490, 0, 0}, {491, 500, 498, 0}, {501, 519, 505, 0}, {0}, {520, 545, 0, 0}, {462, 462, 0, 0}, {462, 481, 0, 0}}, new int[][]{{1, 1, 0, 0}, {0, 24, 0, 0}, {25, 45, 0, 0}, {46, 83, 0, 0}, {84, 88, 0, 4}, {89, 97, 94, 2}, {98, 105, 0, 0}, {106, 115, 111, 2}, {116, 123, 0, 0}, {124, 135, 130, 2}, {136, 143, 0, 0}, {144, 151, 0, 0}, {152, 181, 157, 0}, {182, 190, 0, 3}, {191, 205, 193}, {206, 220, 210, 0}, {221, 237, 229, 0}, {238, 279, 238, 0}, {280, 286, 280, 0}, {287, 293, 287, 0}, {294, 314, 0, 0}, {315, 335, 0, 0}, {336, 348, 0, 0}, {349, 361, 0, 0}, {362, 378, 0, 0}, {379, 395, 0, 0}, {396, 437, 416, 7}, {438, 450, 0, 0}, {451, 475, 0, 0}, {475, 500, 476, 0}, {501, 508, 0, 0}, {509, 522, 513, 0}, {523, 540, 526, 0}, {0}, {541, 564, 0, 0}, {492, 492, 0, 0}, {493, 500, 0, 0}}, new int[][]{{1, 1, 0, 0}, {0, 24, 0, 0}, {25, 45, 0, 0}, {46, 86, 0, 0}, {87, 91, 0, 4}, {92, 97, 95, 2}, {98, 106, 0, 0}, {107, 115, 109, 2}, {116, 124, 0, 0}, {125, 131, 127, 2}, {132, 140, 0, 0}, {141, 151, 0, 0}, {152, 164, 0, 0}, {165, 181, 167, 3}, {182, 192, 186, 0}, {193, 208, 194, 0}, {209, 229, 214, 0}, {230, 274, 230, 0}, {275, 280, 275, 0}, {281, 286, 281, 0}, {287, 309, 0, 0}, {310, 332, 0, 0}, {333, 347, 0, 0}, {348, 362, 0, 0}, {363, 379, 0, 0}, {380, 396, 0, 0}, {397, 423, 409, 7}, {424, 438, 0, 0}, {439, 463, 0, 0}, {464, 488, 465, 0}, {489, 499, 0, 0}, {500, 515, 504, 0}, {516, 534, 521, 0}, {535, 546, 537, 0}, {547, 571, 0, 0}, {476, 476, 0, 0}, {477, 488, 0, 0}}, new int[][]{{1, 1, 0, 0}, {0, 24, 0, 0}, {25, 45, 0, 0}, {46, 83, 0, 0}, {84, 87, 0, 4}, {88, 93, 89, 2}, {94, 101, 0, 0}, {102, 108, 105, 2}, {109, 116, 0, 0}, {117, 125, 124, 2}, {126, 133, 0, 0}, {134, 140, 0, 0}, {141, 147, 0, 0}, {148, 164, 153, 3}, {165, 175, 165, 0}, {176, 191, 177, 0}, {192, 208, 198, 0}, {209, 254, 209, 0}, {255, 260, 255, 0}, {261, 266, 261, 0}, {267, 283, 0, 0}, {284, 300, 0, 0}, {301, 309, 0, 0}, {310, 318, 0, 0}, {319, 331, 0, 0}, {332, 344, 0, 0}, {345, 365, 355, 7}, {366, 374, 0, 0}, {375, 399, 0, 0}, {400, 424, 400, 0}, {425, 434, 0, 0}, {435, 452, 439, 0}, {453, 465, 455, 0}, {0}, {466, 490, 0, 0}, {413, 413, 0, 0}, {414, 424, 0, 0}}, new int[][]{{1, 1, 0, 0}, {0, 24, 0, 0}, {25, 45, 0, 0}, {46, 83, 0, 0}, {84, 87, 0, 4}, {88, 94, 90, 2}, {95, 100, 0, 0}, {101, 109, 106, 2}, {110, 115, 0, 0}, {116, 124, 122, 2}, {125, 130, 0, 0}, {131, 135, 0, 0}, {136, 142, 0, 0}, {143, 156, 147, 3}, {157, 167, 160, 0}, {168, 183, 168, 0}, {184, 198, 193, 0}, {199, 240, 199, 0}, {241, 246, 241, 0}, {247, 252, 257, 0}, {253, 269, 0, 0}, {270, 286, 0, 0}, {287, 296, 0, 0}, {297, 306, 0, 0}, {307, 319, 0, 0}, {320, 332, 0, 0}, {333, 353, 347, 7}, {354, 363, 0, 0}, {364, 388, 0, 0}, {389, 413, 389, 0}, {414, 429, 0, 0}, {430, 441, 432, 0}, {442, 458, 448, 0}, {0}, {459, 483, 0, 0}, {401, 401, 0, 0}, {402, 413, 0, 0}}};
    private static final int[] spark_translate = new int[]{0, -40, 0, -40, -40, 0, 0, -40, -50};
    private static final int[][] puddle_offset = new int[][]{{9, -138}, {187, -15}, {143, -1}, {187, -15}, {187, -15}, {160, 170}, {-275, -9}, {187, -15}, {223, 3}};
    public static final int STEP_LENGTH = 400;
    private int id;
    private int shadow_id;
    private AEGeometry geometry;
    private AEGeometry shadow;
    private AEGeometry blood;
    private AEGeometry sparks;
    private AEGeometry[] dagger;
    private AEGeometry[] trails;
    private AEGeometry net;
    private boolean moving;
    private boolean renderSparks;
    private int animID;
    private int idle_anim;
    private AEVector3D targetPos;
    private AEVector3D targetRotation;
    private AEVector3D translateTo;
    private AEVector3D translateFrom;
    public boolean translateWhileTurning;
    public boolean animStartOver;

    public FighterFigure(int mesh_id, int shadow_id) {
        this.id = mesh_id;
        this.shadow_id = shadow_id;
        this.initGeometries();
        this.idle_anim = 1;
        this.targetPos = new AEVector3D();
        this.targetRotation = new AEVector3D();
        this.translateTo = new AEVector3D();
        this.translateFrom = new AEVector3D();
    }

    public void initGeometries() {
        try {
            int i;
            this.geometry = AEResourceManager.getGeometryResource(this.id);
            if (this.id >= 300) {
                this.id -= 300;
            }
            this.geometry.stopAnim();
            this.geometry.setAnimRange(anim_info[this.id][1][0], anim_info[this.id][1][1]);
            this.geometry.setLayer(3);
            this.geometry.enableLight(true);
            if (this.id == 1) {
                this.dagger = new AEGeometry[2];
                this.dagger[0] = AEResourceManager.getGeometryResource(14);
                this.dagger[1] = AEResourceManager.getGeometryResource(15);
                for (i = 0; i < this.dagger.length; ++i) {
                    this.dagger[i].stopAnim();
                    this.dagger[i].setAnimRange(1, 17);
                    this.dagger[i].setLayer(4);
                }
            }
            this.shadow = AEResourceManager.getGeometryResource(this.shadow_id);
            if (this.shadow != null) {
                this.shadow.stopAnim();
                this.shadow.setAnimRange(anim_info[this.id][1][0], anim_info[this.id][1][1]);
                this.shadow.setLayer(2);
            }
            this.trails = new AEGeometry[2];
            this.trails[0] = AEResourceManager.getGeometryResource(40 + this.id);
            this.trails[1] = AEResourceManager.getGeometryResource(50 + this.id);
            for (i = 0; i < this.trails.length; ++i) {
                if (this.trails[i] == null) continue;
                this.trails[i].stopAnim();
                if (this.id == 5 || this.id == 2 || this.id == 4) {
                    this.trails[i].setAnimRange(AEMath.min(anim_info[this.id][1][0], 0), anim_info[this.id][1][1]);
                } else {
                    this.trails[i].setAnimRange(anim_info[this.id][1][0] + 1, anim_info[this.id][1][1] + 1);
                }
                this.trails[i].setLayer(4);
            }
            this.blood = AEResourceManager.getGeometryResource(19);
            this.blood.stopAnim();
            this.blood.setAnimRange(1, 12);
            this.blood.setLayer(4);
            this.sparks = AEResourceManager.getGeometryResource(16);
            this.sparks.stopAnim();
            this.sparks.setAnimRange(0, 5);
            this.sparks.setLayer(4);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void playAnim(int aID) {
        this.animStartOver = this.animID == aID && aID != 1;
        this.animID = aID;
        this.moving = true;
        this.geometry.setAnimRange(0, 1);
        this.geometry.setAnimRange(anim_info[this.id][this.animID][0], anim_info[this.id][this.animID][1]);
        this.geometry.playAnim((byte)1);
        if (this.shadow != null) {
            this.shadow.setAnimRange(anim_info[this.id][this.animID][0], anim_info[this.id][this.animID][1]);
            this.shadow.playAnim((byte)1);
        }
        if (this.trails != null) {
            for (int i = 0; i < this.trails.length; ++i) {
                if (this.trails[i] == null) continue;
                if (this.id == 5 || this.id == 2 || this.id == 4) {
                    this.trails[i].setAnimRange(anim_info[this.id][this.animID][0], anim_info[this.id][this.animID][1]);
                } else {
                    this.trails[i].setAnimRange(anim_info[this.id][this.animID][0] + 1, anim_info[this.id][this.animID][1] + 1);
                }
                this.trails[i].playAnim((byte)1);
            }
        }
        if (this.dagger != null && this.dagger[0] != null && this.dagger[1] != null && aID == 26) {
            this.dagger[0].stopAnim();
            this.dagger[1].stopAnim();
            this.dagger[0].playAnim((byte)1);
            this.dagger[1].playAnim((byte)1);
        }
        if (this.blood != null && (this.animID == 18 || this.animID == 19 || this.animID == 29 || this.animID == 17)) {
            this.blood.stopAnim();
            int scale_y = this.animID == 29 ? 512 : grh.rnd.nextInt(1024);
            int scale_x = this.animID == 29 ? 2560 : grh.rnd.nextInt(2048);
            this.blood.setScaling(2048 + scale_x, 3072 + scale_y, 3072 + scale_y);
            this.blood.playAnim((byte)1);
        }
        if (this.animID == 14) {
            this.renderSparks = true;
        }
    }

    public void setContinueDecisionPose() {
        this.geometry.setAnimRange(anim_info[this.id][35][0], anim_info[this.id][35][1]);
        this.geometry.playAnim((byte)2);
        if (this.shadow != null) {
            this.shadow.setAnimRange(anim_info[this.id][35][0], anim_info[this.id][35][1]);
            this.shadow.playAnim((byte)2);
        }
    }

    public void setExecutionPose() {
        this.geometry.setAnimRange(anim_info[this.id][1][0], anim_info[this.id][1][0]);
        this.geometry.playAnim((byte)2);
        if (this.shadow != null) {
            this.shadow.setAnimRange(anim_info[this.id][1][0], anim_info[this.id][1][0]);
            this.shadow.playAnim((byte)2);
        }
    }

    public void setTargetPos(int x, int y, int z) {
        this.targetPos.set(x, y, z);
    }

    public void setTargetRotation(int rx, int ry, int rz) {
        this.targetRotation.set(rx, ry, rz);
    }

    public AETransform getTransform() {
        return this.geometry.getLocalTransform();
    }

    public int getID() {
        return this.id;
    }

    public boolean isMoving() {
        return this.moving;
    }

    public int getBlockFrame() {
        return anim_info[this.id][this.animID][3];
    }

    public int getHitFrame() {
        return anim_info[this.id][this.animID][2];
    }

    public boolean hitFrameReached() {
        return this.geometry.getCurrentAnimFrame() >= anim_info[this.id][this.animID][2] && this.geometry.getCurrentAnimFrame() <= anim_info[this.id][this.animID][2] + 4;
    }

    public boolean blockFrameReached() {
        return this.geometry.getCurrentAnimFrame() >= anim_info[this.id][this.animID][2] - 3 && this.geometry.getCurrentAnimFrame() <= anim_info[this.id][this.animID][2] + 4;
    }

    public boolean nextAttackPossible(int continue_frames) {
        return (this.animID == 5 || this.animID == 7 || this.animID == 9 && this.id == 6 || this.animID == 30 || this.animID == 31) && this.geometry.getCurrentAnimFrame() >= anim_info[this.id][this.animID][1] - continue_frames;
    }

    public boolean animAbortPossible(int abort_frames) {
        if (this.animID == 29) {
            abort_frames += 3;
        }
        return this.geometry.getCurrentAnimFrame() >= anim_info[this.id][this.animID][1] - abort_frames;
    }

    public int getCurrentAnimID() {
        return this.animID;
    }

    public int getFrame() {
        return this.geometry.getCurrentAnimFrame();
    }

    public int getCurrentAnimFrame() {
        return this.geometry.getCurrentAnimFrame() - anim_info[this.id][this.animID][0];
    }

    public AEVector3D getTargetPosition() {
        return this.targetPos;
    }

    public AEVector3D getTargetRotation() {
        return this.targetRotation;
    }

    public void update(long elapsed_time, int opponent_animID, int opponent_animFrame) {
        if (this.geometry == null) {
            return;
        }
        if (this.renderSparks) {
            this.renderSparks = false;
            if (this.sparks != null) {
                this.sparks.stopAnim();
                this.sparks.playAnim((byte)1);
            }
        }
        if (this.translateWhileTurning) {
            float factor = (float)(this.geometry.getCurrentAnimFrame() - anim_info[this.id][this.animID][0]) / (float)(anim_info[this.id][this.animID][1] - anim_info[this.id][this.animID][0]);
            AEVector3D temp = new AEVector3D();
            temp = this.translateTo.sub(this.translateFrom, temp);
            if (factor > 0.8f) {
                this.geometry.setTranslation(this.translateTo);
            } else {
                this.geometry.setTranslation(this.translateFrom.x + (int)((float)temp.x * factor), 0, this.translateFrom.z + (int)((float)temp.z * factor));
            }
            this.geometry.translate(0, 0, 0);
            temp = null;
        } else {
            this.geometry.translate(0, 0, 0);
        }
        this.geometry.update(false);
        if (!this.geometry.isPlaying()) {
            this.moving = false;
        }
    }

    public void updateTransformation() {
        this.geometry.translate(0, 0, 0);
        this.geometry.update(false);
    }

    public void render() {
        if (this.shadow != null) {
            this.shadow.setTranslation(this.geometry.getPosition());
            this.shadow.setRotation(0, this.geometry.getRotationY(), 0);
            this.shadow.translate(0, 0, 0);
            this.shadow.update(false);
        }
        grh.renderer.render(this.geometry);
        if (this.shadow != null) {
            grh.renderer.renderNoCull(this.shadow);
        }
        if (this.dagger != null && this.animID == 26) {
            for (int i = 0; i < this.dagger.length; ++i) {
                this.dagger[i].setTranslation(this.geometry.getPosition());
                this.dagger[i].setRotation(0, this.geometry.getRotationY(), 0);
                this.dagger[i].translate(0, 0, 0);
                this.dagger[i].update(false);
                if (!this.dagger[i].isPlaying()) continue;
                grh.renderer.render(this.dagger[i]);
            }
        }
        if (this.net != null) {
            this.net.setTranslation(this.geometry.getPosition());
            this.net.setRotation(0, this.geometry.getRotationY(), 0);
            this.net.translate(0, 0, 0);
            this.net.update(false);
            grh.renderer.render(this.net);
        }
        if (this.blood != null && (this.animID == 18 || this.animID == 19 || this.animID == 29) || this.animID == 17) {
            this.blood.setTranslation(this.geometry.getPosition());
            this.blood.setRotation(0, this.geometry.getRotationY(), 0);
            this.blood.translate(0, 0, 0);
            this.blood.update(false);
            if (this.blood.isPlaying()) {
                grh.renderer.render(this.blood);
            }
        }
        if (this.sparks != null && this.animID == 14) {
            this.sparks.setTranslation(this.geometry.getPosition());
            this.sparks.translate(0, spark_translate[this.id], 0);
            this.sparks.setRotation(0, this.geometry.getRotationY(), 0);
            this.sparks.translate(0, 0, 0);
            this.sparks.update(false);
            if (this.sparks.isPlaying()) {
                grh.renderer.render(this.sparks);
            }
        }
    }

    public void renderTrails(int trail_id) {
        if (this.animID == 1) {
            return;
        }
        boolean render = true;
        if (this.trails[trail_id] != null) {
            if (this.id == 5) {
                switch (this.animID) {
                    case 5: 
                    case 7: 
                    case 9: 
                    case 12: 
                    case 16: 
                    case 26: 
                    case 30: 
                    case 31: 
                    case 32: {
                        if (this.firstThirdOfAnim() || anim_info[this.id][this.animID][1] - this.geometry.getCurrentAnimFrame() <= 3) {
                            render = false;
                            break;
                        }
                        this.trails[trail_id].setAnimRange(this.geometry.getCurrentAnimFrame() + 1, anim_info[this.id][this.animID][1]);
                        break;
                    }
                    default: {
                        render = false;
                    }
                }
            }
            for (int i = 0; i < this.trails.length; ++i) {
                this.trails[i].setTranslation(this.geometry.getPosition());
                this.trails[i].setRotation(0, this.geometry.getRotationY(), 0);
                this.trails[i].translate(0, 0, 0);
                this.trails[i].update(false);
            }
            if (render) {
                grh.renderer.render(this.trails[trail_id]);
            }
        }
    }

    public void setCharacter(int id) {
        this.geometry = AEResourceManager.getGeometryResource(id);
    }

    public void setTransformation(int x, int y, int z, int rx, int ry, int rz) {
        this.geometry.setTranslation(x, y, z);
        this.geometry.setRotation(rx, ry, rz);
        this.geometry.translate(0, 0, 0);
        this.geometry.update(false);
        this.targetPos.set(x, y, z);
        this.targetRotation.set(rx, ry, rz);
    }

    public void rotate(int rx, int ry, int rz) {
        this.geometry.rotate(rx, ry, rz);
        this.geometry.translate(0, 0, 0);
        this.geometry.update(false);
    }

    public AEVector3D getDir(int opponent_x, int opponent_z) {
        AEVector3D opponnent_pos = new AEVector3D(opponent_x, 0, opponent_z);
        AEVector3D pos = new AEVector3D(this.geometry.getPositionX(), 0, this.geometry.getPositionZ());
        AEVector3D dir = new AEVector3D();
        dir = opponnent_pos.sub(pos, dir);
        dir.normalize();
        pos = null;
        opponnent_pos = null;
        return dir;
    }

    public AEGeometry getGeometry() {
        return this.geometry;
    }

    public void translateToTargetPos() {
        this.translateWhileTurning = false;
        this.geometry.setTranslation(this.targetPos.x, this.targetPos.y, this.targetPos.z);
        this.geometry.setRotation(this.targetRotation.x, this.targetRotation.y, this.targetRotation.z);
        this.geometry.translate(0, 0, 0);
        this.geometry.update(false);
        this.translateWhileTurning = false;
    }

    public void moveForward(int opponent_x, int opponent_z) {
        AEVector3D dir = this.getDir(opponent_x, opponent_z);
        this.targetPos.set(this.geometry.getPositionX() + (dir.x * 400 >> 12), 0, this.geometry.getPositionZ() + (dir.z * 400 >> 12));
        this.targetPos = this.setToRaster(this.targetPos);
        this.targetRotation.set(this.geometry.getRotation());
        dir = null;
    }

    public boolean facesOpponent(int opponent_x, int opponent_z) {
        AEVector3D dir = new AEVector3D();
        this.geometry.rotate(0, 1024, 0);
        this.geometry.translate(0, 0, 0);
        this.geometry.update(false);
        dir = this.geometry.getWorldDirection();
        this.geometry.rotate(0, -1024, 0);
        this.geometry.translate(0, 0, 0);
        this.geometry.update(false);
        AEVector3D temp = new AEVector3D();
        for (int i = 1; i < 3; ++i) {
            temp.set(this.geometry.getPositionX() + i * (dir.x * 400 >> 12), 0, this.geometry.getPositionZ() + i * (dir.z * 400 >> 12));
            temp = this.setToRaster(temp);
            if (Math.abs(temp.x - opponent_x) >= 150 || Math.abs(temp.z - opponent_z) >= 150) continue;
            temp = null;
            dir = null;
            return true;
        }
        temp = null;
        dir = null;
        return false;
    }

    public void moveBackward(int opponent_x, int opponent_z, int ry) {
        AEVector3D dir = this.getDir(opponent_x, opponent_z);
        this.targetPos.set(this.geometry.getPositionX() + (-dir.x * 400 >> 12), 0, this.geometry.getPositionZ() + (-dir.z * 400 >> 12));
        this.targetPos = this.setToRaster(this.targetPos);
        this.targetRotation.set(0, ry, 0);
        dir = null;
    }

    private AEVector3D setToRaster(AEVector3D vec) {
        int x = vec.x;
        int temp = x % 200;
        vec.x = Math.abs(temp) > 100 ? (temp > 0 ? (vec.x += 200 - temp) : (vec.x += -200 - temp)) : (vec.x -= temp);
        int z = vec.z;
        temp = z % 400;
        vec.z = Math.abs(temp) > 200 ? (temp > 0 ? (vec.z += 400 - temp) : (vec.z += -400 - temp)) : (vec.z -= temp);
        return vec;
    }

    public void moveLeft(int opponent_x, int opponent_z, boolean near) {
        AEVector3D dir = this.getDir(opponent_x, opponent_z);
        AEVector3D temp = new AEVector3D();
        temp = this.geometry.getDirection(temp);
        AEVector3D left = new AEVector3D();
        left = dir.cross(this.geometry.getUpVector(), left);
        if (near) {
            this.targetPos.set(this.geometry.getPositionX() + ((dir.x - left.x) * 400 >> 12), 0, this.geometry.getPositionZ() + ((dir.z - left.z) * 400 >> 12));
            this.targetPos = this.setToRaster(this.targetPos);
        } else {
            this.targetPos.set(this.geometry.getPositionX() + ((dir.x - left.x) * 400 >> 12), 0, this.geometry.getPositionZ() + ((dir.z - left.z) * 400 >> 12));
            this.targetPos.set(this.targetPos.x + (dir.x * 400 >> 12), 0, this.targetPos.z + (dir.z * 400 >> 12));
            this.targetPos = this.setToRaster(this.targetPos);
            this.translateTo.set(this.geometry.getPositionX() + (dir.x * 400 >> 12), 0, this.geometry.getPositionZ() + (dir.z * 400 >> 12));
            this.translateTo = this.setToRaster(this.translateTo);
            this.translateFrom.set(this.geometry.getPosition());
            this.translateFrom = this.setToRaster(this.translateFrom);
            this.translateWhileTurning = true;
        }
        this.targetRotation.set(0, this.geometry.getRotationY() - 1024, 0);
        temp = null;
        dir = null;
        left = null;
    }

    public void moveRight(int opponent_x, int opponent_z, boolean near) {
        AEVector3D dir = this.getDir(opponent_x, opponent_z);
        AEVector3D temp = new AEVector3D();
        temp = this.geometry.getDirection(temp);
        AEVector3D left = new AEVector3D();
        left = dir.cross(this.geometry.getUpVector(), left);
        if (near) {
            this.targetPos.set(this.geometry.getPositionX() + ((dir.x + left.x) * 400 >> 12), 0, this.geometry.getPositionZ() + ((dir.z + left.z) * 400 >> 12));
            this.targetPos = this.setToRaster(this.targetPos);
        } else {
            this.targetPos.set(this.geometry.getPositionX() + ((dir.x + left.x) * 400 >> 12), 0, this.geometry.getPositionZ() + ((dir.z + left.z) * 400 >> 12));
            this.targetPos.set(this.targetPos.x + (dir.x * 400 >> 12), 0, this.targetPos.z + (dir.z * 400 >> 12));
            this.targetPos = this.setToRaster(this.targetPos);
            this.translateTo.set(this.geometry.getPositionX() + (dir.x * 400 >> 12), 0, this.geometry.getPositionZ() + (dir.z * 400 >> 12));
            this.translateTo = this.setToRaster(this.translateTo);
            this.translateFrom.set(this.geometry.getPosition());
            this.translateFrom = this.setToRaster(this.translateFrom);
            this.translateWhileTurning = true;
        }
        this.targetRotation.set(0, this.geometry.getRotationY() + 1024, 0);
        temp = null;
        dir = null;
        left = null;
    }

    public void abyssUpdate() {
        this.geometry.translate(0, 0, 0);
        this.geometry.update(false);
    }

    public AEVector3D getPosition() {
        return this.geometry.getPosition();
    }

    public int getPositionX() {
        return this.geometry.getPositionX();
    }

    public int getPositionY() {
        return this.geometry.getPositionY();
    }

    public int getPositionZ() {
        return this.geometry.getPositionZ();
    }

    public int getRotationX() {
        return this.geometry.getRotationX();
    }

    public int getRotationY() {
        return this.geometry.getRotationY();
    }

    public int getRotationZ() {
        return this.geometry.getRotationZ();
    }

    public int getPuddleX() {
        return this.getPositionX() + (this.geometry.getWorldRightX() * puddle_offset[this.id][0] >> 12) + (this.geometry.getWorldDirectionX() * puddle_offset[this.id][1] >> 12);
    }

    public int getPuddleZ() {
        return this.getPositionZ() + (this.geometry.getWorldRightZ() * puddle_offset[this.id][0] >> 12) + (this.geometry.getWorldDirectionZ() * puddle_offset[this.id][1] >> 12);
    }

    public void reset(int x, int ry, int z) {
        this.translateWhileTurning = false;
        this.animStartOver = false;
        this.translateTo.set(x, 0, z);
        this.targetPos.set(x, 0, z);
        this.targetRotation.set(0, ry, 0);
        this.translateTo.set(x, 0, z);
        this.translateFrom.set(x, 0, z);
    }

    public void release() {
        int i;
        if (this.dagger != null) {
            for (i = 0; i < this.dagger.length; ++i) {
                this.dagger[i] = null;
            }
            this.dagger = null;
        }
        if (this.trails != null) {
            for (i = 0; i < this.trails.length; ++i) {
                this.trails[i] = null;
            }
            this.trails = null;
        }
        this.net = null;
        this.geometry = null;
        this.shadow = null;
        this.sparks = null;
        this.blood = null;
        this.targetPos = null;
        this.targetRotation = null;
        this.translateTo = null;
        this.translateFrom = null;
    }

    public boolean lastAnimFrameReached() {
        return this.geometry.getCurrentAnimFrame() == anim_info[this.id][this.animID][1];
    }

    public int getCurrentAnimStartFrame() {
        return anim_info[this.id][this.animID][0];
    }

    public int getCurrentAnimEndFrame() {
        return anim_info[this.id][this.animID][1];
    }

    public boolean firstThirdOfAnim() {
        return this.geometry.getCurrentAnimFrame() - anim_info[this.id][this.animID][0] <= (anim_info[this.id][this.animID][1] - anim_info[this.id][this.animID][0]) / 3;
    }

    public boolean secondHalfOfAnim() {
        return this.geometry.getCurrentAnimFrame() - anim_info[this.id][this.animID][0] >= (anim_info[this.id][this.animID][1] - anim_info[this.id][this.animID][0]) / 2;
    }

    public void enableLight(boolean b2) {
        this.geometry.enableLight(b2);
    }
}

