/*
 * Decompiled with CFR 0.152.
 */
package GameEssentials;

import AbyssEngine.AEMath;
import FLToolkit.AEFont;
import FLToolkit.ImgAdjust;
import FLToolkit.grh;
import GameEssentials.Fighter;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;

public class GUI {
    private static final int BORDER_LEFT = 5;
    private static final int BORDER_TOP = 5;
    private static final int BAR_LEFT = 45;
    private static final int BAR_TOP = 7;
    private static final int SPACE_MIDDLE = 50;
    private static final int BAR_HEIGHT = 8;
    private static final int BAR_NAME_SPACE = 2;
    private static final int BARS_SPACE = 3;
    private static final int MEDAL_SPACE_X = 1;
    private static final int MEDAL_SPACE_Y = 3;
    public static final int HEIGHT_FOOTER = 20;
    public static final int MENU_ITEM_HEIGHT = 13;
    public static final int SELECTION_WING_OFFSET = -2;
    public static final int MARGIN = 6;
    private static final int EAGLE_OFFSET_Y = 0;
    private static final int FIGHT_INTERFACE_X = 2;
    private static final int FIGHT_INTERFACE_Y = 6;
    private static final int FIGHT_INTERFACE_HEIGHT = 21;
    private static final int TIME_INTERFACE_Y = 5;
    private static final int TIME_INTERFACE_WIDTH = 50;
    private static final int TIME_INTERFACE_HEIGHT = 26;
    private static final int BOX_NAME_OFFSET = 3;
    private static final int NAME_X = 2;
    private static final int NAME_JEWEL_OFFSET = 2;
    private static final int JEWEL_X = 5;
    private static final int JEWEL_SPACE_X = 4;
    private static final int LIFE_X_OFFSET = 3;
    private static final int LIFE_Y_OFFSET = 2;
    private static final int LIFE_HEIGHT = 5;
    private static final int FAME_HEIGHT = 3;
    private static final int SPECIAL_BAR_HEIGHT = 6;
    public static final int SPECIAL_BOX_HEIGHT = 16;
    private static final int SPECIAL_BAR_OFFSET_X = 5;
    private static final int SPECIAL_BAR_OFFSET_Y = 2;
    private static final int FAME_Y_OFFSET = 2;
    private static final int FAME_THIRD_X_OFFSET = 2;
    private static final int SCROLL_ARROW_OFFSET = 6;
    private static final int COLOR_BORDER_0 = 3217416;
    private static final int COLOR_BORDER_1 = 0;
    private static final int COLOR_LIFE_0 = 4035075;
    private static final int COLOR_LIFE_1 = 3846661;
    private static final int COLOR_LIFE_2 = 5308164;
    private static final int COLOR_LIFE_DISABLE_0 = 2052613;
    private static final int COLOR_LIFE_DISABLE_1 = 1660673;
    private static final int COLOR_LIFE_DISABLE_2 = 2456834;
    private static final int COLOR_DAMAGE_0 = 12257030;
    private static final int COLOR_DAMAGE_1 = 15272202;
    private static final int COLOR_DAMAGE_2 = 16748033;
    private static final int COLOR_WIN_1 = 14856492;
    private static final int COLOR_WIN_2 = 14845484;
    private static final int COLOR_BORDER_HINT = 0xFFFFFF;
    private static final int COLOR_FAME_0 = 807093;
    private static final int COLOR_FAME_1 = 7318013;
    private static final int COLOR_FAME_ACTIVE_0 = 761586;
    private static final int COLOR_FAME_ACTIVE_1 = 6285042;
    private static final int COLOR_FAME_DISABLE_0 = 266017;
    private static final int COLOR_FAME_DISABLE_1 = 1449798;
    private static final int COLOR_SPECIAL_BORDER = 0;
    private static final int COLOR_SPECIAL_0 = 14237184;
    private static final int COLOR_SPECIAL_1 = 16743437;
    private static final int COLOR_SPECIAL_2 = 16559368;
    private static final int COLOR_SPECIAL_DISABLE_0 = 5904896;
    private static final int COLOR_SPECIAL_DISABLE_1 = 6894341;
    private static final int COLOR_SPECIAL_DISABLE_2 = 6899715;
    public static final int COLOR_BOX_TITLE_LINE = 4140826;
    public static final int COLOR_FIGHT_BOX_BORDER_1 = 0;
    public static final int COLOR_FIGHT_BOX_BORDER_2 = 3483672;
    public static final int COLOR_FIGHT_BOX_BORDER_3 = 10249786;
    public static final int COLOR_FIGHT_BOX_FILL_LIGHT = 4653313;
    public static final int COLOR_FIGHT_BOX_FILL_DARK = 921102;
    public static final int BORDER_COLOR_0 = 3217416;
    public static final int BORDER_COLOR_1 = 8479041;
    public static final int BORDER_COLOR_2 = 4598034;
    public static final int BORDER_COLOR_3 = 0;
    public static final int BORDER_NONE = 0;
    public static final int BORDER_U = 1;
    public static final int BORDER_D = 2;
    public static final int BORDER_L = 3;
    public static final int BORDER_HINT_TIME = 500;
    public static final int COLOR_FONT = 9991232;
    public static final int COLOR_LIGHT_BLUE = -16737069;
    public static final int COLOR_DARK_RED = 3081228;
    public static final int COLOR_FOOTER = 921102;
    public static final int COLOR_FOOTER_BORDER = 72747;
    public static final int COLOR_BG = 921102;
    public static final int COLOR_BG_DARK = 3081228;
    public static final int COLOR_BG_DARKER = 1573382;
    public static final int SELECTION_MARK_ANIM_TIME = 700;
    public static final int FADE_IN_TIME = 700;
    private static Sprite selectionWing;
    private static Sprite numbers;
    private static Image[] names;
    private static Image imgPattern;
    private static Image imgArrows;
    private static Image menu_bg;
    private static Image menu_border;
    private static Image pause_icon;
    private static Image gradient;
    private static Image eagle;
    private static Image jewel;
    private static Image noend;
    private static Sprite corner_box;
    private static Sprite colloseum;
    private static Image[] damage_up;
    private static Sprite border_arrow;
    private static Image special_bar;
    private static Image special_mark;
    private static Image special_adjust;
    private static Image tut_dpad;
    private static Sprite tut_arrow_hold;
    private static Sprite tut_arrow_press;
    private static Image tut_button_hold;
    private static Image tut_button_press;
    private static Image tut_hash;
    private static Image tut_hash_press;
    private static Image tut_hash_hold;
    private static Image tut_star;
    private static Image tut_star_press;
    private static Image tut_star_hold;
    private static Image tut_press;
    private static Image tut_hold;
    private static Image tut_num1;
    private static Image tut_num2;
    private static final int MASK_SIZE = 32;
    private static int[] mask;
    public static final int TUT_BUTTON_HOLD = 0;
    public static final int TUT_BUTTON_PRESS = 1;
    public static final int TUT_BUTTON_HOLD_BLINK = 2;
    public static final int TUT_BUTTON_PRESS_BLINK = 3;
    public static final int TUT_BUTTON_UP = 0;
    public static final int TUT_BUTTON_LEFT = 1;
    public static final int TUT_BUTTON_DOWN = 2;
    public static final int TUT_BUTTON_RIGHT = 3;
    public static final int TUT_BUTTON_FIRE = 4;
    public static final int TUT_BUTTON_STAR = 5;
    private static final int[][] tutorial_button_highlights;
    private static long tut_display_time;
    public static int TICK;

    public static void init() {
        selectionWing = new Sprite(ImgAdjust.getCypherImage("/data/2d/240x320/selected_wing.png"));
        imgPattern = ImgAdjust.getCypherImage("/data/2d/240x320/filter.png");
        imgArrows = ImgAdjust.getCypherImage("/data/2d/240x320/soft_arrows.png");
        menu_bg = ImgAdjust.getCypherImage("/data/2d/240x320/menu_bgr.png");
        menu_border = ImgAdjust.getCypherImage("/data/2d/240x320/menu_border.png");
        gradient = ImgAdjust.getCypherImage("/data/2d/240x320/gradient.png");
        colloseum = new Sprite(ImgAdjust.getCypherImage("/data/2d/240x320/colloseum.png"));
    }

    public static void initFightModule(int char_id, int opponent_id) {
        Image img = ImgAdjust.getCypherImage("/data/2d/240x320/numbers.png");
        numbers = new Sprite(img, img.getWidth() / 10, img.getHeight());
        img = null;
        selectionWing = new Sprite(ImgAdjust.getCypherImage("/data/2d/240x320/selected_wing.png"));
        img = ImgAdjust.getCypherImage("/data/2d/240x320/border_arrow.png");
        border_arrow = new Sprite(img);
        img = null;
        names = new Image[2];
        GUI.names[0] = GUI.getCharacterFightName(char_id);
        GUI.names[1] = GUI.getCharacterFightName(opponent_id);
        imgPattern = ImgAdjust.getCypherImage("/data/2d/240x320/filter.png");
        pause_icon = ImgAdjust.getCypherImage("/data/2d/240x320/arrow_menu.png");
        imgArrows = ImgAdjust.getCypherImage("/data/2d/240x320/soft_arrows.png");
        corner_box = new Sprite(ImgAdjust.getCypherImage("/data/2d/240x320/corner_box.png"));
        eagle = ImgAdjust.getCypherImage("/data/2d/240x320/menu_eagle.png");
        jewel = ImgAdjust.getCypherImage("/data/2d/240x320/attr_jewel.png");
        noend = ImgAdjust.getCypherImage("/data/2d/240x320/noend.png");
        damage_up = new Image[2];
        GUI.damage_up[0] = ImgAdjust.getCypherImage("/data/2d/240x320/fame_blue.png");
        GUI.damage_up[1] = ImgAdjust.getCypherImage("/data/2d/240x320/fame_red.png");
        tut_dpad = ImgAdjust.getCypherImage("/data/2d/240x320/tut_dpad.png");
        tut_press = ImgAdjust.getCypherImage("/data/2d/240x320/tut_press.png");
        tut_hold = ImgAdjust.getCypherImage("/data/2d/240x320/tut_hold.png");
        tut_num1 = ImgAdjust.getCypherImage("/data/2d/240x320/tut_num1.png");
        tut_num2 = ImgAdjust.getCypherImage("/data/2d/240x320/tut_num2.png");
        tut_button_hold = ImgAdjust.getCypherImage("/data/2d/240x320/tut_but_hold.png");
        tut_button_press = ImgAdjust.getCypherImage("/data/2d/240x320/tut_but_press.png");
        tut_arrow_hold = new Sprite(ImgAdjust.getCypherImage("/data/2d/240x320/tut_arrow_hold.png"));
        tut_arrow_press = new Sprite(ImgAdjust.getCypherImage("/data/2d/240x320/tut_arrow_press.png"));
        tut_hash = ImgAdjust.getCypherImage("/data/2d/240x320/tut_hash.png");
        tut_hash_press = ImgAdjust.getCypherImage("/data/2d/240x320/tut_hash_press.png");
        tut_hash_hold = ImgAdjust.getCypherImage("/data/2d/240x320/tut_hash_hold.png");
        tut_star = ImgAdjust.getCypherImage("/data/2d/240x320/tut_star.png");
        tut_star_press = ImgAdjust.getCypherImage("/data/2d/240x320/tut_star_press.png");
        tut_star_hold = ImgAdjust.getCypherImage("/data/2d/240x320/tut_star_hold.png");
        special_bar = ImgAdjust.getCypherImage("/data/2d/240x320/spec_bar.png");
        special_adjust = ImgAdjust.getCypherImage("/data/2d/240x320/spec_adjust.png");
        special_mark = ImgAdjust.getCypherImage("/data/2d/240x320/spec_mark.png");
    }

    private static void initMask() {
        if (mask == null) {
            mask = new int[1024];
            for (int i = 0; i < mask.length; ++i) {
                GUI.mask[i] = 0x44000000;
            }
        }
    }

    public static void drawTransparentPattern() {
        int size = imgPattern.getWidth();
        for (int i = 0; i < grh.w; i += size) {
            for (int j = 0; j < grh.h; j += size) {
                grh.g.drawImage(imgPattern, i, j, 0);
            }
        }
    }

    public static void drawGradient(int y) {
        for (int i = 0; i < grh.w; i += gradient.getWidth()) {
            grh.g.drawImage(gradient, i, y, 0);
        }
    }

    public static void drawColloseum(int bottom_y) {
        colloseum.setTransform(0);
        colloseum.setPosition(0, bottom_y - colloseum.getHeight());
        colloseum.paint(grh.g);
        colloseum.setTransform(2);
        colloseum.setPosition(grh.w / 2, bottom_y - colloseum.getHeight());
        colloseum.paint(grh.g);
    }

    public static void fillBackGround() {
        grh.g.setColor(921102);
        grh.g.fillRect(0, 0, grh.w, grh.h);
    }

    public static void drawWins(Fighter player, Fighter opponent) {
        int i;
        int medal_w = jewel.getWidth();
        for (i = 0; i < player.getWins(); ++i) {
            grh.g.drawImage(jewel, 5 + i * (medal_w + 4), 30 + names[0].getHeight() + 2, 0);
        }
        for (i = 0; i < opponent.getWins(); ++i) {
            grh.g.drawImage(jewel, grh.w - 5 - medal_w - i * (medal_w + 4), 30 + names[0].getHeight() + 2, 0);
        }
    }

    public static void drawDamageUps(Fighter player, Fighter opponent) {
        int color = 0;
        int x = 5;
        int add_x = 0;
        if (player.fameMultiplierChanged() && player.getFame() >= 34) {
            if (player.getFame() >= 67) {
                color = 1;
            }
            if (player.getDamageUpTime() < player.getMaxDamageUpTime() / 8) {
                add_x = -2 * damage_up[color].getWidth() + 2 * damage_up[color].getWidth() * player.getDamageUpTime() / (player.getMaxDamageUpTime() / 8);
            } else if (player.getDamageUpTime() > player.getMaxDamageUpTime() * 7 / 8) {
                add_x = -2 * damage_up[color].getWidth() + 2 * damage_up[color].getWidth() * (player.getMaxDamageUpTime() - player.getDamageUpTime()) / (player.getMaxDamageUpTime() / 8);
            }
            grh.g.drawImage(damage_up[color], x + add_x, 30 + names[0].getHeight() + 4 + jewel.getHeight(), 0);
        }
        color = 0;
        x = grh.w - 5 - damage_up[0].getWidth();
        if (opponent.fameMultiplierChanged() && opponent.getFame() >= 34) {
            if (opponent.getFame() >= 67) {
                color = 1;
            }
            if (opponent.getDamageUpTime() < opponent.getMaxDamageUpTime() / 4) {
                add_x = -2 * damage_up[color].getWidth() + 2 * damage_up[color].getWidth() * opponent.getDamageUpTime() / (opponent.getMaxDamageUpTime() / 4);
            } else if (opponent.getDamageUpTime() > opponent.getMaxDamageUpTime() * 3 / 4) {
                add_x = -2 * damage_up[color].getWidth() + 2 * damage_up[color].getWidth() * (opponent.getMaxDamageUpTime() - opponent.getDamageUpTime()) / (opponent.getMaxDamageUpTime() / 4);
            }
            grh.g.drawImage(damage_up[color], x - add_x, 30 + names[0].getHeight() + 4 + jewel.getHeight(), 0);
        }
    }

    public static int getNumberHight() {
        return numbers.getHeight();
    }

    public static int getNumberWidth(int number) {
        int digits = 1;
        while (number / 10 != 0) {
            number /= 10;
            ++digits;
        }
        return digits * numbers.getWidth();
    }

    public static void drawNumbers(int number_in, int x, int y) {
        int number = number_in;
        int digits = 1;
        while (number / 10 != 0) {
            number /= 10;
            ++digits;
        }
        number = number_in;
        for (int i = 0; i < digits; ++i) {
            int fact = 1;
            for (int j = 0; j < digits - i - 1; ++j) {
                fact *= 10;
            }
            numbers.setFrame(number / fact);
            numbers.setPosition(x + i * numbers.getWidth(), y);
            numbers.paint(grh.g);
            number %= fact;
        }
    }

    public static void resetTutorialTime() {
        tut_display_time = 0L;
    }

    public static void drawTutorialDPad(int lesson_id, int elapsed_time) {
        int tick = (int)((tut_display_time += (long)elapsed_time) / (long)TICK);
        if (tick > 11 || lesson_id == 5 && tick > 3) {
            tut_display_time = lesson_id != 5 ? (tut_display_time -= (long)(11 * TICK)) : (tut_display_time -= (long)(3 * TICK));
            tick = 0;
        }
        AEFont.setFont((byte)0);
        int text_width = AEMath.max(AEFont.getStringWidth(grh.gameText.getText(159)), AEFont.getStringWidth(grh.gameText.getText(158)));
        int box_left = 6;
        int box_top = grh.h - 20 - 24 - 2 * tut_press.getHeight();
        int text_y_offset = 6;
        int but_y_offset = 0;
        int offset_x = 0;
        boolean force = false;
        if (box_left + text_width > grh.w / 2 - tut_dpad.getWidth() / 2 - 1 || force) {
            int i;
            text_width = grh.w / 2 - tut_dpad.getWidth() / 2 - 1 - box_left;
            String[] temp = AEFont.getLineArray(grh.gameText.getText(159), text_width + 5);
            text_width = 0;
            for (i = 0; i < temp.length; ++i) {
                if (AEFont.getStringWidth(temp[i]) <= text_width) continue;
                text_width = AEFont.getStringWidth(temp[i]);
            }
            if (grh.w / 2 - tut_star.getWidth() - tut_star.getWidth() / 2 < text_width + tut_button_hold.getWidth() + 24) {
                offset_x = 10 + text_width + tut_button_hold.getWidth() + 18 - (grh.w / 2 - tut_star.getWidth() - tut_star.getWidth() / 2);
            }
            GUI.drawBox(box_left, box_top, text_width + tut_button_hold.getWidth() + 18, AEMath.max(tut_button_hold.getHeight() * 2, AEFont.getRowHeight() * 2) + 18 + AEFont.getRowHeight());
            AEFont.drawString(grh.gameText.getText(158), box_left + 12 + tut_press.getWidth(), box_top + text_y_offset);
            for (i = 0; i < temp.length; ++i) {
                if (temp[i].charAt(0) == ' ') {
                    temp[i] = temp[i].substring(1);
                }
                AEFont.drawString(temp[i], box_left + 12 + tut_press.getWidth(), box_top + text_y_offset * 2 + tut_press.getHeight() + i * AEFont.getRowHeight());
            }
            temp = null;
        } else {
            GUI.drawBox(box_left, box_top, text_width + tut_button_hold.getWidth() + 18, AEMath.max(tut_button_hold.getHeight() * 2, AEFont.getRowHeight() * 2) + 18);
            AEFont.drawString(grh.gameText.getText(158), box_left + 12 + tut_press.getWidth(), box_top + 6);
            AEFont.drawString(grh.gameText.getText(159), box_left + 12 + tut_press.getWidth(), box_top + 12 + tut_press.getHeight());
        }
        grh.g.drawImage(tut_press, box_left + 6, box_top + 6 + but_y_offset, 0);
        grh.g.drawImage(tut_hold, box_left + 6, box_top + 12 + tut_press.getHeight() + but_y_offset, 0);
        int dpad_top = grh.h - 20 - 6 - tut_dpad.getHeight();
        int dpad_left = grh.w / 2 - tut_dpad.getWidth() / 2;
        int dpad_center_y = dpad_top + tut_dpad.getHeight() / 2;
        grh.g.drawImage(tut_dpad, offset_x + dpad_left, dpad_top, 0);
        grh.g.drawImage(tut_star, offset_x + grh.w / 2 - tut_star.getWidth() - tut_star.getWidth() / 2, grh.h - 6 - tut_star.getHeight(), 0);
        grh.g.drawImage(tut_hash, offset_x + grh.w / 2 + tut_star.getWidth() / 2, grh.h - 6 - tut_star.getHeight(), 0);
        block10: for (int i = 0; i < tutorial_button_highlights[lesson_id].length; i += 2) {
            switch (tutorial_button_highlights[lesson_id][i + 1]) {
                case 0: {
                    if (tutorial_button_highlights[lesson_id][i] == 0) {
                        tut_arrow_hold.setTransform(0);
                        tut_arrow_hold.setPosition(offset_x + grh.w / 2 - tut_arrow_hold.getWidth() / 2, dpad_top);
                        tut_arrow_hold.paint(grh.g);
                        continue block10;
                    }
                    if ((lesson_id != 0 || tick >= 2) && lesson_id == 0) continue block10;
                    tut_arrow_press.setTransform(0);
                    tut_arrow_press.setPosition(offset_x + grh.w / 2 - tut_arrow_press.getWidth() / 2, dpad_top);
                    tut_arrow_press.paint(grh.g);
                    continue block10;
                }
                case 2: {
                    if (tutorial_button_highlights[lesson_id][i] == 0) {
                        tut_arrow_hold.setTransform(1);
                        tut_arrow_hold.setPosition(offset_x + grh.w / 2 - tut_arrow_hold.getWidth() / 2, dpad_top + tut_dpad.getHeight() - tut_arrow_hold.getHeight());
                        tut_arrow_hold.paint(grh.g);
                    } else {
                        tut_arrow_press.setTransform(1);
                        tut_arrow_press.setPosition(offset_x + grh.w / 2 - tut_arrow_press.getWidth() / 2, dpad_top + tut_dpad.getHeight() - tut_arrow_press.getHeight());
                        if (lesson_id == 0 && tick >= 3 && tick <= 4 || lesson_id == 5 && tick == 0 || lesson_id != 0 && lesson_id != 5) {
                            tut_arrow_press.paint(grh.g);
                        }
                    }
                    if (lesson_id != 5) continue block10;
                    grh.g.drawImage(tut_num1, offset_x + dpad_left + tut_dpad.getWidth() / 2 - tut_num1.getWidth() / 2, dpad_center_y + tut_dpad.getHeight() / 2 - tut_num1.getHeight() / 2, 0);
                    continue block10;
                }
                case 1: {
                    if (tutorial_button_highlights[lesson_id][i] == 0) {
                        tut_arrow_hold.setTransform(4);
                        tut_arrow_hold.setPosition(offset_x + dpad_left, dpad_center_y - tut_arrow_hold.getHeight() / 2);
                        tut_arrow_hold.paint(grh.g);
                    } else {
                        tut_arrow_press.setTransform(4);
                        tut_arrow_press.setPosition(offset_x + dpad_left, dpad_center_y - tut_arrow_press.getHeight() / 2);
                        if (lesson_id == 0 && tick >= 6 && tick <= 7 || lesson_id == 5 && tick == 1 || lesson_id != 0 && lesson_id != 5) {
                            tut_arrow_press.paint(grh.g);
                        }
                    }
                    if (lesson_id != 5) continue block10;
                    grh.g.drawImage(tut_num2, tut_arrow_press.getX() - tut_num2.getWidth() / 2, dpad_center_y - tut_num1.getHeight() / 2, 0);
                    continue block10;
                }
                case 3: {
                    if (tutorial_button_highlights[lesson_id][i] == 0) {
                        tut_arrow_hold.setTransform(5);
                        tut_arrow_hold.setPosition(offset_x + dpad_left + tut_dpad.getWidth() - tut_arrow_hold.getWidth(), dpad_center_y - tut_arrow_hold.getHeight() / 2);
                        tut_arrow_hold.paint(grh.g);
                        continue block10;
                    }
                    if ((lesson_id != 0 || tick < 9 || tick > 10) && lesson_id == 0) continue block10;
                    tut_arrow_press.setTransform(5);
                    tut_arrow_press.setPosition(offset_x + dpad_left + tut_dpad.getWidth() - tut_arrow_press.getWidth(), dpad_center_y - tut_arrow_press.getHeight() / 2);
                    tut_arrow_press.paint(grh.g);
                    continue block10;
                }
                case 5: {
                    if (tutorial_button_highlights[lesson_id][i] != 0) continue block10;
                    grh.g.drawImage(tut_star_hold, offset_x + grh.w / 2 - tut_star.getWidth() - tut_star.getWidth() / 2, grh.h - 6 - tut_star.getHeight(), 0);
                    continue block10;
                }
                case 4: {
                    if (tutorial_button_highlights[lesson_id][i] == 0) {
                        grh.g.drawImage(tut_button_hold, offset_x + grh.w / 2 - tut_button_press.getWidth() / 2, dpad_center_y - tut_button_press.getHeight() / 2, 0);
                        continue block10;
                    }
                    if ((lesson_id != 2 || tick != 1 && tick != 3 && tick != 5) && lesson_id == 2) continue block10;
                    grh.g.drawImage(tut_button_press, offset_x + grh.w / 2 - tut_button_press.getWidth() / 2, dpad_center_y - tut_button_press.getHeight() / 2, 0);
                }
            }
        }
    }

    public static void drawTime(int round_time) {
        if (grh.time_limit != grh.TIME_OFF && (grh.game_mode == 1 || grh.game_mode == 0 || grh.game_mode == 2)) {
            numbers.setFrame(AEMath.max(0, round_time / 10000));
            numbers.setPosition(grh.w / 2 - numbers.getWidth(), 18 - numbers.getHeight() / 2 - 1);
            numbers.paint(grh.g);
            numbers.setFrame(AEMath.max(0, round_time / 1000 % 10));
            numbers.setPosition(grh.w / 2, 18 - numbers.getHeight() / 2 - 1);
            numbers.paint(grh.g);
        } else {
            grh.g.drawImage(noend, grh.w / 2 - noend.getWidth() / 2, 18 - noend.getHeight() / 2 - 1, 0);
        }
    }

    private static void drawLife(int x1, int x2, int y, boolean old_hitpoints, boolean disable) {
        if (old_hitpoints) {
            grh.g.setColor(12257030);
        } else if (disable) {
            grh.g.setColor(2052613);
        } else {
            grh.g.setColor(4035075);
        }
        grh.g.drawLine(x1, y, x2, y);
        grh.g.drawLine(x1, y + 5 - 1, x2, y + 5 - 1);
        if (old_hitpoints) {
            grh.g.setColor(15272202);
        } else if (disable) {
            grh.g.setColor(1660673);
        } else {
            grh.g.setColor(3846661);
        }
        grh.g.drawLine(x1, y + 1, x2, y + 1);
        grh.g.drawLine(x1, y + 5 - 2, x2, y + 5 - 2);
        if (old_hitpoints) {
            grh.g.setColor(16748033);
        } else if (disable) {
            grh.g.setColor(2456834);
        } else {
            grh.g.setColor(5308164);
        }
        for (int i = 0; i < 1; ++i) {
            grh.g.drawLine(x1, y + 2 + i, x2, y + 2 + i);
        }
    }

    public static void drawHitPoints(int player_life, int opponent_life, boolean old_hitpoints) {
        int percent = AEMath.max(100 * player_life / 100, 0);
        int y = 12;
        int x1 = 9;
        int width = grh.w / 2 - 2 - 4 - 6 - 25 - 1;
        int x2 = x1 + width * percent / 100;
        if (player_life > 0 && x2 <= x1) {
            x2 = x1 + 1;
        }
        if (old_hitpoints) {
            GUI.drawLife(x1, x1 + width, y, false, true);
        }
        if (x2 > x1 && player_life > 0) {
            GUI.drawLife(x1, x2, y, old_hitpoints, false);
        }
        percent = AEMath.max(100 * opponent_life / 100, 0);
        x1 = grh.w / 2 + 25 + 2 + 1 + grh.w / 2 - 2 - 4 - 6 - 25;
        x2 = x1 - width * percent / 100 - 1;
        if (opponent_life > 0 && x2 >= x1) {
            x2 = x1 - 1;
        }
        if (old_hitpoints) {
            GUI.drawLife(x1, x1 - width - 1, y, false, true);
        }
        if (x2 < x1 && opponent_life > 0) {
            GUI.drawLife(x1, x2, y, old_hitpoints, false);
        }
    }

    public static void drawFame(Fighter player, Fighter opponent) {
        int j;
        int i;
        int third_width = (grh.w / 2 - 2 - 4 - 6 - 25 - 1) * 2 / 9;
        int x1 = 9;
        int y = 19;
        int percent = AEMath.min(player.getFame(), 100);
        for (i = 0; i < 3; ++i) {
            if (i > 0) {
                percent -= 33;
            }
            x1 = 9 + i * (third_width + 2);
            grh.g.setColor(266017);
            grh.g.drawLine(x1, y, x1 + 33 * third_width / 33 - 1, y);
            for (j = 0; j < 1; ++j) {
                grh.g.setColor(1449798);
                grh.g.drawLine(x1, y + 1 + j, x1 + 33 * third_width / 33 - 1, y + 1 + j);
            }
            grh.g.setColor(266017);
            grh.g.drawLine(x1, y + 3 - 1, x1 + 33 * third_width / 33 - 1, y + 3 - 1);
            if (AEMath.max(AEMath.min(33, percent), 0) * third_width / 33 <= 0) continue;
            grh.g.setColor(player.fameWentUp() ? 761586 : 807093);
            grh.g.drawLine(x1, y, x1 + AEMath.max(AEMath.min(33, percent), 0) * third_width / 33 - 1, y);
            for (j = 0; j < 1; ++j) {
                grh.g.setColor(player.fameWentUp() ? 6285042 : 7318013);
                grh.g.drawLine(x1, y + 1 + j, x1 + AEMath.max(AEMath.min(33, percent), 0) * third_width / 33 - 1, y + 1 + j);
            }
            grh.g.setColor(player.fameWentUp() ? 761586 : 807093);
            grh.g.drawLine(x1, y + 3 - 1, x1 + AEMath.max(AEMath.min(33, percent), 0) * third_width / 33 - 1, y + 3 - 1);
        }
        x1 = grh.w - 2 - 4 - 3 + 1;
        for (i = 0; i < 3; ++i) {
            grh.g.setColor(0);
            grh.g.fillRect(x1 - i * (third_width + 2) - third_width, y, third_width, 3);
        }
        percent = AEMath.min(opponent.getFame(), 100);
        for (i = 0; i < 3; ++i) {
            if (i > 0) {
                percent -= 33;
            }
            x1 = grh.w - 2 - 4 - 3 - i * (third_width + 2);
            grh.g.setColor(266017);
            grh.g.drawLine(x1, y, x1 - 33 * third_width / 33 + 1, y);
            for (j = 0; j < 1; ++j) {
                grh.g.setColor(1449798);
                grh.g.drawLine(x1, y + 1 + j, x1 - 33 * third_width / 33 + 1, y + 1 + j);
            }
            grh.g.setColor(266017);
            grh.g.drawLine(x1, y + 3 - 1, x1 - 33 * third_width / 33 + 1, y + 3 - 1);
            if (AEMath.max(AEMath.min(33, percent), 0) * third_width / 33 <= 1) continue;
            grh.g.setColor(opponent.fameWentUp() ? 761586 : 807093);
            grh.g.drawLine(x1, y, x1 - AEMath.max(AEMath.min(33, percent), 0) * third_width / 33 + 1, y);
            grh.g.setColor(opponent.fameWentUp() ? 6285042 : 7318013);
            for (j = 0; j < 1; ++j) {
                grh.g.drawLine(x1, y + 1 + j, x1 - AEMath.max(AEMath.min(33, percent), 0) * third_width / 33 + 1, y + 1 + j);
            }
            grh.g.setColor(opponent.fameWentUp() ? 761586 : 807093);
            grh.g.drawLine(x1, y + 3 - 1, x1 - AEMath.max(AEMath.min(33, percent), 0) * third_width / 33 + 1, y + 3 - 1);
        }
    }

    private static void drawSpecialBar(int x1, int y, int x2, boolean disable) {
        if (disable) {
            grh.g.setColor(0);
            grh.g.drawLine(x1 + 1, y, x2 - 1, y);
            grh.g.drawLine(x1, y + 1, x1, y + 6 - 1);
            grh.g.drawLine(x1 + 1, y + 6, x2 - 1, y + 6);
            grh.g.drawLine(x2, y + 1, x2, y + 6 - 1);
        }
        if (disable) {
            grh.g.setColor(5904896);
        } else {
            grh.g.setColor(14237184);
        }
        grh.g.drawLine(x1 + 1, y + 1, x2 - 1, y + 1);
        grh.g.drawLine(x1 + 1, y + 6 - 1, x2 - 1, y + 6 - 1);
        if (disable) {
            grh.g.setColor(6894341);
        } else {
            grh.g.setColor(16743437);
        }
        grh.g.drawLine(x1 + 1, y + 2, x2 - 1, y + 2);
        grh.g.drawLine(x1 + 1, y + 6 - 2, x2 - 1, y + 6 - 2);
        if (disable) {
            grh.g.setColor(6899715);
        } else {
            grh.g.setColor(16559368);
        }
        for (int i = 0; i < 1; ++i) {
            grh.g.drawLine(x1 + 1, y + 3 + i, x2 - 1, y + 3 + i);
        }
    }

    public static void drawSpecialMeter(int percent) {
        int y = grh.h - 6 - 16;
        int x = 6;
        int w = special_bar.getWidth() + 12;
        int h = special_mark.getHeight();
        int offset_y = (special_mark.getHeight() - special_bar.getHeight()) / 2;
        int offset_x = (special_adjust.getWidth() - special_mark.getWidth()) / 2;
        GUI.drawFightBox(x, y, w, h, 4653313, true, false);
        grh.g.drawImage(special_bar, x + 6, y + offset_y, 0);
        grh.g.drawImage(special_mark, x + 6 + special_bar.getWidth() * 2 / 3, y, 0);
        if (percent >= 100) {
            grh.g.drawImage(special_adjust, x + 6 - offset_x + AEMath.min(special_bar.getWidth(), percent * special_bar.getWidth() * 2 / 3 / 100 + 2), y, 0);
        } else {
            grh.g.drawImage(special_adjust, x + 6 - offset_x + AEMath.min(special_bar.getWidth(), percent * special_bar.getWidth() * 2 / 3 / 100), y, 0);
        }
    }

    public static void drawPauseIcon() {
        grh.g.drawImage(pause_icon, grh.w - pause_icon.getWidth() - 6, grh.h - pause_icon.getHeight() - 6, 0);
    }

    public static void drawBorderHint(Fighter player, Fighter opponent) {
        if (player.displayBorders()) {
            if ((player.getBorderMark() & 4) != 0) {
                border_arrow.setTransform(3);
                border_arrow.setPosition(5, grh.h / 2 - border_arrow.getHeight() / 2);
                border_arrow.paint(grh.g);
            }
            if ((player.getBorderMark() & 2) != 0) {
                border_arrow.setTransform(6);
                border_arrow.setPosition(grh.w / 2 - border_arrow.getWidth() / 2, 31 + eagle.getHeight());
                border_arrow.paint(grh.g);
            }
            if ((player.getBorderMark() & 8) != 0) {
                border_arrow.setTransform(5);
                border_arrow.setPosition(grh.w / 2 - border_arrow.getWidth() / 2, grh.h - 5 - 26 - eagle.getHeight());
                border_arrow.paint(grh.g);
            }
        }
    }

    public static void drawRedBox(int x, int y, int width, int height, boolean lower_line) {
        grh.g.setClip(x, y, width, height);
        for (int i = x; i < x + width; i += menu_bg.getWidth()) {
            grh.g.drawImage(menu_bg, i, y, 0);
        }
        grh.g.setClip(0, 0, grh.w, grh.h);
        if (lower_line) {
            grh.g.setColor(3217416);
            grh.g.drawLine(x, y + height - 3, x + width - 1, y + height - 3);
            grh.g.setColor(8479041);
            grh.g.drawLine(x, y + height - 2, x + width - 1, y + height - 2);
            grh.g.setColor(4598034);
            grh.g.drawLine(x, y + height - 1, x + width - 1, y + height - 1);
            grh.g.setColor(0);
            grh.g.drawLine(x, y + height, x + width - 1, y + height);
        } else {
            grh.g.setColor(3217416);
            grh.g.drawLine(x, y, x + width - 1, y);
            grh.g.setColor(8479041);
            grh.g.drawLine(x, y + 1, x + width - 1, y + 1);
            grh.g.setColor(4598034);
            grh.g.drawLine(x, y + 2, x + width - 1, y + 2);
            grh.g.setColor(0);
            grh.g.drawLine(x, y + 3, x + width - 1, y + 3);
        }
    }

    public static void drawLines(int x, int y, int width) {
        grh.g.setColor(3217416);
        grh.g.drawLine(x, y - 3, x + width - 1, y - 3);
        grh.g.setColor(8479041);
        grh.g.drawLine(x, y - 2, x + width - 1, y - 2);
        grh.g.setColor(4598034);
        grh.g.drawLine(x, y - 1, x + width - 1, y - 1);
        grh.g.setColor(0);
        grh.g.drawLine(x, y, x + width - 1, y);
    }

    public static void drawFightInterface() {
        GUI.drawFightBox(2, 6, grh.w - 4, 21, 4653313, false, false);
        GUI.drawFightBox(grh.w / 2 - 25, 5, 50, 26, 921102, true, true);
        grh.g.drawImage(names[0], 2, 30, 0);
        grh.g.drawImage(names[1], grh.w - 2 - names[1].getWidth(), 30, 0);
    }

    public static int getLessonTitleY() {
        return 30 + names[0].getHeight() + 12;
    }

    public static void drawFightBox(int x, int y, int width, int height, int color, boolean draw_corners, boolean draw_eagle) {
        grh.g.setColor(color);
        grh.g.fillRect(x, y, width, height);
        grh.g.setColor(0);
        grh.g.drawLine(x, y, x + width, y);
        grh.g.drawLine(x + width, y, x + width, y + height);
        grh.g.drawLine(x, y + height, x + width, y + height);
        grh.g.drawLine(x, y, x, y + height);
        grh.g.setColor(3483672);
        grh.g.drawLine(x + 1, y + 1, x + width - 1, y + 1);
        grh.g.drawLine(x + width - 1, y + 1, x + width - 1, y + height - 1);
        grh.g.drawLine(x + 1, y + height - 1, x + width - 1, y + height - 1);
        grh.g.drawLine(x + 1, y + 1, x + 1, y + height - 1);
        grh.g.setColor(10249786);
        grh.g.drawLine(x + 2, y + 2, x + width - 2, y + 2);
        grh.g.drawLine(x + width - 2, y + 2, x + width - 2, y + height - 2);
        grh.g.drawLine(x + 2, y + height - 2, x + width - 2, y + height - 2);
        grh.g.drawLine(x + 2, y + 2, x + 2, y + height - 2);
        grh.g.setColor(0);
        grh.g.drawLine(x + 3, y + 3, x + width - 3, y + 3);
        grh.g.drawLine(x + width - 3, y + 3, x + width - 3, y + height - 3);
        grh.g.drawLine(x + 3, y + height - 3, x + width - 3, y + height - 3);
        grh.g.drawLine(x + 3, y + 3, x + 3, y + height - 3);
        if (draw_corners) {
            corner_box.setTransform(6);
            corner_box.setPosition(x - 1, y - 1);
            corner_box.paint(grh.g);
            corner_box.setTransform(0);
            corner_box.setPosition(x + width + 2 - corner_box.getWidth(), y - 1);
            corner_box.paint(grh.g);
            corner_box.setTransform(5);
            corner_box.setPosition(x + width + 2 - corner_box.getWidth(), y + height + 2 - corner_box.getHeight());
            corner_box.paint(grh.g);
            corner_box.setTransform(3);
            corner_box.setPosition(x - 1, y + height + 2 - corner_box.getHeight());
            corner_box.paint(grh.g);
        }
        if (draw_eagle) {
            grh.g.drawImage(eagle, x + width / 2 - eagle.getWidth() / 2, y + height - 4 - 0, 0);
        }
    }

    public static void drawBox(int x, int y, int width, int height) {
        grh.g.setColor(921102);
        grh.g.fillRect(x, y, width, height);
        grh.g.setColor(3217416);
        grh.g.drawLine(x, y, x + width - 1, y);
        grh.g.setColor(8479041);
        grh.g.drawLine(x, y + 1, x + width - 1, y + 1);
        grh.g.setColor(4598034);
        grh.g.drawLine(x, y + 2, x + width - 1, y + 2);
        grh.g.setColor(0);
        grh.g.drawLine(x, y + 3, x + width - 1, y + 3);
        grh.g.setColor(3217416);
        grh.g.drawLine(x, y + height - 3, x + width - 1, y + height - 3);
        grh.g.setColor(8479041);
        grh.g.drawLine(x, y + height - 2, x + width - 1, y + height - 2);
        grh.g.setColor(4598034);
        grh.g.drawLine(x, y + height - 1, x + width - 1, y + height - 1);
        grh.g.setColor(0);
        grh.g.drawLine(x, y + height, x + width - 1, y + height);
    }

    public static int getMenuBorderHeight() {
        if (menu_border == null) {
            return 0;
        }
        return menu_border.getHeight();
    }

    public static int getMenuBGHeight() {
        return menu_border.getHeight() * 2 + menu_bg.getHeight();
    }

    private static void drawMenuBG(int bottom_y) {
        int i;
        for (i = 0; i < grh.w; i += menu_border.getWidth()) {
            grh.g.drawImage(menu_border, i, bottom_y - menu_border.getHeight(), 0);
        }
        for (i = 0; i < grh.w; i += menu_bg.getWidth()) {
            grh.g.drawImage(menu_bg, i, bottom_y - menu_border.getHeight() - menu_bg.getHeight(), 0);
        }
        for (i = 0; i < grh.w; i += menu_border.getWidth()) {
            grh.g.drawImage(menu_border, i, bottom_y - 2 * menu_border.getHeight() - menu_bg.getHeight(), 0);
        }
    }

    private static void drawMenuBG(int top, int bottom) {
        int i;
        grh.g.setClip(0, top, grh.w, bottom);
        for (int j = 0; j < bottom - top - 2 * menu_border.getHeight(); j += menu_bg.getHeight()) {
            for (int i2 = 0; i2 < grh.w; i2 += menu_bg.getWidth()) {
                grh.g.drawImage(menu_bg, i2, top + menu_border.getHeight() + j, 0);
            }
        }
        for (i = 0; i < grh.w; i += menu_border.getWidth()) {
            grh.g.drawImage(menu_border, i, bottom - menu_border.getHeight(), 0);
        }
        for (i = 0; i < grh.w; i += menu_border.getWidth()) {
            grh.g.drawImage(menu_border, i, top, 0);
        }
        grh.g.setClip(0, 0, grh.w, grh.h);
    }

    public static void drawMenuBackground() {
        GUI.drawMenuBG(grh.h - 20 - menu_bg.getHeight() - 2 * menu_border.getHeight(), grh.h - 20);
    }

    public static void drawMenuBackground(int top, int bottom) {
        GUI.drawMenuBG(top, bottom);
    }

    private static void drawFooter() {
        grh.g.setColor(921102);
        grh.g.fillRect(0, grh.h - 20, grh.w, 20);
    }

    public static void drawFooter(String leftString, String middleString, String rightString) {
        GUI.drawFooter();
        AEFont.setFont((byte)0);
        if (leftString != null) {
            AEFont.drawString(leftString, 5, grh.h - 7, 33);
        }
        if (rightString != null) {
            AEFont.drawString(rightString, grh.w - 5, grh.h - 7, 34);
        }
        if (middleString != null) {
            if (middleString.equals("drawArrows()")) {
                grh.g.drawImage(imgArrows, grh.w / 2 - imgArrows.getWidth() / 2, grh.h - 6 - imgArrows.getHeight(), 0);
            } else {
                AEFont.drawString(middleString, grh.w / 2, grh.h - 7, 40);
            }
        }
    }

    public static void drawHeader(String leftString, String rightString) {
        AEFont.setFont((byte)0);
        if (leftString != null) {
            AEFont.drawString(leftString, 5, 3, 17);
        }
        if (rightString != null) {
            AEFont.drawString(rightString, grh.w - 5, 3, 18);
        }
    }

    public static final Image getCharacterLogo(int id) {
        switch (id) {
            case 1: {
                return ImgAdjust.getCypherImage("/data/2d/240x320/logo_ama.png");
            }
            case 3: {
                return ImgAdjust.getCypherImage("/data/2d/240x320/logo_bull.png");
            }
            case 8: {
                return ImgAdjust.getCypherImage("/data/2d/240x320/logo_com.png");
            }
            case 5: {
                return ImgAdjust.getCypherImage("/data/2d/240x320/logo_hag.png");
            }
            case 2: {
                return ImgAdjust.getCypherImage("/data/2d/240x320/logo_jub.png");
            }
            case 0: {
                return ImgAdjust.getCypherImage("/data/2d/240x320/logo_mac.png");
            }
            case 7: {
                return ImgAdjust.getCypherImage("/data/2d/240x320/logo_max.png");
            }
            case 6: {
                return ImgAdjust.getCypherImage("/data/2d/240x320/logo_tig.png");
            }
            case 4: {
                return ImgAdjust.getCypherImage("/data/2d/240x320/logo_trid.png");
            }
        }
        return ImgAdjust.getCypherImage("/data/2d/240x320/logo_max.png");
    }

    public static final Image getCharacterIcon(int id) {
        switch (id) {
            case 1: {
                return ImgAdjust.getCypherImage("/data/2d/240x320/icon_amazon.png");
            }
            case 3: {
                return ImgAdjust.getCypherImage("/data/2d/240x320/icon_bovinus.png");
            }
            case 8: {
                return ImgAdjust.getCypherImage("/data/2d/240x320/icon_commodus.png");
            }
            case 5: {
                return ImgAdjust.getCypherImage("/data/2d/240x320/icon_hagen.png");
            }
            case 2: {
                return ImgAdjust.getCypherImage("/data/2d/240x320/icon_juba.png");
            }
            case 0: {
                return ImgAdjust.getCypherImage("/data/2d/240x320/icon_mace.png");
            }
            case 7: {
                return ImgAdjust.getCypherImage("/data/2d/240x320/icon_maximus.png");
            }
            case 6: {
                return ImgAdjust.getCypherImage("/data/2d/240x320/icon_tiger.png");
            }
            case 4: {
                return ImgAdjust.getCypherImage("/data/2d/240x320/icon_trident.png");
            }
        }
        return ImgAdjust.getCypherImage("/data/2d/240x320/icon_maximus.png");
    }

    public static final Image getCharacterFightName(int id) {
        switch (id) {
            case 1: {
                return ImgAdjust.getCypherImage("/data/2d/240x320/ingame_ama.png");
            }
            case 3: {
                return ImgAdjust.getCypherImage("/data/2d/240x320/ingame_bull.png");
            }
            case 8: {
                return ImgAdjust.getCypherImage("/data/2d/240x320/ingame_com.png");
            }
            case 5: {
                return ImgAdjust.getCypherImage("/data/2d/240x320/ingame_hag.png");
            }
            case 2: {
                return ImgAdjust.getCypherImage("/data/2d/240x320/ingame_jub.png");
            }
            case 0: {
                return ImgAdjust.getCypherImage("/data/2d/240x320/ingame_mac.png");
            }
            case 7: {
                return ImgAdjust.getCypherImage("/data/2d/240x320/ingame_max.png");
            }
            case 6: {
                return ImgAdjust.getCypherImage("/data/2d/240x320/ingame_tig.png");
            }
            case 4: {
                return ImgAdjust.getCypherImage("/data/2d/240x320/ingame_trid.png");
            }
        }
        return ImgAdjust.getCypherImage("/data/2d/240x320/ingame_max.png");
    }

    public static int getSelectionWingHeight() {
        return selectionWing.getHeight();
    }

    public static void drawSelectionWing(boolean left, int x, int y) {
        if (left) {
            selectionWing.setTransform(0);
            selectionWing.setPosition(x - selectionWing.getWidth() - 3, y + -2);
        } else {
            selectionWing.setTransform(2);
            selectionWing.setPosition(x + 3, y + -2);
        }
        selectionWing.paint(grh.g);
    }

    public static void release() {
        int i;
        if (names != null) {
            for (i = 0; i < names.length; ++i) {
                GUI.names[i] = null;
            }
            names = null;
        }
        if (damage_up != null) {
            for (i = 0; i < damage_up.length; ++i) {
                GUI.damage_up[i] = null;
            }
            damage_up = null;
        }
        border_arrow = null;
        tut_dpad = null;
        tut_arrow_hold = null;
        tut_arrow_press = null;
        tut_button_hold = null;
        tut_button_press = null;
        tut_press = null;
        tut_hold = null;
        tut_num1 = null;
        tut_num2 = null;
        tut_hash = null;
        tut_hash_press = null;
        tut_hash_hold = null;
        tut_star = null;
        tut_star_press = null;
        tut_star_hold = null;
        special_adjust = null;
        special_bar = null;
        special_mark = null;
        mask = null;
        jewel = null;
        eagle = null;
        colloseum = null;
        gradient = null;
        numbers = null;
        noend = null;
        selectionWing = null;
        imgPattern = null;
        imgArrows = null;
        menu_bg = null;
        menu_border = null;
        pause_icon = null;
        corner_box = null;
    }

    static {
        tutorial_button_highlights = new int[][]{{1, 1, 1, 2, 1, 3, 1, 0}, {1, 4}, {1, 4}, {0, 4, 0, 5}, {0, 5, 1, 3}, {0, 5, 1, 2, 1, 1}, {0, 1}, {1, 3}, {1, 0, 0, 5}};
        TICK = 200;
    }
}

