/*
 * Decompiled with CFR 0.152.
 */
package Main;

import AbyssEngine.AEDevice;
import AbyssEngine.AERenderer;
import FLToolkit.AEFont;
import FLToolkit.AELoadingScreen;
import FLToolkit.AEModule;
import FLToolkit.AEModuleHandle;
import FLToolkit.GameText;
import FLToolkit.Sound;
import FLToolkit.TextOutput;
import FLToolkit.grh;
import GameEssentials.ContentPool;
import Main.MainMIDlet;
import Main.ModFight;
import Main.ModMenu;
import Main.ModTitle;
import com.Fishlabs.AEBluetooth.FLBluetooth;
import java.util.Random;
import javax.microedition.lcdui.game.GameCanvas;

public class MainCanvas
extends GameCanvas {
    private MainMIDlet app;
    private int keyStates;
    private int keyEvents;
    private AEModuleHandle currentHandle = null;
    private AELoadingScreen loadingScreen;
    protected boolean first = true;
    protected boolean init = false;

    MainCanvas(MainMIDlet app) {
        super(false);
        this.app = app;
        this.setFullScreenMode(true);
        grh.canvas = this;
        grh.rnd = new Random();
        grh.midlet = app;
        try {
            grh.version = "v " + app.getAppProperty("MIDlet-Version");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void pause() {
        if (this.currentHandle != null) {
            this.currentHandle.pause();
        }
    }

    public void showError(String error) {
        grh.g.drawString(error, 0, 0, 0);
        this.flushGraphics();
    }

    synchronized void processPaint() {
        if (this.first) {
            this.first = false;
            this.flushGraphics();
            return;
        }
        if (!this.init) {
            this.init = true;
            grh.g = this.getGraphics();
            grh.w = this.getWidth();
            grh.h = this.getHeight();
            grh.text = new TextOutput();
            this.loadingScreen = new AELoadingScreen();
            this.loadingScreen.setCanvas(this);
            this.loadingScreen.start();
            grh.sound = new Sound();
            grh.m_Sound = false;
            grh.display = this.app.getDisplay();
            grh.device = AEDevice.create();
            grh.renderer = new AERenderer(grh.device);
            grh.renderer.addLayer(true);
            grh.renderer.addLayer(true);
            grh.renderer.addLayer(true);
            grh.renderer.addLayer(true);
            AEFont.setGraphics(grh.g);
            AEFont.addFont("/data/2d/240x320/font_gladiator_small.png", (byte)2, 15, 16);
            AEFont.setRowHeight(12, 0);
            AEFont.setSpacing(1, 0);
            AEFont.addFont("/data/2d/240x320/font_gladiator_big.png", (byte)1, 9, 16);
            AEFont.setRowHeight(20, 1);
            AEFont.setSpacing(0, 1);
            ContentPool.prepareResources();
            grh.loadSettings();
            grh.loadRecords();
            grh.gameText = new GameText();
            grh.gameText.setLanguage(grh.lang);
            grh.last_unlocked_character = grh.unlocked_character;
            grh.last_unlocked_difficulty = grh.unlocked_difficulty;
            FLBluetooth.init(3);
            grh.handle = this.currentHandle = new AEModuleHandle(this, this.loadingScreen);
            grh.modules = new AEModule[3];
            grh.modules[1] = new ModTitle();
            grh.modules[0] = new ModMenu();
            grh.modules[2] = new ModFight();
            this.currentHandle.setModule(grh.modules[1]);
        }
        this.currentHandle.process();
        this.flushGraphics();
    }

    void clearResource() {
        FLBluetooth.release();
        ContentPool.finalRelease();
    }

    synchronized void processKeyState() {
        this.keyStates = this.keyEvents;
    }

    public synchronized void keyPressed(int keyCode) {
        if (this.currentHandle != null) {
            this.currentHandle.onKeyPress(keyCode);
        }
    }

    public synchronized void keyRepeated(int keyCode) {
    }

    public void hideNotify() {
        this.pause();
    }

    public void showNotify() {
    }

    public synchronized void keyReleased(int keyCode) {
        if (this.currentHandle != null) {
            this.currentHandle.onKeyRelease(keyCode);
        }
    }

    public AEModuleHandle getHandle() {
        return this.currentHandle;
    }
}

