/*
 * Decompiled with CFR 0.152.
 */
package Main;

import AbyssEngine.AEAnimationController;
import AbyssEngine.AECamera;
import AbyssEngine.AEEaseInOut;
import AbyssEngine.AEGeometry;
import AbyssEngine.AEGroup;
import AbyssEngine.AEKeyFrameTransform;
import AbyssEngine.AELookAtConstraint;
import AbyssEngine.AEMath;
import AbyssEngine.AEResourceManager;
import AbyssEngine.AEScene;
import AbyssEngine.AETransform;
import AbyssEngine.AEVector3D;
import FLToolkit.AEFont;
import FLToolkit.AEModule;
import FLToolkit.ChoiceWindow;
import FLToolkit.ImgAdjust;
import FLToolkit.MenuItem;
import FLToolkit.ScrollTextBox;
import FLToolkit.SimpleMenu;
import FLToolkit.Sound;
import FLToolkit.Weather;
import FLToolkit.WeatherSnow3DSim;
import FLToolkit.grh;
import GameEssentials.Arena;
import GameEssentials.Fighter;
import GameEssentials.FighterAI;
import GameEssentials.GUI;
import Main.ModMenu;
import com.Fishlabs.AEBluetooth.FLBluetooth;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Image;

public class ModFight
extends AEModule {
    private static boolean DISABLE_AI = false;
    private static boolean SHOW_FPS = false;
    private static boolean WRITE_PROTOCOL_FILE = false;
    private long prot_id = 0L;
    private static final int NO_OF_CAM_ANIMS = 30;
    private static final int TARGET_Y = 200;
    private static final int[] basic_damages = new int[]{5, 5, 5, 5, 20, 3};
    private static final int[] damage_multipliers = new int[]{1, 1, 1, 1, 2, 1};
    private static final int DOUBLE_PRESS_MILLIS = 250;
    private static final int ROUND_TIME = 90000;
    private static final int SURVIVAL_WINS = 1;
    private static final int INTRO_TIME = 3000;
    private static final int OUTRO_TIME = 5000;
    private static final int CONTINUE_TIME = 9999;
    private static final int GAME_OVER_SCENE_TIME = 6500;
    private static final int CONTINUE_SCENE_TIME = 2500;
    private static final int CONTINUE_COST_EASY = 150;
    private static final int CONTINUE_COST_NORMAL = 150;
    private static final int CONTINUE_COST_HARD = 200;
    private static final int BLOCK_START_TIME = 200;
    private static final int TUTORIAL_LESSON_TIME = 30000;
    private static final int QUOTE_DISPLAY_TIME = 3500;
    private static final int STATE_PRE_FIGHT = 0;
    private static final int STATE_POST_FIGHT = 1;
    private static final int STATE_FIGHT = 2;
    private static final int STATE_PAUSE = 3;
    private static final int STATE_NEXT_FIGHT = 4;
    private static final int STATE_CONTINUE_QUESTION = 5;
    private static final int STATE_GAME_OVER = 6;
    private static final int STATE_CONTINUE_DECISION = 7;
    private static final int STATE_ARCADE_OUTRO_SEQUENCE = 8;
    private static final int STATE_SURVIVAL_OVER = 9;
    private static final int STATE_ADD_FAME = 10;
    private static final int STATE_CONTINUE = 11;
    private static final int STATE_LESSON_COMMENT = 12;
    private static final int STATE_LESSON_DEMO = 13;
    private static final int STATE_LESSON = 14;
    private static final int STATE_LESSON_SHOW_ME = 15;
    private static final int STATE_LESSON_OVER = 16;
    private static final int STATE_LESSON_HINT = 17;
    private static final int STATE_HINT = 18;
    private static final int INGAME_PAUSE_MENU = 0;
    private static final int INGAME_PAUSE_MENU_LESSON_SELECT = 1;
    private static final int PAUSE_RESUME = 0;
    private static final int PAUSE_SOUND = 1;
    private static final int PAUSE_VIBRATION = 2;
    private static final int PAUSE_CONTROLS = 3;
    private static int PAUSE_QUIT = 4;
    private static int PAUSE_SKIP_LESSON = -1;
    private static int PAUSE_RESTART_LESSON = -1;
    private static int PAUSE_SELECT_LESSON = -1;
    private static final int CAM_INTRO = 27;
    private static final int CAM_MERCY = 28;
    private static final int CAM_DEATH = 29;
    private SimpleMenu ingame_menu;
    private ChoiceWindow choiceWindow;
    private boolean showMsg;
    private int selection_mark_time;
    private int margin_left;
    private ScrollTextBox box;
    private boolean showBox;
    private static final int COUNTDOWN_DECS_PER_SECOND = 30;
    private static final int MASK_SIZE = 32;
    private int[] mask;
    private int fadeAlpha;
    private AETransform playerTransform;
    private Arena arena;
    private Fighter player;
    private Fighter opponent;
    private FighterAI fighterAI;
    private AECamera cam;
    private AEScene scene;
    private AEGroup target;
    private AELookAtConstraint lookat;
    private AEAnimationController[] camAnim;
    private AEAnimationController[] targetAnim;
    private AEGeometry sponsorMesh;
    private Image defeat;
    private Image damage_up1;
    private Image damage_up2;
    private Image special_raster;
    private Image[] awards;
    private static final int MARGIN = 6;
    private static final int TEXT_OFFSET = 1;
    private static final int NUMBERS_OFFSET = 2;
    private boolean[] fire_held;
    private boolean[] star_held;
    private int[] hold_fire;
    private int[] special_move_step;
    private int[] special_move_step_time;
    private int[] block_held_time;
    private static final int TEXT_SPEED = 50;
    private static int NBR_OF_LINES;
    private int top_line_index;
    private String[] lines;
    private String[] output;
    private String outro_text;
    private int outro_step;
    private boolean text_fully_displayed;
    private int needed_wins;
    private int round_time;
    private int round;
    private int required_fame;
    private int displayed_fame;
    private int state;
    private int pre_pause_state;
    private int intro_time;
    private int outro_time;
    private int continue_time;
    private int game_over_time;
    private int fame_countdown_time;
    private long pause_time;
    private long pause_time_slowmo;
    private boolean renderPlayer;
    private long slow_mo_time;
    private int cameraID;
    private int add_fame;
    private AEEaseInOut ease;
    private int old_fame;
    private boolean display_quote = false;
    private String[] quote_text;
    private String quote_character;
    private InputStream is;
    private byte[] data;
    private StringBuffer currentToken;
    private int init = 10;
    private ByteArrayOutputStream bout = null;
    private DataOutputStream oos = null;
    private ByteArrayInputStream bin = null;
    private DataInputStream oin = null;
    private int sent_p_anim;
    private int sent_o_anim;
    private int sent_p_fame;
    private int sent_o_fame;
    private int[] data_p;
    private int[] data_o;
    private boolean sendSpecialNext;
    private boolean sendSlowMoEnd;
    private boolean p_anim_end;
    private boolean o_anim_end;
    private int deathsent = 0;
    private int minusOneCount = 0;
    private int minusOneSent = 0;
    public boolean erase_saved_game = false;
    private Image proximo;
    private int lesson_step;
    private int demo_step;
    private int tutorial_time;
    private String[] tutorial_text;
    private int tutorial_text_line;
    private int text_display_time;
    private static final int TUTORIAL_NUMBER_OF_LINES = 3;
    private static final int TUTORIAL_NUMBER_OF_LESSONS = 9;
    private long[][] tutorial_bit_masks = new long[][]{{0x3C0000L, 0L}, {8L, 65536L}, {256L, 0L}, {2048L, 0L}, {0x1000000L, 0L}, {0x40000000L, 0L}, {4096L, 0L}, {0L, 0x4000000L}, {2L, 0L}};
    private Weather confetti;
    private boolean new_record;
    private int reputation;
    private byte last_p_trails;
    private byte last_o_trails;
    private static final byte TRAILS_NONE = 0;
    private static final byte TRAILS_RED = 1;
    private static final byte TRAILS_BLUE = 2;
    private boolean isInitialized;
    static /* synthetic */ Class class$java$lang$Class;

    private Fighter createFighter(Fighter fighter, int id) {
        fighter = new Fighter(id, 20 + id);
        fighter.setName(grh.fighter_names[id]);
        fighter.setStrength(grh.char_attributes[id][0]);
        fighter.setAgility(grh.char_attributes[id][1]);
        fighter.setConstitution(grh.char_attributes[id][2]);
        fighter.setCharisma(grh.char_attributes[id][3]);
        return fighter;
    }

    public int onInitialize() {
        this.isInitialized = false;
        switch (this.init) {
            case 10: {
                this.display_quote = false;
                this.erase_saved_game = false;
                this.ingame_menu = new SimpleMenu();
                int menu_len = 5;
                if (grh.game_mode == 4) {
                    menu_len = 8;
                    if (this.round >= 8) {
                        menu_len = 7;
                    }
                }
                MenuItem[] rootMenu = new MenuItem[menu_len];
                rootMenu[0] = new MenuItem(grh.gameText.getText(20), null);
                rootMenu[1] = new MenuItem(grh.gameText.getText(26), new String[]{grh.gameText.getText(27), "25%", "50%", "75%", "100%"});
                rootMenu[2] = new MenuItem(grh.gameText.getText(29), new String[]{grh.gameText.getText(28), grh.gameText.getText(27)});
                if (grh.vibration) {
                    rootMenu[2].setToggleIndex(0);
                } else {
                    rootMenu[2].setToggleIndex(1);
                }
                rootMenu[1].setToggleIndex(grh.volume);
                rootMenu[3] = new MenuItem(grh.gameText.getText(22), null);
                if (grh.game_mode == 4) {
                    PAUSE_RESTART_LESSON = 4;
                    if (this.round < 8) {
                        PAUSE_SKIP_LESSON = 5;
                        PAUSE_SELECT_LESSON = 6;
                    } else {
                        PAUSE_SKIP_LESSON = -1;
                        PAUSE_SELECT_LESSON = 5;
                    }
                    PAUSE_QUIT = PAUSE_SELECT_LESSON + 1;
                    rootMenu[ModFight.PAUSE_RESTART_LESSON] = new MenuItem(grh.gameText.getText(119), null);
                    if (PAUSE_SKIP_LESSON != -1) {
                        rootMenu[ModFight.PAUSE_SKIP_LESSON] = new MenuItem(grh.gameText.getText(120), null);
                    }
                    rootMenu[ModFight.PAUSE_SELECT_LESSON] = new MenuItem(grh.gameText.getText(121), null);
                } else {
                    PAUSE_QUIT = 4;
                }
                rootMenu[ModFight.PAUSE_QUIT] = new MenuItem(grh.gameText.getText(117), null);
                this.ingame_menu.addMenu(0, null, rootMenu);
                if (grh.game_mode == 4) {
                    MenuItem[] lesson_menu = new MenuItem[9];
                    for (int i = 0; i < lesson_menu.length; ++i) {
                        lesson_menu[i] = new MenuItem(grh.gameText.getText(169 + i), null);
                    }
                    this.ingame_menu.addMenu(1, new int[]{PAUSE_SELECT_LESSON}, lesson_menu);
                }
                this.box = new ScrollTextBox(grh.gameText.getText(45));
                break;
            }
            case 9: {
                if (grh.current_fight == 4 && grh.game_mode == 0) {
                    this.arena = new Arena(100, false);
                } else if (grh.game_mode == 4) {
                    grh.current_fight = -1;
                    this.arena = new Arena(110, false);
                } else {
                    this.arena = new Arena(110, false);
                }
                this.player = this.createFighter(this.player, grh.char_id);
                this.opponent = this.createFighter(this.opponent, grh.opponent_id);
                this.player.setPosition(0);
                this.opponent.setPosition(1);
                this.player.setOpponent(this.opponent);
                this.opponent.setOpponent(this.player);
                this.player.setIsPlayer(true);
                this.opponent.setIsPlayer(false);
                break;
            }
            case 8: {
                this.fire_held = new boolean[2];
                this.star_held = new boolean[2];
                this.hold_fire = new int[2];
                this.special_move_step = new int[2];
                this.special_move_step_time = new int[2];
                this.block_held_time = new int[2];
                if (grh.game_mode != 0) break;
                this.sponsorMesh = AEResourceManager.getGeometryResource(9);
                this.sponsorMesh.setAnimRange(0, 0);
                this.sponsorMesh.playAnim((byte)2);
                this.sponsorMesh.setTranslation(60, 330, -1450);
                this.sponsorMesh.rotate(0, -1600, 0);
                this.sponsorMesh.setLayer(3);
                this.sponsorMesh.enableLight(true);
                break;
            }
            case 7: {
                this.defeat = ImgAdjust.getCypherImage("/data/2d/240x320/def_blood.png");
                this.cam = AECamera.create(grh.w, grh.h, 720, 100, 32000);
                this.cam.translate(0, 600, 2400);
                this.cam.rotate(0, 0, 0);
                grh.renderer.setCamera(this.cam);
                this.target = new AEGroup();
                break;
            }
            case 6: {
                int i;
                AEKeyFrameTransform kft = new AEKeyFrameTransform();
                this.camAnim = new AEAnimationController[30];
                for (i = 0; i < this.camAnim.length; ++i) {
                    this.camAnim[i] = new AEAnimationController();
                }
                for (i = 0; i < this.camAnim.length; ++i) {
                    kft = new AEKeyFrameTransform();
                    kft.setTarget(this.cam);
                    kft.setTranslationFrames(this.readCamPositions("/data/cameras/cam_" + i + ".txt"));
                    this.camAnim[i].addKeyFrameTransform(kft);
                    kft = null;
                }
                this.targetAnim = new AEAnimationController[30];
                for (i = 0; i < this.targetAnim.length; ++i) {
                    this.targetAnim[i] = new AEAnimationController();
                }
                for (i = 0; i < this.targetAnim.length; ++i) {
                    kft = new AEKeyFrameTransform();
                    kft.setTarget(this.target);
                    kft.setTranslationFrames(this.readCamPositions("/data/cameras/target_" + i + ".txt"));
                    this.targetAnim[i].addKeyFrameTransform(kft);
                    kft = null;
                }
                break;
            }
            case 5: {
                this.scene = new AEScene();
                this.scene.addChild(this.cam);
                this.scene.addChild(this.target);
                this.lookat = new AELookAtConstraint(this.target, this.cam);
                this.scene.addConstraint(this.lookat);
                this.fadeAlpha = 0;
                if (this.mask == null) {
                    this.mask = new int[1024];
                    for (int i = 0; i < this.mask.length; ++i) {
                        this.mask[i] = 11161088;
                    }
                }
                GUI.initFightModule(grh.char_id, grh.opponent_id);
                break;
            }
            case 4: {
                if (this.choiceWindow == null) {
                    this.choiceWindow = new ChoiceWindow();
                }
                this.margin_left = (int)((float)grh.w * 0.125f);
                switch (grh.game_mode) {
                    case 0: {
                        this.needed_wins = 2;
                        this.round = 0;
                        break;
                    }
                    case 1: {
                        this.needed_wins = 1;
                        this.player.setHitPoints(grh.survival_hp);
                        break;
                    }
                    case 4: {
                        this.proximo = ImgAdjust.getCypherImage("/data/2d/240x320/tut_proximo.png");
                        break;
                    }
                    default: {
                        this.needed_wins = 2;
                        this.round = 0;
                    }
                }
                this.awards = new Image[3];
                this.awards[0] = ImgAdjust.getCypherImage("/data/2d/240x320/vict_bronze.png");
                this.awards[1] = ImgAdjust.getCypherImage("/data/2d/240x320/vict_silver.png");
                this.awards[2] = ImgAdjust.getCypherImage("/data/2d/240x320/vict_gold.png");
                this.special_raster = ImgAdjust.getCypherImage("/data/2d/240x320/filter_red.png");
                grh.sound.stop();
                if (grh.volume != 0) {
                    grh.sound.stop();
                }
                if (grh.game_mode != 3) break;
                this.bout = new ByteArrayOutputStream();
                this.oos = new DataOutputStream(this.bout);
                byte[] ba = new byte[]{1, (byte)grh.char_id};
                FLBluetooth.send(ba);
                break;
            }
            case 2: {
                break;
            }
            case 1: {
                this.opponent.setWaitForSpecialResult(false);
                this.player.setWaitForSpecialResult(false);
                if (grh.game_mode == 3) {
                    this.opponent.setWaitForSpecialResult(true);
                    this.player.setWaitForSpecialResult(false);
                    this.data_o = new int[6];
                    this.data_p = new int[6];
                    FLBluetooth.update();
                    if (FLBluetooth.dataReceived()) {
                        byte[] bba = FLBluetooth.getReceivedData();
                        if (bba[0] != 1) {
                            return this.init;
                        }
                    } else {
                        return this.init;
                    }
                }
                this.initNewFight();
                if (grh.resume_last_game && grh.game_mode != 2 && grh.game_mode != 2) {
                    grh.resume_last_game = false;
                    this.loadSpecificFightData();
                }
                this.isInitialized = true;
            }
        }
        --this.init;
        return this.init;
    }

    public void onRelease() {
        int i;
        this.isInitialized = false;
        this.init = 10;
        if (this.erase_saved_game) {
            grh.deleteLastGame(grh.game_mode);
        }
        this.ingame_menu = null;
        if (this.choiceWindow != null) {
            this.choiceWindow.release();
        }
        this.choiceWindow = null;
        this.mask = null;
        this.playerTransform = null;
        if (this.arena != null) {
            this.arena.release();
        }
        this.arena = null;
        if (this.player != null) {
            this.player.release();
        }
        this.player = null;
        if (this.opponent != null) {
            this.opponent.release();
        }
        this.opponent = null;
        this.fighterAI = null;
        this.cam = null;
        this.scene = null;
        this.target = null;
        this.lookat = null;
        this.box = null;
        this.ease = null;
        if (this.camAnim != null) {
            for (i = 0; i < this.camAnim.length; ++i) {
                this.camAnim[i] = null;
            }
            this.camAnim = null;
        }
        if (this.targetAnim != null) {
            for (i = 0; i < this.targetAnim.length; ++i) {
                this.targetAnim[i] = null;
            }
            this.targetAnim = null;
        }
        this.sponsorMesh = null;
        this.defeat = null;
        this.special_raster = null;
        if (this.awards != null) {
            for (i = 0; i < this.awards.length; ++i) {
                this.awards[i] = null;
            }
            this.awards = null;
        }
        this.fire_held = null;
        this.star_held = null;
        this.hold_fire = null;
        this.special_move_step = null;
        this.special_move_step_time = null;
        this.block_held_time = null;
        if (this.lines != null) {
            for (i = 0; i < this.lines.length; ++i) {
                this.lines[i] = null;
            }
            this.lines = null;
        }
        if (this.output != null) {
            for (i = 0; i < this.output.length; ++i) {
                this.output[i] = null;
            }
            this.output = null;
        }
        this.is = null;
        this.data = null;
        this.currentToken = null;
        this.proximo = null;
        if (this.tutorial_text != null) {
            for (i = 0; i < this.tutorial_text.length; ++i) {
                this.tutorial_text[i] = null;
            }
            this.tutorial_text = null;
        }
        this.confetti = null;
        this.bout = null;
        this.oos = null;
        this.bin = null;
        this.oin = null;
        this.data_p = null;
        this.data_o = null;
        AEResourceManager.releaseAllResources();
        GUI.release();
    }

    private void loadFile(String filename) throws Exception {
        this.is = (class$java$lang$Class == null ? (class$java$lang$Class = ModFight.class$("java.lang.Class")) : class$java$lang$Class).getResourceAsStream(filename);
        this.data = new byte[this.is.available()];
        this.is.read(this.data, 0, this.is.available());
        this.is.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] readCamPositions(String filePath) {
        int[] res = null;
        try {
            this.loadFile(filePath);
            this.currentToken = new StringBuffer(30);
            int len = 0;
            for (int i = 0; i < this.data.length; ++i) {
                char c = (char)this.data[i];
                if (c == ',') {
                    ++len;
                    this.currentToken = new StringBuffer(30);
                    continue;
                }
                this.currentToken.append(c);
            }
            res = new int[len];
            int it = 0;
            for (int i = 0; i < this.data.length; ++i) {
                char c = (char)this.data[i];
                if (c == ',') {
                    res[it] = Integer.parseInt(this.currentToken.toString());
                    ++it;
                    this.currentToken = new StringBuffer(30);
                    continue;
                }
                this.currentToken.append(c);
            }
            int[] nArray = res;
            return nArray;
        }
        catch (Exception e) {
            System.out.println("readCam: Error loading file " + filePath);
        }
        finally {
            if (this.currentToken != null) {
                this.currentToken = null;
            }
            this.data = null;
        }
        return res;
    }

    private void drawMask() {
        for (int i = 0; i < grh.w / 32 + 1; ++i) {
            for (int j = 0; j < grh.h / 32 + 1; ++j) {
                grh.g.drawRGB(this.mask, 0, 32, i * 32, j * 32, 32, 32, true);
            }
        }
    }

    private void optionsToggle(int key, int currentItem, int toggleIndex) {
        switch (currentItem) {
            case 1: {
                grh.volume = toggleIndex + 1;
                if (grh.volume >= Sound.volumes.length) {
                    grh.volume = 0;
                }
                if (grh.volume == 0) {
                    grh.sound.stop();
                } else if (grh.volume == 1) {
                    // empty if block
                }
                grh.sound.setVolume(grh.volume);
                grh.saveSettings();
                break;
            }
            case 2: {
                grh.vibration = toggleIndex != 0;
                grh.saveSettings();
            }
        }
    }

    private void jumpToNextFight() {
        this.init = 10;
        if (grh.game_mode == 0 || grh.game_mode == 1) {
            this.saveGame();
        }
        grh.sound.stop();
        grh.handle.setModule(grh.modules[0]);
    }

    private void jumpToMainMenu() {
        this.init = 10;
        ((ModMenu)grh.modules[0]).reset();
        if (grh.game_mode == 3 && FLBluetooth.isDisconnected()) {
            ((ModMenu)grh.modules[0]).showBluetoothTerminate();
        }
        FLBluetooth.disconnect(false);
        try {
            this.oos.close();
            this.bout.close();
            this.oin.close();
            this.bin.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.oos = null;
        this.bout = null;
        grh.sound.stop();
        if (grh.game_mode == 0 || grh.game_mode == 1) {
            this.saveGame();
        }
        this.round = 0;
        grh.handle.setModule(grh.modules[0]);
    }

    private void jumpToCharacterSelect() {
        this.init = 10;
        grh.sound.stop();
        ((ModMenu)grh.modules[0]).jumpToCharSelect();
        if (grh.game_mode == 0 || grh.game_mode == 1) {
            this.saveGame();
        }
        this.round = 0;
        grh.handle.setModule(grh.modules[0]);
    }

    private void clientKeyPress(int key, Fighter fighter) {
        if ((key & 0x400) != 0 & !this.star_held[0]) {
            this.star_held[0] = true;
        }
        if (!((key & 0x1000) == 0 || this.fire_held[0] || grh.game_mode == 4 && this.round == 1)) {
            this.fire_held[0] = true;
        }
        if ((key & 0x2000) != 0 && (fighter.canMove() || fighter.animAbortPossible())) {
            this.block_held_time[0] = 1;
        }
    }

    private void clientKeyRelease(int key, Fighter fighter) {
        if ((key & 0x1000) != 0) {
            this.star_held[0] = false;
            this.fire_held[0] = false;
            this.hold_fire[0] = 0;
        }
        if ((key & 0x400) != 0) {
            this.star_held[0] = false;
            this.fire_held[0] = false;
            this.hold_fire[0] = 0;
            this.special_move_step[0] = 0;
        }
        if ((key & 0x2000) != 0) {
            this.block_held_time[0] = 0;
        }
    }

    private void handleFightKeyPress(int key, Fighter fighter, int id, boolean receivedAction, boolean update_hold) {
        if (fighter.getOpponent().performsSpecial()) {
            return;
        }
        if (fighter.performsSpecial()) {
            if (key != 4096) {
                return;
            }
            if (!fighter.isInSlowMoMode()) {
                return;
            }
        }
        if ((key & 0x400) != 0 & !this.star_held[id]) {
            this.star_held[id] = true;
            if (this.fire_held[id] && (grh.game_mode != 4 || this.round >= 4)) {
                if (fighter.prepareHeavyAttack(false, false)) {
                    this.hold_fire[id] = 0;
                } else {
                    this.star_held[id] = false;
                }
            }
        }
        if (!(!this.star_held[id] || key != Fighter.special_moves[fighter.getID()][this.special_move_step[id]] || fighter.opponentInCloseRange() || fighter.opponentWillBeInCloseRange() || this.opponent.getCurrentAnim() == 23 || grh.game_mode == 4 && this.round < 6)) {
            int n = id;
            this.special_move_step[n] = this.special_move_step[n] + 1;
            this.special_move_step_time[id] = 0;
            if (this.special_move_step[id] >= Fighter.special_moves[fighter.getID()].length) {
                this.special_move_step[id] = 0;
                if (fighter.performSpecialAttack(false)) {
                    this.playerTransform = fighter.getTransform();
                    this.cameraID = fighter.getID() * 3;
                    this.camAnim[this.cameraID].play(0);
                    this.targetAnim[this.cameraID].play(0);
                }
            }
            return;
        }
        if ((key & 0x8000) != 0) {
            if (!this.star_held[id]) {
                if (fighter.moveLeftPossible() && !fighter.isBlocking()) {
                    if (receivedAction) {
                        fighter.moveLeft(false);
                    } else if (!fighter.moveLeft(false)) {
                        fighter.checkForBorders();
                    }
                }
            } else if (grh.game_mode != 4 || this.round >= 9) {
                fighter.cheer();
            }
        }
        if ((key & 0x10000) != 0 && !this.star_held[id] && fighter.moveRightPossible() && !fighter.isBlocking()) {
            if (receivedAction) {
                fighter.moveRight(false);
            } else if (!fighter.moveRight(false)) {
                fighter.checkForBorders();
            }
        }
        if ((key & 0x4000) != 0) {
            if (fighter.opponentWillBeInCloseRange()) {
                if (grh.game_mode != 4 || this.round >= 8) {
                    fighter.shieldAttack(false, false);
                    if (!DISABLE_AI && grh.game_mode != 3) {
                        this.fighterAI.react(fighter.getCurrentAnim(), this.ingame_time);
                    }
                }
            } else if (this.star_held[id]) {
                if (grh.game_mode != 4 || this.round >= 5) {
                    fighter.performAttack(true, false, false);
                    if (!DISABLE_AI && grh.game_mode != 3) {
                        this.fighterAI.react(fighter.getCurrentAnim(), this.ingame_time);
                    }
                }
            } else {
                fighter.moveForward(false);
            }
        } else if ((key & 0x2000) != 0) {
            if (grh.game_mode != 4 || this.round >= 7) {
                if (fighter.canMove() || fighter.animAbortPossible()) {
                    this.block_held_time[id] = 1;
                }
            } else if (fighter.moveBackwardsPossible() && !fighter.moveBackward(false)) {
                fighter.checkForBorders();
            }
        }
        if (!((key & 0x1000) == 0 || this.fire_held[id] || grh.game_mode == 4 && this.round == 1)) {
            this.fire_held[id] = true;
            if (!update_hold && !this.star_held[id] || fighter.performsSpecial()) {
                fighter.performAttack(false, false, false);
                if (!DISABLE_AI && grh.game_mode != 3) {
                    this.fighterAI.react(fighter.getCurrentAnim(), this.ingame_time);
                }
            } else if (this.star_held[id] && this.fire_held[id] && (grh.game_mode != 4 || this.round >= 4)) {
                if (fighter.prepareHeavyAttack(false, false)) {
                    this.hold_fire[id] = 0;
                } else {
                    this.fire_held[id] = false;
                }
            }
        }
        this.special_move_step[id] = 0;
    }

    public void onKeyPress(int key) {
        if (key == 2048) {
            key = 1024;
        }
        if ((key & 2) != 0) {
            if (grh.cheat_fight) {
                this.player.setHitPoints(1);
            }
            return;
        }
        if ((key & 8) != 0) {
            if (grh.cheat_fight) {
                this.opponent.setHitPoints(1);
            }
            return;
        }
        if ((key & 0x80) != 0) {
            if (grh.cheat_disableAI) {
                DISABLE_AI = !DISABLE_AI;
            }
            return;
        }
        if ((key & 0x200) != 0) {
            if (grh.cheat_fight) {
                SHOW_FPS = !SHOW_FPS;
            }
            return;
        }
        switch (this.state) {
            case 8: {
                if ((key & 0x20000) == 0 && (key & 0x1000) == 0) break;
                if (this.outro_step == 0) {
                    if (this.top_line_index + NBR_OF_LINES < this.lines.length) {
                        if (!this.text_fully_displayed) {
                            this.outro_time += 32000;
                            return;
                        }
                        this.text_fully_displayed = false;
                        this.top_line_index += NBR_OF_LINES;
                        this.outro_time = 0;
                    } else {
                        if (!this.text_fully_displayed) {
                            this.outro_time += 32000;
                            return;
                        }
                        ++this.outro_step;
                    }
                } else if (this.outro_step == 1) {
                    ++this.outro_step;
                } else {
                    this.jumpToMainMenu();
                }
                return;
            }
            case 12: {
                if ((key & 0x20000) == 0 && (key & 0x1000) == 0) break;
                if (this.output != null && !this.output[this.output.length - 1].equals(this.tutorial_text[this.tutorial_text_line + this.output.length - 1])) {
                    this.text_display_time += 10000;
                    break;
                }
                this.lessonTextNext();
                return;
            }
            case 10: {
                if ((key & 0x20000) == 0 && (key & 0x1000) == 0) break;
                if (this.continue_time < this.fame_countdown_time) {
                    this.continue_time = this.fame_countdown_time;
                    return;
                }
                if (grh.game_mode == 0 || grh.game_mode == 2) {
                    grh.total_fame += this.add_fame;
                    this.add_fame = 0;
                    if (this.player.getWins() < this.needed_wins) {
                        this.initNewFight();
                        this.updateCamera();
                        return;
                    }
                    if (grh.current_fight == grh.arcade_opponents[grh.char_id].length - 1) {
                        this.handleArcadeComplete();
                    } else if (grh.game_mode == 2) {
                        this.jumpToCharacterSelect();
                    } else {
                        grh.opponent_id = grh.arcade_opponents[grh.char_id][++grh.current_fight];
                        this.state = 0;
                        this.jumpToNextFight();
                    }
                    return;
                }
                if (grh.game_mode != 1) break;
                grh.total_fame += this.add_fame;
                int health_bonus = this.add_fame / 3;
                if (health_bonus > (grh.survival_hp - this.player.getHitPoints()) / 2) {
                    health_bonus = (grh.survival_hp - this.player.getHitPoints()) / 2;
                }
                this.add_fame = 0;
                grh.survival_hp = this.player.getHitPoints() + health_bonus;
                do {
                    if (++grh.current_fight != grh.survival_opponents.length) continue;
                    if (grh.difficulty == 0) {
                        grh.difficulty = 1;
                    } else if (grh.difficulty == 1) {
                        grh.difficulty = 2;
                    }
                    grh.current_fight = 0;
                } while (grh.char_id == (grh.opponent_id = grh.survival_opponents[grh.current_fight]));
                this.state = 0;
                this.init = 10;
                grh.handle.setModule(grh.modules[2]);
                return;
            }
            case 6: {
                if (!this.display_quote) {
                    this.game_over_time = -6501;
                    break;
                }
                this.game_over_time = -3501;
                break;
            }
            case 11: {
                this.game_over_time = -2501;
                break;
            }
            case 9: {
                if ((key & 0x20000) == 0 && (key & 0x1000) == 0) break;
                this.jumpToMainMenu();
                break;
            }
            case 7: {
                if ((key & 0x20000) == 0 && (key & 0x1000) == 0) break;
                if (this.continue_time > 0) {
                    this.continue_time = 0;
                    if (grh.total_fame > 0) {
                        return;
                    }
                }
                if (grh.total_fame - this.required_fame > 0) {
                    this.handleContinueGranted();
                } else {
                    this.handleGameOver();
                }
                return;
            }
            case 5: {
                if ((key & 0x20000) != 0 || (key & 0x1000) != 0) {
                    this.initContinueDecision();
                    return;
                }
                if ((key & 0x40000) == 0) break;
                this.movePlayersToStart();
                this.handleGameOver();
                return;
            }
            case 4: {
                if ((key & 0x20000) == 0 && (key & 0x1000) == 0) break;
                this.state = 0;
                this.jumpToNextFight();
                return;
            }
            case 16: {
                if (!this.showMsg) break;
                if (key == 32768) {
                    this.choiceWindow.up();
                }
                if (key == 65536) {
                    this.choiceWindow.down();
                }
                if ((key & 0x20000) != 0 || (key & 0x1000) != 0) {
                    this.showMsg = false;
                    this.lesson_step = 0;
                    this.intro_time = 12345678;
                    this.state = 0;
                    this.init = 10;
                    if (this.choiceWindow.fire()) {
                        --this.round;
                    }
                    if (this.round == 9) {
                        this.jumpToMainMenu();
                        return;
                    }
                    grh.handle.setModule(grh.modules[2]);
                }
                return;
            }
            case 18: {
                if (!this.showBox) break;
                if ((key & 0x20000) != 0 || (key & 0x1000) != 0 && this.tutorial_time >= 0) {
                    this.showBox = false;
                    this.state = 2;
                    this.tutorial_time = 0;
                    this.ingame_time = this.pause_time;
                }
                return;
            }
            case 17: {
                if (!this.showMsg) break;
                if ((key & 0x20000) != 0 || (key & 0x1000) != 0 && this.tutorial_time >= 0) {
                    this.showMsg = false;
                    this.state = 14;
                    this.tutorial_time = 0;
                }
                return;
            }
            case 14: {
                if (this.showMsg) {
                    if (((key & 0x20000) != 0 || (key & 0x1000) != 0) && this.round_time < 100000) {
                        this.init = 10;
                        this.showMsg = false;
                        this.lesson_step = 0;
                        --this.round;
                        this.intro_time = 12345678;
                        this.state = 0;
                        grh.handle.setModule(grh.modules[2]);
                    }
                    return;
                }
            }
            case 2: {
                if (grh.game_mode == 3) {
                    if (!FLBluetooth.isServer()) {
                        try {
                            if (this.player.performsSpecial() && this.player.isInSlowMoMode() && this.player.getSpecialResult() == 0 && key == 4096) {
                                this.player.performAttack(false, true, false);
                                this.oos.writeByte(6);
                                this.oos.writeByte(this.player.getSpecialResult());
                                this.oos.flush();
                                byte[] sD = this.bout.toByteArray();
                                FLBluetooth.send(sD);
                                sD = null;
                                this.bout.reset();
                                break;
                            }
                            if ((this.player.performsSpecial() || this.opponent.performsSpecial()) && key != 1024) break;
                            this.oos.writeByte(3);
                            this.oos.writeInt(key);
                            this.oos.flush();
                            byte[] sD = this.bout.toByteArray();
                            FLBluetooth.send(sD);
                            sD = null;
                            this.bout.reset();
                            this.clientKeyPress(key, this.player);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                    this.handleFightKeyPress(key, this.player, 0, false, false);
                    break;
                }
                this.handleFightKeyPress(key, this.player, 0, false, false);
                break;
            }
            case 3: {
                if ((key & 0x40000) != 0 && !this.showMsg && !this.showBox) {
                    if (this.ingame_menu.getCurrentMenu() == 0) {
                        grh.saveSettings();
                        this.state = this.pre_pause_state;
                        this.handlePauseFightResume();
                        this.ingame_time = this.pause_time;
                        this.slow_mo_time = this.pause_time_slowmo;
                        return;
                    }
                    this.ingame_menu.back(PAUSE_SELECT_LESSON);
                    return;
                }
                if (this.showBox) {
                    if (key == 262144) {
                        this.showBox = false;
                        return;
                    }
                } else if (this.showMsg) {
                    if (key == 262144) {
                        this.showMsg = false;
                        return;
                    }
                    if (key == 32768) {
                        this.choiceWindow.up();
                    }
                    if (key == 65536) {
                        this.choiceWindow.down();
                    }
                } else {
                    if (key == 32768) {
                        this.ingame_menu.up();
                    }
                    if (key == 65536) {
                        this.ingame_menu.down();
                    }
                }
                if (key != 4096 && key != 131072) break;
                if (this.ingame_menu.getCurrentMenu() == 0) {
                    switch (this.ingame_menu.getCurrentItem()) {
                        case 0: {
                            grh.saveSettings();
                            this.state = this.pre_pause_state;
                            if (this.pre_pause_state == 2) {
                                this.handlePauseFightResume();
                            }
                            this.ingame_time = this.pause_time;
                            return;
                        }
                        case 3: {
                            this.showBox = true;
                            this.box.setText(grh.gameText.getText(45));
                            this.box.setTitle(grh.gameText.getText(22));
                            this.box.fadeIn();
                            this.box.resetScrollBar();
                            break;
                        }
                        case 1: 
                        case 2: {
                            this.optionsToggle(key, this.ingame_menu.getCurrentItem(), this.ingame_menu.getItemAt(this.ingame_menu.getCurrentItem()).getToggleIndex());
                            break;
                        }
                        default: {
                            int index = this.ingame_menu.getCurrentItem();
                            if (index == PAUSE_QUIT) {
                                if (this.showMsg) {
                                    this.showMsg = false;
                                    if (this.choiceWindow.fire()) {
                                        this.jumpToMainMenu();
                                        return;
                                    }
                                    this.ingame_menu.back(0);
                                    break;
                                }
                                if (grh.game_mode == 0 || grh.game_mode == 1) {
                                    this.choiceWindow.set(grh.gameText.getText(49), true);
                                } else {
                                    this.choiceWindow.set(grh.gameText.getText(48), true);
                                }
                                this.showMsg = true;
                                break;
                            }
                            if (index == PAUSE_SKIP_LESSON) {
                                if (this.showMsg) {
                                    this.showMsg = false;
                                    if (this.choiceWindow.fire()) {
                                        this.lesson_step = 0;
                                        this.init = 10;
                                        grh.handle.setModule(grh.modules[2]);
                                        return;
                                    }
                                    this.ingame_menu.back(0);
                                    break;
                                }
                                this.choiceWindow.set(grh.gameText.getText(180), true);
                                this.showMsg = true;
                                break;
                            }
                            if (index == PAUSE_RESTART_LESSON) {
                                if (this.showMsg) {
                                    this.showMsg = false;
                                    if (this.choiceWindow.fire()) {
                                        --this.round;
                                        this.lesson_step = 0;
                                        this.init = 10;
                                        grh.handle.setModule(grh.modules[2]);
                                        return;
                                    }
                                    this.ingame_menu.back(0);
                                    break;
                                }
                                this.choiceWindow.set(grh.gameText.getText(179), true);
                                this.showMsg = true;
                                break;
                            } else {
                                break;
                            }
                        }
                    }
                } else if (this.ingame_menu.getCurrentMenu() == 1) {
                    if (this.showMsg) {
                        this.showMsg = false;
                        if (this.choiceWindow.fire()) {
                            this.round = this.ingame_menu.getCurrentItem();
                            this.lesson_step = 0;
                            this.init = 10;
                            grh.handle.setModule(grh.modules[2]);
                            return;
                        }
                    } else {
                        this.choiceWindow.set(grh.gameText.getText(181), true);
                        this.showMsg = true;
                    }
                }
                this.ingame_menu.select();
            }
        }
        if ((key & 0x40000) != 0) {
            if (this.state != 3 && this.state == 2 || this.state == 0 || this.state == 14 || this.state == 12 || this.state == 13 || this.state == 15) {
                this.pre_pause_state = this.state;
                this.state = 3;
                this.ingame_menu.setCurrentMenu(0, 0);
                this.pause_time = this.ingame_time;
                this.pause_time_slowmo = this.slow_mo_time;
                if (grh.game_mode == 3) {
                    this.jumpToMainMenu();
                }
            } else if (this.state == 3) {
                this.state = this.pre_pause_state;
                this.ingame_time = this.pause_time;
                this.slow_mo_time = this.pause_time_slowmo;
            }
        }
    }

    private void handlePauseFightResume() {
        if ((this.keystate & 0x2000) == 0 && this.player.isBlocking() && !this.player.performsSpecial() && !this.opponent.performsSpecial()) {
            this.handleFightKeyRelease(8192, this.player, 0);
        }
        if ((this.keystate & 0x400) == 0) {
            this.handleFightKeyRelease(1024, this.player, 0);
        }
        if ((this.keystate & 0x1000) == 0) {
            this.handleFightKeyRelease(4096, this.player, 0);
        }
    }

    private void handleFightKeyRelease(int key, Fighter fighter, int id) {
        if ((key & 0x2000) != 0 && (grh.game_mode != 4 || this.round >= 7)) {
            if (this.block_held_time[id] <= 200) {
                this.block_held_time[id] = 0;
                if (fighter.moveBackwardsPossible() && !fighter.moveBackward(false)) {
                    fighter.checkForBorders();
                }
            } else {
                this.block_held_time[id] = 0;
                fighter.stopBlock(true);
                fighter.idle();
            }
        }
        if ((key & 0x1000) != 0) {
            if (fighter.getCurrentAnim() == 11 || fighter.getCurrentAnim() == 12) {
                if (fighter.heavyAttackLoopDealsDamage()) {
                    fighter.performHeavyAttack(false);
                } else {
                    fighter.idle();
                }
            }
            this.star_held[id] = false;
            this.fire_held[id] = false;
            this.hold_fire[id] = 0;
        }
        if ((key & 0x400) != 0) {
            if (fighter.getCurrentAnim() == 11 || fighter.getCurrentAnim() == 12) {
                if (fighter.heavyAttackLoopDealsDamage()) {
                    fighter.performHeavyAttack(false);
                } else {
                    fighter.idle();
                }
            }
            this.star_held[id] = false;
            this.fire_held[id] = false;
            this.hold_fire[id] = 0;
            this.special_move_step[id] = 0;
        }
    }

    public void onKeyRelease(int key) {
        if (key == 2048) {
            key = 1024;
        }
        if (this.state == 2 || this.state == 14) {
            if (grh.game_mode == 3) {
                if (!FLBluetooth.isServer()) {
                    if (!this.player.performsSpecial() || key == 1024) {
                        try {
                            this.oos.writeByte(4);
                            this.oos.writeInt(key);
                            this.oos.flush();
                            byte[] sD = this.bout.toByteArray();
                            FLBluetooth.send(sD);
                            sD = null;
                            this.bout.reset();
                            this.clientKeyRelease(key, this.player);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                } else {
                    this.handleFightKeyRelease(key, this.player, 0);
                }
            } else {
                this.handleFightKeyRelease(key, this.player, 0);
            }
        }
    }

    public void onStatusChange(long status_on, long status_off) {
        if (grh.game_mode == 3) {
            this.jumpToMainMenu();
        }
    }

    private void updateCamera() {
        if (grh.game_mode != 3 && (this.player.specialNext() || this.opponent.specialNext())) {
            ++this.cameraID;
            this.camAnim[this.cameraID].play(0);
            this.targetAnim[this.cameraID].play(0);
        }
        if (!(this.state != 2 && this.state != 1 && this.state != 10 && this.state != 14 && this.state != 13 && this.state != 12 || (this.camAnim[this.cameraID].isPlaying() || this.player.isInSlowMoMode() || this.opponent.isInSlowMoMode()) && !this.player.hasWon() && !this.opponent.hasWon())) {
            AEVector3D dir = new AEVector3D();
            dir = this.opponent.getFuturePosition().sub(this.player.getFuturePosition(), dir);
            int len = dir.length();
            AEVector3D up = new AEVector3D(0, 4096, 0);
            AEVector3D right = new AEVector3D();
            right = dir.cross(up, right);
            right.normalize();
            AEVector3D ideal_target_pos = new AEVector3D();
            AEVector3D ideal_cam_pos = new AEVector3D();
            if (this.player.hasWon() && !this.opponent.isMoving()) {
                ideal_target_pos.set(this.player.getFutureX(), 200, this.player.getFutureZ());
                ideal_cam_pos.set(this.player.getFutureX() + dir.x / 2 + (right.x * 500 >> 12), 200, this.player.getFutureZ() + (right.z * 500 >> 12));
            } else if (this.opponent.hasWon() && !this.player.isMoving()) {
                ideal_target_pos.set(this.opponent.getFutureX(), 200, this.opponent.getFutureZ());
                ideal_cam_pos.set(this.player.getFutureX() + dir.x / 2 + (right.x * 500 >> 12), 200, this.player.getFutureZ() + (right.z * 500 >> 12));
            } else {
                ideal_target_pos.set(this.player.getFutureX() + dir.x / 2, 200, this.player.getFutureZ() + dir.z / 2);
                ideal_cam_pos.set(ideal_target_pos.x + (right.x * len * 2 >> 12), 200, ideal_target_pos.z + (right.z * len * 2 >> 12));
            }
            if (ideal_cam_pos.z < -2200) {
                ideal_cam_pos.z = -2200;
            }
            if (ideal_cam_pos.z > 2200) {
                ideal_cam_pos.z = 2200;
            }
            if (ideal_cam_pos.x < -2200) {
                ideal_cam_pos.x = -2200;
            }
            if (ideal_cam_pos.x > 2200) {
                ideal_cam_pos.x = 2200;
            }
            dir = ideal_target_pos.sub(this.target.getPosition(), dir);
            len = dir.length();
            dir.normalize();
            if (this.player.hasWon() || this.opponent.hasWon()) {
                this.target.setTranslation(this.target.getPositionX() + (dir.x * len / 40 >> 12), 200, this.target.getPositionZ() + (dir.z * len / 40 >> 12));
            } else {
                this.target.setTranslation(this.target.getPositionX() + (dir.x * len / 8 >> 12), 200, this.target.getPositionZ() + (dir.z * len / 8 >> 12));
            }
            AEVector3D test = new AEVector3D();
            test.set(this.target.getPosition());
            dir = ideal_cam_pos.sub(this.cam.getPosition(), dir);
            len = dir.length();
            dir.normalize();
            if (this.player.hasWon() || this.opponent.hasWon()) {
                this.cam.setTranslation(this.cam.getPositionX() + (dir.x * len / 40 >> 12), 200, this.cam.getPositionZ() + (dir.z * len / 40 >> 12));
            } else {
                this.cam.setTranslation(this.cam.getPositionX() + (dir.x * len / 8 >> 12), 200, this.cam.getPositionZ() + (dir.z * len / 8 >> 12));
            }
            dir = null;
        } else if (this.camAnim[this.cameraID].isPlaying() && (this.state == 2 || this.state == 0 || this.state == 6 || this.state == 11 || this.state == 14 || this.state == 13 || this.state == 12)) {
            this.camAnim[this.cameraID].update((int)this.elapsed_time, (byte)0);
            this.targetAnim[this.cameraID].update((int)this.elapsed_time, (byte)0);
            AEVector3D result = new AEVector3D();
            AEVector3D vec = new AEVector3D(this.target.getPositionX(), this.target.getPositionY(), this.target.getPositionZ());
            result = this.playerTransform.getTransformed(vec, result);
            this.target.setTranslation(result);
            vec.set(this.cam.getPositionX(), this.cam.getPositionY(), this.cam.getPositionZ());
            result = this.playerTransform.getTransformed(vec, result);
            this.cam.setTranslation(result);
            result = null;
            Object var2_4 = null;
        }
    }

    private void initNewFight() {
        int stage;
        this.star_held[0] = false;
        this.fire_held[0] = false;
        this.star_held[1] = false;
        this.fire_held[1] = false;
        this.block_held_time[0] = 0;
        this.block_held_time[1] = 0;
        this.fadeAlpha = 0;
        this.player.setPosition(0);
        this.opponent.setPosition(1);
        if (grh.game_mode == 3 && !FLBluetooth.isServer()) {
            this.opponent.setPosition(0);
            this.player.setPosition(1);
        }
        if ((stage = grh.current_fight) > 4) {
            stage = 4;
        }
        if (grh.game_mode == 2) {
            stage = 2;
        }
        if (!DISABLE_AI && grh.game_mode != 3) {
            this.fighterAI = null;
            this.fighterAI = new FighterAI(grh.difficulty, stage);
            this.fighterAI.setFighters(this.opponent, this.player);
        }
        this.cameraID = 27;
        this.camAnim[this.cameraID].play(0);
        this.targetAnim[this.cameraID].play(0);
        this.playerTransform = this.player.getTransform();
        this.player.reset();
        if (grh.game_mode == 1) {
            this.player.setHitPoints(grh.survival_hp);
        }
        this.opponent.reset();
        ++this.round;
        this.round_time = grh.round_time[grh.time_limit];
        if (grh.game_mode == 3 || grh.game_mode == 4) {
            this.round_time = grh.round_time[grh.TIME_OFF];
        }
        this.intro_time = 3000;
        this.outro_time = 5000;
        this.state = 0;
        this.tutorial_time = 0;
        this.renderPlayer = true;
        this.last_o_trails = 0;
        this.last_p_trails = 0;
        if (!grh.resume_last_game && grh.game_mode != 2 && grh.game_mode != 3) {
            this.saveGame();
        }
        if (grh.volume != 0 && this.round == 1) {
            grh.sound.playSound(14);
        }
    }

    private void handleSurvivalOver() {
        this.erase_saved_game = true;
        this.state = 9;
        if (this.round - 1 > grh.survival_records[grh.char_id][0]) {
            grh.survival_records[grh.char_id][0] = this.round - 1;
            grh.survival_records[grh.char_id][1] = grh.total_fame;
            grh.saveRecords();
        } else if (this.round - 1 == grh.survival_records[grh.char_id][0] && grh.survival_records[grh.char_id][1] < grh.total_fame) {
            grh.survival_records[grh.char_id][1] = grh.total_fame;
            grh.saveRecords();
        }
    }

    private void handleArcadeComplete() {
        this.outro_step = 0;
        try {
            boolean unlock;
            int i;
            this.erase_saved_game = true;
            boolean save = false;
            if (grh.total_fame > grh.arcade_records[grh.char_id][grh.difficulty * 2]) {
                grh.arcade_records[grh.char_id][grh.difficulty * 2] = grh.total_fame;
                save = true;
                this.new_record = true;
            } else {
                this.new_record = false;
            }
            if (grh.arcade_records[grh.char_id][1] == 0) {
                int last_unlocks = grh.unlocked_character;
                if (grh.unlocked_character < grh.fighter_names.length - 3) {
                    ++grh.unlocked_character;
                }
                if (last_unlocks == grh.unlocked_character && grh.unlocked_character < 7) {
                    grh.unlock_hint = true;
                }
            }
            if (grh.difficulty == 1 && grh.arcade_records[grh.char_id][3] == 0) {
                boolean unlock_maximus = true;
                if (grh.unlocked_character < 7) {
                    for (i = 0; i < grh.fighter_names.length - 3; ++i) {
                        if (i == grh.char_id) continue;
                        unlock_maximus = unlock_maximus && grh.arcade_records[i][3] != 0;
                    }
                    if (unlock_maximus) {
                        grh.unlocked_character = 7;
                    }
                } else if (grh.unlocked_character == 7 && grh.char_id == 7) {
                    ++grh.unlocked_character;
                }
            }
            if (grh.total_fame >= 0) {
                if (grh.total_fame < 500) {
                    if (grh.arcade_records[grh.char_id][grh.difficulty * 2 + 1] < 1) {
                        grh.arcade_records[grh.char_id][grh.difficulty * 2 + 1] = 1;
                        save = true;
                    }
                    this.reputation = 1;
                } else if (grh.total_fame < 750) {
                    if (grh.arcade_records[grh.char_id][grh.difficulty * 2 + 1] < 2) {
                        grh.arcade_records[grh.char_id][grh.difficulty * 2 + 1] = 2;
                        save = true;
                    }
                    this.reputation = 2;
                } else {
                    if (grh.arcade_records[grh.char_id][grh.difficulty * 2 + 1] < 3) {
                        grh.arcade_records[grh.char_id][grh.difficulty * 2 + 1] = 3;
                        save = true;
                    }
                    this.reputation = 3;
                }
            }
            if (grh.unlocked_difficulty == 0) {
                unlock = true;
                for (i = 0; unlock && i < grh.fighter_names.length - 2; ++i) {
                    if (grh.arcade_records[i][1] != 0) continue;
                    unlock = false;
                }
                if (unlock) {
                    grh.unlock_hint = false;
                    grh.unlocked_difficulty = 1;
                    save = true;
                }
            } else if (grh.unlocked_difficulty < 2) {
                unlock = true;
                for (i = 0; unlock && i < grh.fighter_names.length; ++i) {
                    if (grh.arcade_records[i][3] != 0) continue;
                    unlock = false;
                }
                if (unlock) {
                    grh.unlocked_difficulty = 2;
                    save = true;
                }
            }
            if (save) {
                grh.saveRecords();
            }
            this.state = 8;
            this.cam.setTranslation(0, 100, 500);
            this.target.setTranslation(0, 400, 0);
            int[] ry = new int[]{-250, -512, -800, -800, -800, -800, -512, -512, -800};
            this.player.setTransform(0, 0, 0, ry[grh.char_id]);
            this.player.reset();
            this.player.cheer();
            this.confetti = new WeatherSnow3DSim(grh.w, grh.h, 100, true);
            boolean outro_text_id = true;
            switch (grh.char_id) {
                case 7: {
                    this.outro_text = grh.gameText.getText(184).toUpperCase() + "\n\n" + grh.gameText.getText(74);
                    break;
                }
                case 8: {
                    this.outro_text = grh.gameText.getText(184).toUpperCase() + "\n\n" + grh.gameText.getText(75);
                    break;
                }
                case 6: {
                    this.outro_text = grh.gameText.getText(184).toUpperCase() + "\n\n" + grh.gameText.getText(76);
                    break;
                }
                case 0: {
                    this.outro_text = grh.gameText.getText(184).toUpperCase() + "\n\n" + grh.gameText.getText(80);
                    break;
                }
                case 1: {
                    this.outro_text = grh.gameText.getText(184).toUpperCase() + "\n\n" + grh.gameText.getText(77);
                    break;
                }
                case 2: {
                    this.outro_text = grh.gameText.getText(184).toUpperCase() + "\n\n" + grh.gameText.getText(78);
                    break;
                }
                case 3: {
                    this.outro_text = grh.gameText.getText(184).toUpperCase() + "\n\n" + grh.gameText.getText(79);
                    break;
                }
                case 4: {
                    this.outro_text = grh.gameText.getText(184).toUpperCase() + "\n\n" + grh.gameText.getText(81);
                    break;
                }
                case 5: {
                    this.outro_text = grh.gameText.getText(184).toUpperCase() + "\n\n" + grh.gameText.getText(82);
                }
            }
            AEFont.setFont((byte)0);
            this.lines = AEFont.getLineArray(this.outro_text, grh.w - 24);
            NBR_OF_LINES = 4;
            this.outro_time = 0;
            this.top_line_index = 0;
            this.text_fully_displayed = false;
            if (grh.volume != 0) {
                grh.sound.stop();
                grh.sound.playMusicOnce(19);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void playSponsorThumbsDown() {
        if (this.sponsorMesh != null) {
            this.sponsorMesh.setAnimRange(11, 16);
            this.sponsorMesh.playAnim((byte)1);
        }
    }

    private void playSponsorThumbsUp() {
        if (this.sponsorMesh != null) {
            this.sponsorMesh.setAnimRange(17, 22);
            this.sponsorMesh.playAnim((byte)1);
        }
        if (grh.volume != 0) {
            grh.sound.playSound(14);
        }
    }

    private void movePlayersToStart() {
        this.player.setPosition(0);
        this.player.setTransform(this.player.getPositionX(), 0, 400, 0);
        this.opponent.setPosition(1);
        this.opponent.setTransform(this.opponent.getPositionX(), 0, 400, 2048);
        this.player.setContinueDecisionPose();
        this.opponent.setExecutionPose();
    }

    private void initContinueDecision() {
        this.movePlayersToStart();
        this.state = 7;
        switch (grh.difficulty) {
            case 0: {
                this.required_fame = 150;
                break;
            }
            case 1: {
                this.required_fame = 150;
                break;
            }
            case 2: {
                this.required_fame = 200;
            }
        }
        this.displayed_fame = this.required_fame;
        this.continue_time = this.fame_countdown_time = this.required_fame * 1000 / 30;
        if (this.ease == null) {
            this.ease = new AEEaseInOut(0, 500);
        }
        this.ease.decrease(100000);
        this.target.setTranslation(0, 200, 0);
        this.cam.setTranslation(0, 1200, -1600);
    }

    private void initAddFameState() {
        this.old_fame = this.player.getFame();
        this.state = 10;
        this.displayed_fame = grh.total_fame;
        this.fame_countdown_time = this.add_fame * 1000 / 30;
        this.continue_time = 0;
    }

    private void handleContinueGranted() {
        this.state = 11;
        this.game_over_time = 0;
        this.cameraID = 28;
        this.camAnim[this.cameraID].play(0);
        this.targetAnim[this.cameraID].play(0);
        this.playerTransform = this.player.getTransform();
        this.player.initGameOver();
        this.player.getUp();
    }

    private void handleGameOver() {
        this.erase_saved_game = true;
        this.state = 6;
        this.game_over_time = 0;
        this.cameraID = 29;
        this.camAnim[this.cameraID].play(0);
        this.targetAnim[this.cameraID].play(0);
        this.player.initGameOver();
        this.opponent.initGameOver();
        this.playerTransform = this.player.getTransform();
        this.player.getUp();
        this.opponent.finishOpponent();
        int rnd = grh.rnd.nextInt(6);
        this.quote_text = AEFont.getLineArray(grh.gameText.getText(198 + rnd), grh.w - 24);
        switch (rnd) {
            case 3: {
                this.quote_character = "-" + grh.gameText.getText(207) + "-";
                break;
            }
            case 5: {
                this.quote_character = "-" + grh.gameText.getText(209) + "-";
                break;
            }
            default: {
                this.quote_character = "-" + grh.gameText.getText(208) + "-";
            }
        }
    }

    private void addBloodIfRequired() {
        if (this.opponent.addBloodPuddle()) {
            this.arena.addBloodPuddle(this.opponent.getPuddleX(), this.opponent.getPuddleZ());
            this.opponent.puddleAdded();
        }
        if (this.player.addBloodDrops()) {
            this.arena.addBloodDrop(this.player.getPositionX(), this.player.getPositionZ());
            this.player.dropsAdded();
        }
        if (this.opponent.addBloodDrops()) {
            this.arena.addBloodDrop(this.opponent.getPositionX(), this.opponent.getPositionZ());
            this.opponent.dropsAdded();
        }
    }

    private void handleReceivedAnim(Fighter f, Fighter o, int anim, boolean animEnd) {
        if (anim != -1) {
            switch (anim) {
                case 31: 
                case 32: {
                    this.ingame_time = this.slow_mo_time;
                    this.slow_mo_time = 0L;
                    f.handleSlowMoOver();
                    f.setCurrentAnim(0);
                    f.playAnim(anim);
                    break;
                }
                case 30: {
                    f.performSpecialAttack(true);
                    this.playerTransform = f.getTransform();
                    this.cameraID = f.getID() * 3;
                    this.camAnim[this.cameraID].play(0);
                    this.targetAnim[this.cameraID].play(0);
                    break;
                }
                case 16: {
                    f.shieldAttack(true, animEnd);
                    break;
                }
                case 4: {
                    f.performAttack(false, true, animEnd);
                    break;
                }
                case 26: {
                    f.performAttack(true, true, animEnd);
                    break;
                }
                case 22: {
                    f.moveForward(true);
                    break;
                }
                case 23: {
                    f.moveBackward(true);
                    break;
                }
                case 21: {
                    f.moveLeft(true);
                    break;
                }
                case 20: {
                    f.moveRight(true);
                    break;
                }
                case 27: {
                    f.moveBackward(true);
                    break;
                }
                case 11: {
                    f.prepareHeavyAttack(true, animEnd);
                    break;
                }
                case 13: {
                    f.handleAnimationEnd();
                    f.performHeavyAttack(true);
                    break;
                }
                case 34: {
                    f.holdBlock(true);
                    break;
                }
                case 17: 
                case 18: 
                case 19: 
                case 29: {
                    f.hit(o.getCurrentAnim(), o.getID());
                    break;
                }
                case 15: {
                    f.handleAnimationEnd();
                    f.playAnim(anim);
                    f.playSound(2, f, f.getOpponent());
                    break;
                }
                case 1: {
                    if (f.getCurrentAnim() == 30 && f.getID() == 4) {
                        this.ingame_time = this.slow_mo_time;
                        this.slow_mo_time = 0L;
                        f.handleSlowMoOver();
                        f.setCurrentAnim(0);
                        f.playAnim(anim);
                    }
                    if (f.getCurrentAnim() == 34) {
                        f.stopBlock(true);
                    }
                    f.handleAnimationEnd();
                    f.idle();
                    break;
                }
                default: {
                    f.handleAnimationEnd();
                    f.playAnim(anim);
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public void onUpdate() {
        this.updateCamera();
        block3 : switch (this.state) {
            case 8: {
                this.outro_time = (int)((long)this.outro_time + this.elapsed_time);
                if (this.outro_time > 5500 && this.outro_time < 6000) {
                    if (grh.volume != 0) {
                        grh.sound.playSound(14);
                    }
                }
                if (this.player.getCurrentAnim() != 2 && grh.rnd.nextInt(10) == 0) {
                    this.player.cheer();
                }
                this.confetti.update(this.elapsed_time);
                break;
            }
            case 12: {
                this.text_display_time = (int)((long)this.text_display_time + this.elapsed_time);
                break;
            }
            case 3: 
            case 18: {
                if (this.showBox && this.box != null) {
                    if ((this.keystate & 32772) != 0) {
                        this.box.up((int)this.elapsed_time);
                    } else if ((this.keystate & 65792) != 0) {
                        this.box.down((int)this.elapsed_time);
                    }
                }
                if (!this.showMsg) {
                    this.selection_mark_time = (int)((long)this.selection_mark_time + this.elapsed_time);
                    if (this.selection_mark_time > 700) {
                        this.selection_mark_time -= 700;
                    }
                }
                if (this.state == 18) {
                    this.tutorial_time = (int)((long)this.tutorial_time + this.elapsed_time);
                    return;
                }
                return;
            }
            case 10: {
                this.opponent.update(this.elapsed_time);
                this.updateCamera();
                this.continue_time = (int)((long)this.continue_time + this.elapsed_time);
                if (this.continue_time >= this.fame_countdown_time) {
                    this.continue_time = this.fame_countdown_time;
                }
                if (this.fame_countdown_time <= 0) break;
                this.player.setFame(this.old_fame - this.add_fame * this.continue_time / this.fame_countdown_time, false);
                this.player.setHighlightFame(true);
                this.displayed_fame = grh.total_fame + this.add_fame * this.continue_time / this.fame_countdown_time;
                break;
            }
            case 7: {
                if (this.ease.getValue() < 500) {
                    this.ease.increase((int)this.elapsed_time);
                    this.cam.setTranslation(0, 1200 - this.ease.getValue(), -1600);
                    if (this.ease.getValue() < 500) break;
                    if (grh.total_fame == 0) {
                        this.playSponsorThumbsDown();
                        break;
                    }
                    this.sponsorMesh.setAnimRange(0, 10);
                    this.sponsorMesh.playAnim((byte)1);
                    break;
                }
                this.player.update(this.elapsed_time);
                this.continue_time = (int)((long)this.continue_time - this.elapsed_time);
                if (this.continue_time < 0) {
                    this.continue_time = 0;
                }
                if (grh.total_fame <= 0 || this.required_fame <= 0) break;
                last_fame = this.displayed_fame;
                this.displayed_fame = this.required_fame * this.continue_time / this.fame_countdown_time;
                old = grh.total_fame;
                if ((grh.total_fame -= last_fame - this.displayed_fame) < 0) {
                    this.displayed_fame = -grh.total_fame;
                    grh.total_fame = 0;
                }
                if (old > 0 && grh.total_fame == 0) {
                    this.playSponsorThumbsDown();
                }
                if (this.displayed_fame > 0) break;
                this.required_fame = 0;
                this.playSponsorThumbsUp();
                break;
            }
            case 11: {
                this.player.update(this.elapsed_time);
                this.opponent.update(this.elapsed_time);
                this.game_over_time = (int)((long)this.game_over_time - this.elapsed_time);
                if (this.game_over_time >= -2500) break;
                this.init = 10;
                grh.handle.setModule(grh.modules[2]);
                break;
            }
            case 6: {
                if (grh.game_mode != 3 && this.player.addBloodPuddle()) {
                    this.arena.addBloodPuddle(this.player.getPositionX(), this.player.getPositionZ());
                    this.player.puddleAdded();
                }
                this.player.update(this.elapsed_time);
                this.opponent.update(this.elapsed_time);
                this.game_over_time = (int)((long)this.game_over_time - this.elapsed_time);
                if (!this.display_quote && this.game_over_time < -6500) {
                    this.fadeAlpha = (int)((long)this.fadeAlpha + Math.max(this.elapsed_time / 3L, 1L));
                    if (this.fadeAlpha > 255) {
                        this.fadeAlpha = 255;
                    }
                    for (i = 0; i < this.mask.length; ++i) {
                        this.mask[i] = (this.fadeAlpha << 24) + 0x960000 + 0 + 0;
                    }
                    if (this.fadeAlpha < 255) break;
                    this.display_quote = true;
                    this.game_over_time = 0;
                    break;
                }
                if (!this.display_quote) break;
                if (this.game_over_time >= -3500) {
                    this.fadeAlpha = (int)((long)this.fadeAlpha - Math.max(this.elapsed_time / 3L, 1L));
                    if (this.fadeAlpha < 0) {
                        this.fadeAlpha = 0;
                    }
                } else {
                    this.fadeAlpha = (int)((long)this.fadeAlpha + Math.max(this.elapsed_time / 3L, 1L));
                    if (this.fadeAlpha > 255) {
                        this.fadeAlpha = 255;
                    }
                }
                for (i = 0; i < this.mask.length; ++i) {
                    this.mask[i] = this.fadeAlpha << 24;
                }
                if (this.fadeAlpha < 255) break;
                this.intro_time = 0;
                this.jumpToMainMenu();
                break;
            }
            case 5: {
                this.continue_time = (int)((long)this.continue_time - this.elapsed_time);
                if (this.continue_time >= 0) break;
                this.handleGameOver();
                return;
            }
            case 0: {
                this.intro_time = (int)((long)this.intro_time - this.elapsed_time);
                if (this.intro_time >= 0) break;
                this.state = 2;
                if (grh.game_mode != 4) break;
                if (this.round == 1) {
                    this.lesson_step = -1;
                }
                this.initLessonComment();
                break;
            }
            case 1: {
                this.player.update(this.elapsed_time);
                if (grh.game_mode != 3 && !ModFight.DISABLE_AI) {
                    this.fighterAI.update(this.elapsed_time);
                }
                this.opponent.update(this.elapsed_time);
                this.updateCamera();
                this.addBloodIfRequired();
                this.outro_time = (int)((long)this.outro_time - this.elapsed_time);
                if (this.outro_time >= 0) break;
                if (this.player.getWins() >= this.needed_wins || this.opponent.getWins() >= this.needed_wins) {
                    switch (grh.game_mode) {
                        case 1: {
                            if (this.player.getWins() >= this.needed_wins) {
                                this.initAddFameState();
                                break block3;
                            }
                            this.handleSurvivalOver();
                            break block3;
                        }
                        case 0: {
                            if (this.player.getWins() >= this.needed_wins) {
                                this.initAddFameState();
                                break block3;
                            }
                            this.state = 5;
                            this.continue_time = 9999;
                            break block3;
                        }
                    }
                    this.jumpToCharacterSelect();
                    break;
                }
                if (grh.game_mode == 3) {
                    this.initNewFight();
                    this.updateCamera();
                    return;
                }
                if (this.player.hasWon()) {
                    this.initAddFameState();
                    break;
                }
                if (this.arena.puddleSpreading()) break;
                if (grh.game_mode == 1) {
                    --this.round;
                }
                this.initNewFight();
                this.updateCamera();
                break;
            }
            case 13: {
                special = this.opponent.performsSpecial();
                this.demo_step = this.fighterAI.updateTutorialShowMove(this.round, this.demo_step, this.elapsed_time);
                if (!special && this.opponent.performsSpecial()) {
                    this.playerTransform = this.opponent.getTransform();
                    this.cameraID = this.opponent.getID() * 3;
                    this.camAnim[this.cameraID].play(0);
                    this.targetAnim[this.cameraID].play(0);
                }
                if (this.demo_step != -1) break;
                this.state = 12;
                break;
            }
            case 17: {
                this.tutorial_time = (int)((long)this.tutorial_time + this.elapsed_time);
                break;
            }
            case 14: {
                this.tutorial_time = (int)((long)this.tutorial_time + this.elapsed_time);
                if (this.showMsg) {
                    this.round_time = (int)((long)this.round_time - this.elapsed_time);
                    return;
                }
                if (this.opponent.getHitPoints() <= 20) {
                    this.showMsg = true;
                    AEFont.setFont((byte)0);
                    this.choiceWindow.set(grh.gameText.getText(155), false);
                    this.round_time = 102000;
                    return;
                }
                if ((this.player.getTutorialBitMask() & this.tutorial_bit_masks[this.round - 1][0]) == this.tutorial_bit_masks[this.round - 1][0] && (this.opponent.getTutorialBitMask() & this.tutorial_bit_masks[this.round - 1][1]) == this.tutorial_bit_masks[this.round - 1][1]) {
                    this.player.idle();
                    this.state = 12;
                    return;
                }
                if (this.round == 8 && (this.player.getCurrentAnim() == 20 || this.player.getCurrentAnim() == 21) && this.player.figure.secondHalfOfAnim() && this.opponent.canMove()) {
                    this.opponent.performAttack(false, false, false);
                }
                if (this.round == 7 && this.player.isBlocking()) {
                    this.opponent.performAttack(false, false, false);
                }
                if (this.tutorial_time >= 30000 && this.player.canMove() && !this.player.performsSpecial()) {
                    this.state = 17;
                    this.showMsg = true;
                    AEFont.setFont((byte)0);
                    this.choiceWindow.set(grh.gameText.getText(160 + this.round - 1), false);
                    this.tutorial_time = -2000;
                }
            }
            case 2: {
                if (grh.game_mode != 3 && (this.player.fameMultiplierChanged() && (grh.hints & 2) == 0 || (this.opponent.getHitPoints() <= 0 || (long)this.round_time - this.elapsed_time < 0L && grh.time_limit != grh.TIME_OFF && this.opponent.getHitPoints() < this.player.getHitPoints()) && (grh.hints & 4) == 0)) {
                    AEFont.setFont((byte)0);
                    if (this.player.fameMultiplierChanged() && (grh.hints & 2) == 0) {
                        grh.hints |= 2;
                        this.box.setText(grh.gameText.getText(123));
                        this.box.setTitle(grh.gameText.getText(122));
                        this.box.fadeIn();
                        this.box.resetScrollBar();
                    } else {
                        grh.hints |= 4;
                        this.box.setText(grh.gameText.getText(124));
                        this.box.setTitle(grh.gameText.getText(122));
                        this.box.fadeIn();
                        this.box.resetScrollBar();
                    }
                    this.state = 18;
                    this.showBox = true;
                    grh.saveRecords();
                    this.tutorial_time = -2000;
                    this.pause_time = this.ingame_time;
                    this.pause_time_slowmo = this.slow_mo_time;
                    return;
                }
                if (grh.game_mode == 3 && (grh.game_mode != 3 || !FLBluetooth.isServer())) ** GOTO lbl271
                if (this.player.isBeingHit() || this.player.isRotating() || this.opponent.performsSpecial()) {
                    this.player.stopBlock(false);
                    if (this.opponent.performsSpecial() && this.player.getCurrentAnim() != 1 && this.player.getCurrentAnim() != 18 && this.player.getCurrentAnim() != 29 && this.player.getCurrentAnim() != 14 && this.player.getCurrentAnim() != 34) {
                        this.player.idle();
                    } else if (this.opponent.performsSpecial() && grh.game_mode != 3 && this.player.getCurrentAnim() == 34) {
                        this.player.idle();
                    }
                    this.block_held_time[0] = 0;
                    this.hold_fire[0] = 0;
                    this.fire_held[0] = false;
                    this.star_held[0] = false;
                }
                if (this.opponent.isBeingHit() || this.opponent.isRotating() || this.player.performsSpecial()) {
                    this.opponent.stopBlock(false);
                    this.block_held_time[1] = 0;
                    this.hold_fire[1] = 0;
                    this.fire_held[1] = false;
                    this.star_held[1] = false;
                }
                if ((this.keystate & 8192) != 0 && this.block_held_time[0] == 0 && this.special_move_step[0] == 0 && !this.opponent.performsSpecial() && (this.player.canMove() || this.player.animAbortPossible())) {
                    this.handleFightKeyPress(8192, this.player, 0, false, true);
                }
                if ((this.keystate & 1024) != 0 && !this.star_held[0] && !this.opponent.performsSpecial() && (this.player.canMove() || this.player.animAbortPossible())) {
                    this.handleFightKeyPress(1024, this.player, 0, false, true);
                }
                if ((this.keystate & 4096) != 0 && !this.fire_held[0] && !this.opponent.performsSpecial() && (this.player.canMove() || this.player.animAbortPossible())) {
                    this.handleFightKeyPress(4096, this.player, 0, false, true);
                }
                for (i = 0; i < 2; ++i) {
                    if (this.special_move_step[i] > 0) {
                        v0 = i;
                        this.special_move_step_time[v0] = (int)((long)this.special_move_step_time[v0] + this.elapsed_time);
                    }
                    if (this.special_move_step_time[i] > 300) {
                        this.special_move_step[i] = 0;
                        this.special_move_step_time[i] = 0;
                    }
                    if (this.block_held_time[i] <= 0) continue;
                    v1 = i;
                    this.block_held_time[v1] = (int)((long)this.block_held_time[v1] + this.elapsed_time);
                    if (this.block_held_time[i] <= 200) continue;
                    if (i == 0) {
                        if (this.player.isBlocking()) continue;
                        this.player.holdBlock(false);
                        continue;
                    }
                    if (i != 1 || this.opponent.isBlocking()) continue;
                    this.opponent.holdBlock(false);
                }
                ** GOTO lbl324
lbl271:
                // 1 sources

                if (grh.game_mode != 3 || FLBluetooth.isServer()) ** GOTO lbl319
                if (this.player.isBeingHit() || this.player.isRotating() || this.opponent.performsSpecial() || this.player.performsSpecial()) {
                    this.block_held_time[0] = 0;
                    this.hold_fire[0] = 0;
                    this.fire_held[0] = false;
                    this.star_held[0] = false;
                }
                try {
                    if (!this.player.performsSpecial()) {
                        key = -1;
                        if ((this.keystate & 8192) != 0 && this.block_held_time[0] == 0 && this.special_move_step[0] == 0 && !this.opponent.performsSpecial() && (this.player.canMove() || this.player.animAbortPossible())) {
                            this.clientKeyPress(8192, this.player);
                            key = 8192;
                            this.oos.writeByte(3);
                            this.oos.writeInt(key);
                            this.oos.flush();
                            sD = this.bout.toByteArray();
                            FLBluetooth.send(sD);
                            sD = null;
                            this.bout.reset();
                        }
                        if ((this.keystate & 1024) != 0 && !this.star_held[0] && !this.opponent.performsSpecial()) {
                            this.clientKeyPress(1024, this.player);
                            key = 1024;
                            this.oos.writeByte(3);
                            this.oos.writeInt(key);
                            this.oos.flush();
                            sD = this.bout.toByteArray();
                            FLBluetooth.send(sD);
                            sD = null;
                            this.bout.reset();
                        }
                        if ((this.keystate & 4096) != 0 && !this.fire_held[0] && !this.opponent.performsSpecial() && (this.player.canMove() || this.player.animAbortPossible())) {
                            this.clientKeyPress(4096, this.player);
                            key = 4096;
                            this.oos.writeByte(3);
                            this.oos.writeInt(key);
                            this.oos.flush();
                            sD = this.bout.toByteArray();
                            FLBluetooth.send(sD);
                            sD = null;
                            this.bout.reset();
                        }
                    }
                    ** GOTO lbl324
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                ** GOTO lbl324
lbl319:
                // 1 sources

                if (grh.game_mode == 3 && FLBluetooth.isServer() && (this.opponent.isBeingHit() || this.opponent.isRotating() || this.opponent.performsSpecial() || this.player.performsSpecial())) {
                    this.block_held_time[1] = 0;
                    this.hold_fire[1] = 0;
                    this.fire_held[1] = false;
                    this.star_held[1] = false;
                }
lbl324:
                // 7 sources

                if (!this.player.isDead() && !this.opponent.isDead() && grh.time_limit != grh.TIME_OFF && grh.game_mode != 3) {
                    this.round_time = (int)((long)this.round_time - this.elapsed_time);
                }
                if ((this.round_time < 0 && grh.time_limit != grh.TIME_OFF && grh.game_mode != 3 || this.player.isDead() || this.opponent.isDead()) && grh.game_mode != 4) {
                    if (this.round_time < 0 && grh.time_limit != grh.TIME_OFF && grh.game_mode != 3) {
                        if (this.player.getHitPoints() > this.opponent.getHitPoints()) {
                            this.add_fame += this.player.getFame();
                            this.player.win();
                            this.opponent.lose();
                        } else if (this.player.getHitPoints() == this.opponent.getHitPoints()) {
                            this.opponent.lose();
                            this.player.lose();
                        } else {
                            this.opponent.win();
                            this.player.lose();
                        }
                    } else if (this.player.isDead()) {
                        this.opponent.win();
                        this.player.lose();
                    } else {
                        this.add_fame += this.player.getFame();
                        this.player.win();
                        this.opponent.lose();
                    }
                    this.state = 1;
                    return;
                }
                this.addBloodIfRequired();
                for (i = 0; i < 2; ++i) {
                    fighter = i == 0 ? this.player : this.opponent;
                    if (this.fire_held[i] && this.star_held[i]) {
                        v2 = i;
                        this.hold_fire[v2] = (int)((long)this.hold_fire[v2] + this.elapsed_time);
                        if (this.hold_fire[i] >= fighter.getHeavyAttackLoopTime()) {
                            if (grh.game_mode != 3 || grh.game_mode == 3 && FLBluetooth.isServer()) {
                                fighter.performHeavyAttack(false);
                                if (i == 0 && !ModFight.DISABLE_AI && grh.game_mode != 3) {
                                    this.fighterAI.react(fighter.getCurrentAnim(), this.ingame_time);
                                }
                            }
                            this.fire_held[i] = false;
                            this.star_held[i] = false;
                            this.hold_fire[i] = 0;
                        }
                    }
                    if (fighter.getCurrentAnim() == 18 || this.player.getCurrentAnim() == 19) {
                        this.hold_fire[i] = 0;
                    }
                    fighter = null;
                }
                if (ModFight.DISABLE_AI || grh.game_mode == 3) break;
                special = this.opponent.performsSpecial();
                if (grh.game_mode != 4 || this.round == 7) {
                    this.fighterAI.update(this.elapsed_time);
                }
                if (special || !this.opponent.performsSpecial()) break;
                this.playerTransform = this.opponent.getTransform();
                this.cameraID = this.opponent.getID() * 3;
                this.camAnim[this.cameraID].play(0);
                this.targetAnim[this.cameraID].play(0);
            }
        }
        if (grh.game_mode == 3) {
            FLBluetooth.update();
            if (FLBluetooth.isDisconnected()) {
                this.init = 10;
                this.jumpToMainMenu();
                return;
            }
            if (FLBluetooth.dataReceived() && (rD = FLBluetooth.getReceivedData()) != null) {
                this.bin = new ByteArrayInputStream(rD);
                this.oin = new DataInputStream(this.bin);
                try {
                    type = this.oin.readByte();
                    switch (type) {
                        case 6: {
                            this.opponent.setSpecialResult(this.oin.readByte());
                            break;
                        }
                        case 3: {
                            key = this.oin.readInt();
                            this.handleFightKeyPress(key, this.opponent, 1, true, false);
                            break;
                        }
                        case 4: {
                            key = this.oin.readInt();
                            this.handleFightKeyRelease(key, this.opponent, 1);
                            break;
                        }
                        case 5: {
                            slowMoEnd = this.oin.readBoolean();
                            specialResult = this.oin.readByte();
                            if (specialResult != -1) {
                                this.opponent.setSpecialResult(specialResult);
                                ++this.cameraID;
                                this.camAnim[this.cameraID].play(0);
                                this.targetAnim[this.cameraID].play(0);
                            }
                            rec_prot_id = this.oin.readLong();
                            o_anim_count = this.oin.readInt();
                            if (o_anim_count != -1) {
                                for (i = 0; i < o_anim_count; i += 2) {
                                    anim_in = this.oin.readByte();
                                    handleAnimEnd = this.oin.readByte() == 1;
                                    this.handleReceivedAnim(this.opponent, this.player, anim_in, handleAnimEnd);
                                }
                            }
                            opponent_fame = this.oin.readInt();
                            p_anim_count = this.oin.readInt();
                            if (p_anim_count != -1) {
                                for (i = 0; i < p_anim_count; i += 2) {
                                    anim_in = this.oin.readByte();
                                    handleAnimEnd = this.oin.readByte() == 1;
                                    this.handleReceivedAnim(this.player, this.opponent, anim_in, handleAnimEnd);
                                }
                            }
                            if ((player_fame = this.oin.readInt()) != this.player.getFame()) {
                                this.player.setFame(player_fame, false);
                            }
                            if (opponent_fame == this.opponent.getFame()) break;
                            this.opponent.setFame(opponent_fame, false);
                        }
                    }
                    this.oin.close();
                    this.bin.close();
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        if (grh.game_mode == 3 && FLBluetooth.isServer()) {
            this.bluetoothServerSend();
        } else {
            if (grh.game_mode == 3) {
                sendSpecialResult = false;
                if (this.player.performsSpecial() && this.player.getSpecialResult() == 0) {
                    sendSpecialResult = true;
                }
                this.player.update(this.elapsed_time);
                this.opponent.update(this.elapsed_time);
                this.handleSpecialNext();
                if (this.player.performsSpecial() && this.player.getSpecialResult() == 0) {
                    sendSpecialResult = false;
                }
                if (sendSpecialResult) {
                    try {
                        this.oos.writeByte(6);
                        this.oos.writeByte(this.player.getSpecialResult());
                        this.oos.flush();
                        sD = this.bout.toByteArray();
                        FLBluetooth.send(sD);
                        sD = null;
                        this.bout.reset();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else {
                this.player.update(this.elapsed_time);
                this.opponent.update(this.elapsed_time);
            }
            var1_4 = this.player.getSpecialResult();
        }
        this.player.correctOrientation();
        this.opponent.correctOrientation();
        this.cam.update(false);
        this.scene.update(false);
    }

    private void handleSpecialNext() {
        if (grh.game_mode == 3) {
            boolean pNext = this.player.specialNext();
            boolean oNext = this.opponent.specialNext();
            if (pNext || FLBluetooth.isServer() && oNext) {
                if (FLBluetooth.isServer() && pNext) {
                    this.sendSpecialNext = true;
                }
                ++this.cameraID;
                this.camAnim[this.cameraID].play(0);
                this.targetAnim[this.cameraID].play(0);
            }
        }
    }

    private void bluetoothServerSend() {
        if (this.player.isInSlowMoMode()) {
            this.sendSlowMoEnd = true;
        }
        this.player.update(this.elapsed_time);
        this.opponent.update(this.elapsed_time);
        this.handleSpecialNext();
        this.sendSlowMoEnd &= !this.player.isInSlowMoMode();
        this.sendSlowMoEnd = false;
        int o_fame = this.opponent.getFame();
        int p_fame = this.player.getFame();
        if (this.sendSpecialNext || this.sendSlowMoEnd || this.player.newAnim || this.opponent.newAnim || this.sent_o_anim != this.opponent.getCurrentAnim() || this.sent_p_anim != this.player.getCurrentAnim() || this.sent_o_fame != o_fame || this.sent_p_fame != p_fame) {
            try {
                int i;
                this.oos.writeByte(5);
                if (this.sendSlowMoEnd) {
                    this.oos.writeBoolean(true);
                    this.sendSlowMoEnd = false;
                } else {
                    this.oos.writeBoolean(false);
                }
                if (this.sendSpecialNext) {
                    this.oos.writeByte(this.player.getSpecialResult());
                } else {
                    this.oos.writeByte(-1);
                }
                this.oos.writeLong(this.prot_id);
                if (this.sendSpecialNext) {
                    this.sendSpecialNext = false;
                }
                this.sent_p_anim = this.player.getCurrentAnim();
                this.sent_o_anim = this.opponent.getCurrentAnim();
                this.sent_p_fame = p_fame;
                this.sent_o_fame = o_fame;
                if (!this.player.newAnim) {
                    ++this.minusOneSent;
                    this.oos.writeInt(-1);
                } else {
                    this.oos.writeInt(this.player.getAnimationCount());
                    for (i = 0; i < this.player.getAnimationCount(); ++i) {
                        this.oos.writeByte(this.player.getAnimationQueue()[i]);
                    }
                }
                this.oos.writeInt(this.sent_p_fame);
                if (!this.opponent.newAnim) {
                    ++this.minusOneSent;
                    this.oos.writeInt(-1);
                } else {
                    this.oos.writeInt(this.opponent.getAnimationCount());
                    for (i = 0; i < this.opponent.getAnimationCount(); ++i) {
                        this.oos.writeByte(this.opponent.getAnimationQueue()[i]);
                    }
                }
                this.oos.writeInt(this.sent_o_fame);
                this.oos.flush();
                this.player.clearAnimationQueue();
                this.opponent.clearAnimationQueue();
                ++this.prot_id;
                byte[] sD = this.bout.toByteArray();
                FLBluetooth.send(sD);
                sD = null;
                this.bout.reset();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.player.newAnim = false;
        this.opponent.newAnim = false;
        this.player.handleAnimEndCalled = false;
        this.opponent.handleAnimEndCalled = false;
    }

    private void drawPauseMenu() {
        if (!this.showMsg) {
            GUI.drawTransparentPattern();
        }
        AEFont.setFont((byte)0);
        if (!this.ingame_menu.currentMenuIsEmpty()) {
            int menu_top = grh.h / 2 - this.ingame_menu.getCurrentLength() * 13 / 2;
            GUI.drawBox(this.margin_left, menu_top - 12, grh.w - 2 * this.margin_left, grh.h - 2 * (menu_top - 12) - 4);
            for (int i = 0; i < this.ingame_menu.getCurrentLength(); ++i) {
                String t = this.ingame_menu.getItemAt(i).getText();
                if (i == this.ingame_menu.getCurrentItem()) {
                    int offset = this.selection_mark_time / 116;
                    if (offset > 2) {
                        offset = 6 - offset;
                    }
                    GUI.drawSelectionWing(true, grh.w / 2 - AEFont.getStringWidth(t) / 2 - offset, menu_top + this.ingame_menu.getCurrentItem() * 13);
                    AEFont.drawString(t, grh.w >> 1, menu_top + i * 13, 12);
                    GUI.drawSelectionWing(false, grh.w / 2 + AEFont.getStringWidth(t) / 2 + offset, menu_top + this.ingame_menu.getCurrentItem() * 13);
                    continue;
                }
                AEFont.drawString(t, grh.w >> 1, menu_top + i * 13, 12);
            }
        }
        if (this.ingame_menu.getCurrentMenu() == 0 && (this.ingame_menu.getCurrentItem() == 1 || this.ingame_menu.getCurrentItem() == 2)) {
            GUI.drawFooter(grh.gameText.getText(44), "drawArrows()", grh.gameText.getText(6));
        } else {
            GUI.drawFooter(grh.gameText.getText(5), "drawArrows()", grh.gameText.getText(6));
        }
        if (this.showMsg) {
            GUI.drawTransparentPattern();
            this.choiceWindow.draw((int)this.elapsed_time);
            GUI.drawFooter(grh.gameText.getText(5), "drawArrows()", grh.gameText.getText(6));
        }
        if (this.showBox) {
            if (this.box != null) {
                this.box.draw((this.keystate & 0x8000) != 0, (this.keystate & 0x10000) != 0, (int)this.elapsed_time);
            }
            GUI.drawFooter(null, "drawArrows()", grh.gameText.getText(6));
        }
    }

    private void drawFightInterface() {
        GUI.drawFightInterface();
        GUI.drawWins(this.player, this.opponent);
        GUI.drawHitPoints(this.player.getOldHitPoints(), this.opponent.getOldHitPoints(), true);
        GUI.drawHitPoints(this.player.getHitPoints(), this.opponent.getHitPoints(), false);
        GUI.drawFame(this.player, this.opponent);
        GUI.drawTime(this.round_time);
        GUI.drawBorderHint(this.player, this.opponent);
        if (this.state != 10 && (this.player.getFame() != 0 || this.opponent.getFame() != 0)) {
            GUI.drawDamageUps(this.player, this.opponent);
        }
        if (this.player.specialContinuePossible()) {
            int percent = 100 * this.player.getSpecialDamageTime() / this.player.getSpecialMaxDamageTime();
            GUI.drawSpecialMeter(percent);
            if (this.player.getSpecialResult() != 0) {
                String str = grh.gameText.getText(100);
                switch (this.player.getSpecialResult()) {
                    case 1: {
                        str = grh.gameText.getText(101);
                        break;
                    }
                    case 3: {
                        str = grh.gameText.getText(102);
                        break;
                    }
                    case 4: {
                        str = grh.gameText.getText(103);
                    }
                }
                AEFont.setFont((byte)1);
                AEFont.drawString(str, 6, grh.h - 16 - 2 - 12 - AEFont.getRowHeight(), 0);
            }
        }
    }

    private void initLessonComment() {
        AEFont.setFont((byte)0);
        this.tutorial_text_line = 0;
        this.state = 12;
        int width = grh.w - this.margin_left - this.proximo.getWidth() - 6;
        this.tutorial_text = this.lesson_step == -1 ? AEFont.getLineArray(grh.gameText.getText(125), width) : (this.lesson_step == 3 ? AEFont.getLineArray(grh.gameText.getText(153), width) : AEFont.getLineArray(grh.gameText.getText(126 + this.lesson_step + (this.round - 1) * 3), width));
    }

    private void lessonTextNext() {
        this.text_display_time = 0;
        if (this.tutorial_text_line + 3 < this.tutorial_text.length) {
            this.tutorial_text_line += 3;
        } else if (this.lesson_step == 2 && this.round < 9 || this.lesson_step == 3) {
            this.state = 16;
            this.choiceWindow.set(grh.gameText.getText(157), true);
            this.showMsg = true;
        } else if (this.lesson_step == -1) {
            ++this.lesson_step;
            this.initLessonComment();
        } else if (this.lesson_step == 0) {
            ++this.lesson_step;
            this.initLessonComment();
            this.demo_step = 0;
            if (this.round == 7) {
                this.player.performAttack(false, false, false);
            }
            this.state = 13;
        } else if (this.lesson_step == 1) {
            ++this.lesson_step;
            this.initLessonComment();
            this.state = 14;
            this.player.setTutorialBitMask(0L);
            if (this.round == 5 || this.round == 6) {
                this.player.moveBackward(true);
            }
        } else if (this.lesson_step == 2) {
            ++this.lesson_step;
            this.initLessonComment();
        }
    }

    private void drawLessonComment() {
        int i;
        AEFont.setFont((byte)0);
        int menu_top = grh.h - 20 - 24 - AEFont.getRowHeight() * 3;
        GUI.drawBox(this.margin_left, menu_top, grh.w - 2 * this.margin_left, 12 + AEFont.getRowHeight() * 3);
        int len = AEMath.min(3, this.tutorial_text.length - this.tutorial_text_line);
        this.output = new String[len];
        for (int i2 = 0; i2 < this.output.length; ++i2) {
            this.output[i2] = this.tutorial_text[this.tutorial_text_line + i2];
        }
        int noOfChars = this.text_display_time / 50;
        int charStartIndex = 0;
        for (i = 0; i < this.output.length; ++i) {
            if (noOfChars < this.output[i].length() + charStartIndex) {
                this.output[i] = this.output[i].substring(0, noOfChars - charStartIndex);
            }
            charStartIndex += this.output[i].length();
        }
        for (i = 0; i < this.output.length; ++i) {
            AEFont.drawString(this.output[i], this.proximo.getWidth(), menu_top + 6 + i * AEFont.getRowHeight() - 1);
        }
        grh.g.drawImage(this.proximo, 0, grh.h - 20 - this.proximo.getHeight(), 0);
    }

    private void drawLessonTitle() {
        AEFont.setFont((byte)1);
        if (AEFont.getStringWidth(grh.gameText.getText(169 + this.round - 1)) <= grh.w) {
            AEFont.drawString(grh.gameText.getText(169 + this.round - 1), grh.w / 2 - AEFont.getStringWidth(grh.gameText.getText(169 + this.round - 1)) / 2, GUI.getLessonTitleY());
        } else {
            String[] out = AEFont.getLineArray(grh.gameText.getText(169 + this.round - 1), grh.w);
            for (int i = 0; i < out.length; ++i) {
                AEFont.drawString(out[i], grh.w / 2 - AEFont.getStringWidth(out[i]) / 2, GUI.getLessonTitleY() - AEFont.getRowHeight() / 2 + i * AEFont.getRowHeight());
            }
            Object var1_1 = null;
        }
    }

    public void onRender2D() {
        if (this.init != 0) {
            return;
        }
        AEFont.setFont((byte)1);
        switch (this.state) {
            case 10: {
                AEFont.setFont((byte)0);
                GUI.drawFightBox(this.margin_left, grh.h / 2 - AEFont.getRowHeight() / 2 - 6, grh.w - 2 * this.margin_left, AEFont.getRowHeight() + 12, 4653313, true, true);
                AEFont.drawString(grh.gameText.getText(104) + ": ", grh.w / 2 - AEFont.getStringWidth(grh.gameText.getText(104) + ": ") / 2 - 1, grh.h / 2 - AEFont.getRowHeight() / 2 - 1);
                GUI.drawNumbers(this.displayed_fame, grh.w / 2 + AEFont.getStringWidth(grh.gameText.getText(104) + ": ") / 2, grh.h / 2 - AEFont.getRowHeight() / 2 - 1 + 2);
                GUI.drawFooter(grh.gameText.getText(5), null, null);
                this.drawFightInterface();
                break;
            }
            case 7: {
                AEFont.setFont((byte)0);
                GUI.drawFightBox(this.margin_left, 6, grh.w - 2 * this.margin_left, 2 * AEFont.getRowHeight() + 12, 4653313, true, true);
                AEFont.drawString(grh.gameText.getText(104) + ": ", grh.w / 2 - AEFont.getStringWidth(grh.gameText.getText(104) + ": ") / 2, 11);
                GUI.drawNumbers(grh.total_fame, grh.w / 2 + AEFont.getStringWidth(grh.gameText.getText(104) + ": ") / 2, 14);
                AEFont.drawString(grh.gameText.getText(105) + ": ", grh.w / 2 - AEFont.getStringWidth(grh.gameText.getText(105) + ": ") / 2, 12 + AEFont.getRowHeight() - 1);
                GUI.drawNumbers(this.displayed_fame, grh.w / 2 + AEFont.getStringWidth(grh.gameText.getText(105) + ": ") / 2, 12 + AEFont.getRowHeight() + 2);
                if (grh.total_fame <= 0) {
                    grh.g.drawImage(this.defeat, grh.w / 2 - this.defeat.getWidth() / 2, grh.h / 2 - this.defeat.getHeight() / 2 - 1 - grh.h / 4, 0);
                    AEFont.setFont((byte)1);
                    AEFont.drawString(grh.gameText.getText(106), grh.w / 2 - AEFont.getStringWidth(grh.gameText.getText(106)) / 2, grh.h / 2 - AEFont.getRowHeight() / 2 - grh.h / 4);
                } else if (this.displayed_fame == 0) {
                    AEFont.setFont((byte)1);
                    GUI.drawFightBox(this.margin_left, grh.h / 2 - AEFont.getRowHeight() / 2 - 6 - grh.h / 4, grh.w - 2 * this.margin_left, AEFont.getRowHeight() + 12, 4653313, true, true);
                    AEFont.drawString(grh.gameText.getText(107), grh.w / 2 - AEFont.getStringWidth(grh.gameText.getText(107)) / 2, grh.h / 2 - AEFont.getRowHeight() / 2 - grh.h / 4);
                }
                GUI.drawFooter(grh.gameText.getText(5), null, null);
                break;
            }
            case 9: {
                GUI.drawFightBox(this.margin_left, grh.h / 2 - 2 * AEFont.getRowHeight() / 2 - 6, grh.w - 2 * this.margin_left, 2 * AEFont.getRowHeight() + 12, 4653313, true, true);
                AEFont.drawString(grh.gameText.getText(106), grh.w / 2 - AEFont.getStringWidth(grh.gameText.getText(106)) / 2, grh.h / 2 - AEFont.getRowHeight());
                AEFont.setFont((byte)0);
                AEFont.drawString(grh.gameText.getText(108) + ": " + (this.round - 1), grh.w / 2 - AEFont.getStringWidth(grh.gameText.getText(108) + ": " + (this.round - 1)) / 2, grh.h / 2);
                GUI.drawFooter(grh.gameText.getText(5), null, null);
                break;
            }
            case 6: {
                if (this.display_quote) {
                    grh.g.setColor(0);
                    grh.g.fillRect(0, 0, grh.w, grh.h);
                    AEFont.setFont((byte)0);
                    int x = 24;
                    if (this.quote_text.length == 1) {
                        AEFont.drawLines(this.quote_text, grh.w / 2, grh.h / 2 - AEFont.getRowHeight() / 2 * this.quote_text.length, (byte)0, 8);
                        AEFont.drawString(this.quote_character, grh.w / 2 - AEFont.getStringWidth(this.quote_text[0]) / 2 + AEFont.getStringWidth(" "), grh.h / 2 + AEFont.getRowHeight() / 2 * (this.quote_text.length + 1));
                    } else {
                        AEFont.drawLines(this.quote_text, x, grh.h / 2 - AEFont.getRowHeight() / 2 * this.quote_text.length, (byte)0);
                        AEFont.drawString(" " + this.quote_character, x, grh.h / 2 + AEFont.getRowHeight() / 2 * (this.quote_text.length + 1));
                    }
                    this.drawMask();
                    break;
                }
                if (this.game_over_time >= -6500) break;
                this.drawMask();
                break;
            }
            case 5: {
                AEFont.setFont((byte)1);
                if (AEFont.getStringWidth(grh.gameText.getText(109)) > grh.w - 2 * this.margin_left - 4) {
                    GUI.drawFightBox(grh.w / 2 - AEFont.getStringWidth(grh.gameText.getText(109)) / 2 - 4, grh.h / 2 - 2 * AEFont.getRowHeight() / 2 - 6, AEFont.getStringWidth(grh.gameText.getText(109)) + 8, 2 * AEFont.getRowHeight() + 12, 4653313, true, true);
                } else {
                    GUI.drawFightBox(this.margin_left, grh.h / 2 - 2 * AEFont.getRowHeight() / 2 - 6, grh.w - 2 * this.margin_left, 2 * AEFont.getRowHeight() + 12, 4653313, true, true);
                }
                AEFont.drawString(grh.gameText.getText(109), grh.w / 2 - AEFont.getStringWidth(grh.gameText.getText(109)) / 2, grh.h / 2 - AEFont.getRowHeight());
                AEFont.drawString("0" + this.continue_time / 1000, grh.w / 2 - AEFont.getStringWidth("0" + this.continue_time / 1000) / 2, grh.h / 2);
                GUI.drawFooter(grh.gameText.getText(39), null, grh.gameText.getText(40));
                break;
            }
            case 8: {
                AEFont.setFont((byte)0);
                this.output = new String[this.lines.length];
                for (int i = 0; i < this.lines.length; ++i) {
                    this.output[i] = this.lines[i];
                }
                int noOfChars = this.outro_time / 50;
                int charStartIndex = 0;
                for (int i = this.top_line_index; i < this.output.length; ++i) {
                    if (noOfChars < this.output[i].length() + charStartIndex) {
                        this.output[i] = this.output[i].substring(0, noOfChars - charStartIndex);
                    }
                    charStartIndex += this.output[i].length();
                }
                this.confetti.draw(grh.g);
                if (this.outro_step == 0) {
                    GUI.drawFightBox(6, 6, grh.w - 12, AEFont.getRowHeight() * (NBR_OF_LINES + 1) + 6, 3081228, true, true);
                    float add = 0.0f;
                    for (int i = this.top_line_index; i < this.output.length && i < this.top_line_index + NBR_OF_LINES; ++i) {
                        add = 0.0f;
                        if (this.top_line_index + NBR_OF_LINES > this.output.length) {
                            add = (this.top_line_index + NBR_OF_LINES - this.output.length) / 2;
                        }
                        AEFont.drawString(this.output[i], grh.w / 2 - AEFont.getStringWidth(this.lines[i]) / 2, 12 + AEFont.getRowHeight() * (i - this.top_line_index) + (int)((float)AEFont.getRowHeight() * add));
                        if (this.text_fully_displayed || i != this.output.length - 1 && i != this.top_line_index + NBR_OF_LINES - 1 || !this.output[i].equals(this.lines[i])) continue;
                        this.text_fully_displayed = true;
                    }
                } else if (this.outro_step == 1) {
                    GUI.drawFightBox(6, 6, grh.w - 12, AEFont.getRowHeight() * (NBR_OF_LINES + 1) + 6, 3081228, true, true);
                    AEFont.drawString(grh.gameText.getText(185) + ": ", grh.w / 2 - AEFont.getStringWidth(grh.gameText.getText(185) + ": ") / 2 - GUI.getNumberWidth(grh.total_fame) / 2, 12 + AEFont.getRowHeight());
                    GUI.drawNumbers(grh.total_fame, grh.w / 2 + AEFont.getStringWidth(grh.gameText.getText(185) + ": ") / 2 + GUI.getNumberWidth(grh.total_fame) / 2 - GUI.getNumberWidth(grh.total_fame), 14 + AEFont.getRowHeight());
                    if (this.new_record && System.currentTimeMillis() / 500L % 2L == 0L) {
                        AEFont.drawString(grh.gameText.getText(186).toUpperCase(), grh.w / 2 - AEFont.getStringWidth(grh.gameText.getText(186).toUpperCase()) / 2, 12 + 5 * AEFont.getRowHeight() / 2);
                    }
                } else {
                    GUI.drawFightBox(6, 6, grh.w - 12, AEFont.getRowHeight() * (NBR_OF_LINES + 1) + 6, 3081228, true, true);
                    String rep = grh.gameText.getText(92);
                    if (this.reputation == 2) {
                        rep = grh.gameText.getText(93);
                    } else if (this.reputation == 3) {
                        rep = grh.gameText.getText(94);
                    }
                    rep = rep.toUpperCase();
                    int str_len = AEMath.max(AEFont.getStringWidth(grh.gameText.getText(187) + ": ") / 2, AEFont.getStringWidth(rep) / 2);
                    int len_diff = 0;
                    if (AEFont.getStringWidth(grh.gameText.getText(187) + ": ") < AEFont.getStringWidth(rep)) {
                        len_diff = AEFont.getStringWidth(rep) - AEFont.getStringWidth(grh.gameText.getText(187) + ": ");
                        AEFont.drawString(grh.gameText.getText(187) + ": ", grh.w / 2 - str_len - this.awards[0].getWidth() / 2 - 3 + len_diff / 2, 12 + AEFont.getRowHeight());
                        AEFont.drawString(rep, grh.w / 2 - str_len - this.awards[0].getWidth() / 2, 12 + 2 * AEFont.getRowHeight() + 2);
                    } else {
                        len_diff = AEFont.getStringWidth(grh.gameText.getText(187) + ": ") - AEFont.getStringWidth(rep);
                        AEFont.drawString(grh.gameText.getText(187) + ": ", grh.w / 2 - str_len - this.awards[0].getWidth() / 2 - 3, 12 + AEFont.getRowHeight());
                        AEFont.drawString(rep, grh.w / 2 - str_len - this.awards[0].getWidth() / 2 + len_diff / 2, 12 + 2 * AEFont.getRowHeight() + 2);
                    }
                    grh.g.drawImage(this.awards[this.reputation - 1], grh.w / 2 + str_len + this.awards[0].getWidth() / 2 + 6 - this.awards[0].getWidth(), 12 + AEFont.getRowHeight(), 0);
                }
                this.output = null;
                GUI.drawFooter(grh.gameText.getText(5), null, null);
                break;
            }
            case 3: {
                this.drawPauseMenu();
                break;
            }
            case 0: {
                if (this.intro_time > 2000) {
                    GUI.drawFightBox(this.margin_left, grh.h / 2 - AEFont.getRowHeight() / 2 - 6, grh.w - 2 * this.margin_left, AEFont.getRowHeight() + 12, 4653313, true, true);
                    if (grh.game_mode == 1) {
                        AEFont.drawString(grh.gameText.getText(112) + " " + this.round, grh.w / 2 - AEFont.getStringWidth(grh.gameText.getText(112) + " " + this.round) / 2, grh.h / 2 - AEFont.getRowHeight() / 2);
                    } else if (grh.game_mode == 4) {
                        AEFont.drawString(grh.gameText.getText(178) + " " + this.round, grh.w / 2 - AEFont.getStringWidth(grh.gameText.getText(178) + " " + this.round) / 2, grh.h / 2 - AEFont.getRowHeight() / 2);
                    } else {
                        AEFont.drawString(grh.gameText.getText(116) + " " + this.round, grh.w / 2 - AEFont.getStringWidth(grh.gameText.getText(116) + " " + this.round) / 2, grh.h / 2 - AEFont.getRowHeight() / 2);
                    }
                } else if (this.intro_time <= 1000 && grh.game_mode != 4) {
                    GUI.drawFightBox(this.margin_left, grh.h / 2 - AEFont.getRowHeight() / 2 - 6, grh.w - 2 * this.margin_left, AEFont.getRowHeight() + 12, 4653313, true, true);
                    AEFont.drawString(grh.gameText.getText(113), grh.w / 2 - AEFont.getStringWidth(grh.gameText.getText(113)) / 2, grh.h / 2 - AEFont.getRowHeight() / 2);
                }
                this.drawFightInterface();
                GUI.drawPauseIcon();
                break;
            }
            case 1: {
                if (this.outro_time > 2500) {
                    String text = "";
                    if (this.opponent.getWins() < this.needed_wins) {
                        // empty if block
                    }
                    if (this.player.getHitPoints() == this.opponent.getHitPoints()) {
                        GUI.drawFightBox(this.margin_left, grh.h / 2 - AEFont.getRowHeight() / 2 - 6, grh.w - 2 * this.margin_left, AEFont.getRowHeight() + 12, 4653313, true, true);
                        text = grh.gameText.getText(114);
                    } else if (this.player.getWins() >= this.needed_wins) {
                        GUI.drawFightBox(this.margin_left, grh.h / 2 - AEFont.getRowHeight() / 2 - 6, grh.w - 2 * this.margin_left, AEFont.getRowHeight() + 12, 4653313, true, true);
                        text = grh.gameText.getText(110);
                    } else if (this.opponent.getWins() >= this.needed_wins) {
                        grh.g.drawImage(this.defeat, grh.w / 2 - this.defeat.getWidth() / 2, grh.h / 2 - this.defeat.getHeight() / 2 - 1, 0);
                        text = grh.gameText.getText(111);
                    } else if (this.player.isDead() || this.opponent.isDead()) {
                        text = "";
                    } else {
                        GUI.drawFightBox(this.margin_left, grh.h / 2 - AEFont.getRowHeight() / 2 - 6, grh.w - 2 * this.margin_left, AEFont.getRowHeight() + 12, 4653313, true, true);
                        text = grh.gameText.getText(115);
                    }
                    AEFont.drawString(text, grh.w / 2 - AEFont.getStringWidth(text) / 2, grh.h / 2 - AEFont.getRowHeight() / 2);
                }
                this.drawFightInterface();
                break;
            }
            case 13: {
                this.drawFightInterface();
                this.drawLessonTitle();
                GUI.drawPauseIcon();
                break;
            }
            case 18: {
                GUI.drawTransparentPattern();
                if (this.box != null) {
                    this.box.draw((this.keystate & 0x8000) != 0, (this.keystate & 0x10000) != 0, (int)this.elapsed_time);
                }
                GUI.drawFooter(grh.gameText.getText(5), "drawArrows()", null);
                break;
            }
            case 17: {
                this.drawFightInterface();
                if (this.showMsg) {
                    GUI.drawTransparentPattern();
                    AEFont.setFont((byte)0);
                    if (this.choiceWindow != null) {
                        this.choiceWindow.draw((int)this.elapsed_time);
                    }
                }
                GUI.drawFooter(grh.gameText.getText(5), null, null);
                break;
            }
            case 12: {
                this.drawLessonComment();
                this.drawFightInterface();
                this.drawLessonTitle();
                GUI.drawFooter(grh.gameText.getText(5), null, grh.gameText.getText(118));
                break;
            }
            case 14: {
                if (!this.player.performsSpecial() && !this.opponent.performsSpecial()) {
                    GUI.drawTutorialDPad(this.round - 1, (int)this.elapsed_time);
                }
            }
            case 16: {
                this.drawLessonTitle();
            }
            case 2: {
                this.drawFightInterface();
                if (this.showMsg) {
                    GUI.drawTransparentPattern();
                    if (this.choiceWindow != null) {
                        this.choiceWindow.draw((int)this.elapsed_time);
                    }
                } else {
                    GUI.drawPauseIcon();
                }
                if (grh.game_mode != 3 || !WRITE_PROTOCOL_FILE) break;
                grh.g.setColor(255, 0, 0);
                grh.g.drawString("HP (p): " + this.player.getHitPoints(), 0, 30, 0);
                grh.g.drawString("HP (o): " + this.opponent.getHitPoints(), 0, 42, 0);
                grh.g.drawString("Fame (p): " + this.player.getFame(), 0, 62, 0);
                grh.g.drawString("Fame (o): " + this.opponent.getFame(), 0, 82, 0);
            }
        }
        if (SHOW_FPS) {
            grh.g.setColor(255, 0, 0);
            grh.g.drawString("fps: " + 1000L / this.elapsed_time, 10, 50, 0);
            if (grh.cheat_fight) {
                grh.g.drawString("flag: " + this.arena.getRenderFlag(), 10, 65, 0);
            }
        }
        grh.g.setColor(255, 0, 0);
    }

    public void onRender3D() {
        if (this.state == 3) {
            return;
        }
        if (this.init != 0) {
            return;
        }
        if (this.arena != null) {
            if (this.player.isInSlowMoMode() || this.opponent.isInSlowMoMode()) {
                this.arena.render();
                grh.device.bind(grh.g);
                grh.renderer.drawLayers(this.slow_mo_time * 2L / 3L);
                grh.device.unbind(grh.g);
                grh.g.drawImage(this.special_raster, grh.w / 2, grh.h / 2, 3);
            } else {
                this.arena.render();
            }
        }
        if ((this.player.isInSlowMoMode() || this.opponent.isInSlowMoMode()) && this.slow_mo_time == 0L) {
            this.slow_mo_time = this.ingame_time;
        } else if (!this.player.isInSlowMoMode() && !this.opponent.isInSlowMoMode() && this.slow_mo_time != 0L) {
            this.ingame_time = this.slow_mo_time;
            this.slow_mo_time = 0L;
        }
        if (this.player != null && this.renderPlayer) {
            this.player.render();
            if (this.player.hasRedTrails()) {
                if (this.last_p_trails != 1) {
                    if (this.player.newAnim) {
                        this.last_p_trails = 1;
                    } else if (this.last_p_trails == 2) {
                        this.player.renderBlueTrails();
                    }
                } else {
                    this.last_p_trails = 1;
                    this.player.renderRedTrails();
                }
            } else if (this.player.hasBlueTrails()) {
                if (this.last_p_trails != 2) {
                    if (this.player.newAnim) {
                        this.last_p_trails = (byte)2;
                    } else if (this.last_p_trails == 1) {
                        this.player.renderRedTrails();
                    }
                } else {
                    this.last_p_trails = (byte)2;
                    this.player.renderBlueTrails();
                }
            } else {
                this.last_p_trails = 0;
            }
            this.player.newAnim = false;
        }
        if (this.opponent != null && this.state != 8) {
            this.opponent.render();
            if (this.opponent.hasRedTrails()) {
                if (this.last_o_trails != 1) {
                    if (this.opponent.newAnim) {
                        this.last_o_trails = 1;
                    } else if (this.last_o_trails == 2) {
                        this.opponent.renderBlueTrails();
                    }
                } else {
                    this.last_o_trails = 1;
                    this.opponent.renderRedTrails();
                }
            } else if (this.opponent.hasBlueTrails()) {
                if (this.last_o_trails != 2) {
                    if (this.opponent.newAnim) {
                        this.last_o_trails = (byte)2;
                    } else if (this.last_o_trails == 1) {
                        this.opponent.renderRedTrails();
                    }
                } else {
                    this.last_o_trails = (byte)2;
                    this.opponent.renderBlueTrails();
                }
            } else {
                this.last_o_trails = 0;
            }
            this.opponent.newAnim = false;
        }
        if (this.state == 7 && this.sponsorMesh != null && this.player.getID() != 8 && this.opponent.getID() != 8) {
            this.sponsorMesh.update(false);
            grh.renderer.render(this.sponsorMesh);
        }
        grh.device.bind(grh.g);
        if (this.state == 3 || this.state == 18) {
            grh.renderer.drawLayers(this.pause_time * 2L / 3L);
        } else if (this.player.isInSlowMoMode() || this.opponent.isInSlowMoMode()) {
            grh.renderer.drawLayers(this.slow_mo_time * 2L / 3L);
        } else {
            grh.renderer.drawLayers(this.ingame_time * 2L / 3L);
        }
        grh.device.unbind(grh.g);
    }

    private void saveGame() {
        grh.resume_time = this.round_time;
        grh.resume_round = this.round;
        grh.resume_char_health = this.player.getHitPoints();
        grh.resume_opponent_health = this.opponent.getHitPoints();
        grh.resume_char_fame = this.player.getFame();
        grh.resume_opponent_fame = this.opponent.getFame();
        grh.resume_char_wins = this.player.getWins();
        grh.resume_opponent_wins = this.opponent.getWins();
        grh.resume_game_mode = grh.game_mode;
        grh.resume_current_fight = grh.current_fight;
        grh.resume_char_id = grh.char_id;
        grh.resume_opponent_id = grh.opponent_id;
        grh.resume_total_fame = grh.total_fame;
        grh.resume_difficulty = grh.difficulty;
        grh.saveLastGame(grh.game_mode);
    }

    private void loadSpecificFightData() {
        if (grh.resume_time != -1) {
            this.round_time = grh.resume_time;
        }
        if (this.round_time > grh.round_time[grh.time_limit]) {
            this.round_time = grh.round_time[grh.time_limit];
        }
        if (grh.resume_round != -1) {
            this.round = grh.resume_round;
        }
        if (grh.resume_char_health != -1) {
            this.player.setHitPoints(grh.resume_char_health);
        }
        if (grh.resume_opponent_health != -1) {
            this.opponent.setHitPoints(grh.resume_opponent_health);
        }
        if (grh.resume_char_fame != -1) {
            this.player.setFame(grh.resume_char_fame, false);
        }
        if (grh.resume_opponent_fame != -1) {
            this.opponent.setFame(grh.resume_opponent_fame, false);
        }
        if (grh.resume_char_wins != -1) {
            this.player.setWins(grh.resume_char_wins);
        }
        if (grh.resume_opponent_wins != -1) {
            this.opponent.setWins(grh.resume_opponent_wins);
        }
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

