/*
 * Decompiled with CFR 0.152.
 */
package Main;

import AbyssEngine.AECamera;
import AbyssEngine.AEEaseInOut;
import AbyssEngine.AEGroup;
import AbyssEngine.AELookAtConstraint;
import AbyssEngine.AEMath;
import AbyssEngine.AEResourceManager;
import AbyssEngine.AEScene;
import AbyssEngine.AEVector3D;
import FLToolkit.AEFont;
import FLToolkit.AEModule;
import FLToolkit.ChoiceWindow;
import FLToolkit.ImgAdjust;
import FLToolkit.MenuItem;
import FLToolkit.ScrollTextBox;
import FLToolkit.SimpleMenu;
import FLToolkit.grh;
import GameEssentials.Arena;
import GameEssentials.Fighter;
import GameEssentials.FighterAI;
import GameEssentials.GUI;
import com.Fishlabs.AEBluetooth.FLBluetooth;
import javax.microedition.lcdui.Image;

public class ModMenu
extends AEModule {
    private static final int STATE_MENU = 0;
    private static final int STATE_CHAR_SELECT = 1;
    private static final int STATE_CHAR_INFO = 2;
    private static final int STATE_NO_CONNECTION = 3;
    private static final int STATE_VERSUS = 4;
    private static final int MENU_MAIN = 0;
    private static final int MENU_OPTIONS = 1;
    private static final int MENU_HELP = 2;
    private static final int MENU_MORE_GAMES = 3;
    private static final int MENU_ABOUT = 4;
    private static final int MENU_PLAY = 5;
    private static final int MENU_DIFFICULTY = 6;
    private static final int MENU_BLUETOOTH = 7;
    private static final int MENU_SERVER = 8;
    private static final int MENU_CLIENT = 9;
    private static final int MENU_SERVER_SELECT = 10;
    private static final int MENU_RESUME = 11;
    private static final int MENU_CONTROLS = 12;
    private static final int MENU_LANGUAGE = 13;
    private static final int ITEM_PLAY = 0;
    private static final int ITEM_OPTIONS = 1;
    private static final int ITEM_HELP = 2;
    private static final int ITEM_ABOUT = 3;
    private static final int ITEM_QUIT = 4;
    private static final int ITEM_GET_MORE_GAMES = -1;
    private static final int ITEM_SOUND = 0;
    private static final int ITEM_VIBRATION = 1;
    private static final int ITEM_TIME_LIMIT = 2;
    private static final int ITEM_LANGUAGE = 3;
    private static int ITEM_ARCADE = 0;
    private static int ITEM_SURVIVAL = 1;
    private static int ITEM_TRAINING = 2;
    private static int ITEM_BLUETOOTH = 3;
    private static final int ITEM_EASY = 0;
    private static final int ITEM_NORMAL = 1;
    private static final int ITEM_HARD = 2;
    private static final int ITEM_HOST_GAME = 0;
    private static final int ITEM_JOIN_GAME = 1;
    private static final int ITEM_RECONNECT_1 = 2;
    private static final int ITEM_RECONNECT_2 = 3;
    private static final int ITEM_RECONNECT_3 = 4;
    private static final int ITEM_RESUME = 0;
    private static final int ITEM_START_NEW_GAME = 1;
    private static final int ITEM_INSTRUCTIONS = 0;
    private static final int ITEM_CONTROLS = 1;
    private static final int ITEM_TUTORIAL = 2;
    private SimpleMenu menu;
    private ScrollTextBox textBox;
    private ChoiceWindow choiceWindow;
    private boolean showMsg;
    private boolean showNewUnlocked;
    private int state;
    private int lastMenu;
    private int lastItem;
    private int secondToLastItem;
    private int currentMenu;
    private int currentItem;
    private int rootItemCount;
    private int selection_mark_time;
    private AEEaseInOut ease_menu;
    private AEEaseInOut ease_character;
    private AEEaseInOut ease_next_fighter_selection;
    private AEEaseInOut ease_versus;
    private String subMenuText;
    private int EASE_OUT_VALUE;
    private int EASE_IN_VALUE;
    private int fade_state;
    private static final int FADE_NONE = 0;
    private static final int FADE_IN = 1;
    private static final int FADE_OUT = 2;
    private static final int FADE_OUT_AND_IN = 3;
    private static final int CHAR_EASE_IN = 0;
    private static final int CHAR_EASE_OUT = 400;
    private int char_fade_state;
    private static final int INFO_SWITCH_TIME = 3500;
    private int info_switch_time;
    private boolean showCharacterName;
    private boolean showCharacterSelect;
    private int portrait_width;
    private int portrait_spacing;
    private int char_index;
    private int last_char_index;
    private String cheatCode;
    private static final int LOGO_MEANDER_SPACING = 10;
    private static final int BORDER_HEIGHT = 4;
    private static final int ATTR_OFFSET_X = 1;
    private static final int ATTR_OFFSET_Y = 2;
    private static final int ATTR_BAR_OFFSET_Y = 3;
    private static final int NEXT_FIGHT_PORTRAIT_SPACING = 12;
    private static final int EAGLE_OFFSET = 0;
    private static final int SUBMENU_TEXT_OFFSET = -1;
    private static final int SUBMENU_CHAR_NAME_OFFSET = 2;
    private static final int EASE_OFFSET = 9;
    private static final int SUB_MENU_TXT_BOX_ADD = 0;
    private static final int JEWEl_OFFSET = 1;
    private static final int MENU_TEXT_OFFSET = 3;
    private static final int STATS_OFFSET = 12;
    private static final int DISABLE_DIFFICULTY_LINE_OFFSET = 2;
    private static final int PORTRAIT_SPACING = 10;
    private static final int BG_DARK = 921102;
    private static final int COLOR_ATTR_0 = 13842693;
    private static final int COLOR_ATTR_1 = 16740864;
    private Image[] char_icons;
    private Image[] char_names;
    private Image border;
    private Image border_selected;
    private Image disable;
    private Image menu_meander;
    private Image gladiator_logo;
    private Image menu_eagle;
    private Image attributeBar;
    private Image attributeJewel;
    private Image versus;
    private Image cross;
    private Image arrow_vs;
    private Image[] awards;
    private AEScene scene;
    private AECamera cam;
    private Fighter fighter;
    private Fighter next_fighter;
    private AEGroup target;
    private AELookAtConstraint lookat;
    private Arena arena;
    private Fighter player;
    private Fighter opponent;
    private FighterAI[] fighterAI;
    private boolean characterPicked;
    private boolean reinitModule;
    private int[] attribs = new int[]{0, 0, 0, 0};
    private boolean isInitialized;
    private int reinitCharacter;
    private int last_opponent;
    private boolean noResume;
    private boolean btSearchForServers;
    private int[][] char_select_translation = new int[][]{{-20, -60, 0, 0}, {0, 0, 0, 0}, {-40, -20, -10, -100}, {-100, -40, 0, 0}, {-60, -30, -10, 0}, {-60, -40, -20, -150}, {-20, -20, -10, 0}, {-20, 0, -20, 0}, {0, 0, 0, 0}};
    private int[][] versus_left_translation = new int[][]{{20, -30, -80, 60}, {40, 20, 60, -80}, {-20, 0, -60, -40}, {-10, -20, -30, 50}, {-20, 0, -50, 0}, {-20, -10, -50, 0}, {20, 0, -80, -100}, {0, 20, -20, 100}, {0, 0, 0, 0}};
    private int[][] versus_right_translation = new int[][]{{0, -35, -30, 0}, {-20, 20, 60, 80}, {-10, 0, -50, 200}, {0, -20, -40, -40}, {0, 0, -60, 100}, {0, -10, -60, 150}, {0, 0, -20, 70}, {0, 20, 30, 0}, {-20, 30, 60, 0}};
    private int init = 10;

    public int onInitialize() {
        switch (this.init) {
            case 10: {
                MenuItem[] difficultyMenu;
                MenuItem[] playMenu;
                this.cheatCode = "";
                this.btSearchForServers = false;
                this.noResume = false;
                AEFont.setFont((byte)0);
                if (this.textBox == null) {
                    this.textBox = new ScrollTextBox("Credits coming soon");
                }
                if (this.state == 3) {
                    this.textBox.fadeIn();
                }
                this.menu = new SimpleMenu();
                this.rootItemCount = 5;
                MenuItem[] rootMenu = new MenuItem[this.rootItemCount];
                rootMenu[0] = new MenuItem(grh.gameText.getText(0), null);
                rootMenu[1] = new MenuItem(grh.gameText.getText(1), null);
                rootMenu[3] = new MenuItem(grh.gameText.getText(3), null);
                rootMenu[2] = new MenuItem(grh.gameText.getText(2), null);
                rootMenu[4] = new MenuItem(grh.gameText.getText(4), null);
                int menu_length = 3;
                if (FLBluetooth.hasDeviceBluetoothSupport()) {
                    playMenu = new MenuItem[menu_length + 1];
                    playMenu[ModMenu.ITEM_BLUETOOTH] = new MenuItem(grh.gameText.getText(10), null);
                } else {
                    playMenu = new MenuItem[menu_length];
                }
                playMenu[ModMenu.ITEM_ARCADE] = new MenuItem(grh.gameText.getText(8), null);
                playMenu[ModMenu.ITEM_SURVIVAL] = new MenuItem(grh.gameText.getText(9), null);
                playMenu[ModMenu.ITEM_TRAINING] = new MenuItem(grh.gameText.getText(11), null);
                if (grh.unlocked_difficulty > 1) {
                    difficultyMenu = new MenuItem[3];
                    difficultyMenu[2] = new MenuItem(grh.gameText.getText(15), null);
                } else {
                    difficultyMenu = new MenuItem[]{new MenuItem(grh.gameText.getText(13), null), new MenuItem(grh.gameText.getText(14), null)};
                }
                MenuItem[] resumeMenu = new MenuItem[]{new MenuItem(grh.gameText.getText(20), null), new MenuItem(grh.gameText.getText(21), null)};
                MenuItem[] moreGamesMenu = new MenuItem[]{new MenuItem(null, null)};
                MenuItem[] aboutMenu = new MenuItem[]{new MenuItem(null, null)};
                MenuItem[] helpMenu = new MenuItem[]{new MenuItem(grh.gameText.getText(24), null), new MenuItem(grh.gameText.getText(22), null), new MenuItem(grh.gameText.getText(23), null)};
                MenuItem[] controlsMenu = new MenuItem[]{new MenuItem(null, null)};
                MenuItem[] instructionsMenu = new MenuItem[]{new MenuItem(null, null)};
                MenuItem[] optionsMenu = new MenuItem[4];
                optionsMenu[3] = new MenuItem(grh.gameText.getText(25), null);
                optionsMenu[0] = new MenuItem(grh.gameText.getText(26), new String[]{grh.gameText.getText(27), "25%", "50%", "75%", "100%"});
                optionsMenu[1] = new MenuItem(grh.gameText.getText(29), new String[]{grh.gameText.getText(28), grh.gameText.getText(27)});
                optionsMenu[2] = new MenuItem(grh.gameText.getText(30) + ":", new String[]{grh.gameText.getText(31), "60s", "90s"});
                optionsMenu[2].setToggleIndex(grh.time_limit);
                optionsMenu[0].setToggleIndex(grh.volume);
                if (grh.vibration) {
                    optionsMenu[1].setToggleIndex(0);
                } else {
                    optionsMenu[1].setToggleIndex(1);
                }
                MenuItem[] langMenu = new MenuItem[]{new MenuItem("English", null), new MenuItem("Deutsch", null), new MenuItem("Fran\u00e7ais", null), new MenuItem("Italiano", null), new MenuItem("Espa\u00f1ol", null)};
                int count = 2;
                boolean reconnectPossible = false;
                if (FLBluetooth.clientGetLastServerCount() != 0) {
                    for (int i = 0; i < FLBluetooth.clientGetLastServerCount(); ++i) {
                        if (FLBluetooth.clientGetLastServerName(i).length() <= 0) continue;
                        ++count;
                        reconnectPossible = true;
                    }
                }
                MenuItem[] bluetoothMenu = new MenuItem[count];
                bluetoothMenu[0] = new MenuItem(grh.gameText.getText(51), null);
                bluetoothMenu[1] = new MenuItem(grh.gameText.getText(52), null);
                if (reconnectPossible) {
                    for (int i = 0; i < FLBluetooth.clientGetLastServerCount(); ++i) {
                        if (FLBluetooth.clientGetLastServerName(i).length() <= 0) continue;
                        bluetoothMenu[2 + i] = new MenuItem(grh.gameText.getText(53) + ": " + FLBluetooth.clientGetLastServerName(i), null);
                    }
                }
                MenuItem[] serverMenu = new MenuItem[]{new MenuItem(null, null)};
                MenuItem[] clientMenu = new MenuItem[]{new MenuItem(null, null)};
                FLBluetooth.DEBUG = true;
                this.menu.addMenu(0, null, rootMenu);
                this.menu.addMenu(5, new int[]{0}, playMenu);
                this.menu.addMenu(11, new int[]{0, ITEM_ARCADE}, resumeMenu);
                this.menu.addMenu(11, new int[]{0, ITEM_SURVIVAL}, resumeMenu);
                this.menu.addMenu(6, new int[]{0, ITEM_ARCADE, 1}, difficultyMenu);
                this.menu.addMenu(6, new int[]{0, ITEM_TRAINING}, difficultyMenu);
                this.menu.addMenu(1, new int[]{1}, optionsMenu);
                this.menu.addMenu(13, new int[]{1, 3}, langMenu);
                if (FLBluetooth.hasDeviceBluetoothSupport()) {
                    this.menu.addMenu(7, new int[]{0, ITEM_BLUETOOTH}, bluetoothMenu);
                    this.menu.addMenu(8, new int[]{0, ITEM_BLUETOOTH, 0}, serverMenu);
                    this.menu.addMenu(9, new int[]{0, ITEM_BLUETOOTH, 1}, clientMenu);
                    if (reconnectPossible) {
                        for (int i = 0; i < count - 2; ++i) {
                            this.menu.addMenu(9, new int[]{0, ITEM_BLUETOOTH, 2 + i}, clientMenu);
                        }
                    }
                }
                this.menu.addMenu(4, new int[]{3}, aboutMenu);
                this.menu.addMenu(2, new int[]{2}, helpMenu);
                this.menu.addMenu(12, new int[]{2, 1}, controlsMenu);
                this.menu.addMenu(12, new int[]{2, 0}, instructionsMenu);
                this.menu.setCurrentMenu(this.currentMenu, this.currentItem);
                break;
            }
            case 9: {
                this.cam = AECamera.create(grh.w, grh.h, 720, 100, 32000);
                this.cam.translate(500, 100, 250);
                this.cam.rotate(0, 0, 0);
                grh.renderer.setCamera(this.cam);
                this.target = new AEGroup();
                this.target.translate(-350, 100, 0);
                this.scene = new AEScene();
                this.scene.addChild(this.cam);
                this.scene.addChild(this.target);
                this.lookat = new AELookAtConstraint(this.target, this.cam);
                this.scene.addConstraint(this.lookat);
                if (this.state != 0 && this.state != 3) break;
                this.arena = new Arena(110, true);
                break;
            }
            case 8: {
                this.fighter = this.createFighter(this.fighter, this.char_index, true);
                this.fighter.setHitPoints(1);
                this.fighter.idle();
                this.fighter.initMenuMode();
                this.next_fighter = this.createFighter(this.next_fighter, grh.opponent_id, false);
                this.next_fighter.setHitPoints(1);
                this.next_fighter.idle();
                this.next_fighter.initMenuMode();
                this.fighter.setOpponent(this.next_fighter);
                this.next_fighter.setOpponent(this.fighter);
                break;
            }
            case 7: {
                if (this.state != 0 && this.state != 3) break;
                this.player = this.createFighter(this.player, 7, false);
                this.opponent = this.createFighter(this.opponent, 0, false);
                this.player.setOpponent(this.opponent);
                this.opponent.setOpponent(this.player);
                this.player.setPosition(0);
                this.opponent.setPosition(1);
                this.player.initMenuMode();
                this.opponent.initMenuMode();
                this.cam.setTranslation(0, 150, 2400);
                this.cam.setRotation(0, 0, 0);
                break;
            }
            case 6: {
                if (this.state != 0 && this.state != 3) break;
                this.fighterAI = new FighterAI[2];
                this.fighterAI[0] = new FighterAI(1, 0);
                this.fighterAI[0].setFighters(this.player, this.opponent);
                this.fighterAI[0].disableSpecials();
                this.fighterAI[1] = new FighterAI(1, 0);
                this.fighterAI[1].setFighters(this.opponent, this.player);
                this.fighterAI[1].disableSpecials();
                break;
            }
            case 5: {
                int i;
                this.char_icons = new Image[grh.fighter_names.length];
                for (i = 0; i < this.char_icons.length; ++i) {
                    this.char_icons[i] = GUI.getCharacterIcon(i);
                }
                this.char_names = new Image[grh.fighter_names.length];
                for (i = 0; i < this.char_names.length; ++i) {
                    this.char_names[i] = GUI.getCharacterLogo(i);
                }
                this.disable = ImgAdjust.getCypherImage("/data/2d/240x320/disable_grey.png");
                this.border = ImgAdjust.getCypherImage("/data/2d/240x320/border_vs.png");
                this.border_selected = ImgAdjust.getCypherImage("/data/2d/240x320/border_selected.png");
                this.portrait_width = this.char_icons[0].getWidth();
                this.portrait_spacing = 10;
                this.menu_meander = ImgAdjust.getCypherImage("/data/2d/240x320/menu_meander.png");
                this.gladiator_logo = ImgAdjust.getCypherImage("/data/2d/240x320/gladiator_logo.png");
                this.menu_eagle = ImgAdjust.getCypherImage("/data/2d/240x320/menu_eagle.png");
                this.attributeBar = ImgAdjust.getCypherImage("/data/2d/240x320/attr_bar.png");
                this.attributeJewel = ImgAdjust.getCypherImage("/data/2d/240x320/attr_jewel.png");
                this.versus = ImgAdjust.getCypherImage("/data/2d/240x320/menu_vs.png");
                this.arrow_vs = ImgAdjust.getCypherImage("/data/2d/240x320/arrow_vs.png");
                this.cross = ImgAdjust.getCypherImage("/data/2d/240x320/cross.png");
                this.awards = new Image[3];
                this.awards[0] = ImgAdjust.getCypherImage("/data/2d/240x320/vict_bronze.png");
                this.awards[1] = ImgAdjust.getCypherImage("/data/2d/240x320/vict_silver.png");
                this.awards[2] = ImgAdjust.getCypherImage("/data/2d/240x320/vict_gold.png");
                break;
            }
            case 4: {
                this.EASE_OUT_VALUE = 4 + 2 * this.menu_meander.getHeight() + this.gladiator_logo.getHeight() + 20 + 3;
                this.EASE_IN_VALUE = 4 + 2 * this.menu_meander.getHeight() + this.gladiator_logo.getHeight() + 20 - 1 - AEMath.max(AEFont.getRowHeight(), this.char_names[0].getHeight());
                this.ease_menu = new AEEaseInOut(this.EASE_IN_VALUE, this.EASE_OUT_VALUE);
                if (this.state == 4) {
                    this.ease_menu.increase(10000000);
                } else {
                    this.ease_menu.decrease(10000000);
                }
                this.ease_character = new AEEaseInOut(0, 400);
                this.char_fade_state = 1;
                this.ease_character.increase(100000);
                this.ease_next_fighter_selection = new AEEaseInOut(0, this.char_icons[0].getWidth() + 12);
                this.ease_next_fighter_selection.decrease(100000);
                this.ease_versus = new AEEaseInOut(0, grh.h / 2 + this.versus.getHeight() / 2);
                this.ease_versus.decrease(10000);
                if (this.currentMenu == 13 || this.state == 3) break;
                this.subMenuText = "";
                break;
            }
            case 3: {
                GUI.init();
                if (this.state == 1) {
                    this.fade_state = 1;
                    if (this.showCharacterSelect) {
                        this.subMenuText = grh.gameText.getText(16);
                        this.showCharacterSelect = false;
                    } else {
                        this.showCharacterName = true;
                        this.info_switch_time = 0;
                        this.subMenuText = grh.fighter_names[this.char_index];
                    }
                }
                this.reinitModule = false;
                this.reinitCharacter = 0;
                break;
            }
            case 2: {
                this.displayUnlockablesIfNecessary();
                if (this.state == 1 || this.state == 4) {
                    if (grh.volume == 0) break;
                    if (grh.sound.isMusicPlaying()) {
                        if (grh.sound.getLastMusic() == 18) break;
                    }
                    grh.sound.stop();
                    grh.sound.playMusic(18);
                    break;
                }
                if (grh.volume == 0) break;
                if (grh.sound.isMusicPlaying()) {
                    if (grh.sound.getLastMusic() == 17) break;
                }
                grh.sound.stop();
                grh.sound.playMusic(17);
            }
        }
        --this.init;
        System.gc();
        this.isInitialized = this.init == 0;
        return this.init;
    }

    public void reset() {
        this.initMenuState();
        this.fade_state = 0;
        this.currentMenu = 0;
        this.currentItem = 0;
    }

    public void showBluetoothTerminate() {
        this.state = 3;
        this.initTextBox(this.textBox, grh.gameText.getText(10), grh.gameText.getText(54));
        this.subMenuText = grh.gameText.getText(59);
    }

    public void jumpToCharSelect() {
        if (grh.game_mode != 2) {
            grh.opponent_id = -1;
        }
        this.state = 1;
        this.characterPicked = false;
        this.fade_state = 3;
        this.showCharacterSelect = true;
        this.info_switch_time = 0;
        this.char_fade_state = 1;
    }

    private void displayUnlockablesIfNecessary() {
        if (grh.last_unlocked_character != grh.unlocked_character || grh.last_unlocked_difficulty != grh.unlocked_difficulty || grh.unlock_hint) {
            this.showMsg = true;
            String text = "";
            if (grh.unlock_hint) {
                text = text + grh.gameText.getText(188);
                grh.unlock_hint = false;
            } else if (grh.last_unlocked_character != grh.unlocked_character) {
                text = grh.unlocked_character - grh.last_unlocked_character == 1 ? text + grh.gameText.getText(34) + ":\n\n" : text + grh.gameText.getText(35) + ":\n\n";
                for (int i = grh.last_unlocked_character + 1; i <= grh.unlocked_character; ++i) {
                    text = text + " - " + grh.fighter_names[i] + "\n";
                }
                grh.last_unlocked_character = grh.unlocked_character;
            }
            if (grh.last_unlocked_difficulty != grh.unlocked_difficulty) {
                if (text.length() > 2) {
                    text = text + "\n";
                }
                text = text + grh.gameText.getText(36) + ":\n\n";
                if (grh.last_unlocked_difficulty == 0) {
                    text = text + " - " + grh.gameText.getText(14) + "\n";
                    if (!grh.cheat_unlock) {
                        text = text + "\n" + grh.gameText.getText(189);
                    }
                } else {
                    text = text + " - " + grh.gameText.getText(15) + "\n";
                }
                grh.last_unlocked_difficulty = grh.unlocked_difficulty;
            }
            if (this.choiceWindow == null) {
                this.choiceWindow = new ChoiceWindow();
            }
            this.showNewUnlocked = true;
            this.choiceWindow.set(text, false);
        }
    }

    private void updateCamera() {
        AEVector3D dir = new AEVector3D();
        dir = this.opponent.getFuturePosition().sub(this.player.getFuturePosition(), dir);
        int len = dir.length();
        AEVector3D up = new AEVector3D(0, 4096, 0);
        AEVector3D right = new AEVector3D();
        right = dir.cross(up, right);
        right.normalize();
        AEVector3D ideal_target_pos = new AEVector3D();
        ideal_target_pos.set(this.player.getFutureX() + dir.x / 2, 200, this.player.getFutureZ() + dir.z / 2);
        AEVector3D ideal_cam_pos = new AEVector3D();
        ideal_cam_pos.set(ideal_target_pos.x + (right.x * len * 2 >> 12), 200, ideal_target_pos.z + (right.z * len * 2 >> 12));
        if (ideal_cam_pos.z < -2200) {
            ideal_cam_pos.z = -2200;
        }
        if (ideal_cam_pos.z > 2200) {
            ideal_cam_pos.z = 2200;
        }
        if (ideal_cam_pos.x < -2200) {
            ideal_cam_pos.x = -2200;
        }
        if (ideal_cam_pos.x > 2200) {
            ideal_cam_pos.x = 2200;
        }
        dir = ideal_target_pos.sub(this.target.getPosition(), dir);
        len = dir.length();
        dir.normalize();
        this.target.setTranslation(this.target.getPositionX() + (dir.x * len / 2 >> 12), 150, this.target.getPositionZ() + (dir.z * len / 2 >> 12));
        AEVector3D test = new AEVector3D();
        test.set(this.target.getPosition());
        dir = ideal_cam_pos.sub(this.cam.getPosition(), dir);
        len = dir.length();
        dir.normalize();
        this.cam.setTranslation(this.cam.getPositionX() + (dir.x * len / 6 >> 12), 200, this.cam.getPositionZ() + (dir.z * len / 6 >> 12));
        dir = null;
    }

    private Fighter createFighter(Fighter fighter, int id, boolean checkForLock) {
        if (id == -1) {
            id = 1;
        }
        fighter = id > grh.unlocked_character && checkForLock ? new Fighter(id + 300, 20 + id) : new Fighter(id, 20 + id);
        fighter.setName(grh.fighter_names[id]);
        fighter.setStrength(grh.char_attributes[id][0]);
        fighter.setConstitution(grh.char_attributes[id][1]);
        fighter.setAgility(grh.char_attributes[id][2]);
        fighter.setCharisma(grh.char_attributes[id][3]);
        fighter.setHitPoints(1);
        return fighter;
    }

    private void initCharacterSelect() {
        if (grh.volume != 0) {
            if (grh.sound.getLastMusic() != 18) {
                grh.sound.stop();
                grh.sound.playMusic(18);
            }
        }
        this.state = 1;
        this.fade_state = 3;
        this.showCharacterSelect = true;
        this.info_switch_time = 0;
        this.char_fade_state = 1;
        this.characterPicked = false;
        this.isInitialized = false;
        grh.handle.setModule(grh.modules[0]);
    }

    private void initMenuState() {
        block2: {
            block3: {
                this.state = 0;
                if (grh.volume == 0) break block2;
                if (!grh.sound.isMusicPlaying()) break block3;
                if (grh.sound.getLastMusic() == 17) break block2;
            }
            grh.sound.stop();
            grh.sound.playMusic(17);
        }
    }

    public void onRelease() {
        int i;
        this.init = 10;
        this.isInitialized = false;
        this.menu = null;
        if (this.choiceWindow != null) {
            this.choiceWindow.release();
        }
        this.choiceWindow = null;
        this.ease_menu = null;
        this.ease_character = null;
        this.ease_next_fighter_selection = null;
        this.ease_versus = null;
        this.cheatCode = null;
        if (this.char_icons != null) {
            for (i = 0; i < this.char_icons.length; ++i) {
                if (this.char_icons[i] == null) continue;
                this.char_icons[i] = null;
            }
            this.char_icons = null;
        }
        if (this.char_names != null) {
            for (i = 0; i < this.char_names.length; ++i) {
                if (this.char_names[i] == null) continue;
                this.char_names[i] = null;
            }
            this.char_names = null;
        }
        this.border = null;
        this.border_selected = null;
        this.disable = null;
        this.menu_meander = null;
        this.gladiator_logo = null;
        this.menu_eagle = null;
        this.attributeBar = null;
        this.attributeJewel = null;
        this.versus = null;
        this.cross = null;
        this.arrow_vs = null;
        if (this.awards != null) {
            for (i = 0; i < this.awards.length; ++i) {
                this.awards[i] = null;
            }
            this.awards = null;
        }
        this.scene = null;
        this.cam = null;
        if (this.fighter != null) {
            this.fighter.release();
        }
        this.fighter = null;
        if (this.next_fighter != null) {
            this.next_fighter.release();
        }
        this.next_fighter = null;
        this.target = null;
        this.lookat = null;
        if (this.arena != null) {
            this.arena.release();
        }
        this.arena = null;
        if (this.player != null) {
            this.player.release();
        }
        this.player = null;
        if (this.opponent != null) {
            this.opponent.release();
        }
        this.opponent = null;
        if (this.fighterAI != null) {
            for (i = 0; i < this.fighterAI.length; ++i) {
                if (this.fighterAI[i] == null) continue;
                this.fighterAI[i].release();
                this.fighterAI[i] = null;
            }
            this.fighterAI = null;
        }
        GUI.release();
        AEResourceManager.releaseAllResources();
    }

    private void optionsToggle(int key, int currentItem, int toggleIndex) {
        block0 : switch (this.menu.getCurrentMenu()) {
            case 1: {
                switch (currentItem) {
                    case 0: {
                        grh.volume = toggleIndex;
                        if (toggleIndex == 0) {
                            grh.sound.stop();
                        } else if (toggleIndex == 1) {
                            grh.sound.playMusic(17);
                        }
                        grh.sound.setVolume(grh.volume);
                        grh.saveSettings();
                        break block0;
                    }
                    case 1: {
                        grh.vibration = toggleIndex == 0;
                        grh.saveSettings();
                        break block0;
                    }
                    case 2: {
                        grh.time_limit = toggleIndex;
                    }
                }
            }
        }
    }

    private void initTextBox(ScrollTextBox box, String title, String text) {
        box.setText(text);
        box.setTitle(title);
        box.fadeIn();
        box.resetScrollBar();
    }

    private void selectCharacterKeyPress(int key, boolean char_select) {
        int index = char_select ? this.char_index : grh.opponent_id;
        if (key == 16384) {
            if (++index == 9 || index == 8 && grh.unlocked_character < 8) {
                index = 0;
            }
            if (char_select) {
                this.fade_state = 2;
            }
            this.char_fade_state = 2;
            this.reinitModule = true;
        } else if (key == 8192) {
            if (--index == -1) {
                index = 8;
            }
            if (index == 8 && grh.unlocked_character < 8) {
                index = 7;
            }
            if (char_select) {
                this.fade_state = 2;
            }
            this.char_fade_state = 2;
            this.reinitModule = true;
        } else if (key == 32768 || key == 65536) {
            int value = 5;
            if (grh.unlocked_character < 8) {
                value = 4;
            }
            if (index < value) {
                if ((index += value) == 9) {
                    index = 8;
                }
                if (index == 8 && grh.unlocked_character < 8) {
                    index = 7;
                }
            } else {
                index -= value;
            }
            if (char_select) {
                this.fade_state = 2;
            }
            this.char_fade_state = 2;
            this.reinitModule = true;
        }
        if (char_select) {
            this.last_char_index = this.char_index;
            this.char_index = index;
        } else {
            this.last_opponent = grh.opponent_id;
            grh.opponent_id = index;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onKeyPress(int key) {
        if (key == 2) {
            System.gc();
        }
        if (this.ingame_time < 500L && this.state == 0) {
            return;
        }
        if (!(this.menu == null || this.menu.getCurrentMenu() != 4 || grh.cheat_unlock && grh.cheat_fight && grh.cheat_disableAI)) {
            switch (key) {
                case 1: {
                    this.cheatCode = this.cheatCode + "0";
                    break;
                }
                case 2: {
                    this.cheatCode = this.cheatCode + "1";
                    break;
                }
                case 32768: 
                case 32772: {
                    this.cheatCode = this.cheatCode + "2";
                    break;
                }
                case 8: {
                    this.cheatCode = this.cheatCode + "3";
                    break;
                }
                case 8192: 
                case 8208: {
                    this.cheatCode = this.cheatCode + "4";
                    break;
                }
                case 4096: {
                    this.cheatCode = this.cheatCode + "5";
                    break;
                }
                case 16384: 
                case 16448: {
                    this.cheatCode = this.cheatCode + "6";
                    break;
                }
                case 128: {
                    this.cheatCode = this.cheatCode + "7";
                    break;
                }
                case 65536: 
                case 65792: {
                    this.cheatCode = this.cheatCode + "8";
                    break;
                }
                case 512: {
                    this.cheatCode = this.cheatCode + "9";
                    break;
                }
                case 0x400000: {
                    if (this.cheatCode.length() <= 0) break;
                    this.cheatCode = this.cheatCode.substring(0, this.cheatCode.length() - 1);
                }
            }
            if (this.cheatCode.equalsIgnoreCase("24267466")) {
                this.cheatCode = "";
                grh.cheat_unlock = true;
                grh.unlocked_character = 8;
                grh.unlocked_difficulty = 2;
                this.isInitialized = false;
                grh.handle.setModule(grh.modules[0]);
                return;
            }
            if (this.cheatCode.equalsIgnoreCase("4523487")) {
                this.cheatCode = "";
                grh.cheat_fight = true;
            } else if (this.cheatCode.equalsIgnoreCase("79482424")) {
                this.cheatCode = "";
                grh.cheat_disableAI = true;
            } else {
                String s1 = "24267466";
                String s2 = "4523487";
                String s3 = "79482424";
                if (!(this.cheatCode.equalsIgnoreCase(s1.substring(0, this.cheatCode.length())) || this.cheatCode.equalsIgnoreCase(s2.substring(0, this.cheatCode.length())) || this.cheatCode.equalsIgnoreCase(s3.substring(0, this.cheatCode.length())))) {
                    this.cheatCode = "";
                }
            }
        }
        if (grh.cheat_fight && key == 16384 && this.state == 4 && grh.game_mode == 0) {
            if (++grh.current_fight == 5) {
                grh.current_fight = 0;
            }
            grh.opponent_id = grh.arcade_opponents[grh.char_id][grh.current_fight];
        }
        if (grh.cheat_fight && key == 8192 && this.state == 4 && grh.game_mode == 0) {
            if (--grh.current_fight == -1) {
                grh.current_fight = 4;
            }
            grh.opponent_id = grh.arcade_opponents[grh.char_id][grh.current_fight];
        }
        if (!this.isInitialized) {
            return;
        }
        switch (this.state) {
            case 0: {
                String t;
                this.currentMenu = this.menu.getCurrentMenu();
                this.currentItem = this.menu.getCurrentItem();
                block20 : switch (this.currentMenu) {
                    case 10: {
                        if (key == 262144) {
                            this.menu.setCurrentMenu(7, 1);
                            this.fade_state = 3;
                            FLBluetooth.disconnect(false);
                            return;
                        }
                        if (key != 4096 && key != 131072) break;
                        FLBluetooth.clientConnectToServer(this.currentItem);
                        break;
                    }
                    case 8: 
                    case 9: {
                        if (key != 262144) break;
                        this.btSearchForServers = false;
                        FLBluetooth.disconnect(false);
                        if (this.currentMenu == 8) {
                            this.menu.setCurrentMenu(7, 0);
                            return;
                        } else {
                            this.menu.setCurrentMenu(7, 1);
                        }
                        return;
                    }
                    case 7: {
                        if (key != 4096 && key != 131072) break;
                        switch (this.currentItem) {
                            case 0: {
                                this.initTextBox(this.textBox, grh.gameText.getText(55), grh.gameText.getText(58));
                                grh.btServer = true;
                                FLBluetooth.createServer();
                                break;
                            }
                            case 1: {
                                this.initTextBox(this.textBox, grh.gameText.getText(56), grh.gameText.getText(58));
                                grh.btServer = false;
                                FLBluetooth.createClient();
                                this.btSearchForServers = true;
                                break;
                            }
                            case 2: 
                            case 3: 
                            case 4: {
                                this.initTextBox(this.textBox, grh.gameText.getText(57), grh.gameText.getText(58));
                                grh.btServer = false;
                                FLBluetooth.createClient(this.currentItem - 2);
                            }
                        }
                        break;
                    }
                    case 6: {
                        if (key != 4096 && key != 131072) break;
                        switch (this.currentItem) {
                            case 0: {
                                grh.difficulty = 0;
                                break;
                            }
                            case 1: {
                                grh.difficulty = 1;
                                break;
                            }
                            case 2: {
                                grh.difficulty = 2;
                            }
                        }
                        this.initCharacterSelect();
                        return;
                    }
                    case 11: {
                        if (key != 4096 && key != 131072) break;
                        if (this.showMsg) {
                            this.showMsg = false;
                            if (!this.choiceWindow.fire()) return;
                            grh.resume_last_game = false;
                            if (grh.game_mode == 1) {
                                this.initCharacterSelect();
                                return;
                            }
                        } else if (this.currentItem == 0) {
                            this.loadGlobalFightData();
                            this.char_index = grh.char_id;
                            grh.resume_last_game = true;
                            if (grh.game_mode == 0) {
                                this.state = 4;
                                this.fade_state = 0;
                                this.ease_menu.decrease(10000);
                                this.isInitialized = false;
                                grh.handle.setModule(grh.modules[0]);
                                return;
                            }
                            this.isInitialized = false;
                            grh.handle.setModule(grh.modules[2]);
                        } else if (this.currentItem == 1) {
                            if (this.choiceWindow == null) {
                                this.choiceWindow = new ChoiceWindow();
                            }
                            this.choiceWindow.set(grh.gameText.getText(47), true);
                            this.showMsg = true;
                            return;
                        }
                        this.fade_state = 3;
                        break;
                    }
                    case 5: {
                        if (key != 4096 && key != 131072) break;
                        grh.resume_last_game = false;
                        if (this.currentItem == ITEM_ARCADE) {
                            grh.game_mode = 0;
                            this.noResume = !grh.loadLastGame(0);
                        } else if (this.currentItem == ITEM_SURVIVAL) {
                            grh.game_mode = 1;
                            boolean bl = this.noResume = !grh.loadLastGame(1);
                            if (this.noResume) {
                                this.initCharacterSelect();
                                return;
                            }
                        } else if (this.currentItem == ITEM_TRAINING) {
                            grh.game_mode = 2;
                        } else if (this.currentItem == ITEM_BLUETOOTH) {
                            grh.game_mode = 3;
                        }
                        this.fade_state = 3;
                        break;
                    }
                    case 2: {
                        if (key != 4096 && key != 131072) break;
                        switch (this.currentItem) {
                            case 0: {
                                this.initTextBox(this.textBox, grh.gameText.getText(24), grh.gameText.getText(46));
                                break block20;
                            }
                            case 1: {
                                this.initTextBox(this.textBox, grh.gameText.getText(22), grh.gameText.getText(45));
                                break block20;
                            }
                            case 2: {
                                grh.char_id = 0;
                                grh.opponent_id = 4;
                                grh.game_mode = 4;
                                if (grh.start_turorial) {
                                    grh.start_turorial = false;
                                    grh.saveRecords();
                                }
                                this.isInitialized = false;
                                this.showMsg = false;
                                grh.handle.setModule(grh.modules[2]);
                                return;
                            }
                        }
                        break;
                    }
                    case 0: {
                        if (this.showMsg && !this.showNewUnlocked && this.currentItem != 4) {
                            if (key != 4096 && key != 131072) break;
                            if (this.choiceWindow.fire()) {
                                grh.char_id = 0;
                                grh.opponent_id = 4;
                                grh.game_mode = 4;
                                this.isInitialized = false;
                                this.showMsg = false;
                                grh.handle.setModule(grh.modules[2]);
                                return;
                            }
                            this.fade_state = 1;
                            this.showMsg = false;
                            break;
                        }
                        if (this.showNewUnlocked) break;
                        switch (this.currentItem) {
                            case 0: {
                                if (key != 4096 && key != 131072) break block20;
                                this.fade_state = 1;
                                if (!grh.start_turorial) break block20;
                                grh.start_turorial = false;
                                grh.saveRecords();
                                if (this.choiceWindow == null) {
                                    this.choiceWindow = new ChoiceWindow();
                                }
                                this.choiceWindow.set(grh.gameText.getText(156), true);
                                this.choiceWindow.up();
                                this.showMsg = true;
                                return;
                            }
                            case 3: {
                                if (key != 4096 && key != 131072) break block20;
                                this.initTextBox(this.textBox, grh.gameText.getText(3), grh.gameText.getText(32) + "\n" + "v." + grh.midlet.getAppProperty("MIDlet-Version") + "\n\n\n" + grh.gameText.getText(33));
                                break block20;
                            }
                            case 4: {
                                if (key != 4096 && key != 131072) break block20;
                                if (this.showMsg) {
                                    if (this.choiceWindow.fire()) {
                                        this.isInitialized = false;
                                        grh.quit();
                                        return;
                                    }
                                    this.showMsg = false;
                                    this.menu.back(this.lastItem);
                                    break block20;
                                }
                                if (this.choiceWindow == null) {
                                    this.choiceWindow = new ChoiceWindow();
                                }
                                this.choiceWindow.set(grh.gameText.getText(48), true);
                                this.showMsg = true;
                                break block20;
                            }
                        }
                        if (key != 4096 && key != 131072) break;
                        this.fade_state = 1;
                        break;
                    }
                    case 1: {
                        if (key != 4096 && key != 131072) break;
                        int item = this.menu.getCurrentItem();
                        if (item < 3) {
                            this.menu.select();
                            this.optionsToggle(key, item, this.menu.getItemAt(this.menu.getCurrentItem()).getToggleIndex());
                            return;
                        }
                        this.fade_state = 3;
                        break;
                    }
                    case 13: {
                        if (key != 4096 && key != 131072) break;
                        grh.lang = this.menu.getCurrentItem();
                        grh.gameText.setLanguage(this.menu.getCurrentItem());
                        this.subMenuText = grh.gameText.getText(19);
                        grh.saveSettings();
                        this.fade_state = 1;
                        this.isInitialized = false;
                        grh.handle.setModule(grh.modules[0]);
                        return;
                    }
                    case 3: {
                        break;
                    }
                }
                if (this.showMsg) {
                    if (key == 262144) {
                        this.showMsg = false;
                        return;
                    }
                    if (key == 32768) {
                        this.choiceWindow.up();
                    }
                    if (key == 65536) {
                        this.choiceWindow.down();
                    }
                    if (key != 4096 && key != 131072 || !this.showNewUnlocked) return;
                    this.showNewUnlocked = false;
                    this.showMsg = false;
                    this.fade_state = 0;
                    return;
                }
                if (key == 32768) {
                    this.menu.up();
                    t = this.menu.getItemAt(this.menu.getCurrentItem()).getText();
                    if (t.equals(grh.gameText.getText(14)) && grh.unlocked_difficulty == 0) {
                        this.menu.down();
                    }
                    t = null;
                    if (this.textBox != null) {
                        this.textBox.up(0);
                    }
                }
                if (key == 65536) {
                    this.menu.down();
                    t = this.menu.getItemAt(this.menu.getCurrentItem()).getText();
                    if (t.equals(grh.gameText.getText(14)) && grh.unlocked_difficulty == 0) {
                        this.menu.up();
                    }
                    t = null;
                    if (this.textBox != null) {
                        this.textBox.down(0);
                    }
                }
                if (key == 4096 || key == 131072) {
                    this.lastMenu = this.menu.getCurrentMenu();
                    this.secondToLastItem = this.lastItem;
                    this.lastItem = this.menu.getCurrentItem();
                    this.menu.select();
                    if (this.noResume && this.lastMenu == 5 && (this.lastItem == ITEM_ARCADE || this.lastItem == ITEM_SURVIVAL)) {
                        this.menu.down();
                        this.menu.select();
                    }
                    if (this.fade_state == 1) {
                        switch (this.menu.getCurrentMenu()) {
                            case 13: {
                                this.subMenuText = grh.gameText.getText(19);
                                break;
                            }
                            case 1: {
                                this.subMenuText = grh.gameText.getText(1);
                                break;
                            }
                            case 5: {
                                this.subMenuText = grh.gameText.getText(7);
                                break;
                            }
                            case 2: {
                                this.subMenuText = grh.gameText.getText(2);
                                break;
                            }
                            case 11: {
                                this.subMenuText = grh.gameText.getText(18);
                                break;
                            }
                            case 7: {
                                this.subMenuText = grh.gameText.getText(59);
                                break;
                            }
                            case 10: {
                                this.subMenuText = grh.gameText.getText(60);
                            }
                        }
                        if (this.state == 1) {
                            this.subMenuText = grh.gameText.getText(16);
                        }
                    }
                }
                if (key != 262144) return;
                if (this.menu.getCurrentMenu() == 1) {
                    grh.saveSettings();
                }
                switch (this.menu.getCurrentMenu()) {
                    case 1: 
                    case 2: 
                    case 5: {
                        this.fade_state = 2;
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 11: 
                    case 13: {
                        this.fade_state = 3;
                    }
                }
                if (this.menu.getCurrentMenu() == 6) {
                    this.menu.setCurrentMenu(this.lastMenu, this.lastItem);
                } else {
                    this.menu.back(this.lastItem);
                }
                this.lastItem = this.secondToLastItem;
                return;
            }
            case 3: {
                if (key != 4096 && key != 131072) return;
                this.initMenuState();
                return;
            }
            case 2: {
                if (key != 262144) return;
                this.state = 1;
                return;
            }
            case 4: {
                if (this.showMsg) {
                    if (key == 32768) {
                        this.choiceWindow.up();
                    }
                    if (key == 65536) {
                        this.choiceWindow.down();
                    }
                    if (key == 131072 || key == 4096) {
                        if (this.choiceWindow.fire()) {
                            this.saveGameDuringVersusScreen();
                            this.showMsg = false;
                            this.reset();
                            this.isInitialized = false;
                            grh.handle.setModule(grh.modules[0]);
                            return;
                        }
                        this.showMsg = false;
                        return;
                    } else {
                        if (key != 262144) return;
                        this.showMsg = false;
                        return;
                    }
                }
                if (key == 131072 || key == 4096) {
                    if (grh.game_mode == 0 && grh.current_fight == grh.arcade_opponents[grh.char_id].length - 1) {
                        this.initMenuState();
                        this.menu.setCurrentMenu(0, 0);
                    }
                    this.isInitialized = false;
                    grh.handle.setModule(grh.modules[2]);
                    return;
                }
                if (key == 262144) {
                    if (grh.game_mode == 2) {
                        this.initCharacterSelect();
                        grh.handle.setModule(grh.modules[0]);
                        return;
                    }
                    if (grh.current_fight == 0 || grh.resume_last_game) {
                        this.state = 1;
                        if (this.currentMenu == 6) {
                            this.initCharacterSelect();
                        } else {
                            this.fade_state = 3;
                            this.initMenuState();
                        }
                        this.isInitialized = false;
                        grh.handle.setModule(grh.modules[0]);
                        return;
                    }
                    if (this.choiceWindow == null) {
                        this.choiceWindow = new ChoiceWindow();
                    }
                    this.choiceWindow.set(grh.gameText.getText(49), true);
                    this.showMsg = true;
                }
                if (grh.game_mode != 2) return;
                this.selectCharacterKeyPress(key, false);
                return;
            }
            case 1: {
                if (grh.game_mode == 3 && this.characterPicked && key != 262144) {
                    return;
                }
                this.selectCharacterKeyPress(key, true);
                if (key == 4096) {
                    if (this.char_index > grh.unlocked_character) return;
                    grh.char_id = this.char_index;
                    grh.current_fight = 0;
                    grh.total_fame = 0;
                    switch (grh.game_mode) {
                        case 0: {
                            grh.opponent_id = grh.arcade_opponents[grh.char_id][grh.current_fight];
                            this.state = 4;
                            break;
                        }
                        case 2: {
                            this.state = 4;
                            break;
                        }
                        case 1: {
                            grh.survival_hp = 100;
                            grh.difficulty = 0;
                            grh.opponent_id = grh.survival_opponents[0];
                            if (grh.opponent_id == grh.char_id) {
                                ++grh.current_fight;
                                ++grh.opponent_id;
                            }
                            this.isInitialized = false;
                            grh.handle.setModule(grh.modules[2]);
                            return;
                        }
                        case 3: {
                            byte[] ba = new byte[]{0, (byte)grh.char_id};
                            FLBluetooth.send(ba);
                            this.characterPicked = true;
                            this.initTextBox(this.textBox, grh.gameText.getText(61), grh.gameText.getText(62));
                            if (grh.opponent_id != -1) break;
                            return;
                        }
                    }
                    this.fade_state = 0;
                    this.ease_menu.decrease(10000);
                    this.isInitialized = false;
                    if (grh.game_mode == 3) {
                        grh.handle.setModule(grh.modules[2]);
                        return;
                    }
                    grh.handle.setModule(grh.modules[0]);
                    return;
                }
                if (key == 131072 && this.char_index <= grh.unlocked_character) {
                    this.state = 2;
                    if (grh.game_mode == 0) {
                        this.textBox.setText(grh.gameText.getText(87) + ": " + grh.arcade_records[this.char_index][grh.difficulty * 2] + "\n" + grh.gameText.getText(90) + ": " + this.getReputation(grh.game_mode, grh.difficulty, this.char_index) + "\n\n" + this.getDiscriptionText(this.char_index));
                    } else if (grh.game_mode == 1) {
                        this.textBox.setText(grh.gameText.getText(87) + ": " + grh.survival_records[this.char_index][1] + "\n" + grh.gameText.getText(108) + ": " + grh.survival_records[this.char_index][0] + "\n" + grh.gameText.getText(90) + ": " + this.getReputation(grh.game_mode, grh.difficulty, this.char_index) + "\n\n" + this.getDiscriptionText(this.char_index));
                    } else {
                        this.textBox.setText(this.getDiscriptionText(this.char_index));
                    }
                    this.textBox.setTitle(grh.fighter_names[this.char_index]);
                    this.textBox.resetScrollBar();
                    this.textBox.fadeIn();
                    return;
                }
                if (key != 262144) return;
                this.initMenuState();
                this.fade_state = 3;
                this.characterPicked = false;
                if (grh.game_mode == 3) {
                    FLBluetooth.disconnect(false);
                    this.menu.setCurrentMenu(7, 0);
                }
                this.isInitialized = false;
                grh.handle.setModule(grh.modules[0]);
                return;
            }
        }
    }

    public void onKeyRelease(int key) {
        if ((this.state == 0 || this.state == 2) && this.textBox != null) {
            if (key == 65536) {
                this.textBox.downRelease((int)this.elapsed_time);
            } else if (key == 32768) {
                this.textBox.upRelease((int)this.elapsed_time);
            }
        }
    }

    public void onStatusChange(long status_on, long status_off) {
        if (status_off == 2L && grh.volume != 0) {
            if (this.state == 1 || this.state == 2) {
                grh.sound.playMusic(18);
            } else {
                grh.sound.playMusic(17);
            }
        }
    }

    public void onUpdate() {
        if (!this.isInitialized) {
            return;
        }
        if ((this.state == 1 || this.state == 4 && grh.game_mode == 2) && this.reinitCharacter > 0) {
            --this.reinitCharacter;
            if (this.reinitCharacter == 0) {
                if (this.state == 4) {
                    this.next_fighter = this.createFighter(this.next_fighter, grh.opponent_id, false);
                    this.next_fighter.setHitPoints(1);
                    this.next_fighter.idle();
                    this.fighter.setOpponent(this.next_fighter);
                    this.next_fighter.setOpponent(this.fighter);
                } else {
                    this.fighter = this.createFighter(this.fighter, this.char_index, true);
                    this.fighter.setHitPoints(1);
                    if (this.state != 1) {
                        this.fighter.idle();
                    }
                    this.ease_menu.decrease(10000000);
                    this.showCharacterName = true;
                    this.subMenuText = grh.fighter_names[this.char_index];
                }
                this.reinitModule = false;
                this.char_fade_state = 1;
                this.ease_character.increase(100000);
                this.fade_state = 1;
                this.info_switch_time = 0;
            }
        }
        if (!this.isInitialized) {
            return;
        }
        if (grh.game_mode == 3) {
            FLBluetooth.update();
            if (this.state == 0 && FLBluetooth.isConnected()) {
                this.characterPicked = false;
                grh.opponent_id = -1;
                this.menu.setCurrentMenu(7, 0);
                this.fade_state = 1;
                this.initCharacterSelect();
            }
            if (!(this.state != 0 || this.menu.getCurrentMenu() != 8 && this.menu.getCurrentMenu() != 9 || FLBluetooth.isConnected() || FLBluetooth.isServer() || !FLBluetooth.statusFindServicesReady())) {
                this.btSearchForServers = false;
                if (FLBluetooth.clientGetServerCount() > 0) {
                    MenuItem[] serverChooseMenu = new MenuItem[FLBluetooth.clientGetServerCount()];
                    for (int i = 0; i < FLBluetooth.clientGetServerCount(); ++i) {
                        serverChooseMenu[i] = new MenuItem(FLBluetooth.clientGetServerName(i), null);
                    }
                    this.menu.deleteMenu(10);
                    this.menu.addMenu(10, new int[]{0, ITEM_BLUETOOTH, 1, 0}, serverChooseMenu);
                    this.menu.setCurrentMenu(10, 0);
                    this.fade_state = 3;
                } else {
                    this.state = 3;
                    this.menu.setCurrentMenu(7, 0);
                    this.fade_state = 1;
                    this.initTextBox(this.textBox, grh.gameText.getText(63), grh.gameText.getText(64));
                }
            }
            if (this.state == 1) {
                byte[] ba;
                this.btSearchForServers = false;
                if (FLBluetooth.isDisconnected()) {
                    FLBluetooth.disconnect(false);
                    this.menu.setCurrentMenu(7, 0);
                    this.subMenuText = grh.gameText.getText(59);
                    this.fade_state = 0;
                    this.ease_menu.decrease(100000);
                    this.characterPicked = false;
                    this.state = 3;
                    this.initTextBox(this.textBox, grh.gameText.getText(10), grh.gameText.getText(54));
                    this.isInitialized = false;
                    grh.handle.setModule(grh.modules[0]);
                    return;
                }
                if (FLBluetooth.dataReceived() && (ba = FLBluetooth.getReceivedData())[0] == 0) {
                    grh.opponent_id = ba[1];
                    if (this.characterPicked) {
                        this.fade_state = 0;
                        this.isInitialized = false;
                        grh.handle.setModule(grh.modules[2]);
                    }
                    return;
                }
            }
        }
        if (this.textBox != null) {
            if ((this.keystate & 0x8004) != 0) {
                this.textBox.up((int)this.elapsed_time);
            } else if ((this.keystate & 0x10100) != 0) {
                this.textBox.down((int)this.elapsed_time);
            }
        }
        if (this.state != 4 || grh.game_mode == 2 && this.state == 4) {
            if (this.char_fade_state == 2) {
                this.ease_character.increase((int)this.elapsed_time * 4);
            } else if (this.char_fade_state == 1) {
                this.ease_character.decrease((int)this.elapsed_time * 4);
            }
        }
        if (this.fade_state == 3) {
            this.ease_menu.decrease((int)this.elapsed_time * 4);
            if (this.ease_menu.getValue() <= this.EASE_IN_VALUE) {
                this.fade_state = 1;
                switch (this.menu.getCurrentMenu()) {
                    case 5: {
                        this.subMenuText = grh.gameText.getText(7);
                        break;
                    }
                    case 11: {
                        this.subMenuText = grh.gameText.getText(18);
                        break;
                    }
                    case 2: {
                        this.subMenuText = grh.gameText.getText(2);
                        break;
                    }
                    case 6: {
                        this.subMenuText = grh.gameText.getText(12);
                        break;
                    }
                    case 7: {
                        this.subMenuText = grh.gameText.getText(59);
                        break;
                    }
                    case 10: {
                        this.subMenuText = grh.gameText.getText(60);
                        break;
                    }
                    case 13: {
                        this.subMenuText = grh.gameText.getText(19);
                        break;
                    }
                    case 1: {
                        this.subMenuText = grh.gameText.getText(1);
                    }
                }
                if (this.state == 1) {
                    if (this.showCharacterSelect) {
                        this.subMenuText = grh.gameText.getText(16);
                        this.showCharacterSelect = false;
                    } else if (this.showCharacterName) {
                        this.subMenuText = grh.fighter_names[this.char_index];
                    } else if (grh.game_mode == 0) {
                        this.subMenuText = grh.gameText.getText(87) + ": " + grh.arcade_records[this.char_index][grh.difficulty * 2];
                    } else if (grh.game_mode == 1) {
                        this.subMenuText = grh.gameText.getText(88) + ": " + grh.survival_records[this.char_index][0] + " " + grh.gameText.getText(38);
                    } else if (grh.game_mode == 2) {
                        this.subMenuText = grh.gameText.getText(11);
                    }
                }
            }
        }
        if (this.fade_state == 1) {
            if (!this.reinitModule) {
                this.ease_menu.increase((int)this.elapsed_time * 4);
            }
        } else if (this.fade_state == 2) {
            this.ease_menu.decrease((int)this.elapsed_time * 4);
        }
        if (!this.showMsg) {
            this.selection_mark_time = (int)((long)this.selection_mark_time + this.elapsed_time);
            if (this.selection_mark_time > 700) {
                this.selection_mark_time -= 700;
            }
        }
        if (this.state == 4) {
            if (grh.current_fight > 0) {
                this.ease_next_fighter_selection.increase((int)this.elapsed_time * 2);
            } else {
                this.ease_next_fighter_selection.increase(10000);
            }
            if (this.ease_next_fighter_selection.getValue() >= 12 + this.char_icons[0].getWidth()) {
                this.ease_versus.increase((int)this.elapsed_time * 8);
            }
            if (this.ease_versus.getValue() >= grh.h / 2 + this.versus.getHeight() / 2 && !this.reinitModule) {
                this.ease_character.decrease((int)this.elapsed_time * 2);
            }
            if (this.fighter != null) {
                this.fighter.setTransform(-140 + this.versus_left_translation[grh.char_id][0], this.versus_left_translation[grh.char_id][1], this.versus_left_translation[grh.char_id][2], -512 + this.versus_left_translation[grh.char_id][3]);
            }
            if (this.reinitModule || this.reinitCharacter != 0) {
                if (this.next_fighter != null) {
                    this.next_fighter.setTransform(160 + this.ease_character.getValue() + this.versus_right_translation[this.last_opponent][0], this.versus_right_translation[this.last_opponent][1], this.versus_right_translation[this.last_opponent][2], 2560 + this.versus_right_translation[this.last_opponent][3]);
                }
            } else if (this.next_fighter != null) {
                this.next_fighter.setTransform(160 + this.ease_character.getValue() + this.versus_right_translation[grh.opponent_id][0], this.versus_right_translation[grh.opponent_id][1], this.versus_right_translation[grh.opponent_id][2], 2560 + this.versus_right_translation[grh.opponent_id][3]);
            }
            this.target.setTranslation(0, 250, 0);
            this.cam.setTranslation(0, 250, 400);
            if (this.fighter != null && this.next_fighter != null) {
                this.fighter.update(this.elapsed_time);
            }
            if (this.next_fighter != null) {
                this.next_fighter.update(this.elapsed_time);
            }
            this.cam.update(false);
            this.scene.update(false);
            if (this.reinitModule && grh.game_mode == 2 && this.ease_character.getValue() >= 400) {
                this.reinitModule = false;
                if (this.next_fighter != null) {
                    this.next_fighter.release();
                }
                this.next_fighter = null;
                this.reinitCharacter = 2;
            }
        }
        if (this.state == 1 || this.state == 2) {
            if (grh.game_mode == 3) {
                FLBluetooth.update();
                if (FLBluetooth.isDisconnected()) {
                    this.menu.setCurrentMenu(7, 0);
                    this.fade_state = 1;
                }
            }
            this.info_switch_time = (int)((long)this.info_switch_time + this.elapsed_time);
            if (this.info_switch_time >= 3500) {
                this.info_switch_time = 0;
                this.fade_state = 3;
                this.showCharacterName = !this.showCharacterName;
            }
            for (int i = 0; i < 4; ++i) {
                if (this.attribs[i] < grh.char_attributes[this.char_index][i] * 25) {
                    int n = i;
                    this.attribs[n] = this.attribs[n] + AEMath.max(6, (int)this.elapsed_time / 12);
                    if (this.attribs[i] <= grh.char_attributes[this.char_index][i] * 25) continue;
                    this.attribs[i] = grh.char_attributes[this.char_index][i] * 25;
                    continue;
                }
                if (this.attribs[i] <= grh.char_attributes[this.char_index][i] * 25) continue;
                int n = i;
                this.attribs[n] = this.attribs[n] - AEMath.max(6, (int)this.elapsed_time / 12);
                if (this.attribs[i] >= grh.char_attributes[this.char_index][i] * 25) continue;
                this.attribs[i] = grh.char_attributes[this.char_index][i] * 25;
            }
            this.target.setTranslation(-350, 200, 50 + this.ease_character.getValue());
            this.cam.setTranslation(500, 200, 300 + this.ease_character.getValue());
            if (this.reinitModule || this.reinitCharacter != 0) {
                if (this.fighter != null) {
                    this.fighter.setTransform(this.char_select_translation[this.last_char_index][0], this.char_select_translation[this.last_char_index][1], this.char_select_translation[this.last_char_index][2], this.char_select_translation[this.last_char_index][3]);
                }
            } else if (this.fighter != null) {
                this.fighter.setTransform(this.char_select_translation[this.char_index][0], this.char_select_translation[this.char_index][1], this.char_select_translation[this.char_index][2], this.char_select_translation[this.char_index][3]);
            }
            if (this.fighter != null) {
                this.fighter.update(this.elapsed_time);
            }
            this.cam.update(false);
            this.scene.update(false);
            if (this.reinitModule && this.ease_menu.getValue() <= this.EASE_IN_VALUE && this.ease_character.getValue() >= 400) {
                this.reinitModule = false;
                if (this.fighter != null) {
                    this.fighter.release();
                }
                this.fighter = null;
                AEResourceManager.releaseAllResources();
                this.reinitCharacter = 2;
            }
        } else if (this.state != 4) {
            if (this.player != null) {
                this.updateCamera();
                this.player.update(this.elapsed_time);
                this.opponent.update(this.elapsed_time);
            }
            if (this.fighterAI != null) {
                for (int i = 0; i < this.fighterAI.length; ++i) {
                    if (this.fighterAI[i] == null) continue;
                    this.fighterAI[i].update(this.elapsed_time);
                }
            }
            this.cam.update(false);
            this.scene.update(false);
        }
    }

    private String getDiscriptionText(int id) {
        switch (id) {
            case 1: {
                return grh.gameText.getText(65);
            }
            case 3: {
                return grh.gameText.getText(66);
            }
            case 8: {
                return grh.gameText.getText(67);
            }
            case 5: {
                return grh.gameText.getText(68);
            }
            case 2: {
                return grh.gameText.getText(69);
            }
            case 0: {
                return grh.gameText.getText(70);
            }
            case 7: {
                return grh.gameText.getText(71);
            }
            case 6: {
                return grh.gameText.getText(72);
            }
            case 4: {
                return grh.gameText.getText(73);
            }
        }
        return "wrong id";
    }

    private void drawMenuTop() {
        int y = this.ease_menu.getValue();
        GUI.drawRedBox(0, y, grh.w, this.EASE_OUT_VALUE - this.EASE_IN_VALUE, true);
        if (this.state == 1) {
            if (this.subMenuText.equals(grh.fighter_names[this.char_index])) {
                grh.g.drawImage(this.char_names[this.char_index], grh.w / 2 - this.char_names[this.char_index].getWidth() / 2, y + (this.EASE_OUT_VALUE - this.EASE_IN_VALUE) / 2 - this.char_names[this.char_index].getHeight() / 2 - 1, 0);
            } else if (this.fade_state != 2) {
                AEFont.drawString(this.subMenuText, grh.w / 2 - AEFont.getStringWidth(this.subMenuText) / 2, y + -1, 16);
            }
        } else {
            AEFont.drawString(this.subMenuText, grh.w / 2 - AEFont.getStringWidth(this.subMenuText) / 2, y + -1, 16);
        }
        grh.g.setColor(3217416);
        grh.g.drawLine(0, 0, grh.w, 0);
        grh.g.setColor(8479041);
        grh.g.drawLine(0, 1, grh.w, 1);
        grh.g.setColor(4598034);
        grh.g.drawLine(0, 2, grh.w, 2);
        grh.g.setColor(0);
        grh.g.drawLine(0, 3, grh.w, 3);
        grh.g.setColor(921102);
        grh.g.fillRect(0, 4 + this.menu_meander.getHeight(), grh.w, this.gladiator_logo.getHeight() + 20);
        for (int i = 0; i < grh.w; i += this.menu_meander.getWidth()) {
            grh.g.drawImage(this.menu_meander, 0 + i, 4, 0);
            grh.g.drawImage(this.menu_meander, 0 + i, 4 + this.menu_meander.getHeight() + this.gladiator_logo.getHeight() + 20, 0);
        }
        grh.g.drawImage(this.gladiator_logo, grh.w / 2 - this.gladiator_logo.getWidth() / 2, this.menu_meander.getHeight() + 4 + 10, 0);
        grh.g.setColor(3217416);
        grh.g.drawLine(0, 4 + 2 * this.menu_meander.getHeight() + this.gladiator_logo.getHeight() + 20, grh.w, 4 + 2 * this.menu_meander.getHeight() + this.gladiator_logo.getHeight() + 20);
        grh.g.setColor(8479041);
        grh.g.drawLine(0, 4 + 2 * this.menu_meander.getHeight() + this.gladiator_logo.getHeight() + 20 + 1, grh.w, 4 + 2 * this.menu_meander.getHeight() + this.gladiator_logo.getHeight() + 20 + 1);
        grh.g.setColor(4598034);
        grh.g.drawLine(0, 4 + 2 * this.menu_meander.getHeight() + this.gladiator_logo.getHeight() + 20 + 2, grh.w, 4 + 2 * this.menu_meander.getHeight() + this.gladiator_logo.getHeight() + 20 + 2);
        grh.g.setColor(0);
        grh.g.drawLine(0, 4 + 2 * this.menu_meander.getHeight() + this.gladiator_logo.getHeight() + 20 + 3, grh.w, 4 + 2 * this.menu_meander.getHeight() + this.gladiator_logo.getHeight() + 20 + 3);
        grh.g.drawImage(this.menu_eagle, grh.w / 2 - this.menu_eagle.getWidth() / 2, y + this.EASE_OUT_VALUE - this.EASE_IN_VALUE - 4 + 0, 0);
    }

    private void drawCharacterPortraitSelection(boolean characterSelect) {
        int index = this.char_index;
        if (!characterSelect) {
            index = grh.opponent_id;
        }
        int characters_first_line = 5;
        if (grh.unlocked_character < 8) {
            characters_first_line = 4;
        }
        int left = grh.w / 2 - characters_first_line * (this.portrait_width + this.portrait_spacing) / 2;
        int char_count = 9;
        if (grh.unlocked_character < 8) {
            char_count = 8;
        }
        for (int i = 0; i < char_count; ++i) {
            int factor_y = i < characters_first_line ? 0 : 1;
            int factor_x = i < characters_first_line || grh.unlocked_character < 8 ? 0 : 1;
            int x = grh.w / 2 - characters_first_line * (this.portrait_width + this.portrait_spacing) / 2 + i % characters_first_line * (this.portrait_width + this.portrait_spacing) + this.portrait_spacing / 2;
            int y = grh.h - 20 - GUI.getMenuBorderHeight() - 3 * this.portrait_spacing / 2 - 2 * this.portrait_width;
            int offset = (this.border.getWidth() - this.char_icons[0].getWidth()) / 2;
            grh.g.drawImage(this.char_icons[i], x + factor_x * this.portrait_width / 2, y + factor_y * (this.portrait_width + this.portrait_spacing), 0);
            grh.g.drawImage(this.border, x - offset + factor_x * this.portrait_width / 2, y + factor_y * (this.portrait_width + this.portrait_spacing) - offset, 0);
            if (i <= grh.unlocked_character || !characterSelect) continue;
            grh.g.drawImage(this.disable, x + factor_x * this.portrait_width / 2, y + factor_y * (this.portrait_width + this.portrait_spacing), 0);
        }
        int x = grh.w / 2 - characters_first_line * (this.portrait_width + this.portrait_spacing) / 2 + index % characters_first_line * (this.portrait_width + this.portrait_spacing) + this.portrait_spacing / 2;
        int y = grh.h - 20 - GUI.getMenuBorderHeight() - 3 * this.portrait_spacing / 2 - 2 * this.portrait_width;
        int factor_y = index < characters_first_line ? 0 : 1;
        int factor_x = index < characters_first_line || grh.unlocked_character < 8 ? 0 : 1;
        int offset = (this.border_selected.getWidth() - this.char_icons[0].getWidth()) / 2;
        grh.g.drawImage(this.border_selected, x + factor_x * this.portrait_width / 2 - offset, y + factor_y * (this.portrait_width + this.portrait_spacing) - offset, 0);
    }

    private String getReputation(int mode, int difficulty, int character) {
        if (mode == 0) {
            switch (grh.arcade_records[character][difficulty * 2 + 1]) {
                case 0: {
                    return grh.gameText.getText(91);
                }
                case 1: {
                    return grh.gameText.getText(92);
                }
                case 2: {
                    return grh.gameText.getText(93);
                }
                case 3: {
                    return grh.gameText.getText(94);
                }
            }
        } else if (mode == 1 && grh.survival_records[character][0] >= 3) {
            if (grh.survival_records[character][0] < 5) {
                return grh.gameText.getText(92);
            }
            if (grh.survival_records[character][0] < 8) {
                return grh.gameText.getText(93);
            }
            return grh.gameText.getText(94);
        }
        return grh.gameText.getText(91);
    }

    public void onRender2D() {
        if (!this.isInitialized) {
            return;
        }
        switch (this.state) {
            case 0: 
            case 3: {
                this.drawMenuTop();
                GUI.drawMenuBackground(grh.h - 20 - GUI.getMenuBGHeight() / 2 - (this.rootItemCount + 1) * 13 / 2, grh.h - 20);
                if (this.menu.getCurrentMenu() == 0) {
                    GUI.drawFooter(grh.gameText.getText(5), "drawArrows()", null);
                } else if (this.menu.getCurrentMenu() == 1) {
                    GUI.drawFooter(grh.gameText.getText(44), "drawArrows()", grh.gameText.getText(6));
                } else if (this.menu.getCurrentMenu() != 4 && this.menu.getCurrentMenu() != 12) {
                    GUI.drawFooter(grh.gameText.getText(5), "drawArrows()", grh.gameText.getText(6));
                }
                AEFont.setFont((byte)0);
                if (!this.menu.currentMenuIsEmpty()) {
                    String t;
                    int i;
                    int menu_top = grh.h - 20 - GUI.getMenuBGHeight() / 2 - this.menu.getCurrentLength() * 13 / 2 + 3;
                    for (i = 0; i < this.menu.getCurrentLength(); ++i) {
                        t = this.menu.getItemAt(i).getText();
                        if (i == this.menu.getCurrentItem()) {
                            int offset = this.selection_mark_time / 116;
                            if (offset > 2) {
                                offset = 6 - offset;
                            }
                            if (offset < 0) {
                                offset = 0;
                            }
                            GUI.drawSelectionWing(true, grh.w / 2 - AEFont.getStringWidth(t) / 2 - offset, menu_top + this.menu.getCurrentItem() * 13);
                            AEFont.drawString(t, grh.w >> 1, menu_top + i * 13, 12);
                            GUI.drawSelectionWing(false, grh.w / 2 + AEFont.getStringWidth(t) / 2 + offset, menu_top + this.menu.getCurrentItem() * 13);
                            continue;
                        }
                        AEFont.drawString(t, grh.w >> 1, menu_top + i * 13, 12);
                    }
                    for (i = 0; i < this.menu.getCurrentLength(); ++i) {
                        t = this.menu.getItemAt(i).getText();
                        if (!t.equals(grh.gameText.getText(14)) || grh.unlocked_difficulty != 0) continue;
                        grh.g.setColor(9991232);
                        grh.g.drawLine(grh.w / 2 - AEFont.getStringWidth(t) / 2 - 2, menu_top + i * 13 + 2, grh.w / 2 + AEFont.getStringWidth(t) / 2 + 2, menu_top + i * 13 + 2);
                    }
                }
                if (this.menu.getCurrentMenu() == 4 || this.menu.getCurrentMenu() == 12 || this.menu.getCurrentMenu() == 9 || this.menu.getCurrentMenu() == 8 || this.state == 3) {
                    GUI.drawTransparentPattern();
                    this.textBox.draw((this.keystate & 0x8000) != 0, (this.keystate & 0x10000) != 0, (int)this.elapsed_time);
                    grh.g.setClip(0, 0, grh.w, grh.h);
                    if (this.state == 0) {
                        GUI.drawFooter(null, "drawArrows()", grh.gameText.getText(6));
                    } else {
                        GUI.drawFooter(grh.gameText.getText(5), "drawArrows()", null);
                    }
                }
                if (this.showMsg && this.choiceWindow != null) {
                    GUI.drawTransparentPattern();
                    this.choiceWindow.draw((int)this.elapsed_time);
                    GUI.drawFooter(grh.gameText.getText(5), null, grh.gameText.getText(6));
                }
                if (this.menu.getCurrentMenu() != 4 || !grh.cheat_fight && !grh.cheat_unlock && !grh.cheat_disableAI) break;
                String s = "Cheats activated: ";
                if (grh.cheat_fight) {
                    s = s + " | fight";
                }
                if (grh.cheat_unlock) {
                    s = s + " | unlock";
                }
                if (grh.cheat_disableAI) {
                    s = s + " | AI";
                }
                AEFont.drawString(s, 2, 2, (byte)0);
                break;
            }
            case 4: {
                this.subMenuText = grh.game_mode == 2 ? grh.gameText.getText(17) : grh.gameText.getText(37);
                this.drawMenuTop();
                GUI.drawMenuBackground();
                if (grh.game_mode == 2) {
                    GUI.drawMenuBackground(grh.h - 20 - 2 * GUI.getMenuBorderHeight() - 2 * this.portrait_spacing - 2 * this.portrait_width, grh.h - 20);
                    GUI.drawRedBox(0, grh.h - 20 - 2 * GUI.getMenuBorderHeight() - 2 * this.portrait_spacing - 2 * this.portrait_width - 13 - 6, grh.w, 19, false);
                    boolean offset = true;
                    grh.g.drawImage(this.char_names[grh.char_id], 6, grh.h - 20 - 2 * GUI.getMenuBorderHeight() - 2 * this.portrait_spacing - 2 * this.portrait_width - 9 - this.char_names[grh.char_id].getHeight() / 2 + 1, 0);
                    if (this.char_fade_state == 2) {
                        grh.g.drawImage(this.char_names[this.last_opponent], grh.w - 6 - this.char_names[this.last_opponent].getWidth() + this.ease_character.getValue() / 4, grh.h - 20 - 2 * GUI.getMenuBorderHeight() - 2 * this.portrait_spacing - 2 * this.portrait_width - 9 - this.char_names[grh.char_id].getHeight() / 2 + 1, 0);
                    } else {
                        grh.g.drawImage(this.char_names[grh.opponent_id], grh.w - 6 - this.char_names[grh.opponent_id].getWidth() + this.ease_character.getValue() / 4, grh.h - 20 - 2 * GUI.getMenuBorderHeight() - 2 * this.portrait_spacing - 2 * this.portrait_width - 9 - this.char_names[grh.char_id].getHeight() / 2 + 1, 0);
                    }
                } else {
                    GUI.drawRedBox(0, grh.h - GUI.getMenuBGHeight() - 13 - 6 - 20, grh.w, 19, false);
                    grh.g.drawImage(this.char_names[grh.char_id], 6, grh.h - GUI.getMenuBGHeight() - 20 - 9 - this.char_names[grh.char_id].getHeight() / 2 + 1, 0);
                    grh.g.drawImage(this.char_names[grh.opponent_id], grh.w - 6 - this.char_names[grh.opponent_id].getWidth() + this.ease_character.getValue() / 4, grh.h - GUI.getMenuBGHeight() - 20 - 9 - this.char_names[grh.char_id].getHeight() / 2 + 1, 0);
                }
                if (grh.game_mode == 0) {
                    int SPACING = 12;
                    int x = grh.w / 2 - this.char_icons[0].getWidth() * 5 / 2 - 2 * SPACING;
                    int y = grh.h - GUI.getMenuBGHeight() / 2 - 20 - this.char_icons[0].getHeight() / 2;
                    int offset = (this.border.getWidth() - this.char_icons[0].getWidth()) / 2;
                    int cross_offset = (this.char_icons[0].getWidth() - this.cross.getWidth()) / 2;
                    int arrow_offset = (this.char_icons[0].getWidth() - this.arrow_vs.getWidth()) / 2;
                    int arrow_offset_y = this.selection_mark_time / 116;
                    if (arrow_offset_y > 2) {
                        arrow_offset_y = 4 - arrow_offset_y;
                    }
                    if (this.ease_next_fighter_selection.getValue() < this.char_icons[0].getWidth() + 12) {
                        arrow_offset_y = 0;
                    }
                    GUI.drawLines(x - SPACING, y + this.char_icons[0].getHeight() / 2 + 2, grh.w - 2 * (x - SPACING));
                    grh.g.drawImage(this.attributeJewel, x - SPACING - this.attributeJewel.getWidth() / 2, y + this.char_icons[0].getHeight() / 2 - this.attributeJewel.getHeight() / 2 + 1, 0);
                    grh.g.drawImage(this.attributeJewel, grh.w - x + SPACING - this.attributeJewel.getWidth() / 2, y + this.char_icons[0].getHeight() / 2 - this.attributeJewel.getHeight() / 2 + 1, 0);
                    for (int i = 0; i < grh.arcade_opponents[0].length; ++i) {
                        grh.g.drawImage(this.border, x + i * (this.char_icons[i].getWidth() + SPACING) - offset, y - offset, 0);
                        grh.g.drawImage(this.char_icons[grh.arcade_opponents[this.char_index][i]], x + i * (this.char_icons[i].getWidth() + SPACING), y, 0);
                        if (i > grh.current_fight) {
                            grh.g.drawImage(this.disable, x + i * (this.char_icons[i].getWidth() + SPACING), y, 0);
                            continue;
                        }
                        if (i == grh.current_fight) {
                            grh.g.drawImage(this.arrow_vs, x + (i - 1) * (this.char_icons[i].getWidth() + SPACING) + arrow_offset + this.ease_next_fighter_selection.getValue(), y - offset + 1 - arrow_offset_y, 36);
                            continue;
                        }
                        grh.g.drawImage(this.cross, x + i * (this.char_icons[i].getWidth() + SPACING) + cross_offset, y, 0);
                    }
                } else if (grh.game_mode == 2) {
                    this.drawCharacterPortraitSelection(false);
                }
                grh.g.drawImage(this.versus, grh.w / 2 - this.versus.getWidth() / 2, this.ease_versus.getValue() - this.versus.getHeight(), 0);
                GUI.drawFooter(grh.gameText.getText(5), null, grh.gameText.getText(6));
                if (!this.showMsg) break;
                GUI.drawTransparentPattern();
                if (this.choiceWindow == null) break;
                this.choiceWindow.draw((int)this.elapsed_time);
                break;
            }
            case 1: 
            case 2: {
                this.drawMenuTop();
                GUI.drawMenuBackground(grh.h - 20 - 2 * GUI.getMenuBorderHeight() - 2 * this.portrait_spacing - 2 * this.portrait_width, grh.h - 20);
                this.drawCharacterPortraitSelection(true);
                int left = grh.w / 2 - 5 * (this.portrait_width + this.portrait_spacing) / 2;
                if (this.char_index <= grh.unlocked_character) {
                    String[] attributes = new String[]{grh.gameText.getText(83), grh.gameText.getText(84), grh.gameText.getText(85), grh.gameText.getText(86)};
                    int top = this.EASE_OUT_VALUE + 13 + 12;
                    for (int i = 0; i < attributes.length; ++i) {
                        float fact = 2.0f;
                        AEFont.drawString(attributes[i], left, top + (int)((float)(i * AEFont.getRowHeight()) * fact) - 2);
                        if (i >= 4) continue;
                        grh.g.setColor(9991232);
                        grh.g.drawImage(this.attributeBar, left, top + (int)((float)(i * AEFont.getRowHeight()) * fact) + AEFont.getRowHeight() + 3, 0);
                        grh.g.setColor(13842693);
                        grh.g.drawLine(left + 1, top + (int)((float)(i * AEFont.getRowHeight()) * fact) + AEFont.getRowHeight() + 3 + 2, left + 1 + this.attribs[i] * (this.attributeBar.getWidth() - 1) / 100 - 1, top + (int)((float)(i * AEFont.getRowHeight()) * fact) + AEFont.getRowHeight() + 3 + 2);
                        grh.g.drawLine(left + 1, top + (int)((float)(i * AEFont.getRowHeight()) * fact) + AEFont.getRowHeight() + 3 + 2 + 2, left + 1 + this.attribs[i] * (this.attributeBar.getWidth() - 1) / 100 - 1, top + (int)((float)(i * AEFont.getRowHeight()) * fact) + AEFont.getRowHeight() + 3 + 2 + 2);
                        grh.g.setColor(16740864);
                        grh.g.drawLine(left + 1, top + (int)((float)(i * AEFont.getRowHeight()) * fact) + AEFont.getRowHeight() + 3 + 2 + 1, left + 1 + this.attribs[i] * (this.attributeBar.getWidth() - 1) / 100 - 1, top + (int)((float)(i * AEFont.getRowHeight()) * fact) + AEFont.getRowHeight() + 3 + 2 + 1);
                        grh.g.drawImage(this.attributeJewel, left + 1 + this.attribs[i] * (this.attributeBar.getWidth() - 1) / 100 - 1 - this.attributeJewel.getWidth() / 2, top + (int)((float)(i * AEFont.getRowHeight()) * fact) + AEFont.getRowHeight() + 3 + 2 - this.attributeJewel.getHeight() / 2 + 1, 0);
                    }
                }
                if (grh.game_mode == 0) {
                    if (grh.arcade_records[this.char_index][grh.difficulty * 2 + 1] > 0) {
                        grh.g.drawImage(this.awards[grh.arcade_records[this.char_index][grh.difficulty * 2 + 1] - 1], grh.w - 3 - this.awards[0].getWidth(), this.EASE_OUT_VALUE + 13 + 12, 0);
                    }
                } else if (grh.game_mode == 1 && grh.survival_records[this.char_index][0] >= 3) {
                    if (grh.survival_records[this.char_index][0] < 5) {
                        grh.g.drawImage(this.awards[0], grh.w - 3 - this.awards[0].getWidth(), this.EASE_OUT_VALUE + 13 + 12, 0);
                    } else if (grh.survival_records[this.char_index][0] < 8) {
                        grh.g.drawImage(this.awards[1], grh.w - 3 - this.awards[0].getWidth(), this.EASE_OUT_VALUE + 13 + 12, 0);
                    } else {
                        grh.g.drawImage(this.awards[2], grh.w - 3 - this.awards[0].getWidth(), this.EASE_OUT_VALUE + 13 + 12, 0);
                    }
                }
                AEFont.setFont((byte)0);
                if (this.state == 2) {
                    GUI.drawTransparentPattern();
                    this.textBox.draw((this.keystate & 0x8000) != 0, (this.keystate & 0x10000) != 0, (int)this.elapsed_time);
                    GUI.drawFooter(null, null, grh.gameText.getText(6));
                    break;
                }
                if (grh.game_mode == 3 && this.characterPicked) {
                    this.textBox.draw((this.keystate & 0x8000) != 0, (this.keystate & 0x10000) != 0, (int)this.elapsed_time);
                    GUI.drawFooter(null, null, grh.gameText.getText(6));
                    break;
                }
                if (this.char_index > grh.unlocked_character) {
                    GUI.drawFooter(null, null, grh.gameText.getText(6));
                    break;
                }
                GUI.drawFooter(grh.gameText.getText(41), grh.gameText.getText(42), grh.gameText.getText(6));
            }
        }
    }

    public void onRender3D() {
        if (!this.isInitialized || this.btSearchForServers) {
            return;
        }
        if (this.state == 1 || this.state == 2 || this.state == 4) {
            GUI.drawGradient(this.EASE_OUT_VALUE);
            if (this.state == 4) {
                GUI.drawColloseum(grh.h - GUI.getMenuBGHeight());
            }
            if (this.fighter != null) {
                this.fighter.render();
            }
            if (this.state == 4 && this.next_fighter != null) {
                this.next_fighter.render();
            }
        } else if (this.state == 0) {
            if (this.player != null) {
                this.player.render();
            }
            if (this.opponent != null) {
                this.opponent.render();
            }
            if (this.arena != null) {
                this.arena.render();
            }
        }
        grh.device.bind(grh.g);
        grh.renderer.drawLayers(this.ingame_time * 2L / 3L);
        if (this.state == 0) {
            GUI.drawTransparentPattern();
        }
        grh.device.unbind(grh.g);
    }

    private void loadGlobalFightData() {
        if (grh.resume_game_mode != -1) {
            grh.game_mode = grh.resume_game_mode;
        }
        if (grh.resume_current_fight != -1) {
            grh.current_fight = grh.resume_current_fight;
        }
        if (grh.resume_char_id != -1) {
            grh.char_id = grh.resume_char_id;
        }
        if (grh.resume_opponent_id != -1) {
            grh.opponent_id = grh.resume_opponent_id;
        }
        if (grh.resume_total_fame != -1) {
            grh.total_fame = grh.resume_total_fame;
        }
        if (grh.resume_difficulty != -1) {
            grh.difficulty = grh.resume_difficulty;
        }
    }

    private void saveGameDuringVersusScreen() {
        grh.resume_time = grh.round_time[grh.time_limit];
        grh.resume_round = 1;
        grh.resume_char_health = 100;
        grh.resume_opponent_health = 100;
        grh.resume_char_fame = 0;
        grh.resume_opponent_fame = 0;
        grh.resume_char_wins = 0;
        grh.resume_opponent_wins = 0;
        grh.resume_game_mode = grh.game_mode;
        grh.resume_current_fight = grh.current_fight;
        grh.resume_char_id = grh.char_id;
        grh.resume_opponent_id = grh.opponent_id;
        grh.resume_total_fame = grh.total_fame;
        grh.resume_difficulty = grh.difficulty;
        grh.saveLastGame(0);
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }
}

